/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.extjs.model;

import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.javascript2.editor.model.DeclarationScope;
import org.netbeans.modules.javascript2.editor.model.JsObject;
import org.netbeans.modules.javascript2.editor.model.Occurrence;
import org.netbeans.modules.javascript2.editor.spi.model.FunctionArgument;
import org.netbeans.modules.javascript2.editor.spi.model.FunctionInterceptor;
import org.netbeans.modules.javascript2.editor.spi.model.ModelElementFactory;

public class ExtApplyFunctionInterceptor
implements FunctionInterceptor {
    public Pattern getNamePattern() {
        return Pattern.compile("Ext\\.apply");
    }

    public void intercept(String functionName, JsObject globalObject, DeclarationScope scope, ModelElementFactory factory, Collection<FunctionArgument> args) {
        if (args.size() == 2) {
            Iterator<FunctionArgument> iterator = args.iterator();
            FunctionArgument arg1 = iterator.next();
            FunctionArgument arg2 = iterator.next();
            int offset = arg1.getOffset();
            if (arg1.getKind() == FunctionArgument.Kind.REFERENCE && arg2.getKind() == FunctionArgument.Kind.ANONYMOUS_OBJECT) {
                JsObject definedObject;
                JsObject parent;
                JsObject oldParent = parent = globalObject;
                if (arg1.getValue() instanceof Collection) {
                    for (String name : (Collection)arg1.getValue()) {
                        JsObject jsObject = oldParent.getProperty(name);
                        OffsetRange offsetRange = new OffsetRange(offset, offset + name.length());
                        if (jsObject == null) {
                            jsObject = factory.newObject(parent, name, offsetRange, true);
                            parent.addProperty(name, jsObject);
                            oldParent = jsObject;
                        } else if (!jsObject.isDeclared()) {
                            JsObject newJsObject = factory.newObject(parent, name, offsetRange, true);
                            parent.addProperty(name, newJsObject);
                            for (Occurrence occurrence : jsObject.getOccurrences()) {
                                newJsObject.addOccurrence(occurrence.getOffsetRange());
                            }
                            newJsObject.addOccurrence(jsObject.getDeclarationName().getOffsetRange());
                            oldParent = jsObject;
                            jsObject = newJsObject;
                        }
                        parent = jsObject;
                        offset += name.length() + 1;
                    }
                }
                if ((definedObject = (JsObject)arg2.getValue()).getModifiers().remove(Modifier.PRIVATE)) {
                    definedObject.getModifiers().add(Modifier.PUBLIC);
                }
                for (JsObject property : definedObject.getProperties().values()) {
                    if (!property.isDeclared()) continue;
                    parent.addProperty(property.getName(), factory.newReference(parent, property.getName(), property.getDeclarationName().getOffsetRange(), property, true, property.getModifiers()));
                }
            }
        }
    }
}

