/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.hyperlink;

import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProviderExt;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkType;
import org.netbeans.modules.bugtracking.api.Util;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class EditorHyperlinkProviderImpl
implements HyperlinkProviderExt {
    private static final Logger LOG = Logger.getLogger(EditorHyperlinkProviderImpl.class.getName());

    public Set<HyperlinkType> getSupportedHyperlinkTypes() {
        return EnumSet.of(HyperlinkType.GO_TO_DECLARATION);
    }

    public boolean isHyperlinkPoint(Document doc, int offset, HyperlinkType type) {
        return this.getIssueSpan(doc, offset, type) != null;
    }

    public int[] getHyperlinkSpan(Document doc, int offset, HyperlinkType type) {
        return this.getIssueSpan(doc, offset, type);
    }

    public void performClickAction(final Document doc, int offset, HyperlinkType type) {
        final String issueId = this.getIssueId(doc, offset, type);
        if (issueId == null) {
            return;
        }
        class IssueDisplayer
        implements Runnable {
            IssueDisplayer() {
            }

            @Override
            public void run() {
                DataObject dobj = (DataObject)doc.getProperty("stream");
                FileObject fileObject = null;
                if (dobj != null) {
                    fileObject = dobj.getPrimaryFile();
                }
                if (fileObject == null) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "EditorHyperlinkProviderImpl - no file found for given document");
                    return;
                }
                Util.openIssue((FileObject)fileObject, (String)issueId);
            }
        }
        RequestProcessor.getDefault().post((Runnable)new IssueDisplayer());
    }

    public String getTooltipText(Document doc, int offset, HyperlinkType type) {
        return NbBundle.getMessage(EditorHyperlinkProviderImpl.class, (String)"LBL_OpenIssue", (Object[])new Object[]{this.getIssueId(doc, offset, type)});
    }

    private String getIssueId(Document doc, int offset, HyperlinkType type) {
        int[] span = this.getIssueSpan(doc, offset, type);
        if (span == null) {
            return null;
        }
        String issueId = null;
        try {
            if (span[0] <= offset && offset <= span[1]) {
                int length = span[1] - span[0];
                String text = doc.getText(span[0], length);
                issueId = Util.getIssueId((String)text);
            }
        }
        catch (BadLocationException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        if (issueId == null) {
            try {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "No issue found for {0}", doc.getText(span[0], span[1] - span[0]));
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return issueId;
    }

    private int[] getIssueSpan(final Document doc, final int offset, HyperlinkType type) {
        final int[][] ret = new int[1][];
        doc.render(new Runnable(){

            @Override
            public void run() {
                TokenHierarchy th = TokenHierarchy.get((Document)doc);
                List list = th.embeddedTokenSequences(offset, false);
                for (TokenSequence ts : list) {
                    String name;
                    String primCategory;
                    if (ts == null) {
                        return;
                    }
                    ts.move(offset);
                    if (!ts.moveNext()) {
                        return;
                    }
                    Token t = ts.token();
                    TokenId tokenId = t.id();
                    if (tokenId == null || (primCategory = tokenId.primaryCategory()) == null || (name = tokenId.name()) == null || primCategory.toUpperCase().indexOf("COMMENT") <= -1 && name.toUpperCase().indexOf("COMMENT") <= -1) continue;
                    CharSequence text = t.text();
                    int[] spans = Util.getIssueSpans((String)text.toString());
                    for (int i = 1; i < spans.length; i += 2) {
                        if (ts.offset() + spans[i - 1] > offset || offset > ts.offset() + spans[i]) continue;
                        ret[0] = new int[]{ts.offset() + spans[i - 1], ts.offset() + spans[i]};
                        return;
                    }
                }
            }
        });
        return ret[0];
    }
}

