/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

public class PrivacyItem {
    private boolean allow;
    private int order;
    private PrivacyRule rule;
    private boolean filterIQ = false;
    private boolean filterMessage = false;
    private boolean filterPresence_in = false;
    private boolean filterPresence_out = false;

    public PrivacyItem(String type, boolean allow, int order) {
        this.setRule(PrivacyRule.fromString(type));
        this.setAllow(allow);
        this.setOrder(order);
    }

    public boolean isAllow() {
        return this.allow;
    }

    private void setAllow(boolean allow) {
        this.allow = allow;
    }

    public boolean isFilterIQ() {
        return this.filterIQ;
    }

    public void setFilterIQ(boolean filterIQ) {
        this.filterIQ = filterIQ;
    }

    public boolean isFilterMessage() {
        return this.filterMessage;
    }

    public void setFilterMessage(boolean filterMessage) {
        this.filterMessage = filterMessage;
    }

    public boolean isFilterPresence_in() {
        return this.filterPresence_in;
    }

    public void setFilterPresence_in(boolean filterPresence_in) {
        this.filterPresence_in = filterPresence_in;
    }

    public boolean isFilterPresence_out() {
        return this.filterPresence_out;
    }

    public void setFilterPresence_out(boolean filterPresence_out) {
        this.filterPresence_out = filterPresence_out;
    }

    public int getOrder() {
        return this.order;
    }

    private void setOrder(int order) {
        this.order = order;
    }

    public void setValue(String value) {
        if (this.getRule() != null || value != null) {
            this.getRule().setValue(value);
        }
    }

    public Type getType() {
        if (this.getRule() == null) {
            return null;
        }
        return this.getRule().getType();
    }

    public String getValue() {
        if (this.getRule() == null) {
            return null;
        }
        return this.getRule().getValue();
    }

    public boolean isFilterEverything() {
        return !this.isFilterIQ() && !this.isFilterMessage() && !this.isFilterPresence_in() && !this.isFilterPresence_out();
    }

    private PrivacyRule getRule() {
        return this.rule;
    }

    private void setRule(PrivacyRule rule) {
        this.rule = rule;
    }

    public String toXML() {
        StringBuilder buf = new StringBuilder();
        buf.append("<item");
        if (this.isAllow()) {
            buf.append(" action=\"allow\"");
        } else {
            buf.append(" action=\"deny\"");
        }
        buf.append(" order=\"").append(this.getOrder()).append("\"");
        if (this.getType() != null) {
            buf.append(" type=\"").append((Object)this.getType()).append("\"");
        }
        if (this.getValue() != null) {
            buf.append(" value=\"").append(this.getValue()).append("\"");
        }
        if (this.isFilterEverything()) {
            buf.append("/>");
        } else {
            buf.append(">");
            if (this.isFilterIQ()) {
                buf.append("<iq/>");
            }
            if (this.isFilterMessage()) {
                buf.append("<message/>");
            }
            if (this.isFilterPresence_in()) {
                buf.append("<presence-in/>");
            }
            if (this.isFilterPresence_out()) {
                buf.append("<presence-out/>");
            }
            buf.append("</item>");
        }
        return buf.toString();
    }

    public static class PrivacyRule {
        private Type type;
        private String value;
        public static final String SUBSCRIPTION_BOTH = "both";
        public static final String SUBSCRIPTION_TO = "to";
        public static final String SUBSCRIPTION_FROM = "from";
        public static final String SUBSCRIPTION_NONE = "none";

        protected static PrivacyRule fromString(String value) {
            if (value == null) {
                return null;
            }
            PrivacyRule rule = new PrivacyRule();
            rule.setType(Type.valueOf(value.toLowerCase()));
            return rule;
        }

        public Type getType() {
            return this.type;
        }

        private void setType(Type type) {
            this.type = type;
        }

        public String getValue() {
            return this.value;
        }

        protected void setValue(String value) {
            if (this.isSuscription()) {
                this.setSuscriptionValue(value);
            } else {
                this.value = value;
            }
        }

        private void setSuscriptionValue(String value) {
            if (value == null) {
                // empty if block
            }
            String setValue = SUBSCRIPTION_BOTH.equalsIgnoreCase(value) ? SUBSCRIPTION_BOTH : (SUBSCRIPTION_TO.equalsIgnoreCase(value) ? SUBSCRIPTION_TO : (SUBSCRIPTION_FROM.equalsIgnoreCase(value) ? SUBSCRIPTION_FROM : (SUBSCRIPTION_NONE.equalsIgnoreCase(value) ? SUBSCRIPTION_NONE : null)));
            this.value = setValue;
        }

        public boolean isSuscription() {
            return this.getType() == Type.subscription;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        group,
        jid,
        subscription;

    }
}

