/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.terminal.ioprovider;

import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.netbeans.lib.terminalemulator.Coord;
import org.netbeans.lib.terminalemulator.StreamTerm;
import org.netbeans.lib.terminalemulator.Term;
import org.netbeans.modules.terminal.api.IOConnect;
import org.netbeans.modules.terminal.api.IOEmulation;
import org.netbeans.modules.terminal.api.IONotifier;
import org.netbeans.modules.terminal.api.IOResizable;
import org.netbeans.modules.terminal.api.IOTerm;
import org.netbeans.modules.terminal.api.IOVisibility;
import org.netbeans.modules.terminal.ioprovider.Task;
import org.netbeans.modules.terminal.ioprovider.Terminal;
import org.netbeans.modules.terminal.ioprovider.TerminalIOProvider;
import org.netbeans.modules.terminal.test.IOTest;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.windows.IOColorLines;
import org.openide.windows.IOColors;
import org.openide.windows.IOContainer;
import org.openide.windows.IOPosition;
import org.openide.windows.IOSelect;
import org.openide.windows.IOTab;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public final class TerminalInputOutput
implements InputOutput,
Lookup.Provider {
    private final IOContainer ioContainer;
    private final String name;
    private final Terminal terminal;
    private OutputWriter outputWriter;
    private OutputWriter errWriter;
    private Icon icon;
    private String toolTipText;
    private final Lookup lookup = Lookups.fixed((Object[])new Object[]{new MyIOColorLines(), new MyIOColors(), new MyIOPosition(), new MyIOResizable(), new MyIOEmulation(), new MyIOTerm(), new MyIOTab(), new MyIOVisibility(), new MyIOConnect(), new MyIONotifier(), new MyIOTest(), new MyIOSelect()});
    private final Map<Color, Integer> colorMap = new HashMap<Color, Integer>();
    private int allocatedColors = 0;
    private final Map<IOColors.OutputType, Color> typeColorMap = new EnumMap<IOColors.OutputType, Color>(IOColors.OutputType.class);
    private int outputColor = 0;
    private PropertyChangeSupport pcs;
    private VetoableChangeSupport vcs;
    static final Color ERROR_COLOR = new Color(235, 0, 0);

    public Lookup getLookup() {
        return this.lookup;
    }

    PropertyChangeSupport pcs() {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        return this.pcs;
    }

    VetoableChangeSupport vcs() {
        if (this.vcs == null) {
            this.vcs = new VetoableChangeSupport(this);
        }
        return this.vcs;
    }

    private int customColor(Color color) {
        if (color == null) {
            return -1;
        }
        if (!this.colorMap.containsKey(color)) {
            if (this.allocatedColors >= 8) {
                return -1;
            }
            Task.SetCustomColor task = new Task.SetCustomColor(this.terminal, this.allocatedColors, color);
            task.post();
            this.colorMap.put(color, this.allocatedColors++ + 50);
        }
        int customColor = this.colorMap.get(color);
        return customColor;
    }

    private void setColor(int color) {
        this.getOut().append('\u001b');
        this.getOut().append('[');
        this.getOut().append((CharSequence)Integer.toString(color));
        this.getOut().append('m');
    }

    private void println(CharSequence text, Color color) {
        int customColor = this.customColor(color);
        if (customColor == -1) {
            this.getOut().println((Object)text);
        } else {
            this.setColor(customColor);
            this.getOut().println((Object)text);
            this.setColor(this.outputColor);
        }
    }

    private void println(CharSequence text, OutputListener listener, boolean important, Color color) {
        if (color == null && listener != null) {
            color = important ? this.typeColorMap.get(IOColors.OutputType.HYPERLINK_IMPORTANT) : this.typeColorMap.get(IOColors.OutputType.HYPERLINK);
        }
        if (listener != null) {
            Task task = new Task.BeginActiveRegion(this.terminal, listener);
            task.post();
            this.println(text, color);
            task = new Task.EndActiveRegion(this.terminal);
            task.post();
        } else {
            this.println(text, color);
        }
    }

    TerminalInputOutput(String name, Action[] actions, IOContainer ioContainer) {
        this.name = name;
        this.ioContainer = ioContainer;
        this.terminal = new Terminal(ioContainer, this, name);
        Task.Add task = new Task.Add(ioContainer, this.terminal, actions);
        task.post();
        this.colorMap.put(Color.black, 30);
        this.colorMap.put(Color.red, 31);
        this.colorMap.put(Color.green, 32);
        this.colorMap.put(Color.yellow, 33);
        this.colorMap.put(Color.blue, 34);
        this.colorMap.put(Color.magenta, 35);
        this.colorMap.put(Color.cyan, 36);
        this.colorMap.put(Color.white, 37);
    }

    void dispose() {
        if (this.outputWriter != null) {
            this.outputWriter = null;
        }
    }

    private StreamTerm term() {
        return this.terminal.term();
    }

    Terminal terminal() {
        return this.terminal;
    }

    String name() {
        return this.name;
    }

    public Reader getIn() {
        Task.GetIn task = new Task.GetIn(this.terminal);
        task.post();
        Reader reader = (Reader)task.get();
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputWriter getOut() {
        TerminalInputOutput terminalInputOutput = this;
        synchronized (terminalInputOutput) {
            if (this.outputWriter == null) {
                Task.GetOut task = new Task.GetOut(this.terminal);
                task.post();
                Writer writer = (Writer)task.get();
                this.outputWriter = new TermOutputWriter(this.terminal, writer);
            }
        }
        this.terminal.setOutConnected(true);
        return this.outputWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputWriter getErr() {
        TerminalInputOutput terminalInputOutput = this;
        synchronized (terminalInputOutput) {
            if (this.errWriter == null) {
                Task.GetOut task = new Task.GetOut(this.terminal);
                task.post();
                Writer writer = (Writer)task.get();
                this.errWriter = new TermErrWriter(this.terminal, writer);
            }
        }
        this.terminal.setErrConnected(true);
        return this.errWriter;
    }

    public void closeInputOutput() {
        TerminalIOProvider.remove(this);
        if (this.outputWriter != null) {
            this.outputWriter.close();
        }
        Task.StrongClose task = new Task.StrongClose(this.ioContainer, this.terminal);
        task.post();
    }

    public boolean isClosed() {
        return !this.terminal.isVisibleInContainer();
    }

    public void setOutputVisible(boolean value) {
    }

    public void setErrVisible(boolean value) {
    }

    public void setInputVisible(boolean value) {
    }

    public void select() {
        EnumSet<IOSelect.AdditionalOperation> extraOps = EnumSet.of(IOSelect.AdditionalOperation.OPEN, IOSelect.AdditionalOperation.REQUEST_VISIBLE);
        Task.Select task = new Task.Select(this.ioContainer, this.terminal, extraOps);
        task.post();
    }

    public boolean isErrSeparated() {
        return false;
    }

    public void setErrSeparated(boolean value) {
    }

    public boolean isFocusTaken() {
        return false;
    }

    public void setFocusTaken(boolean value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Deprecated
    public Reader flushReader() {
        return this.getIn();
    }

    private class MyIOColorLines
    extends IOColorLines {
        private MyIOColorLines() {
        }

        protected void println(CharSequence text, OutputListener listener, boolean important, Color color) {
            TerminalInputOutput.this.println(text, listener, important, color);
        }
    }

    private class MyIOColors
    extends IOColors {
        private MyIOColors() {
        }

        protected Color getColor(IOColors.OutputType type) {
            return (Color)TerminalInputOutput.this.typeColorMap.get(type);
        }

        protected void setColor(IOColors.OutputType type, Color color) {
            TerminalInputOutput.this.typeColorMap.put(type, color);
            if (type == IOColors.OutputType.OUTPUT) {
                TerminalInputOutput.this.outputColor = TerminalInputOutput.this.customColor(color);
                if (TerminalInputOutput.this.outputColor == -1) {
                    TerminalInputOutput.this.outputColor = 0;
                }
                TerminalInputOutput.this.setColor(TerminalInputOutput.this.outputColor);
            }
        }
    }

    private class MyIOConnect
    extends IOConnect {
        private MyIOConnect() {
        }

        @Override
        protected boolean isConnected() {
            return TerminalInputOutput.this.terminal.isConnected();
        }

        @Override
        protected void disconnectAll(Runnable continuation) {
            TerminalInputOutput.this.terminal.setOutConnected(false);
            IOTerm.disconnect(TerminalInputOutput.this, continuation);
        }
    }

    private class MyIOEmulation
    extends IOEmulation {
        private boolean disciplined = false;

        private MyIOEmulation() {
        }

        @Override
        protected String getEmulation() {
            if (TerminalInputOutput.this.term() == null) {
                return "";
            }
            return TerminalInputOutput.this.term().getEmulation();
        }

        @Override
        protected boolean isDisciplined() {
            return this.disciplined;
        }

        @Override
        protected void setDisciplined() {
            if (this.disciplined) {
                return;
            }
            this.disciplined = true;
            if (this.disciplined) {
                Task.SetDisciplined task = new Task.SetDisciplined(TerminalInputOutput.this.terminal, this.disciplined);
                task.post();
            }
        }
    }

    private class MyIONotifier
    extends IONotifier {
        private MyIONotifier() {
        }

        @Override
        protected void addPropertyChangeListener(PropertyChangeListener listener) {
            TerminalInputOutput.this.pcs().addPropertyChangeListener(listener);
        }

        @Override
        protected void removePropertyChangeListener(PropertyChangeListener listener) {
            TerminalInputOutput.this.pcs().removePropertyChangeListener(listener);
        }

        @Override
        public void addVetoableChangeListener(VetoableChangeListener listener) {
            TerminalInputOutput.this.vcs().addVetoableChangeListener(listener);
        }

        @Override
        public void removeVetoableChangeListener(VetoableChangeListener listener) {
            TerminalInputOutput.this.vcs().removeVetoableChangeListener(listener);
        }
    }

    private class MyIOPosition
    extends IOPosition {
        private MyIOPosition() {
        }

        protected IOPosition.Position currentPosition() {
            Task.GetPosition task = new Task.GetPosition(TerminalInputOutput.this.terminal);
            task.post();
            Coord coord = (Coord)task.get();
            return new MyPosition(TerminalInputOutput.this.terminal, coord);
        }
    }

    private static final class MyIOResizable
    extends IOResizable {
        private MyIOResizable() {
        }
    }

    private class MyIOSelect
    extends IOSelect {
        private MyIOSelect() {
        }

        protected void select(Set<IOSelect.AdditionalOperation> extraOps) {
            Task.Select task = new Task.Select(TerminalInputOutput.this.ioContainer, TerminalInputOutput.this.terminal, extraOps);
            task.post();
        }
    }

    private class MyIOTab
    extends IOTab {
        private MyIOTab() {
        }

        protected Icon getIcon() {
            return TerminalInputOutput.this.icon;
        }

        protected void setIcon(Icon icon) {
            TerminalInputOutput.this.icon = icon;
            Task.SetIcon task = new Task.SetIcon(TerminalInputOutput.this.ioContainer, TerminalInputOutput.this.terminal, icon);
            task.post();
        }

        protected String getToolTipText() {
            return TerminalInputOutput.this.toolTipText;
        }

        protected void setToolTipText(String text) {
            TerminalInputOutput.this.toolTipText = text;
            Task.SetToolTipText task = new Task.SetToolTipText(TerminalInputOutput.this.ioContainer, TerminalInputOutput.this.terminal, text);
            task.post();
        }
    }

    private class MyIOTerm
    extends IOTerm {
        private MyIOTerm() {
        }

        @Override
        protected Term term() {
            return TerminalInputOutput.this.terminal.term();
        }

        @Override
        protected void connect(OutputStream pin, InputStream pout, InputStream perr, String charset) {
            Task.Connect task = new Task.Connect(TerminalInputOutput.this.terminal, pin, pout, perr, charset);
            task.post();
        }

        @Override
        protected void disconnect(Runnable continuation) {
            Task.Disconnect task = new Task.Disconnect(TerminalInputOutput.this.terminal, continuation);
            task.post();
        }
    }

    private class MyIOTest
    extends IOTest {
        private MyIOTest() {
        }

        @Override
        protected boolean isQuiescent() {
            return Task.isQuiescent();
        }

        @Override
        protected void performCloseAction() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!TerminalInputOutput.this.terminal().isClosable()) {
                        return;
                    }
                    TerminalInputOutput.this.terminal().close();
                }
            });
        }
    }

    private class MyIOVisibility
    extends IOVisibility {
        private MyIOVisibility() {
        }

        @Override
        protected void setVisible(boolean visible) {
            if (visible) {
                EnumSet<IOSelect.AdditionalOperation> extraOps = EnumSet.noneOf(IOSelect.AdditionalOperation.class);
                Task.Select task = new Task.Select(TerminalInputOutput.this.ioContainer, TerminalInputOutput.this.terminal, extraOps);
                task.post();
            } else {
                Task.DeSelect task = new Task.DeSelect(TerminalInputOutput.this.ioContainer, TerminalInputOutput.this.terminal);
                task.post();
            }
        }

        @Override
        protected void setClosable(boolean closable) {
            Task.SetClosable task = new Task.SetClosable(TerminalInputOutput.this.ioContainer, TerminalInputOutput.this.terminal, closable);
            task.post();
        }

        @Override
        protected boolean isClosable() {
            Task.IsClosable task = new Task.IsClosable(TerminalInputOutput.this.terminal);
            task.post();
            boolean isClosable = (Boolean)task.get();
            return isClosable;
        }

        @Override
        protected boolean isSupported() {
            return true;
        }
    }

    private static class MyPosition
    implements IOPosition.Position {
        private final Terminal terminal;
        private final Coord coord;

        MyPosition(Terminal terminal, Coord coord) {
            this.terminal = terminal;
            this.coord = coord;
        }

        public void scrollTo() {
            if (this.coord == null) {
                return;
            }
            Task.Scroll task = new Task.Scroll(this.terminal, this.coord);
            task.post();
        }
    }

    private final class TermErrWriter
    extends OutputWriter {
        private final Terminal owner;

        TermErrWriter(Terminal owner, Writer writer) {
            super(writer);
            this.owner = owner;
        }

        public void println(String s, OutputListener l) throws IOException {
            TerminalInputOutput.this.println(s, l, false, ERROR_COLOR);
        }

        public void println(String s, OutputListener l, boolean important) throws IOException {
            TerminalInputOutput.this.println(s, l, important, ERROR_COLOR);
        }

        public void println(String x) {
            TerminalInputOutput.this.println(x, ERROR_COLOR);
        }

        public void reset() throws IOException {
        }

        public void close() {
            this.owner.setErrConnected(false);
        }
    }

    private class TermOutputWriter
    extends OutputWriter {
        private final Terminal owner;

        TermOutputWriter(Terminal owner, Writer writer) {
            super(writer);
            this.owner = owner;
        }

        public void println(String s, OutputListener l) throws IOException {
            TerminalInputOutput.this.println(s, l, false, null);
        }

        public void println(String s, OutputListener l, boolean important) throws IOException {
            TerminalInputOutput.this.println(s, l, important, null);
        }

        public void reset() throws IOException {
            Task.ClearHistory task = new Task.ClearHistory(TerminalInputOutput.this.terminal);
            task.post();
        }

        public void close() {
            this.owner.setOutConnected(false);
        }
    }
}

