/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.terminal;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.lib.terminalemulator.LineDiscipline;
import org.netbeans.lib.terminalemulator.Term;
import org.netbeans.lib.terminalemulator.TermStream;
import org.netbeans.lib.terminalemulator.support.TermOptions;
import org.netbeans.modules.terminal.Bundle;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.ColorComboBox;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class TermOptionsPanel
extends JPanel {
    private final Term term;
    private final PropertyChangeListener propertyListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            TermOptionsPanel.this.refreshView();
        }
    };
    private boolean inApplyingModel;
    private TermOptions termOptions;
    private boolean changingSelectByWordText = false;
    private ColorComboBox backgroundComboBox;
    private JLabel backgroundLabel;
    private JCheckBox clickToTypeCheckBox;
    private JLabel descriptionLabel;
    private JButton fontButton;
    private JLabel fontLabel;
    private JLabel fontSizeLabel;
    private JSpinner fontSizeSpinner;
    private JTextField fontText;
    private ColorComboBox foregroundComboBox;
    private JLabel foregroundLabel;
    private JLabel historySizeLabel;
    private JSpinner historySizeSpinner;
    private JCheckBox ignoreKeymapCheckBox;
    private JCheckBox lineWrapCheckBox;
    private JLabel previewLabel;
    private JPanel previewPanel;
    private JButton restoreButton;
    private JCheckBox scrollOnInputCheckBox;
    private JCheckBox scrollOnOutputCheckBox;
    private JLabel selectByWordLabel;
    private JTextField selectByWordTextField;
    private ColorComboBox selectionComboBox;
    private JLabel selectionLabel;
    private JLabel tabSizeLabel;
    private JSpinner tabSizeSpinner;

    public TermOptionsPanel() {
        this.initComponents();
        this.initCustomComponents();
        this.term = new Term();
        String line1String = Bundle.MSG_Hello() + "\r\n";
        char[] line1 = line1String.toCharArray();
        this.term.putChars(line1, 0, line1.length);
        this.term.pushStream((TermStream)new LineDiscipline());
        this.term.setRowsColumns(7, 60);
        this.term.setClickToType(true);
        this.previewPanel.add((Component)this.term, "Center");
    }

    private void initCustomComponents() {
        this.selectByWordTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.textChangeActionPerformed();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.textChangeActionPerformed();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            private void textChangeActionPerformed() {
                if (TermOptionsPanel.this.inApplyingModel) {
                    return;
                }
                TermOptionsPanel.this.changingSelectByWordText = true;
                String delimiters = TermOptionsPanel.this.selectByWordTextField.getText();
                TermOptionsPanel.this.termOptions.setSelectByWordDelimiters(delimiters);
                TermOptionsPanel.this.changingSelectByWordText = false;
            }
        });
    }

    private void initComponents() {
        this.descriptionLabel = new JLabel();
        this.restoreButton = new JButton();
        this.fontLabel = new JLabel();
        this.fontText = new JTextField();
        this.fontButton = new JButton();
        this.fontSizeLabel = new JLabel();
        this.fontSizeSpinner = new JSpinner();
        this.foregroundLabel = new JLabel();
        this.foregroundComboBox = new ColorComboBox();
        this.backgroundLabel = new JLabel();
        this.backgroundComboBox = new ColorComboBox();
        this.selectionLabel = new JLabel();
        this.selectionComboBox = new ColorComboBox();
        this.historySizeLabel = new JLabel();
        this.historySizeSpinner = new JSpinner();
        this.tabSizeLabel = new JLabel();
        this.tabSizeSpinner = new JSpinner();
        this.selectByWordLabel = new JLabel();
        this.selectByWordTextField = new JTextField();
        this.clickToTypeCheckBox = new JCheckBox();
        this.ignoreKeymapCheckBox = new JCheckBox();
        this.lineWrapCheckBox = new JCheckBox();
        this.scrollOnInputCheckBox = new JCheckBox();
        this.scrollOnOutputCheckBox = new JCheckBox();
        this.previewLabel = new JLabel();
        this.previewPanel = new JPanel();
        Mnemonics.setLocalizedText((JLabel)this.descriptionLabel, (String)NbBundle.getMessage(TermOptionsPanel.class, (String)"TermOptionsPanel.descriptionLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.restoreButton, (String)NbBundle.getMessage(TermOptionsPanel.class, (String)"TermOptionsPanel.restoreButton.text"));
        this.restoreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TermOptionsPanel.this.restoreButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.fontLabel, (String)NbBundle.getMessage(TermOptionsPanel.class, (String)"TermOptionsPanel.fontLabel.text"));
        this.fontText.setEditable(false);
        this.fontText.setText(NbBundle.getMessage(TermOptionsPanel.class, (String)"TermOptionsPanel.fontText.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.fontButton, (String)NbBundle.getMessage(TermOptionsPanel.class, (String)"TermOptionsPanel.fontButton.text"));
        this.fontButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TermOptionsPanel.this.fontButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.fontSizeLabel, (String)NbBundle.getMessage(TermOptionsPanel.class, (String)"TermOptionsPanel.fontSizeLabel.text"));
        this.fontSizeSpinner.setModel(new SpinnerNumberModel(12, 8, 48, 1));
        this.fontSizeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TermOptionsPanel.this.fontSizeSpinnerStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.foregroundLabel, (String)NbBundle.getMessage(TermOptionsPanel.class, (String)"TermOptionsPanel.foregroundLabel.text"));
        this.foregroundComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TermOptionsPanel.this.foregroundComboBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.backgroundLabel, (String)NbBundle.getMessage(TermOptionsPanel.class, (String)"TermOptionsPanel.backgroundLabel.text"));
        this.backgroundComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TermOptionsPanel.this.backgroundComboBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.selectionLabel, (String)NbBundle.getMessage(TermOptionsPanel.class, (String)"TermOptionsPanel.selectionLabel.text"));
        this.selectionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TermOptionsPanel.this.selectionComboBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.historySizeLabel, (String)NbBundle.getMessage(TermOptionsPanel.class, (String)"TermOptionsPanel.historySizeLabel.text"));
        this.historySizeSpinner.setModel(new SpinnerNumberModel(5000, 0, 50000, 10));
        this.historySizeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TermOptionsPanel.this.historySizeSpinnerStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.tabSizeLabel, (String)NbBundle.getMessage(TermOptionsPanel.class, (String)"TermOptionsPanel.tabSizeLabel.text"));
        this.tabSizeSpinner.setModel(new SpinnerNumberModel(8, 1, 16, 1));
        this.tabSizeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TermOptionsPanel.this.tabSizeSpinnerStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.selectByWordLabel, (String)NbBundle.getMessage(TermOptionsPanel.class, (String)"TermOptionsPanel.selectByWordLabel.text"));
        this.selectByWordTextField.setText(NbBundle.getMessage(TermOptionsPanel.class, (String)"TermOptionsPanel.selectByWordTextField.text"));
        this.clickToTypeCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.clickToTypeCheckBox, (String)NbBundle.getMessage(TermOptionsPanel.class, (String)"TermOptionsPanel.clickToTypeCheckBox.text"));
        this.clickToTypeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TermOptionsPanel.this.clickToTypeCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.ignoreKeymapCheckBox, (String)NbBundle.getMessage(TermOptionsPanel.class, (String)"TermOptionsPanel.ignoreKeymapCheckBox.text"));
        this.ignoreKeymapCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TermOptionsPanel.this.ignoreKeymapCheckBoxActionPerformed(evt);
            }
        });
        this.lineWrapCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.lineWrapCheckBox, (String)NbBundle.getMessage(TermOptionsPanel.class, (String)"TermOptionsPanel.lineWrapCheckBox.text"));
        this.lineWrapCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TermOptionsPanel.this.lineWrapCheckBoxActionPerformed(evt);
            }
        });
        this.scrollOnInputCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.scrollOnInputCheckBox, (String)NbBundle.getMessage(TermOptionsPanel.class, (String)"TermOptionsPanel.scrollOnInputCheckBox.text"));
        this.scrollOnInputCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TermOptionsPanel.this.scrollOnInputCheckBoxActionPerformed(evt);
            }
        });
        this.scrollOnOutputCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.scrollOnOutputCheckBox, (String)NbBundle.getMessage(TermOptionsPanel.class, (String)"TermOptionsPanel.scrollOnOutputCheckBox.text"));
        this.scrollOnOutputCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TermOptionsPanel.this.scrollOnOutputCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.previewLabel, (String)NbBundle.getMessage(TermOptionsPanel.class, (String)"TermOptionsPanel.previewLabel.text"));
        this.previewPanel.setBorder(BorderFactory.createBevelBorder(1));
        this.previewPanel.setLayout(new BorderLayout());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.previewPanel, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fontLabel).addComponent(this.fontSizeLabel).addComponent(this.foregroundLabel).addComponent(this.backgroundLabel).addComponent(this.selectionLabel).addComponent(this.historySizeLabel)).addGap(79, 79, 79).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.foregroundComboBox, -1, 266, Short.MAX_VALUE).addComponent((Component)this.backgroundComboBox, -1, -1, Short.MAX_VALUE).addComponent((Component)this.selectionComboBox, -1, -1, Short.MAX_VALUE).addComponent(this.selectByWordTextField).addComponent(this.fontText).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fontSizeSpinner, -2, 103, -2).addComponent(this.historySizeSpinner, -2, 103, -2).addComponent(this.tabSizeSpinner, -2, 103, -2)).addGap(0, 0, Short.MAX_VALUE)))).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.clickToTypeCheckBox, GroupLayout.Alignment.LEADING).addComponent(this.descriptionLabel, GroupLayout.Alignment.LEADING)).addGap(0, 0, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.restoreButton, -1, -1, Short.MAX_VALUE).addComponent(this.fontButton, -1, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tabSizeLabel).addComponent(this.previewLabel).addGroup(layout.createSequentialGroup().addComponent(this.scrollOnInputCheckBox).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.ignoreKeymapCheckBox).addGap(18, 18, 18).addComponent(this.lineWrapCheckBox)).addComponent(this.scrollOnOutputCheckBox))).addComponent(this.selectByWordLabel)).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.descriptionLabel).addComponent(this.restoreButton)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fontLabel).addComponent(this.fontButton).addComponent(this.fontText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fontSizeLabel).addComponent(this.fontSizeSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.foregroundLabel).addComponent((Component)this.foregroundComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.backgroundLabel).addComponent((Component)this.backgroundComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.selectionLabel).addComponent((Component)this.selectionComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.historySizeLabel).addComponent(this.historySizeSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tabSizeLabel).addComponent(this.tabSizeSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.selectByWordLabel).addComponent(this.selectByWordTextField, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.clickToTypeCheckBox).addComponent(this.ignoreKeymapCheckBox).addComponent(this.lineWrapCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.scrollOnInputCheckBox).addComponent(this.scrollOnOutputCheckBox)).addGap(18, 18, 18).addComponent(this.previewLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.previewPanel, -1, 82, Short.MAX_VALUE)));
    }

    private void fontSizeSpinnerStateChanged(ChangeEvent evt) {
        if (this.inApplyingModel) {
            return;
        }
        Object fontSizeObj = this.fontSizeSpinner.getValue();
        if (fontSizeObj instanceof Integer) {
            int fontSize = (Integer)fontSizeObj;
            this.termOptions.setFontSize(fontSize);
        }
    }

    private void historySizeSpinnerStateChanged(ChangeEvent evt) {
        if (this.inApplyingModel) {
            return;
        }
        Object historySizeObj = this.historySizeSpinner.getValue();
        if (historySizeObj instanceof Integer) {
            int historySize = (Integer)historySizeObj;
            this.termOptions.setHistorySize(historySize);
        }
    }

    private void tabSizeSpinnerStateChanged(ChangeEvent evt) {
        if (this.inApplyingModel) {
            return;
        }
        Object tabSizeObj = this.tabSizeSpinner.getValue();
        if (tabSizeObj instanceof Integer) {
            int tabSize = (Integer)tabSizeObj;
            this.termOptions.setTabSize(tabSize);
        }
    }

    private void fontButtonActionPerformed(ActionEvent evt) {
        PropertyEditor pe = PropertyEditorManager.findEditor(Font.class);
        if (pe != null) {
            pe.setValue(this.termOptions.getFont());
            DialogDescriptor dd = new DialogDescriptor((Object)pe.getCustomEditor(), Bundle.FontChooser_title());
            String defaultFontString = Bundle.FontChooser_defaultFont_label();
            dd.setOptions(new Object[]{DialogDescriptor.OK_OPTION, defaultFontString, DialogDescriptor.CANCEL_OPTION});
            DialogDisplayer.getDefault().createDialog(dd).setVisible(true);
            if (dd.getValue() == DialogDescriptor.OK_OPTION) {
                Font f = (Font)pe.getValue();
                this.termOptions.setFont(f);
                this.applyTermOptions();
            } else if (dd.getValue() == defaultFontString) {
                Font controlFont = UIManager.getFont("controlFont");
                int fontSize = controlFont == null ? 12 : controlFont.getSize();
                this.termOptions.setFont(new Font("monospaced", 0, fontSize));
            }
        }
    }

    private void restoreButtonActionPerformed(ActionEvent evt) {
        this.termOptions.resetToDefault();
    }

    private void clickToTypeCheckBoxActionPerformed(ActionEvent evt) {
        if (this.inApplyingModel) {
            return;
        }
        this.termOptions.setClickToType(this.clickToTypeCheckBox.isSelected());
    }

    private void scrollOnInputCheckBoxActionPerformed(ActionEvent evt) {
        if (this.inApplyingModel) {
            return;
        }
        this.termOptions.setScrollOnInput(this.scrollOnInputCheckBox.isSelected());
    }

    private void scrollOnOutputCheckBoxActionPerformed(ActionEvent evt) {
        if (this.inApplyingModel) {
            return;
        }
        this.termOptions.setScrollOnOutput(this.scrollOnOutputCheckBox.isSelected());
    }

    private void lineWrapCheckBoxActionPerformed(ActionEvent evt) {
        if (this.inApplyingModel) {
            return;
        }
        this.termOptions.setLineWrap(this.lineWrapCheckBox.isSelected());
    }

    private void ignoreKeymapCheckBoxActionPerformed(ActionEvent evt) {
        if (this.inApplyingModel) {
            return;
        }
        this.termOptions.setIgnoreKeymap(this.ignoreKeymapCheckBox.isSelected());
    }

    private void foregroundComboBoxActionPerformed(ActionEvent evt) {
        if (this.inApplyingModel) {
            return;
        }
        Color c = this.foregroundComboBox.getSelectedColor();
        if (c != null) {
            this.termOptions.setForeground(c);
        }
    }

    private void backgroundComboBoxActionPerformed(ActionEvent evt) {
        if (this.inApplyingModel) {
            return;
        }
        Color c = this.backgroundComboBox.getSelectedColor();
        if (c != null) {
            this.termOptions.setBackground(c);
        }
    }

    private void selectionComboBoxActionPerformed(ActionEvent evt) {
        if (this.inApplyingModel) {
            return;
        }
        Color c = this.selectionComboBox.getSelectedColor();
        if (c != null) {
            this.termOptions.setSelectionBackground(c);
        }
    }

    public void setTermOptions(TermOptions termOptions) {
        if (this.termOptions != null) {
            this.termOptions.removePropertyChangeListener(this.propertyListener);
        }
        this.termOptions = termOptions;
        if (this.termOptions != null) {
            this.termOptions.addPropertyChangeListener(this.propertyListener);
        }
        this.refreshView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyTermOptions() {
        this.inApplyingModel = true;
        try {
            this.fontSizeSpinner.setValue(this.termOptions.getFontSize());
            this.fontText.setText(this.termOptions.getFont().getFamily() + " " + this.termOptions.getFont().getSize());
            this.foregroundComboBox.setSelectedColor(this.termOptions.getForeground());
            this.backgroundComboBox.setSelectedColor(this.termOptions.getBackground());
            this.selectionComboBox.setSelectedColor(this.termOptions.getSelectionBackground());
            this.historySizeSpinner.setValue(this.termOptions.getHistorySize());
            this.tabSizeSpinner.setValue(this.termOptions.getTabSize());
            if (!this.changingSelectByWordText) {
                this.selectByWordTextField.setText(this.termOptions.getSelectByWordDelimiters());
            }
            this.clickToTypeCheckBox.setSelected(this.termOptions.getClickToType());
            this.scrollOnInputCheckBox.setSelected(this.termOptions.getScrollOnInput());
            this.scrollOnOutputCheckBox.setSelected(this.termOptions.getScrollOnOutput());
            this.lineWrapCheckBox.setSelected(this.termOptions.getLineWrap());
            this.ignoreKeymapCheckBox.setSelected(this.termOptions.getIgnoreKeymap());
        }
        finally {
            this.inApplyingModel = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshView() {
        if (this.termOptions != null) {
            this.termOptions.removePropertyChangeListener(this.propertyListener);
        }
        try {
            this.applyTermOptions();
        }
        finally {
            if (this.termOptions != null) {
                this.termOptions.addPropertyChangeListener(this.propertyListener);
            }
        }
        this.previewTermOptions();
    }

    private void previewTermOptions() {
        if (this.term == null) {
            return;
        }
        this.term.setFixedFont(true);
        this.term.setFont(this.termOptions.getFont());
        this.term.setBackground(this.termOptions.getBackground());
        this.term.setForeground(this.termOptions.getForeground());
        this.term.setHighlightColor(this.termOptions.getSelectionBackground());
        this.term.setHistorySize(this.termOptions.getHistorySize());
        this.term.setTabSize(this.termOptions.getTabSize());
        this.term.setSelectByWordDelimiters(this.termOptions.getSelectByWordDelimiters());
        this.term.setClickToType(this.termOptions.getClickToType());
        this.term.setScrollOnInput(this.termOptions.getScrollOnInput());
        this.term.setScrollOnOutput(this.termOptions.getScrollOnOutput());
        this.term.setHorizontallyScrollable(!this.termOptions.getLineWrap());
        this.term.setRowsColumns(7, 60);
        this.patchSizes();
    }

    private void patchSizes() {
        this.term.invalidate();
        this.previewPanel.validate();
        this.previewPanel.invalidate();
        this.validate();
        this.invalidate();
    }
}

