/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.debug.breakpoints.ui;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.javascript2.debug.JSUtils;
import org.netbeans.modules.javascript2.debug.breakpoints.JSLineBreakpoint;
import org.netbeans.modules.javascript2.debug.breakpoints.ui.ControllerProvider;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.text.Line;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class JSLineBreakpointCustomizerPanel
extends JPanel
implements ControllerProvider,
HelpCtx.Provider {
    private static final RequestProcessor RP = new RequestProcessor(JSLineBreakpointCustomizerPanel.class);
    private final Controller controller;
    private final JSLineBreakpoint lb;
    private boolean createBreakpoint;
    private JLabel fileLabel;
    private JTextField fileTextField;
    private JLabel lineLabel;
    private JTextField lineTextField;

    private static JSLineBreakpoint createBreakpoint() {
        Line line = JSUtils.getCurrentLine();
        if (line == null) {
            return null;
        }
        return new JSLineBreakpoint(line);
    }

    public JSLineBreakpointCustomizerPanel() {
        this(JSLineBreakpointCustomizerPanel.createBreakpoint());
        this.createBreakpoint = true;
    }

    public JSLineBreakpointCustomizerPanel(JSLineBreakpoint lb) {
        this.lb = lb;
        this.initComponents();
        this.controller = this.createController();
        if (lb != null) {
            Line line = lb.getLine();
            FileObject fo = (FileObject)line.getLookup().lookup(FileObject.class);
            if (fo != null) {
                File file = FileUtil.toFile((FileObject)fo);
                if (file != null) {
                    this.fileTextField.setText(file.getAbsolutePath());
                } else {
                    this.fileTextField.setText(fo.toURL().toExternalForm());
                }
            }
            this.lineTextField.setText(Integer.toString(line.getLineNumber() + 1));
        }
    }

    protected Controller createController() {
        return new CustomizerController();
    }

    @Override
    public Controller getController() {
        return this.controller;
    }

    protected RequestProcessor getUpdateRP() {
        return RP;
    }

    private void initComponents() {
        this.fileLabel = new JLabel();
        this.fileTextField = new JTextField();
        this.lineLabel = new JLabel();
        this.lineTextField = new JTextField();
        this.fileLabel.setText(NbBundle.getMessage(JSLineBreakpointCustomizerPanel.class, (String)"JSLineBreakpointCustomizerPanel.fileLabel.text"));
        this.lineLabel.setText(NbBundle.getMessage(JSLineBreakpointCustomizerPanel.class, (String)"JSLineBreakpointCustomizerPanel.lineLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lineLabel).addComponent(this.fileLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fileTextField).addComponent(this.lineTextField, -1, 278, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fileLabel).addComponent(this.fileTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lineLabel).addComponent(this.lineTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerLineBreakpointJavaScript");
    }

    private static String toURL(String filePath) {
        URI uri = null;
        try {
            uri = URI.create(filePath);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (uri == null || !uri.isAbsolute()) {
            File f = new File(filePath);
            uri = f.toURI();
        }
        try {
            return uri.toURL().toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            return filePath;
        }
    }

    private class CustomizerController
    implements Controller {
        private CustomizerController() {
        }

        public boolean ok() {
            int lineNumber;
            JSLineBreakpoint lb = JSLineBreakpointCustomizerPanel.this.lb;
            String fileStr = JSLineBreakpointCustomizerPanel.toURL(JSLineBreakpointCustomizerPanel.this.fileTextField.getText());
            try {
                lineNumber = Integer.parseInt(JSLineBreakpointCustomizerPanel.this.lineTextField.getText());
            }
            catch (NumberFormatException nfex) {
                return false;
            }
            Line line = JSUtils.getLine(fileStr, --lineNumber);
            if (line == null) {
                return false;
            }
            if (lb != null) {
                this.updateBreakpoint(line);
            } else {
                lb = new JSLineBreakpoint(line);
            }
            if (JSLineBreakpointCustomizerPanel.this.createBreakpoint) {
                DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)lb);
            }
            return true;
        }

        private void updateBreakpoint(final Line line) {
            JSLineBreakpointCustomizerPanel.this.getUpdateRP().post(new Runnable(){

                @Override
                public void run() {
                    JSLineBreakpointCustomizerPanel.this.lb.setLine(line);
                }
            });
        }

        public boolean cancel() {
            return true;
        }

        public boolean isValid() {
            return true;
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
        }
    }
}

