/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.debug.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.modules.javascript2.debug.breakpoints.JSBreakpointsInfo;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public class JSBreakpointsInfoManager {
    private static JSBreakpointsInfoManager INSTANCE;
    private Collection<? extends JSBreakpointsInfo> infoServices;
    private final Object infoServicesLock = new Object();
    private final PropertyChangeListener servicePCL = new ServicePropertyChangeListener();
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private Boolean lastActivated = null;

    private JSBreakpointsInfoManager() {
        final Lookup.Result lookupResult = Lookup.getDefault().lookupResult(JSBreakpointsInfo.class);
        lookupResult.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent ev) {
                JSBreakpointsInfoManager.this.updateServices(lookupResult.allInstances());
            }
        });
        this.initServices(lookupResult.allInstances());
    }

    public static synchronized JSBreakpointsInfoManager getDefault() {
        if (INSTANCE == null) {
            INSTANCE = new JSBreakpointsInfoManager();
        }
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initServices(Collection<? extends JSBreakpointsInfo> activeServices) {
        for (JSBreakpointsInfo jSBreakpointsInfo : activeServices) {
            jSBreakpointsInfo.addPropertyChangeListener(this.servicePCL);
        }
        Object object = this.infoServicesLock;
        synchronized (object) {
            this.infoServices = activeServices;
            this.lastActivated = null;
        }
    }

    private void updateServices(Collection<? extends JSBreakpointsInfo> activeServices) {
        this.initServices(activeServices);
        this.fireChange("breakpointsActive");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<? extends JSBreakpointsInfo> getServices() {
        ArrayList<? extends JSBreakpointsInfo> services;
        Object object = this.infoServicesLock;
        synchronized (object) {
            services = new ArrayList<JSBreakpointsInfo>(this.infoServices);
        }
        return services;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean areBreakpointsActivated() {
        Boolean activated;
        Object object = this.infoServicesLock;
        synchronized (object) {
            activated = this.lastActivated;
        }
        boolean are = true;
        if (activated != null) {
            are = activated;
        } else {
            for (JSBreakpointsInfo jSBreakpointsInfo : this.getServices()) {
                if (jSBreakpointsInfo.areBreakpointsActivated()) continue;
                are = false;
                break;
            }
            Object object2 = this.infoServicesLock;
            synchronized (object2) {
                this.lastActivated = are;
            }
        }
        return are;
    }

    public boolean isDefault() {
        for (JSBreakpointsInfo jSBreakpointsInfo : this.getServices()) {
            if (!jSBreakpointsInfo.isDefault()) continue;
            return true;
        }
        return false;
    }

    public boolean isAnnotatable(FileObject fo) {
        for (JSBreakpointsInfo jSBreakpointsInfo : this.getServices()) {
            if (!jSBreakpointsInfo.isAnnotatable(fo)) continue;
            return true;
        }
        return false;
    }

    public boolean isTransientURL(URL url) {
        for (JSBreakpointsInfo jSBreakpointsInfo : this.getServices()) {
            if (!jSBreakpointsInfo.isTransientURL(url)) continue;
            return true;
        }
        return false;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    private void fireChange(String propertyName) {
        this.pcs.firePropertyChange(propertyName, null, null);
    }

    private final class ServicePropertyChangeListener
    implements PropertyChangeListener {
        private ServicePropertyChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("breakpointsActive".equals(evt.getPropertyName())) {
                Object object = JSBreakpointsInfoManager.this.infoServicesLock;
                synchronized (object) {
                    JSBreakpointsInfoManager.this.lastActivated = null;
                }
                JSBreakpointsInfoManager.this.fireChange("breakpointsActive");
            }
        }
    }
}

