/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.core.filesystems;

import java.awt.Image;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.modules.versioning.core.APIAccessor;
import org.netbeans.modules.versioning.core.VersioningAnnotationProvider;
import org.netbeans.modules.versioning.core.VersioningManager;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSInterceptor;
import org.netbeans.modules.versioning.core.util.VCSSystemProvider;
import org.openide.filesystems.FileObject;

public final class VCSFilesystemInterceptor {
    private static final Logger LOG = VersioningManager.LOG;
    private static final VersioningManager master = VersioningManager.getInstance();
    private static final Set<VCSFileProxy> deletedFiles = new HashSet<VCSFileProxy>(5);
    private static final String ATTRIBUTE_REMOTE_LOCATION = "ProvidedExtensions.RemoteLocation";
    private static final String ATTRIBUTE_REFRESH = "ProvidedExtensions.Refresh";
    private static final String ATTRIBUTE_SEARCH_HISTORY = "ProvidedExtensions.SearchHistorySupport";
    private static final Map<FileEx, DelegatingInterceptor> filesBeingCreated = new HashMap<FileEx, DelegatingInterceptor>(10);
    private static final DelegatingInterceptor nullDelegatingInterceptor = new DelegatingInterceptor(){

        @Override
        public boolean beforeDelete() {
            return false;
        }

        @Override
        public void doDelete() throws IOException {
        }

        @Override
        public void afterDelete() {
        }

        @Override
        public boolean beforeMove() {
            return false;
        }

        @Override
        public void doMove() throws IOException {
        }

        @Override
        public boolean beforeCreate() {
            return false;
        }

        @Override
        public void doCreate() throws IOException {
        }

        @Override
        public void afterCreate() {
        }

        @Override
        public void beforeChange() {
        }

        @Override
        public void beforeEdit() {
        }

        @Override
        public void afterChange() {
        }

        @Override
        public void afterMove() {
        }
    };
    private static final VCSInterceptor nullInterceptor = new VCSInterceptor(){

        @Override
        public boolean isMutable(VCSFileProxy file) {
            return false;
        }

        @Override
        public Object getAttribute(VCSFileProxy file, String attrName) {
            return null;
        }

        @Override
        public boolean beforeDelete(VCSFileProxy file) {
            return false;
        }

        @Override
        public void doDelete(VCSFileProxy file) throws IOException {
        }

        @Override
        public void afterDelete(VCSFileProxy file) {
        }

        @Override
        public boolean beforeMove(VCSFileProxy from, VCSFileProxy to) {
            return false;
        }

        @Override
        public void doMove(VCSFileProxy from, VCSFileProxy to) throws IOException {
        }

        @Override
        public void afterMove(VCSFileProxy from, VCSFileProxy to) {
        }

        @Override
        public boolean beforeCopy(VCSFileProxy from, VCSFileProxy to) {
            return false;
        }

        @Override
        public void doCopy(VCSFileProxy from, VCSFileProxy to) throws IOException {
        }

        @Override
        public void afterCopy(VCSFileProxy from, VCSFileProxy to) {
        }

        @Override
        public boolean beforeCreate(VCSFileProxy file, boolean isDirectory) {
            return false;
        }

        @Override
        public void doCreate(VCSFileProxy file, boolean isDirectory) throws IOException {
        }

        @Override
        public void afterCreate(VCSFileProxy file) {
        }

        @Override
        public void afterChange(VCSFileProxy file) {
        }

        @Override
        public void beforeChange(VCSFileProxy file) {
        }

        @Override
        public void beforeEdit(VCSFileProxy file) {
        }

        @Override
        public long refreshRecursively(VCSFileProxy dir, long lastTimeStamp, List<? super VCSFileProxy> children) {
            return -1L;
        }
    };

    private VCSFilesystemInterceptor() {
    }

    public static void registerFileStatusListener(VCSAnnotationListener listener) {
        VersioningManager.statusListener(listener, true);
    }

    public static Image annotateIcon(Image icon, int iconType, Set<? extends FileObject> files) {
        return VersioningAnnotationProvider.getDefault().annotateIcon(icon, iconType, files);
    }

    public static String annotateNameHtml(String name, Set<? extends FileObject> files) {
        return VersioningAnnotationProvider.getDefault().annotateNameHtml(name, files);
    }

    public static Action[] actions(Set<? extends FileObject> files) {
        return VersioningAnnotationProvider.getDefault().actions(files);
    }

    public static boolean canWriteReadonlyFile(VCSFileProxy file) {
        LOG.log(Level.FINE, "canWrite {0}", file);
        return VCSFilesystemInterceptor.getInterceptor(file, false, "isMutable").isMutable(file);
    }

    public static Object getAttribute(VCSFileProxy file, String attrName) {
        LOG.log(Level.FINE, "getAttribute {0}, {1}", new Object[]{file, attrName});
        if (ATTRIBUTE_REMOTE_LOCATION.equals(attrName) || ATTRIBUTE_REFRESH.equals(attrName) || ATTRIBUTE_SEARCH_HISTORY.equals(attrName)) {
            return VCSFilesystemInterceptor.getInterceptor(file, file.isDirectory(), "getAttribute").getAttribute(attrName);
        }
        return null;
    }

    public static void beforeChange(VCSFileProxy file) {
        LOG.log(Level.FINE, "beforeChange {0}", file);
        VCSFilesystemInterceptor.getInterceptor(file, file.isDirectory(), "beforeChange").beforeChange();
    }

    public static void fileChanged(VCSFileProxy file) {
        LOG.log(Level.FINE, "fileChanged {0}", file);
        VCSFilesystemInterceptor.removeFromDeletedFiles(file);
        VCSFilesystemInterceptor.getInterceptor(file, "afterChange").afterChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeFromDeletedFiles(VCSFileProxy file) {
        Set<VCSFileProxy> set = deletedFiles;
        synchronized (set) {
            deletedFiles.remove(file);
        }
    }

    public static IOHandler getDeleteHandler(VCSFileProxy file) {
        LOG.log(Level.FINE, "getDeleteHandler {0}", file);
        VCSFilesystemInterceptor.removeFromDeletedFiles(file);
        DelegatingInterceptor dic = VCSFilesystemInterceptor.getInterceptor(file, (Boolean)null, "beforeDelete", "doDelete");
        return dic.beforeDelete() ? dic : null;
    }

    public static void deleteSuccess(VCSFileProxy file) {
        LOG.log(Level.FINE, "deleteSuccess {0}", file);
        VCSFilesystemInterceptor.removeFromDeletedFiles(file);
        VCSFilesystemInterceptor.getInterceptor(file, "afterDelete").afterDelete();
    }

    public static void deletedExternally(VCSFileProxy file) {
        LOG.log(Level.FINE, "deletedExternally {0}", file);
        VCSFilesystemInterceptor.removeFromDeletedFiles(file);
        VCSFilesystemInterceptor.getInterceptor(file, "afterDelete").afterDelete();
    }

    public static void beforeCreate(VCSFileProxy parent, String name, boolean isFolder) {
        LOG.log(Level.FINE, "beforeCreate {0}, {1}, {2} ", new Object[]{parent, name, isFolder});
        if (parent == null) {
            return;
        }
        VCSFileProxy file = APIAccessor.IMPL.createFileProxy(parent, name, isFolder);
        DelegatingInterceptor dic = VCSFilesystemInterceptor.getInterceptor(file, isFolder, "beforeCreate");
        if (dic.beforeCreate()) {
            filesBeingCreated.put(new FileEx(parent, name, isFolder), dic);
        }
    }

    public static void createFailure(VCSFileProxy parent, String name, boolean isFolder) {
        LOG.log(Level.FINE, "createFailure {0}, {1}, {2} ", new Object[]{parent, name, isFolder});
        filesBeingCreated.remove(new FileEx(parent, name, isFolder));
    }

    public static void createSuccess(VCSFileProxy file) {
        LOG.log(Level.FINE, "createSuccess {0}", new Object[]{file});
        VCSFilesystemInterceptor.createSuccessImpl(file);
    }

    public static void createdExternally(VCSFileProxy file) {
        LOG.log(Level.FINE, "createdExternally {0}", new Object[]{file});
        VCSFilesystemInterceptor.createSuccessImpl(file);
    }

    private static void createSuccessImpl(VCSFileProxy file) {
        FileEx fileEx = new FileEx(file.getParentFile(), file.getName(), file.isDirectory());
        DelegatingInterceptor interceptor = filesBeingCreated.remove(fileEx);
        if (interceptor != null) {
            try {
                interceptor.doCreate();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        VCSFilesystemInterceptor.removeFromDeletedFiles(file);
        if (interceptor == null) {
            interceptor = VCSFilesystemInterceptor.getInterceptor(file, "afterCreate");
        }
        interceptor.afterCreate();
    }

    public static IOHandler getMoveHandler(VCSFileProxy from, VCSFileProxy to) {
        LOG.log(Level.FINE, "getMoveHandler {0}, {1}", new Object[]{from, to});
        return VCSFilesystemInterceptor.getMoveHandlerIntern(from, to);
    }

    public static IOHandler getRenameHandler(VCSFileProxy from, String newName) {
        LOG.log(Level.FINE, "getRenameHandler {0}, {1}", new Object[]{from, newName});
        return VCSFilesystemInterceptor.getMoveHandlerIntern(from, VCSFileProxy.createFileProxy(from.getParentFile(), newName));
    }

    private static IOHandler getMoveHandlerIntern(VCSFileProxy from, VCSFileProxy to) {
        DelegatingInterceptor dic = VCSFilesystemInterceptor.getInterceptor(from, to, "beforeMove", "doMove");
        return dic.beforeMove() ? dic.getMoveHandler() : null;
    }

    public static void afterMove(VCSFileProxy from, VCSFileProxy to) {
        LOG.log(Level.FINE, "afterMove {0}, {1}", new Object[]{from, to});
        VCSFilesystemInterceptor.removeFromDeletedFiles(from);
        VCSFilesystemInterceptor.getInterceptor(from, to, "afterMove").afterMove();
    }

    public static IOHandler getCopyHandler(VCSFileProxy from, VCSFileProxy to) {
        LOG.log(Level.FINE, "getCopyHandler {0}, {1}", new Object[]{from, to});
        DelegatingInterceptor dic = VCSFilesystemInterceptor.getInterceptor(from, to, "beforeCopy", "doCopy");
        return dic.beforeCopy() ? dic.getCopyHandler() : null;
    }

    public static void beforeCopy(VCSFileProxy from, VCSFileProxy to) {
    }

    public static void copySuccess(VCSFileProxy from, VCSFileProxy to) {
        LOG.log(Level.FINE, "copySuccess {0}, {1}", new Object[]{from, to});
        VCSFilesystemInterceptor.getInterceptor(from, to, "afterCopy").afterCopy();
    }

    public static void fileLocked(VCSFileProxy fo) throws IOException {
        LOG.log(Level.FINE, "fileLocked {0}", fo);
        VCSFilesystemInterceptor.getInterceptor(fo, "beforeEdit").beforeEdit();
    }

    public static long listFiles(VCSFileProxy dir, long lastTimeStamp, List<? super VCSFileProxy> children) {
        LOG.log(Level.FINE, "listFiles {0}, {1}", new Object[]{dir, lastTimeStamp});
        if (LOG.isLoggable(Level.FINER)) {
            for (VCSFileProxy vCSFileProxy : children) {
                LOG.log(Level.FINE, "  listFiles child {1}", vCSFileProxy);
            }
        }
        DelegatingInterceptor interceptor = VCSFilesystemInterceptor.getRefreshInterceptor(dir);
        return interceptor.refreshRecursively(dir, lastTimeStamp, children);
    }

    private static boolean needsLH(String ... methodNames) {
        if (Boolean.getBoolean("versioning.no.localhistory.interceptor")) {
            return false;
        }
        for (String methodName : methodNames) {
            if (!master.needsLocalHistory(methodName)) continue;
            return true;
        }
        return false;
    }

    private static DelegatingInterceptor getInterceptor(VCSFileProxy file, String ... forMethods) {
        return VCSFilesystemInterceptor.getInterceptor(file, file.isDirectory(), forMethods);
    }

    private static DelegatingInterceptor getInterceptor(VCSFileProxy file, Boolean isDirectory, String ... forMethods) {
        if (file == null || master == null) {
            return nullDelegatingInterceptor;
        }
        Boolean isFile = isDirectory != null ? Boolean.valueOf(isDirectory == false) : null;
        isDirectory = isDirectory != null ? isDirectory : false;
        VCSSystemProvider.VersioningSystem vs = master.getOwner(file, isFile);
        VCSInterceptor vsInterceptor = vs != null ? vs.getVCSInterceptor() : nullInterceptor;
        VCSSystemProvider.VersioningSystem lhvs = VCSFilesystemInterceptor.needsLH(forMethods) ? master.getLocalHistory(file, isFile) : null;
        VCSInterceptor localHistoryInterceptor = lhvs != null ? lhvs.getVCSInterceptor() : nullInterceptor;
        return new DelegatingInterceptor(vsInterceptor, localHistoryInterceptor, file, null, (boolean)isDirectory);
    }

    private static DelegatingInterceptor getInterceptor(VCSFileProxy from, VCSFileProxy to, String ... forMethods) {
        if (from == null || to == null) {
            return nullDelegatingInterceptor;
        }
        VCSSystemProvider.VersioningSystem vs = master.getOwner(from);
        VCSInterceptor vsInterceptor = vs != null ? vs.getVCSInterceptor() : nullInterceptor;
        VCSSystemProvider.VersioningSystem lhvs = VCSFilesystemInterceptor.needsLH(forMethods) ? master.getLocalHistory(from) : null;
        VCSInterceptor localHistoryInterceptor = lhvs != null ? lhvs.getVCSInterceptor() : nullInterceptor;
        return new DelegatingInterceptor(vsInterceptor, localHistoryInterceptor, from, to, false);
    }

    private static DelegatingInterceptor getRefreshInterceptor(VCSFileProxy dir) {
        if (dir == null) {
            return nullDelegatingInterceptor;
        }
        VCSSystemProvider.VersioningSystem vs = master.getOwner(dir);
        VCSInterceptor Interceptor = vs != null ? vs.getVCSInterceptor() : nullInterceptor;
        return new DelegatingInterceptor(Interceptor, nullInterceptor, dir, null, true);
    }

    private static class DelegatingInterceptor
    implements IOHandler {
        final Collection<VCSInterceptor> interceptors;
        final VCSInterceptor interceptor;
        final VCSInterceptor lhInterceptor;
        final VCSFileProxy file;
        final VCSFileProxy to;
        private final boolean isDirectory;
        private IOHandler moveHandler;
        private IOHandler copyHandler;

        private DelegatingInterceptor() {
            this((VCSInterceptor)null, null, null, null, false);
        }

        public DelegatingInterceptor(VCSInterceptor interceptor, VCSInterceptor lhInterceptor, VCSFileProxy file, VCSFileProxy to, boolean isDirectory) {
            this.interceptor = interceptor != null ? interceptor : nullInterceptor;
            this.interceptors = Collections.singleton(this.interceptor);
            this.lhInterceptor = lhInterceptor != null ? lhInterceptor : nullInterceptor;
            this.file = file;
            this.to = to;
            this.isDirectory = isDirectory;
        }

        public DelegatingInterceptor(Collection<VCSInterceptor> interceptors, VCSInterceptor lhInterceptor, VCSFileProxy file, VCSFileProxy to, boolean isDirectory) {
            this.interceptors = interceptors != null && interceptors.size() > 0 ? interceptors : Collections.singleton(nullInterceptor);
            this.interceptor = this.interceptors.iterator().next();
            this.lhInterceptor = lhInterceptor != null ? lhInterceptor : nullInterceptor;
            this.file = file;
            this.to = to;
            this.isDirectory = isDirectory;
        }

        public boolean isMutable(VCSFileProxy file) {
            return this.interceptor.isMutable(file);
        }

        private Object getAttribute(String attrName) {
            return this.interceptor.getAttribute(this.file, attrName);
        }

        public boolean beforeDelete() {
            this.lhInterceptor.beforeDelete(this.file);
            return this.interceptor.beforeDelete(this.file);
        }

        public void doDelete() throws IOException {
            this.lhInterceptor.doDelete(this.file);
            this.interceptor.doDelete(this.file);
        }

        public void afterDelete() {
            this.lhInterceptor.afterDelete(this.file);
            this.interceptor.afterDelete(this.file);
        }

        public boolean beforeMove() {
            this.lhInterceptor.beforeMove(this.file, this.to);
            return this.interceptor.beforeMove(this.file, this.to);
        }

        public void doMove() throws IOException {
            this.lhInterceptor.doMove(this.file, this.to);
            this.interceptor.doMove(this.file, this.to);
        }

        public void afterMove() {
            this.lhInterceptor.afterMove(this.file, this.to);
            this.interceptor.afterMove(this.file, this.to);
        }

        public boolean beforeCopy() {
            this.lhInterceptor.beforeCopy(this.file, this.to);
            return this.interceptor.beforeCopy(this.file, this.to);
        }

        public void doCopy() throws IOException {
            this.lhInterceptor.doCopy(this.file, this.to);
            this.interceptor.doCopy(this.file, this.to);
        }

        public void afterCopy() {
            this.lhInterceptor.afterCopy(this.file, this.to);
            this.interceptor.afterCopy(this.file, this.to);
        }

        public boolean beforeCreate() {
            this.lhInterceptor.beforeCreate(this.file, this.isDirectory);
            return this.interceptor.beforeCreate(this.file, this.isDirectory);
        }

        public void doCreate() throws IOException {
            this.lhInterceptor.doCreate(this.file, this.isDirectory);
            this.interceptor.doCreate(this.file, this.isDirectory);
        }

        public void afterCreate() {
            this.lhInterceptor.afterCreate(this.file);
            this.interceptor.afterCreate(this.file);
        }

        public void afterChange() {
            this.lhInterceptor.afterChange(this.file);
            this.interceptor.afterChange(this.file);
        }

        public void beforeChange() {
            this.lhInterceptor.beforeChange(this.file);
            this.interceptor.beforeChange(this.file);
        }

        public void beforeEdit() throws IOException {
            this.lhInterceptor.beforeEdit(this.file);
            this.interceptor.beforeEdit(this.file);
        }

        private IOHandler getMoveHandler() {
            if (this.moveHandler == null) {
                this.moveHandler = new IOHandler(){

                    @Override
                    public void handle() throws IOException {
                        LOG.log(Level.FINE, "move handle {0}", new Object[]{DelegatingInterceptor.this.file, DelegatingInterceptor.this.to});
                        DelegatingInterceptor.this.doMove();
                    }
                };
            }
            return this.moveHandler;
        }

        private IOHandler getCopyHandler() {
            if (this.copyHandler == null) {
                this.copyHandler = new IOHandler(){

                    @Override
                    public void handle() throws IOException {
                        LOG.log(Level.FINE, "copy handle {0}", new Object[]{DelegatingInterceptor.this.file, DelegatingInterceptor.this.to});
                        DelegatingInterceptor.this.doCopy();
                    }
                };
            }
            return this.copyHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle() throws IOException {
            LOG.log(Level.FINE, "delete handle {0}", new Object[]{this.file});
            this.lhInterceptor.doDelete(this.file);
            this.interceptor.doDelete(this.file);
            Set set = deletedFiles;
            synchronized (set) {
                if (this.file.isDirectory()) {
                    Iterator i = deletedFiles.iterator();
                    while (i.hasNext()) {
                        VCSFileProxy fakedFile = (VCSFileProxy)i.next();
                        if (!this.file.equals(fakedFile.getParentFile())) continue;
                        i.remove();
                    }
                }
                if (this.file.exists()) {
                    deletedFiles.add(this.file);
                } else {
                    deletedFiles.remove(this.file);
                }
            }
        }

        public long refreshRecursively(VCSFileProxy dir, long lastTimeStamp, List<? super VCSFileProxy> children) {
            return this.interceptor.refreshRecursively(dir, lastTimeStamp, children);
        }
    }

    private static class FileEx {
        final VCSFileProxy parent;
        final String name;
        final boolean isFolder;

        public FileEx(VCSFileProxy parent, String name, boolean folder) {
            this.parent = parent;
            this.name = name;
            this.isFolder = folder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof FileEx)) {
                return false;
            }
            FileEx fileEx = (FileEx)o;
            return this.isFolder == fileEx.isFolder && this.name.equals(fileEx.name) && this.parent.equals(fileEx.parent);
        }

        public int hashCode() {
            int result = this.parent.hashCode();
            result = 17 * result + this.name.hashCode();
            result = 17 * result + (this.isFolder ? 1 : 0);
            return result;
        }
    }

    public static interface IOHandler {
        public void handle() throws IOException;
    }

    public static final class VCSAnnotationEvent {
        private Set<? extends FileObject> files;
        private boolean icon;
        private boolean name;

        public VCSAnnotationEvent(Set<? extends FileObject> files, boolean icon, boolean name) {
            this.files = files;
            this.icon = icon;
            this.name = name;
        }

        public VCSAnnotationEvent(FileObject file, boolean icon, boolean name) {
            this(Collections.singleton(file), icon, name);
        }

        public VCSAnnotationEvent(boolean icon, boolean name) {
            this((Set<? extends FileObject>)null, icon, name);
        }

        public boolean isNameChange() {
            return this.name;
        }

        public boolean isIconChange() {
            return this.icon;
        }

        public Set<? extends FileObject> getFiles() {
            return this.files;
        }
    }

    public static interface VCSAnnotationListener {
        public void annotationChanged(VCSAnnotationEvent var1);
    }
}

