/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.eventbase;

import de.proveo.eventbase.EventPayload;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EventResponse
implements Serializable {
    private static final Log log = LogFactory.getLog(EventResponse.class);
    protected static final int EVENT_RESPONSE_INDEX = 0;
    private static final int VPN_INDEX = 1;
    protected static final int USER_ACL_CHANGED_INDEX = 2;
    protected static final int GEO_AREAS_CHANGED_INDEX = 3;
    protected static final int SOFTWARE_UPDATE_AVAILABLE_INDEX = 4;
    protected static final int CONFIGURATION_UPDATE_AVAILABLE_INDEX = 5;
    protected static final int RESET_INDEX = 6;
    protected final Map payloads = new HashMap();
    protected boolean[] flags = new boolean[7];

    public boolean equals(Object obj) {
        if (!obj.getClass().getName().equals(EventResponse.class.getName())) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        EventResponse that = (EventResponse)obj;
        EqualsBuilder eqBuilder = new EqualsBuilder();
        eqBuilder.append(this.flags, that.flags);
        eqBuilder.append((Object)this.payloads, (Object)that.payloads);
        return eqBuilder.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder hq = new HashCodeBuilder();
        hq.append(this.flags);
        hq.append((Object)this.payloads);
        return hq.toHashCode();
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this);
        toStringBuilder.append("eventResponse", this.isEventResponse());
        toStringBuilder.append("vpn", this.isVPN());
        toStringBuilder.append("userACLchanged", this.isUserACLChanged());
        toStringBuilder.append("geoAreasChanged", this.isGeoAreasChanged());
        toStringBuilder.append("softwareUpdateAvailable", this.isSoftwareUpdateAvailable());
        toStringBuilder.append("configurationUpdateAvailable", this.isConfigurationUpdateAvailable());
        toStringBuilder.append("reset", this.isReset());
        toStringBuilder.append("payloads", (Object)this.getPayloads());
        return toStringBuilder.toString();
    }

    public void addPayload(EventPayload payload) {
        this.payloads.put(payload.getName(), payload);
    }

    public EventPayload getPayload(String name) {
        return (EventPayload)this.payloads.get(name);
    }

    public Collection getPayloads() {
        return this.payloads.values();
    }

    public void setPayloads(Collection values) {
        this.payloads.clear();
        for (EventPayload eventPayload : values) {
            this.payloads.put(eventPayload.getName(), eventPayload);
        }
    }

    public boolean isConfigurationUpdateAvailable() {
        return this.flags[5];
    }

    public boolean isEventResponse() {
        return this.flags[0];
    }

    public boolean isGeoAreasChanged() {
        return this.flags[3];
    }

    public boolean isPayloadEmpty() {
        return this.payloads.isEmpty();
    }

    public boolean isReset() {
        return this.flags[6];
    }

    public boolean isResponseValid(byte[] response) {
        return true;
    }

    public boolean isSoftwareUpdateAvailable() {
        return this.flags[4];
    }

    public boolean isUserACLChanged() {
        return this.flags[2];
    }

    public boolean isVPN() {
        return this.flags[1];
    }

    public void removePayload(String name) {
        this.payloads.remove(name);
    }

    public void setConfigurationUpdateAvailable(boolean configurationUpdateAvailable) {
        this.flags[5] = configurationUpdateAvailable;
    }

    public void setEventResponse(boolean eventResponseValue) {
        this.flags[0] = eventResponseValue;
    }

    public void setGeoAreasChanged(boolean geoAreasChanged) {
        this.flags[3] = geoAreasChanged;
    }

    public void setReset(boolean reset) {
        this.flags[6] = reset;
    }

    public void setSoftwareUpdateAvailable(boolean softwareUpdateAvailable) {
        this.flags[4] = softwareUpdateAvailable;
    }

    public void setUserACLChanged(boolean userACLChanged) {
        this.flags[2] = userACLChanged;
    }

    public void setVPN(boolean eventVPNValue) {
        this.flags[1] = eventVPNValue;
    }
}

