/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.summarizedData.dto.statusDuration;

import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityValue;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelValue;
import de.proveo.wwt.logic.ejb.general.unit.entity.typeidentity.UnitTypeIdentityValue;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.common.dto.UnitDTOListBase;
import de.proveo.wwt.logic.web.summarizedData.dto.statusDuration.StatusDurationsDTO;
import java.util.HashMap;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatusDurationsDTOList
extends UnitDTOListBase<StatusDurationsDTO> {
    private long[] statusIds;
    private HashMap<Long, Long> totalDurationMap;
    private long stateModelId;

    public StatusDurationsDTOList(UnitModelValue unitModelValue, UnitIdentityValue unitIdentityValue, UnitTypeIdentityValue unitTypeIdentityValue, long stateModelId, long beginTime, long endTime, long[] statusIds) {
        super(unitModelValue, unitIdentityValue, unitTypeIdentityValue, beginTime, endTime);
        this.stateModelId = stateModelId;
        this.statusIds = statusIds;
    }

    @Override
    public long getStateModelId() {
        return this.stateModelId;
    }

    public StatusDurationsDTOList(UnitDTO buildUnitDTO, Long beginTime, Long endTime, Long stateModelId, long[] statusIds) {
        super(buildUnitDTO, beginTime, endTime);
        this.stateModelId = stateModelId;
        this.statusIds = statusIds;
    }

    public Long getTotalDurationForStatus(long stateId) {
        Long totalDuration = 0L;
        for (StatusDurationsDTO durationsDTO : this) {
            Long duration = durationsDTO.getDuration(stateId);
            if (duration == null) {
                return null;
            }
            totalDuration = totalDuration + duration;
        }
        return totalDuration;
    }

    public HashMap<Long, Long> getTotalDurationMap() {
        if (this.totalDurationMap == null) {
            this.totalDurationMap = new HashMap();
            for (int i = 0; i < this.statusIds.length; ++i) {
                Long totalDuration = 0L;
                for (StatusDurationsDTO durationsDTO : this) {
                    Long duration = durationsDTO.getDuration(this.statusIds[i]);
                    if (duration == null) {
                        return null;
                    }
                    totalDuration = totalDuration + duration;
                }
                this.totalDurationMap.put(this.statusIds[i], totalDuration);
            }
        }
        return this.totalDurationMap;
    }

    public long getTotalDuration() {
        long totalDuration = 0L;
        for (StatusDurationsDTO dto : this) {
            totalDuration += dto.getTotalDuration();
        }
        return totalDuration;
    }

    public long[] getStatusIds() {
        return this.statusIds;
    }

    public boolean dataAvailable() {
        boolean chartDataAvailable = false;
        block0: for (StatusDurationsDTO dto : this) {
            Set<Long> set = dto.getStatusIds();
            for (Long statusId : set) {
                if (this.getTotalDurationForStatus(statusId) == 0L) continue;
                chartDataAvailable = true;
                continue block0;
            }
        }
        return chartDataAvailable;
    }
}

