/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.maintenance.facade;

import de.proveo.eventbase.EventResponse;
import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.logic.ejb.dataIn.event.EventFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.event.EventFacadeUtil;
import de.proveo.wwt.logic.ejb.dataIn.informant.InformantFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.informant.InformantFacadeUtil;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.CurrentStateCacheLocal;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.CurrentStateCacheLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.CurrentStateCachePK;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.CurrentStateCacheUtil;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.CurrentStateCacheValue;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.StateHistoryLocal;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.StateHistoryLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.StateHistoryPK;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.StateHistoryUtil;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.StateHistoryValue;
import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityValue;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelValue;
import de.proveo.wwt.logic.ejb.general.unit.entity.typeidentity.UnitTypeIdentityValue;
import de.proveo.wwt.logic.web.admin.AdminFacadeLocal;
import de.proveo.wwt.logic.web.admin.AdminFacadeUtil;
import de.proveo.wwt.logic.web.common.dto.DTOLogicUtil;
import de.proveo.wwt.logic.web.currentData.CurrentDataFacadeLocal;
import de.proveo.wwt.logic.web.currentData.CurrentDataFacadeUtil;
import de.proveo.wwt.logic.web.historyData.dto.StateDTO;
import de.proveo.wwt.logic.web.historyData.dto.StateDTOList;
import de.proveo.wwt.logic.web.maintenance.forecast.dto.MaintenanceForecastDTO;
import de.proveo.wwt.logic.web.maintenance.forecast.dto.MaintenanceForecastDTOList;
import de.proveo.wwt.logic.web.summarizedData.SummarizedDataFacadeLocal;
import de.proveo.wwt.logic.web.summarizedData.SummarizedDataFacadeUtil;
import de.proveo.wwt.logic.web.summarizedData.dto.statusDuration.StatusDurationsDTO;
import de.proveo.wwt.logic.web.summarizedData.dto.statusDuration.StatusDurationsDTOList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MaintenanceFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final Log logger = LogFactory.getLog(MaintenanceFacadeBean.class);
    private SummarizedDataFacadeLocal summarizedDataFacadeLocal = null;
    private CurrentDataFacadeLocal currentDataHome = null;
    private AdminFacadeLocal adminFacade = null;
    private CurrentStateCacheLocalHome currentStateCacheHome = null;
    private StateHistoryLocalHome stateHistoryLocalHome = null;
    private InformantFacadeLocal informantFacade = null;
    private static final long engineStateModel = 2010L;
    private static final long engineStateRunsNecessarily = 2012L;
    private static final long engineStateRunsUnnecessarily = 2013L;

    @Override
    public void ejbCreate() throws CreateException {
        try {
            this.summarizedDataFacadeLocal = SummarizedDataFacadeUtil.getLocalHome().create();
            this.currentDataHome = CurrentDataFacadeUtil.getLocalHome().create();
            this.adminFacade = AdminFacadeUtil.getLocalHome().create();
            this.currentStateCacheHome = CurrentStateCacheUtil.getLocalHome();
            this.stateHistoryLocalHome = StateHistoryUtil.getLocalHome();
            this.informantFacade = InformantFacadeUtil.getLocalHome().create();
        }
        catch (NamingException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
    }

    public List<MaintenanceForecastDTO> getMaintenanceForecastDTO(Long unitId, int flashbackDays, int forecastDays) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getMaintenanceForecastDTO() called with unitId=" + String.valueOf(unitId)));
        }
        long executionTime = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Maintenance Forecast: retrieving runtimes...");
        }
        StatusDurationsDTOList totalRuntimeList = this.summarizedDataFacadeLocal.getDurationsSummarizedfromStateSummary(unitId, 2010L, 0L, System.currentTimeMillis(), false, false, false);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Maintenance Forecast: generating flashback list...");
        }
        DateTime dateTimeNow = new DateTime();
        DateTime dateTimeFlashback = dateTimeNow.minusDays(flashbackDays);
        StatusDurationsDTOList flashbackList = this.summarizedDataFacadeLocal.getDurationsSummarizedfromStateSummary(unitId, 2010L, dateTimeFlashback.getMillis(), System.currentTimeMillis(), false, false, false);
        HashMap<Long, StatusDurationsDTO> unitFlashbackMap = new HashMap<Long, StatusDurationsDTO>();
        for (int i = 0; i < flashbackList.size(); ++i) {
            StatusDurationsDTO dto = (StatusDurationsDTO)flashbackList.get(i);
            unitFlashbackMap.put(dto.getUnitId(), dto);
        }
        MaintenanceForecastDTOList forecastDtoList = new MaintenanceForecastDTOList();
        for (int i = 0; i < totalRuntimeList.size(); ++i) {
            StatusDurationsDTO totalRuntimeDto = (StatusDurationsDTO)totalRuntimeList.get(i);
            UnitModelValue unitModel = totalRuntimeDto.getUnitModelValue();
            if (unitModel == null) continue;
            float averageRuntimeHours = 0.0f;
            StatusDurationsDTO dtoFlashback = (StatusDurationsDTO)unitFlashbackMap.get(unitModel.getUnitId());
            if (dtoFlashback != null) {
                averageRuntimeHours = ((float)dtoFlashback.getDuration(2013L) + (float)dtoFlashback.getDuration(2012L)) / (float)flashbackDays / 3600000.0f;
                averageRuntimeHours = (float)Math.round(averageRuntimeHours * 100.0f) / 100.0f;
            }
            long totalRuntime = totalRuntimeDto.getDuration(2013L) + totalRuntimeDto.getDuration(2012L) + unitModel.getOperativeTimeOffset();
            long totalRuntimeHours = Math.round((float)totalRuntime / 3600000.0f);
            long availableRuntimeHours = (long)unitModel.getNextMaintenance() - totalRuntimeHours;
            boolean overdue = (float)availableRuntimeHours <= 0.0f;
            int daysToMaintenance = 9999;
            long maintenanceDateMillis = 0L;
            if (averageRuntimeHours != 0.0f) {
                daysToMaintenance = Math.round((float)availableRuntimeHours / averageRuntimeHours);
                DateTime maintenanceDate = dateTimeNow.plusDays(daysToMaintenance);
                maintenanceDateMillis = maintenanceDate.getMillis();
            } else if (overdue) {
                daysToMaintenance = 0;
                maintenanceDateMillis = dateTimeNow.getMillis();
            }
            if (daysToMaintenance > forecastDays) continue;
            UnitIdentityValue unitIdentity = totalRuntimeDto.getUnitIdentityValue();
            UnitTypeIdentityValue unitTypeIdentity = totalRuntimeDto.getUnitTypeIdentityValue();
            MaintenanceForecastDTO forecastDTO = new MaintenanceForecastDTO(unitModel, unitIdentity, unitTypeIdentity, totalRuntimeHours, availableRuntimeHours, overdue, averageRuntimeHours, daysToMaintenance, maintenanceDateMillis);
            forecastDtoList.add(forecastDTO);
        }
        forecastDtoList.setExecutionTime(System.currentTimeMillis() - executionTime);
        DTOLogicUtil.logListSizeAndExecutionTime(logger, forecastDtoList);
        return forecastDtoList;
    }

    private boolean updateCurrentStateCache(StateDTO dto) {
        boolean successful = false;
        CurrentStateCachePK pkCache = new CurrentStateCachePK(dto.getUnitId(), dto.getStateModelId());
        try {
            CurrentStateCacheLocal cache = this.currentStateCacheHome.findByPrimaryKey(pkCache);
            CurrentStateCacheValue value = cache.getCurrentStateCacheValue();
            StateHistoryLocal hist = this.stateHistoryLocalHome.findByPrimaryKey(new StateHistoryPK(value.getPkStatePrevious()));
            StateHistoryValue stateHistoryValue = hist.getStateHistoryValue();
            if (dto.getStateId() == value.getState()) {
                value.setRemark(dto.getRemark());
                cache.setCurrentStateCacheValue(value);
                SerializableEventWrapper wrapper = new SerializableEventWrapper(value, stateHistoryValue);
                wrapper.set_typeOfEvent("StateEventHistoryAndCache");
                try {
                    this.informantFacade.notify(wrapper, "StateEventHistoryAndCache");
                    successful = true;
                }
                catch (Exception e) {
                    logger.error((Object)"handleStateEvent runs into Exception: ", (Throwable)e);
                }
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return successful;
    }

    public boolean generateStateEvent(StateDTO dto) {
        boolean successful = false;
        Properties event = this.buildEvent(dto);
        try {
            StateDTOList list = this.currentDataHome.getCurrentStateData(dto.getUnitId(), 2090L, null, false);
            successful = this.updateCurrentStateCache(dto);
            if (!successful) {
                EventFacadeLocal eventFacade = EventFacadeUtil.getLocalHome().create();
                EventResponse eventResponse = eventFacade.handleEvent(event);
                successful = eventResponse.isEventResponse();
            }
            if (successful) {
                try {
                    String pk = "[." + String.valueOf(dto.getUnitId()) + " " + String.valueOf(dto.getStateModelId()) + ".] " + dto.getUnitName();
                    String newValue = "stateId=" + String.valueOf(dto.getStateId()) + ", remark=" + dto.getRemark();
                    String oldValue = "stateId=" + String.valueOf(((StateDTO)list.get(0)).getStateId()) + ", remark=" + ((StateDTO)list.get(0)).getRemark();
                    this.adminFacade.createAuditData("RTSWEB", pk, "ServiceChange", oldValue, newValue);
                }
                catch (CreateException e1) {
                    logger.error((Object)"runs into", (Throwable)e1);
                }
            }
        }
        catch (CreateException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        catch (NamingException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return successful;
    }

    private Properties buildEvent(StateDTO value) {
        Properties event = new Properties();
        event.setProperty("u", String.valueOf(value.getUnitId()));
        event.setProperty("m", String.valueOf(value.getStateModelId()));
        event.setProperty("s", String.valueOf(value.getStateId()));
        event.setProperty("c", value.getRemark());
        return event;
    }
}

