/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.historyData.dto;

import de.proveo.wwt.logic.ejb.dataIn.use.cache.UseCacheValue;
import de.proveo.wwt.logic.ejb.dataIn.use.history.UseHistoryValue;
import de.proveo.wwt.logic.ejb.general.area.AreaValue;
import de.proveo.wwt.logic.ejb.general.use.group.UseGroupValue;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserValue;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.common.dto.UnitStateDTOBase;

public class UseDTO
extends UnitStateDTOBase {
    private UseUserValue useUserValue;
    private UseGroupValue useGroupValue;
    private AreaValue beginAreaValue;
    private AreaValue endAreaValue;
    private long beginTime;
    private long beginReceiveTime;
    private long endTime;
    private long endReceiveTime;
    long duration;

    public UseDTO(UnitDTO unitDTO, UseUserValue useUserValue, UseGroupValue useGroupValue, UseHistoryValue useHistoryValue, AreaValue beginArea, AreaValue endArea) {
        super(unitDTO);
        this.init(useUserValue, useGroupValue, beginArea, endArea, useHistoryValue.getBeginTime(), useHistoryValue.getEndTime(), useHistoryValue.getBeginReceiveTime(), useHistoryValue.getEndReceiveTime());
    }

    public UseDTO(UseCacheValue value, UnitDTO unitDTO, UseUserValue useUserValue, UseGroupValue useGroupValue, AreaValue beginAreaValue, AreaValue endAreaValue) {
        super(unitDTO);
        this.init(useUserValue, useGroupValue, beginAreaValue, endAreaValue, value.getBeginTime(), 0L, value.getBeginReceiveTime(), 0L);
    }

    public UseDTO(UnitDTO unitDTO, UseUserValue useUserValue, UseGroupValue useGroupValue, AreaValue beginAreaValue, AreaValue endAreaValue, long beginTime, long endTime, long beginReceiveTime, long endReceiveTime) {
        super(unitDTO);
        this.init(useUserValue, useGroupValue, beginAreaValue, endAreaValue, beginTime, endTime, beginReceiveTime, endReceiveTime);
    }

    private void init(UseUserValue useUserValue, UseGroupValue useGroupValue, AreaValue beginAreaValue, AreaValue endAreaValue, long beginTime, long endTime, long beginReceiveTime, long endReceiveTime) {
        this.beginTime = beginTime;
        if (endTime == 0L) {
            endTime = System.currentTimeMillis();
        } else {
            this.endTime = endTime;
        }
        this.useGroupValue = useGroupValue;
        this.useUserValue = useUserValue;
        this.beginReceiveTime = beginReceiveTime;
        this.endReceiveTime = endReceiveTime;
        this.duration = endTime - beginTime;
        this.beginAreaValue = beginAreaValue;
        this.endAreaValue = endAreaValue;
    }

    public long getBeginTime() {
        return this.beginTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getBeginReceiveTime() {
        return this.beginReceiveTime;
    }

    public UseUserValue getUseUserValue() {
        return this.useUserValue;
    }

    public UseGroupValue getUseGroupValue() {
        return this.useGroupValue;
    }

    public long getDuration() {
        return this.duration;
    }

    public String getUseUserName() {
        if (this.useUserValue == null) {
            return "-";
        }
        return this.useUserValue.getName();
    }

    public String getUseUserKey() {
        if (this.useUserValue == null) {
            return "-";
        }
        return this.useUserValue.getKey();
    }

    public String getBeginArea() {
        if (this.beginAreaValue != null) {
            return this.beginAreaValue.getArea();
        }
        return "";
    }

    public String getBeginAreaDesc() {
        if (this.beginAreaValue != null) {
            return this.beginAreaValue.getDescription();
        }
        return "";
    }

    public String getEndArea() {
        if (this.endAreaValue != null) {
            return this.endAreaValue.getArea();
        }
        return "";
    }

    public String getEndAreaDesc() {
        if (this.endAreaValue != null) {
            return this.endAreaValue.getDescription();
        }
        return "";
    }

    public long getEndReceiveTime() {
        return this.endReceiveTime;
    }
}

