/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.hierarchicalData.unitTree;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityValue;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelLocal;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelLocalHome;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelPK;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelUtil;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelValue;
import de.proveo.wwt.logic.ejb.general.unit.entity.typeidentity.UnitTypeIdentityValue;
import de.proveo.wwt.logic.web.admin.AdminUnitFacadeLocal;
import de.proveo.wwt.logic.web.admin.AdminUnitFacadeLocalHome;
import de.proveo.wwt.logic.web.admin.AdminUnitFacadeUtil;
import de.proveo.wwt.logic.web.common.dto.DTOFactory;
import de.proveo.wwt.logic.web.common.dto.UnitDTOListBase;
import de.proveo.wwt.logic.web.commonData.CommonDataFacadeLocal;
import de.proveo.wwt.logic.web.commonData.CommonDataFacadeLocalHome;
import de.proveo.wwt.logic.web.commonData.CommonDataFacadeUtil;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.UnitTreeComparator;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.dto.UnitTreeDTO;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.dto.UnitTreeNode;
import de.proveo.wwt.logic.web.security.PermissionCheckerLocal;
import de.proveo.wwt.logic.web.security.PermissionCheckerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UnitTreeFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final long serialVersionUID = -1747561574171800108L;
    private UnitModelLocalHome unitModelHome;
    private PermissionCheckerLocal permissionCheckerLocal;
    private AdminUnitFacadeLocal adminUnitFacadeLocal;
    private static final Log log = LogFactory.getLog(UnitTreeFacadeBean.class);

    public void ejbCreate() throws CreateException {
        try {
            this.unitModelHome = UnitModelUtil.getLocalHome();
            this.adminUnitFacadeLocal = AdminUnitFacadeUtil.getLocalHome().create();
            this.permissionCheckerLocal = PermissionCheckerUtil.getLocalHome().create();
        }
        catch (Exception ex) {
            log.error((Object)"runs during lookup ejb refs into", (Throwable)ex);
            throw new CreateException("runs during lookup ejb refs into " + ex.getMessage());
        }
    }

    public UnitTreeDTO getUnitKindTreeViewData(boolean filtered) {
        UnitTreeDTO dto;
        block11: {
            log.debug((Object)"getUnitKindTreeViewData called");
            dto = null;
            long rootId = 1000L;
            try {
                UnitModelLocal rootUnit = this.unitModelHome.findByPrimaryKey(new UnitModelPK(rootId));
                if (rootUnit == null) break block11;
                dto = new UnitTreeDTO(rootUnit.getUnitModelValue(), rootUnit.getUnitIdentity().getUnitIdentityValue(), null);
                UnitTreeNode rootNode = dto.getRoot();
                AdminUnitFacadeLocalHome home = null;
                try {
                    home = AdminUnitFacadeUtil.getLocalHome();
                }
                catch (NamingException e) {
                    log.error((Object)"runs into", (Throwable)e);
                }
                try {
                    CommonDataFacadeLocalHome commonFacadeHome = CommonDataFacadeUtil.getLocalHome();
                    CommonDataFacadeLocal commonData = commonFacadeHome.create();
                    AdminUnitFacadeLocal unitFacade = home.create();
                    List<UnitTypeIdentityValue> folders = commonData.getUnitTypeGroups();
                    for (UnitTypeIdentityValue typeIdentity : folders) {
                        UnitModelValue folderValue = new UnitModelValue();
                        UnitIdentityValue folderIdent = new UnitIdentityValue();
                        folderValue.setUnitId(typeIdentity.getId());
                        folderValue.setBasic(false);
                        folderIdent.setUnitId(typeIdentity.getId());
                        folderIdent.setName(typeIdentity.getName());
                        folderIdent.setUnitKind(typeIdentity.getName());
                        try {
                            UnitTreeNode node = rootNode.insertChildNode(new UnitTreeNode(folderValue, folderIdent, null));
                            ArrayList<UnitModelLocal> children = unitFacade.getUnitModelsByTypeId(typeIdentity.getId());
                            for (UnitModelLocal model : children) {
                                node.insertChildNode(new UnitTreeNode(model.getUnitModelValue(), model.getUnitIdentity().getUnitIdentityValue(), model.getUnitTypeIdentity().getUnitTypeIdentityValue()));
                            }
                        }
                        catch (Exception e) {
                            log.error((Object)"runs into", (Throwable)e);
                        }
                    }
                }
                catch (Exception e) {
                    log.error((Object)"runs into", (Throwable)e);
                }
            }
            catch (ObjectNotFoundException e) {
                log.debug((Object)"no values could be found");
            }
            catch (FinderException e) {
                log.error((Object)"Finding UnitModel for Airport (unitID=1000) failed");
            }
        }
        return dto;
    }

    public UnitTreeDTO getTreeViewData(boolean permissionFiltered, boolean airportMapFiltered, boolean withoutDeletedUnits) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getTreeViewData called permissionFiltered:" + permissionFiltered + " airportMapFiltered: " + airportMapFiltered));
        }
        UnitTreeDTO dto = null;
        try {
            Collection<UnitModelLocal> rootGroups = this.adminUnitFacadeLocal.getUnitsWithoutParents(false);
            if (rootGroups != null) {
                Iterator<UnitModelLocal> it = rootGroups.iterator();
                dto = new UnitTreeDTO();
                while (it.hasNext()) {
                    UnitModelLocal rootUnit = it.next();
                    UnitTreeNode rootGroupNode = DTOFactory.buildUnitTreeNode(rootUnit);
                    dto.insertNode(rootGroupNode);
                    this.iterateNodes(rootUnit, rootGroupNode, airportMapFiltered, withoutDeletedUnits);
                }
                Collection<UnitModelLocal> unitsWithoutParents = this.adminUnitFacadeLocal.getUnitsWithoutParents(true);
                for (UnitModelLocal unit : unitsWithoutParents) {
                    if (airportMapFiltered) {
                        if (!unit.getUnitModelValue().getAirportMapVisible()) continue;
                        dto.insertNode(DTOFactory.buildUnitTreeNode(unit));
                        continue;
                    }
                    dto.insertNode(DTOFactory.buildUnitTreeNode(unit));
                }
            }
        }
        catch (ObjectNotFoundException e) {
            log.debug((Object)"no values could be found");
        }
        catch (FinderException e) {
            log.error((Object)"Finding UnitModel for Airport (unitID=1000) failed");
        }
        catch (CreateException e) {
            log.error((Object)"run into", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"run into", (Throwable)e);
        }
        if (permissionFiltered) {
            this.checkPermissions(dto.getRoot());
            if (dto.getChildNodes() == null) {
                return null;
            }
        }
        return dto;
    }

    private void checkPermissions(UnitTreeNode node) {
        if (node != null) {
            UnitDTOListBase children = node.getChildNodes();
            this.permissionCheckerLocal.checkDTOList(children);
            if (children != null) {
                for (int i = children.size() - 1; i >= 0; --i) {
                    UnitTreeNode u = (UnitTreeNode)children.get(i);
                    if (u.isBasic()) continue;
                    this.checkPermissions(u);
                }
            }
            if (!node.isBasic() && !node.hasChildNodes()) {
                node.remove();
                if (node.getParent() == null) {
                    node = null;
                }
            }
        }
    }

    private void iterateNodes(UnitModelLocal unitModel, UnitTreeNode node, boolean airportMapFiltered, boolean withoutDeletedUnits) {
        Collection unitModels = unitModel.getChildUnits();
        ArrayList<UnitModelLocal> sortedList = new ArrayList<UnitModelLocal>();
        for (UnitModelLocal u : unitModels) {
            if (withoutDeletedUnits && u.getUnitModelValue().getDeleted()) continue;
            if (airportMapFiltered && u.getUnitModelValue().getBasic()) {
                if (!u.getUnitModelValue().getAirportMapVisible()) continue;
                sortedList.add(u);
                continue;
            }
            sortedList.add(u);
        }
        Collections.sort(sortedList, new UnitTreeComparator());
        for (UnitModelLocal u : sortedList) {
            UnitTreeNode unitNode = DTOFactory.buildUnitTreeNode(u);
            try {
                UnitTreeNode unitTreeNode = node.insertChildNode(unitNode);
                if (u.getBasic()) continue;
                this.iterateNodes(u, unitTreeNode, airportMapFiltered, withoutDeletedUnits);
            }
            catch (Exception e) {
                log.error((Object)"run into", (Throwable)e);
            }
        }
    }

    public UnitTreeDTO getWebTreeModel(boolean filtered, boolean withoutDeletedUnits) {
        log.debug((Object)("getWebTreeModel logged in as: " + super.getCallerName()));
        return this.getTreeViewData(filtered, false, withoutDeletedUnits);
    }

    public UnitTreeDTO getICCTreeModel() {
        log.debug((Object)("getICCTreeModel logged in as: " + super.getCallerName()));
        return this.getTreeViewData(true, false, true);
    }

    public UnitTreeDTO getAirportMapTreeModel() {
        log.debug((Object)("getAirportMapTreeModel logged in as: " + super.getCallerName()));
        return this.getTreeViewData(true, true, true);
    }
}

