/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.currentData.dto;

import de.proveo.wwt.logic.ejb.dataIn.fisFlight.cache.FisFlightCacheValue;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.common.dto.UnitStateDTOBase;
import de.proveo.wwt.logic.web.historyData.dto.PositionDTO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GseAvailabilityDTO
extends UnitStateDTOBase {
    private static final Log log = LogFactory.getLog(GseAvailabilityDTO.class);
    private FisFlightCacheValue flightValue;
    private PositionDTO posDTO;
    private Long nextAssignment;

    public GseAvailabilityDTO(UnitDTO unitDTO, FisFlightCacheValue flightValue, PositionDTO posDTO, Long nextAssignment) {
        super(unitDTO);
        this.beginTime = this.beginTime;
        this.endTime = this.endTime;
        this.flightValue = flightValue;
        this.posDTO = posDTO;
        this.nextAssignment = nextAssignment;
    }

    public FisFlightCacheValue getFlightValue() {
        return this.flightValue;
    }

    public void setFlightValue(FisFlightCacheValue flightValue) {
        this.flightValue = flightValue;
    }

    public PositionDTO getPosDTO() {
        return this.posDTO;
    }

    public void setPosDTO(PositionDTO posDTO) {
        this.posDTO = posDTO;
    }

    public String getGseId() {
        return super.getUnitName();
    }

    public String getGseType() {
        return super.getUnitTypeName();
    }

    public String getNextPosition() {
        if (this.flightValue == null) {
            return "-";
        }
        return this.flightValue.getParkingStand();
    }

    public String getCurrentPosition() {
        if (this.posDTO == null) {
            return "-";
        }
        return this.posDTO.getArea() + "(" + this.posDTO.getAreaDescription() + ")";
    }

    public Long getNextAssignment() {
        if (this.nextAssignment == null) {
            return 0L;
        }
        return (long)this.nextAssignment;
    }

    public void setNextAssignment(Long nextAssignment) {
        this.nextAssignment = nextAssignment;
    }
}

