/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.admin;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.app.unit.exception.UnitNotFoundException;
import de.proveo.wwt.logic.ejb.dataIn.geo.GdataFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.geo.GdataFacadeUtil;
import de.proveo.wwt.logic.ejb.dataIn.grouphistory.GrouphistoryLocal;
import de.proveo.wwt.logic.ejb.dataIn.grouphistory.GrouphistoryLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.grouphistory.GrouphistoryPK;
import de.proveo.wwt.logic.ejb.dataIn.grouphistory.GrouphistoryUtil;
import de.proveo.wwt.logic.ejb.dataIn.grouphistory.GrouphistoryValue;
import de.proveo.wwt.logic.ejb.dataIn.informant.InformantClient;
import de.proveo.wwt.logic.ejb.dataIn.keepalive.KeepAliveInFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.keepalive.KeepAliveInFacadeUtil;
import de.proveo.wwt.logic.ejb.dataIn.notify.NotifyFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.notify.NotifyFacadeUtil;
import de.proveo.wwt.logic.ejb.dataIn.scanmanmsg.ScanmanMsgFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.scanmanmsg.ScanmanMsgFacadeUtil;
import de.proveo.wwt.logic.ejb.dataIn.state.CurrentStateFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.state.CurrentStateFacadeUtil;
import de.proveo.wwt.logic.ejb.dataIn.state.init.InitStateModelLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.state.init.InitStateModelUtil;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.CurrentStateCacheLocal;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.CurrentStateCacheLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.CurrentStateCacheUtil;
import de.proveo.wwt.logic.ejb.dataIn.use.UseFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.use.UseFacadeUtil;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.group.GroupIdentLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.group.GroupIdentLocalHome;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.group.GroupIdentPK;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.group.GroupIdentUtil;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.group.GroupIdentValue;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.role.RoleLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.role.RoleLocalHome;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.role.RolePK;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.role.RoleUtil;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.role.RoleValue;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.user.AccountLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.user.AccountLocalHome;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.user.AccountPK;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.user.AccountUtil;
import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityLocal;
import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityLocalHome;
import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityPK;
import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityUtil;
import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityValue;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelLocal;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelLocalHome;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelPK;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelUtil;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelValue;
import de.proveo.wwt.logic.ejb.general.unit.entity.typeidentity.UnitTypeIdentityLocal;
import de.proveo.wwt.logic.ejb.general.unit.entity.typeidentity.UnitTypeIdentityLocalHome;
import de.proveo.wwt.logic.ejb.general.unit.entity.typeidentity.UnitTypeIdentityPK;
import de.proveo.wwt.logic.ejb.general.unit.entity.typeidentity.UnitTypeIdentityUtil;
import de.proveo.wwt.logic.ejb.general.unit.entity.typeidentity.UnitTypeIdentityValue;
import de.proveo.wwt.logic.ejb.general.unit.permission.UnitPermissionLocal;
import de.proveo.wwt.logic.ejb.general.unit.permission.UnitPermissionLocalHome;
import de.proveo.wwt.logic.ejb.general.unit.permission.UnitPermissionPK;
import de.proveo.wwt.logic.ejb.general.unit.permission.UnitPermissionUtil;
import de.proveo.wwt.logic.ejb.general.unit.permission.UnitPermissionValue;
import de.proveo.wwt.logic.ejb.general.use.group.UseGroupLocal;
import de.proveo.wwt.logic.ejb.general.use.group.UseGroupLocalHome;
import de.proveo.wwt.logic.ejb.general.use.group.UseGroupPK;
import de.proveo.wwt.logic.ejb.general.use.group.UseGroupUtil;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserLocal;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserLocalHome;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserPK;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserUtil;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserValue;
import de.proveo.wwt.logic.ejb.transaction.ImplicitRollbackException;
import de.proveo.wwt.logic.web.admin.AdminFacadeLocal;
import de.proveo.wwt.logic.web.admin.AdminFacadeUtil;
import de.proveo.wwt.logic.web.admin.permission.UnitPermissionDTO;
import de.proveo.wwt.logic.web.admin.permission.UnitPermissionDTOList;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.commonData.CommonDataFacadeLocal;
import de.proveo.wwt.logic.web.commonData.CommonDataFacadeUtil;
import de.proveo.wwt.logic.web.commonData.dto.UnitDTOList;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.dto.UnitTreeDTO;
import de.proveo.wwt.logic.web.security.PermissionCheckerLocal;
import de.proveo.wwt.logic.web.security.PermissionCheckerUtil;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdminUnitFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final long serialVersionUID = -1747561574171800108L;
    private UnitModelLocalHome unitModelLocalHome;
    private UnitIdentityLocalHome unitIdentityLocalHome;
    private UnitTypeIdentityLocalHome unitTypeIdentityLocalHome;
    private UnitPermissionLocalHome unitPermissionLocalHome;
    private RoleLocalHome roleHome;
    private GroupIdentLocalHome groupIdentHome;
    private AccountLocalHome accountHome;
    private AdminFacadeLocal adminFacade;
    private CommonDataFacadeLocal commonData;
    private UseUserLocalHome useUserHome;
    private UseGroupLocalHome useGroupHome;
    private GrouphistoryLocalHome grouphistoryHome;
    private InitStateModelLocalHome initStateModelHome;
    private PermissionCheckerLocal permissionCheckerLocal;
    private CurrentStateCacheLocalHome currentStateCacheHome;
    private String auditAppl = "";
    private static final Log logger = LogFactory.getLog(AdminUnitFacadeBean.class);

    @Override
    public void ejbCreate() throws CreateException {
        try {
            this.unitModelLocalHome = UnitModelUtil.getLocalHome();
            this.unitIdentityLocalHome = UnitIdentityUtil.getLocalHome();
            this.unitTypeIdentityLocalHome = UnitTypeIdentityUtil.getLocalHome();
            this.unitPermissionLocalHome = UnitPermissionUtil.getLocalHome();
            this.roleHome = RoleUtil.getLocalHome();
            this.groupIdentHome = GroupIdentUtil.getLocalHome();
            this.accountHome = AccountUtil.getLocalHome();
            this.adminFacade = AdminFacadeUtil.getLocalHome().create();
            this.commonData = CommonDataFacadeUtil.getLocalHome().create();
            this.useUserHome = UseUserUtil.getLocalHome();
            this.useGroupHome = UseGroupUtil.getLocalHome();
            this.grouphistoryHome = GrouphistoryUtil.getLocalHome();
            this.initStateModelHome = InitStateModelUtil.getLocalHome();
            this.permissionCheckerLocal = PermissionCheckerUtil.getLocalHome().create();
            this.auditAppl = this.adminFacade.getAuditApplicationName();
            this.currentStateCacheHome = CurrentStateCacheUtil.getLocalHome();
        }
        catch (Exception ex) {
            logger.error((Object)"runs during lookup ejb refs into", (Throwable)ex);
            throw new CreateException("runs during lookup ejb refs into " + ex.getMessage());
        }
    }

    public List<UnitTreeDTO> getBasicUnitOfKind(String reqUnitKind, Collection<UnitModelLocal> basicUnits) {
        ArrayList<UnitTreeDTO> basicUnitsKinds = new ArrayList<UnitTreeDTO>();
        for (UnitModelLocal u : basicUnits) {
            UnitModelValue unitModelValue = u.getUnitModelValue();
            UnitIdentityValue unitIndentityValue = u.getUnitIdentity().getUnitIdentityValue();
            UnitTypeIdentityValue type = u.getUnitTypeIdentity().getUnitTypeIdentityValue();
            String unitKind = unitIndentityValue.getUnitKind();
            if (!reqUnitKind.equals(unitKind)) continue;
            basicUnitsKinds.add(new UnitTreeDTO(unitModelValue, unitIndentityValue, type));
        }
        return basicUnitsKinds;
    }

    public void finishGroupHistoryDataForBasicUnitIds(long[] basicUnitIds, long time) {
        try {
            ArrayList<UnitModelLocal> basicUnits = new ArrayList<UnitModelLocal>();
            for (long unitId : basicUnitIds) {
                UnitModelLocal unitModel = this.unitModelLocalHome.findByPrimaryKey(new UnitModelPK(unitId));
                basicUnits.add(unitModel);
            }
            for (UnitModelLocal u : basicUnits) {
                long unitId;
                UnitModelValue unitModelValue = u.getUnitModelValue();
                unitId = unitModelValue.getUnitId();
                GrouphistoryValue hValue = null;
                try {
                    GrouphistoryLocal hLocal = null;
                    Collection records = this.grouphistoryHome.findByBasicUnitId(unitId);
                    Iterator it = records.iterator();
                    if (!it.hasNext()) continue;
                    hLocal = (GrouphistoryLocal)it.next();
                    hValue = hLocal.getGrouphistoryValue();
                    hValue.setEndTime(time);
                    hLocal.setGrouphistoryValue(hValue);
                }
                catch (FinderException e) {
                    logger.error((Object)"runs into", (Throwable)e);
                }
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
    }

    public Collection<UnitModelLocal> collectParentUnitGroups(UnitModelLocal childId) {
        ArrayList<UnitModelLocal> unitGroups = new ArrayList<UnitModelLocal>();
        Collection<UnitModelLocal> parentIds = this.getParentIdsByChildId(childId);
        for (UnitModelLocal parentId : parentIds) {
            unitGroups.add(parentId);
            unitGroups.addAll(this.collectParentUnitGroups(parentId));
        }
        return unitGroups;
    }

    public Collection<UnitModelLocal> getParentIdsByChildId(UnitModelLocal childId) {
        ArrayList<UnitModelLocal> coll = new ArrayList();
        try {
            coll = this.unitModelLocalHome.findyParentsFromChildId(childId.getUnitId());
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return coll;
    }

    public boolean setUnitsIdsByGroupId(long groupId, long[] unitIds) {
        boolean success = false;
        ArrayList<String> newAssignment = new ArrayList<String>();
        ArrayList<UnitModelLocal> newUnits = new ArrayList<UnitModelLocal>();
        long[] assignedUnits = this.getChildrenIdsByParentId(groupId, 1);
        long[] grouphistoryUnits = new long[assignedUnits.length + unitIds.length];
        try {
            UnitModelLocal unitModelGroup = this.unitModelLocalHome.findByPrimaryKey(new UnitModelPK(groupId));
            ArrayList<String> oldAssignment = new ArrayList<String>();
            Collection groupUnits = unitModelGroup.getChildUnits();
            for (UnitModelLocal unitLoc : groupUnits) {
                oldAssignment.add(unitLoc.getUnitIdentity().getUnitIdentityValue().getName());
                if (!unitLoc.getUnitModelValue().getDeleted()) continue;
                newAssignment.add(unitLoc.getUnitIdentity().getUnitIdentityValue().getName());
                newUnits.add(unitLoc);
            }
            for (int i = 0; i < unitIds.length; ++i) {
                grouphistoryUnits[i] = unitIds[i];
            }
            System.arraycopy(assignedUnits, 0, grouphistoryUnits, unitIds.length, assignedUnits.length);
            UnitModelLocal unitModel = null;
            for (long unitId : unitIds) {
                unitModel = this.unitModelLocalHome.findByPrimaryKey(new UnitModelPK(unitId));
                newAssignment.add(unitModel.getUnitIdentity().getUnitIdentityValue().getName());
                newUnits.add(unitModel);
            }
            Collections.sort(oldAssignment);
            Collections.sort(newAssignment);
            if (((Object)oldAssignment).toString().equals(((Object)newAssignment).toString())) {
                return true;
            }
            unitModelGroup.setChildUnits(newUnits);
            this.permissionCheckerLocal.updateAllUserPermissions();
            try {
                String pk = unitModelGroup.getPrimaryKey().toString() + " " + unitModelGroup.getUnitIdentity().getUnitIdentityValue().getName();
                this.adminFacade.createAuditData(this.auditAppl, pk, "RelationUnitGroupToUnit", oldAssignment, newAssignment);
            }
            catch (CreateException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
            long time = System.currentTimeMillis();
            this.finishGroupHistoryDataForBasicUnitIds(grouphistoryUnits, time);
            this.beginGroupHistoryDataForBasicUnitIds(grouphistoryUnits, time);
            success = true;
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return success;
    }

    public void beginGroupHistoryDataForBasicUnitIds(long[] basicUnitIds) {
        logger.warn((Object)"beginGroupHistoryDataForBasicUnitIds() WWT-418: don't use this method without a provieded timestamp, incomplete GroupHistory entries are possible");
        this.beginGroupHistoryDataForBasicUnitIds(basicUnitIds, System.currentTimeMillis());
    }

    public void beginGroupHistoryDataForBasicUnitIds(long[] basicUnitIds, long time) {
        try {
            ArrayList<UnitModelLocal> basicUnits = new ArrayList<UnitModelLocal>();
            for (long unitId : basicUnitIds) {
                UnitModelLocal unitModel = this.unitModelLocalHome.findByPrimaryKey(new UnitModelPK(unitId));
                if (basicUnits.contains(unitModel)) continue;
                basicUnits.add(unitModel);
            }
            for (UnitModelLocal basicUnit : basicUnits) {
                UnitModelValue unitModelValue = basicUnit.getUnitModelValue();
                UnitIdentityValue unitIndentityValue = basicUnit.getUnitIdentity().getUnitIdentityValue();
                GrouphistoryValue value = new GrouphistoryValue();
                value.setBeginTime(time);
                value.setBasicUnitId(unitModelValue.getUnitId());
                GrouphistoryLocal history = null;
                try {
                    history = this.grouphistoryHome.create(value);
                    value.setPrimaryKey((GrouphistoryPK)history.getPrimaryKey());
                }
                catch (CreateException ex) {
                    this.grouphistoryHome.reorganizeSequence();
                    try {
                        history = this.grouphistoryHome.create(value);
                    }
                    catch (CreateException e) {
                        String string = "createGrouphistory runs into error leave old ";
                        logger.error((Object)string, (Throwable)e);
                        throw new ImplicitRollbackException(string);
                    }
                }
                Collection<Object> unitGroups = new ArrayList();
                unitGroups = this.collectParentUnitGroups(basicUnit);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(" ############### basicUnit " + basicUnit));
                    logger.debug((Object)(" ############### unitGroups " + unitGroups.size()));
                    for (UnitModelLocal unitModelLocal : unitGroups) {
                        logger.debug((Object)("############### parents " + unitModelLocal.getUnitId()));
                    }
                    logger.debug((Object)(" ############### history " + history));
                    logger.debug((Object)" -----------------------------");
                }
                history.setUnitGroups(unitGroups);
                Collection coll = this.currentStateCacheHome.findByUnitId(unitModelValue.getUnitId());
                for (CurrentStateCacheLocal cacheLocal : coll) {
                    if (cacheLocal == null) continue;
                    GrouphistoryLocal ghLocal = cacheLocal.getGroupHistoryId();
                    cacheLocal.setGroupHistoryId(history);
                }
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
    }

    public void getGroupHistoryDataForFolder(long unitGroupId) {
        try {
            UnitModelLocal unitModel = this.unitModelLocalHome.findByPrimaryKey(new UnitModelPK(unitGroupId));
            Collection coll = unitModel.getGroupHistories();
            logger.debug((Object)("++++++++++++\tGrouphistoryValue historyValue =  coll.size( )  " + coll.size()));
            for (GrouphistoryLocal history : coll) {
                GrouphistoryValue historyValue = history.getGrouphistoryValue();
                logger.debug((Object)("++++++++++++\tGrouphistoryValue historyValue =  " + historyValue.toString()));
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
    }

    public UnitTreeDTO getUnitKindTreeData() {
        UnitTreeDTO dto = null;
        return dto;
    }

    public ArrayList<UnitModelValue> getUnitModelValuesByTypeId(long typeGroupId) {
        ArrayList<UnitModelValue> list = new ArrayList<UnitModelValue>();
        try {
            UnitTypeIdentityLocal unitIdentity = this.unitTypeIdentityLocalHome.findByPrimaryKey(new UnitTypeIdentityPK(typeGroupId));
            Collection unitModel = unitIdentity.getUnitModels();
            for (Object obj : unitModel) {
                UnitModelLocal local = (UnitModelLocal)obj;
                UnitModelValue value = local.getUnitModelValue();
                list.add(value);
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public ArrayList<UnitModelLocal> getUnitModelsByTypeId(long typeId) {
        ArrayList<UnitModelLocal> list = new ArrayList<UnitModelLocal>();
        try {
            UnitTypeIdentityLocal unitIdentity = this.unitTypeIdentityLocalHome.findByPrimaryKey(new UnitTypeIdentityPK(typeId));
            Collection unitModel = unitIdentity.getUnitModels();
            for (Object obj : unitModel) {
                UnitModelLocal local = (UnitModelLocal)obj;
                list.add(local);
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    private UnitTypeIdentityValue changeUnitTypeGroup(long unitTypeId, UnitModelLocal unitModel) {
        UnitTypeIdentityValue value = null;
        try {
            UnitTypeIdentityLocal unitTypeIdentityLocal = this.unitTypeIdentityLocalHome.findByPrimaryKey(new UnitTypeIdentityPK(unitTypeId));
            ArrayList<UnitModelLocal> coll = new ArrayList<UnitModelLocal>();
            coll.addAll(unitTypeIdentityLocal.getUnitModels());
            coll.add(unitModel);
            unitTypeIdentityLocal.setUnitModels(coll);
            value = unitTypeIdentityLocal.getUnitTypeIdentityValue();
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return value;
    }

    public Long insertUnit(UnitDTO value, long typeId, boolean validateDuplicates) throws CreateException, DuplicateKeyException {
        Long id = null;
        String validation = null;
        if (validateDuplicates) {
            validation = this.validateUnit(value, value.getUnitId());
        }
        if (validation != null) {
            throw new DuplicateKeyException(validation);
        }
        UnitModelValue unitModelValue = value.getUnitModelValue();
        UnitModelLocal unitModel = this.unitModelLocalHome.create(unitModelValue);
        id = unitModel.getUnitId();
        UnitIdentityValue unitIdentityValue = value.getUnitIdentityValue();
        if (unitModelValue.getBasic()) {
            UnitTypeIdentityValue type = this.changeUnitTypeGroup(typeId, unitModel);
            unitIdentityValue.setUnitKind(type.getAirportMapType());
        }
        UnitIdentityLocal unitIdentityLocal = this.unitIdentityLocalHome.create(unitIdentityValue);
        unitModel.setUnitIdentity(unitIdentityLocal);
        if (unitModelValue.getBasic()) {
            this.initStateModelHome.create().initializeAllStateModels(id);
            new InformantClient().notify("", "UnitModelNotifyMessage");
        }
        try {
            String pk = unitIdentityLocal.getPrimaryKey().toString() + " " + unitIdentityLocal.getUnitIdentityValue().getName();
            this.adminFacade.createAuditData(this.auditAppl, pk, "", null, unitIdentityLocal.getUnitIdentityValue());
            this.adminFacade.createAuditData(this.auditAppl, pk, "", null, unitModel.getUnitModelValue());
        }
        catch (CreateException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return id;
    }

    public String validateUnit(UnitDTO unitDTO, long id) {
        StringBuilder duplicatedValues = new StringBuilder();
        UnitDTOList allUnits = this.commonData.getUnitsByIsBasic(true, false, false);
        allUnits.addAll(this.commonData.getUnitsByIsBasic(false, false, false));
        UnitDTO[] units = allUnits.toArray(new UnitDTO[allUnits.size()]);
        id = unitDTO.getUnitId();
        String unitName = unitDTO.getUnitName();
        String unitIpAddresse = unitDTO.getUnitModelValue().getIpAddress();
        String unitSimNumber = unitDTO.getUnitModelValue().getSimNumber();
        String unitTelephoneNumber = unitDTO.getUnitModelValue().getTelephoneNumber();
        for (int i = 0; i != units.length; ++i) {
            UnitDTO unit = units[i];
            if (unit != null && unit.getUnitId() == id) continue;
            boolean deleted = unit.getUnitModelValue().getDeleted();
            String value = unit.getUnitName();
            if (value != null && !unitName.equals("") && value.equals(unitName)) {
                if (deleted) {
                    duplicatedValues.append("unitNameDeleted,");
                } else {
                    duplicatedValues.append("unitName,");
                }
            }
            if ((value = unit.getUnitModelValue().getIpAddress()) != null && unitIpAddresse != null && !unitIpAddresse.equals("") && value.equals(unitIpAddresse)) {
                if (deleted) {
                    duplicatedValues.append("unitIpAddresseDeleted,");
                } else {
                    duplicatedValues.append("unitIpAddresse,");
                }
            }
            if ((value = unit.getUnitModelValue().getSimNumber()) != null && unitSimNumber != null && !unitSimNumber.equals("") && value.equals(unitSimNumber)) {
                if (deleted) {
                    duplicatedValues.append("unitSimNumberDeleted,");
                } else {
                    duplicatedValues.append("unitSimNumber,");
                }
            }
            if ((value = unit.getUnitModelValue().getTelephoneNumber()) == null || unitTelephoneNumber == null || unitTelephoneNumber.equals("") || !value.equals(unitTelephoneNumber)) continue;
            if (deleted) {
                duplicatedValues.append("unitTelephoneNumberDeleted,");
                continue;
            }
            duplicatedValues.append("unitTelephoneNumber,");
        }
        if (!duplicatedValues.toString().equals("")) {
            return duplicatedValues.toString();
        }
        return null;
    }

    public boolean updateUnit(UnitDTO unitDTO, long typeId, boolean sendUnitModelNotifyMsg, boolean validateDuplicates) throws DuplicateKeyException {
        boolean success = false;
        String validation = null;
        if (validateDuplicates) {
            validation = this.validateUnit(unitDTO, unitDTO.getUnitId());
        }
        if (validation != null) {
            throw new DuplicateKeyException(validation);
        }
        try {
            UnitModelValue unitValue = unitDTO.getUnitModelValue();
            UnitIdentityValue identValue = unitDTO.getUnitIdentityValue();
            long unitId = unitValue.getUnitId();
            UnitModelLocal unitModel = this.unitModelLocalHome.findByPrimaryKey(new UnitModelPK(unitId));
            UnitIdentityLocal unitIdentity = this.unitIdentityLocalHome.findByPrimaryKey(new UnitIdentityPK(unitId));
            UnitModelValue oldUnitValue = unitModel.getUnitModelValue();
            UnitIdentityValue oldUnitIdentity = unitIdentity.getUnitIdentityValue();
            if (unitValue.getBasic()) {
                long oldTypeId = unitModel.getUnitTypeIdentity().getUnitTypeIdentityValue().getId();
                if (unitValue.getBasic() && typeId != 0L && oldTypeId != typeId) {
                    this.changeUnitTypeGroup(typeId, unitModel);
                    UnitTypeIdentityValue type = this.changeUnitTypeGroup(typeId, unitModel);
                    identValue.setUnitKind(type.getAirportMapType());
                }
            }
            if (sendUnitModelNotifyMsg) {
                new InformantClient().notify("", "UnitModelNotifyMessage");
            }
            if (!oldUnitValue.equals(unitValue)) {
                unitModel.setUnitModelValue(unitValue);
            }
            if (!oldUnitIdentity.equals(identValue)) {
                unitIdentity.setUnitIdentityValue(identValue);
            }
            success = true;
            try {
                String pk = unitModel.getPrimaryKey().toString() + " " + unitIdentity.getUnitIdentityValue().getName();
                if (!oldUnitValue.equals(unitValue) && sendUnitModelNotifyMsg) {
                    this.adminFacade.createAuditData(this.auditAppl, pk, "", oldUnitValue, unitValue);
                }
                if (!oldUnitIdentity.equals(identValue) && sendUnitModelNotifyMsg) {
                    this.adminFacade.createAuditData(this.auditAppl, pk, "", oldUnitIdentity, identValue);
                }
            }
            catch (CreateException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return success;
    }

    public void deletePermissionsForUnit(long unitId) {
        if (unitId == 0L) {
            return;
        }
        try {
            Collection permissions = this.unitPermissionLocalHome.findByUnitIdOrGroupId(unitId);
            Iterator iter = permissions.iterator();
            Object permLocal = null;
            while (iter.hasNext()) {
                Object obj = iter.next();
                UnitPermissionLocal local = (UnitPermissionLocal)obj;
                try {
                    local.remove();
                }
                catch (EJBException e) {
                    logger.error((Object)"runs into", (Throwable)e);
                }
                catch (RemoveException e) {
                    logger.error((Object)"runs into", (Throwable)e);
                }
            }
        }
        catch (FinderException e1) {
            logger.error((Object)"runs into", (Throwable)e1);
        }
    }

    public boolean deleteUnit(UnitDTO unitDTO) {
        boolean success = false;
        try {
            UnitModelValue value = unitDTO.getUnitModelValue();
            UnitModelValue oldValue = (UnitModelValue)value.clone();
            long unitId = value.getUnitId();
            UnitModelLocal unitModel = this.unitModelLocalHome.findByPrimaryKey(new UnitModelPK(unitId));
            UnitIdentityLocal unitIdentity = this.unitIdentityLocalHome.findByPrimaryKey(new UnitIdentityPK(unitId));
            String pk = unitModel.getPrimaryKey().toString() + " " + unitIdentity.getUnitIdentityValue().getName();
            if (value.getBasic()) {
                value.setDeleted(true);
                value.setDeletedTime(System.currentTimeMillis());
                value.setDeletedByUsername(this.getCallerName());
                unitModel.setUnitModelValue(value);
                this.moveCacheDataToHistoryForDeletedUnit(unitModel);
                try {
                    this.adminFacade.createAuditData(this.auditAppl, pk, "", oldValue, "Marked as deleted");
                }
                catch (CreateException e) {
                    logger.error((Object)"runs into", (Throwable)e);
                }
            } else {
                try {
                    this.adminFacade.createAuditData(this.auditAppl, pk, "", unitModel.getUnitModelValue(), null);
                    this.adminFacade.createAuditData(this.auditAppl, pk, "", unitIdentity.getUnitIdentityValue(), null);
                }
                catch (CreateException e) {
                    logger.error((Object)"runs into", (Throwable)e);
                }
                this.deletePermissionsForUnit(unitDTO.getUnitId());
                unitModel.remove();
                unitIdentity.remove();
            }
            success = true;
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        catch (RemoveException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return success;
    }

    public Long insertUnitType(UnitTypeIdentityValue value) throws CreateException {
        Long id = null;
        try {
            if (this.duplicatedUnitKind(value.getName(), -1L)) {
                throw new CreateException("update not possible, unitKind already exists");
            }
            UnitTypeIdentityLocal local = this.unitTypeIdentityLocalHome.create(value);
            id = local.getUnitTypeIdentityValue().getId();
            try {
                String pk = local.getPrimaryKey().toString() + " " + local.getUnitTypeIdentityValue().getName();
                this.adminFacade.createAuditData(this.auditAppl, pk, "", null, local.getUnitTypeIdentityValue());
            }
            catch (CreateException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
        }
        catch (CreateException e) {
            logger.error((Object)"runs into", (Throwable)e);
            throw new CreateException("No creation possible, UnitId already exists");
        }
        return id;
    }

    public boolean updateUnitType(UnitTypeIdentityValue value) {
        boolean success;
        block6: {
            success = false;
            try {
                long unitId = value.getId();
                if (this.duplicatedUnitKind(value.getName(), unitId)) {
                    success = false;
                    break block6;
                }
                UnitTypeIdentityLocal unitIdentity = this.unitTypeIdentityLocalHome.findByPrimaryKey(new UnitTypeIdentityPK(unitId));
                UnitTypeIdentityValue oldValue = unitIdentity.getUnitTypeIdentityValue();
                if (oldValue.equals(value)) {
                    return true;
                }
                try {
                    String pk = unitIdentity.getPrimaryKey().toString() + " " + unitIdentity.getUnitTypeIdentityValue().getName();
                    this.adminFacade.createAuditData(this.auditAppl, pk, "", unitIdentity.getUnitTypeIdentityValue(), value);
                }
                catch (CreateException e) {
                    logger.error((Object)"runs into", (Throwable)e);
                }
                unitIdentity.setUnitTypeIdentityValue(value);
                success = true;
            }
            catch (FinderException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
        }
        return success;
    }

    public boolean deleteUnitType(long id) {
        boolean success = false;
        try {
            UnitTypeIdentityLocal unitIdentity = this.unitTypeIdentityLocalHome.findByPrimaryKey(new UnitTypeIdentityPK(id));
            try {
                String pk = unitIdentity.getPrimaryKey().toString() + " " + unitIdentity.getUnitTypeIdentityValue().getName();
                this.adminFacade.createAuditData(this.auditAppl, pk, "", unitIdentity.getUnitTypeIdentityValue(), null);
            }
            catch (CreateException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
            unitIdentity.remove();
            success = true;
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        catch (RemoveException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return success;
    }

    public boolean duplicatedUnitKind(String unitKind, long unitTypeId) {
        boolean duplicated = false;
        List<UnitTypeIdentityValue> collection = this.commonData.getUnitTypeGroups();
        for (UnitTypeIdentityValue value : collection) {
            if (value.getId() == unitTypeId || !value.getName().equals(unitKind)) continue;
            duplicated = true;
            break;
        }
        return duplicated;
    }

    public void deleteUnitPermissionById(long permissionId) {
        try {
            UnitPermissionLocal permLocal = this.unitPermissionLocalHome.findByPrimaryKey(new UnitPermissionPK(permissionId));
            permLocal.remove();
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        catch (RemoveException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
    }

    public ArrayList<UnitPermissionValue> getUnitPermissions(long unitId) {
        Collection unitPermissions = null;
        ArrayList<UnitPermissionValue> list = null;
        try {
            unitPermissions = this.unitPermissionLocalHome.getUnitPermissions(unitId);
            list = new ArrayList<UnitPermissionValue>();
            for (UnitPermissionLocal unitPermission : unitPermissions) {
                UnitPermissionValue unitPermissionValue = unitPermission.getUnitPermissionValue();
                list.add(unitPermissionValue);
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public ArrayList<UnitPermissionValue> getUnitPermissionsByAccount(String username) {
        ArrayList<UnitPermissionValue> list = new ArrayList<UnitPermissionValue>();
        try {
            Collection accountRecords = this.accountHome.findByUsername(username);
            Iterator it = accountRecords.iterator();
            AccountLocal account = null;
            if (it.hasNext()) {
                account = (AccountLocal)it.next();
                Collection unitPermits = account.getUnitPermissions();
                list = new ArrayList();
                for (Object obj : unitPermits) {
                    UnitPermissionLocal local = (UnitPermissionLocal)obj;
                    UnitPermissionValue value = local.getUnitPermissionValue();
                    list.add(value);
                }
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public ArrayList<UnitPermissionValue> getUnitPermissionsByUserId(long userId) {
        ArrayList<UnitPermissionValue> list = null;
        try {
            AccountLocal account = this.accountHome.findByPrimaryKey(new AccountPK(userId));
            Collection unitPermits = account.getUnitPermissions();
            list = new ArrayList<UnitPermissionValue>();
            for (Object obj : unitPermits) {
                UnitPermissionLocal local = (UnitPermissionLocal)obj;
                UnitPermissionValue value = local.getUnitPermissionValue();
                list.add(value);
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public void setPermissionsByUserId(long userId, ArrayList<UnitPermissionValue> newUnitPermissions) {
        ArrayList<UnitPermissionValue> oldUnitPermissions = this.getUnitPermissionsByUserId(userId);
        try {
            AccountLocal account = this.accountHome.findByPrimaryKey(new AccountPK(userId));
            this.createAuditDataForPermissions(account, oldUnitPermissions, newUnitPermissions);
            Collection collNewPermissionLocal = this.synchroniseOldNewUnitPermissions(newUnitPermissions, oldUnitPermissions, true);
            account.setUnitPermissions(collNewPermissionLocal);
            this.permissionCheckerLocal.updateAllUserPermissions();
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
    }

    public void setPermissionsByAccount(String username, ArrayList<UnitPermissionValue> newUnitPermissions, boolean unitTreeSelected) {
        ArrayList<UnitPermissionValue> oldUnitPermissions = this.getUnitPermissionsByAccount(username);
        AccountLocal account = null;
        try {
            Collection accountRecords = this.accountHome.findByUsername(username);
            Iterator it = accountRecords.iterator();
            if (it.hasNext()) {
                account = (AccountLocal)it.next();
                this.createAuditDataForPermissions(account, oldUnitPermissions, newUnitPermissions);
                Collection collNewPermissionLocal = this.synchroniseOldNewUnitPermissions(newUnitPermissions, oldUnitPermissions, unitTreeSelected);
                account.setUnitPermissions(collNewPermissionLocal);
            }
            this.permissionCheckerLocal.updateAllUserPermissions();
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
    }

    public List<UseUserValue> getAllUseUserByUnitId(long unitId) {
        ArrayList<UseUserValue> list = new ArrayList<UseUserValue>();
        ArrayList<Object> unitTypeIdUnitIdCheckingList = new ArrayList();
        unitTypeIdUnitIdCheckingList = this.collectParentFolders(unitId);
        unitTypeIdUnitIdCheckingList.add(unitId);
        UnitModelLocal unitModel = null;
        try {
            unitModel = this.unitModelLocalHome.findByPrimaryKey(new UnitModelPK(unitId));
            ArrayList collection = new ArrayList();
            for (int i = 0; i < unitTypeIdUnitIdCheckingList.size(); ++i) {
                long unitIdNext = (Long)unitTypeIdUnitIdCheckingList.get(i);
                Collection coll = this.unitPermissionLocalHome.findPermissionsForUseUsersByUnitId(unitIdNext);
                collection.addAll(coll);
            }
            for (UnitPermissionLocal permit : collection) {
                long permUnitId = permit.getUnitPermissionValue().getUnitId();
                long permUnitGroupId = permit.getUnitPermissionValue().getGroupId();
                if (!unitTypeIdUnitIdCheckingList.contains(permUnitId) && !unitTypeIdUnitIdCheckingList.contains(permUnitGroupId)) continue;
                long useUserId = permit.getUseUserId();
                long useGroupId = permit.getUseGroupId();
                if (useUserId != 0L) {
                    UseUserLocal useUser = this.useUserHome.findByPrimaryKey(new UseUserPK(useUserId));
                    UseUserValue value = null;
                    if (useUser == null || list.contains(value = useUser.getUseUserValue())) continue;
                    list.add(value);
                    continue;
                }
                List<UseUserValue> listUseUsersForGroup = this.adminFacade.getUseUsersByUseGroupId(useGroupId);
                for (int i = 0; i < listUseUsersForGroup.size(); ++i) {
                    UseUserValue value = listUseUsersForGroup.get(i);
                    if (list.contains(value)) continue;
                    list.add(value);
                }
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public ArrayList<UnitPermissionValue> getUnitPermissionsByUseUserId(long useUserId) {
        ArrayList<UnitPermissionValue> list = null;
        try {
            UseUserLocal useUser = this.useUserHome.findByPrimaryKey(new UseUserPK(useUserId));
            Collection unitPermits = useUser.getUnitPermissions();
            list = new ArrayList<UnitPermissionValue>();
            for (Object obj : unitPermits) {
                UnitPermissionLocal local = (UnitPermissionLocal)obj;
                UnitPermissionValue value = local.getUnitPermissionValue();
                list.add(value);
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public ArrayList<UnitPermissionValue> getUnitPermissionsByUseGroupId(long useGroupId) {
        ArrayList<UnitPermissionValue> list = new ArrayList<UnitPermissionValue>();
        if (useGroupId < 0L) {
            return list;
        }
        try {
            UseGroupLocal useGroup = this.useGroupHome.findByPrimaryKey(new UseGroupPK(useGroupId));
            Collection unitPermits = useGroup.getUnitPermissions();
            for (Object obj : unitPermits) {
                UnitPermissionLocal local = (UnitPermissionLocal)obj;
                UnitPermissionValue value = local.getUnitPermissionValue();
                list.add(value);
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public void setPermissionsByUseUserId(long useUserId, ArrayList<UnitPermissionValue> newUnitPermissions, boolean unitTreeSelected) {
        ArrayList<UnitPermissionValue> oldUnitPermissions = this.getUnitPermissionsByUseUserId(useUserId);
        try {
            UseUserLocal useUser = this.useUserHome.findByPrimaryKey(new UseUserPK(useUserId));
            this.createAuditDataForPermissions(useUser, oldUnitPermissions, newUnitPermissions);
            Collection collNewPermissionLocal = this.synchroniseOldNewUnitPermissions(newUnitPermissions, oldUnitPermissions, unitTreeSelected);
            useUser.setUnitPermissions(collNewPermissionLocal);
            ArrayList<UnitPermissionValue> set = new ArrayList<UnitPermissionValue>();
            set.addAll(newUnitPermissions);
            set.addAll(oldUnitPermissions);
            this.updateUnitUserRefresh(set);
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
    }

    public void setPermissionsByUseGroupId(long useGroupId, ArrayList<UnitPermissionValue> newUnitPermissions, boolean unitTreeSelected) {
        ArrayList<UnitPermissionValue> oldUnitPermissions = this.getUnitPermissionsByUseGroupId(useGroupId);
        try {
            UseGroupLocal useGroup = this.useGroupHome.findByPrimaryKey(new UseGroupPK(useGroupId));
            this.createAuditDataForPermissions(useGroup, oldUnitPermissions, newUnitPermissions);
            Collection collNewPermissionLocal = this.synchroniseOldNewUnitPermissions(newUnitPermissions, oldUnitPermissions, unitTreeSelected);
            useGroup.setUnitPermissions(collNewPermissionLocal);
            ArrayList<UnitPermissionValue> set = new ArrayList<UnitPermissionValue>();
            set.addAll(newUnitPermissions);
            set.addAll(oldUnitPermissions);
            this.updateUnitUserRefresh(set);
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
    }

    public void updateUnitUserRefresh(ArrayList<UnitPermissionValue> permissionValues) {
        if (permissionValues == null || permissionValues.size() == 0) {
            return;
        }
        HashSet<Long> set = this.getUnitIdsForPermission(permissionValues);
        if (set == null || set.size() == 0) {
            return;
        }
        ArrayList<UnitDTO> list = this.getUnitDTOsForUnitIds(set);
        for (UnitDTO obj : list) {
            UnitDTO unitDto = obj;
            if (unitDto == null) continue;
            UnitModelValue unitModelValue = unitDto.getUnitModelValue();
            unitModelValue.setUnitUserRefresh(true);
            unitModelValue.setUnitUserSyncStartTime(0L);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(" ---- set unituserrefresh for unit to true : " + unitDto.getUnitId() + "  " + unitDto.getUnitName()));
            }
            try {
                this.updateUnit(unitDto, 0L, false, false);
            }
            catch (DuplicateKeyException e) {}
        }
    }

    public void updateUnitUserRefreshTmp(ArrayList<UnitPermissionValue> permissionValues) {
        if (permissionValues == null || permissionValues.size() == 0) {
            return;
        }
        HashSet<Long> set = this.getUnitIdsForPermission(permissionValues);
        if (set == null || set.size() == 0) {
            return;
        }
        ArrayList<UnitDTO> list = this.getUnitDTOsForUnitIds(set);
        for (UnitDTO obj : list) {
            UnitDTO unitDto = obj;
            if (unitDto == null) continue;
            UnitModelValue unitModelValue = unitDto.getUnitModelValue();
            unitModelValue.setUnitUserRefreshTmp(true);
            try {
                this.updateUnit(unitDto, 0L, false, false);
            }
            catch (DuplicateKeyException e) {}
        }
    }

    public ArrayList<UnitPermissionValue> getUnitPermissionsByRoleId(long roleId) {
        ArrayList<UnitPermissionValue> list = null;
        try {
            RoleLocal role = this.roleHome.findByPrimaryKey(new RolePK(roleId));
            Collection unitPermits = role.getUnitPermissions();
            list = new ArrayList<UnitPermissionValue>();
            for (Object obj : unitPermits) {
                UnitPermissionLocal local = (UnitPermissionLocal)obj;
                UnitPermissionValue value = local.getUnitPermissionValue();
                list.add(value);
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    public void setPermissionsByRoleId(long roleId, ArrayList<UnitPermissionValue> newUnitPermissions, boolean unitTreeSelected) {
        ArrayList<UnitPermissionValue> oldUnitPermissions = this.getUnitPermissionsByRoleId(roleId);
        try {
            RoleLocal role = this.roleHome.findByPrimaryKey(new RolePK(roleId));
            this.createAuditDataForPermissions(role, oldUnitPermissions, newUnitPermissions);
            Collection collNewPermissionLocal = this.synchroniseOldNewUnitPermissions(newUnitPermissions, oldUnitPermissions, unitTreeSelected);
            role.setUnitPermissions(collNewPermissionLocal);
            this.permissionCheckerLocal.updateAllUserPermissions();
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
    }

    public ArrayList<UnitPermissionValue> getUnitPermissionsByGroupId(long groupId) {
        ArrayList<UnitPermissionValue> list = null;
        try {
            GroupIdentLocal groupIdent = this.groupIdentHome.findByPrimaryKey(new GroupIdentPK(groupId));
            Collection unitPermits = groupIdent.getUnitPermissions();
            list = new ArrayList<UnitPermissionValue>();
            for (Object obj : unitPermits) {
                UnitPermissionLocal local = (UnitPermissionLocal)obj;
                UnitPermissionValue value = local.getUnitPermissionValue();
                list.add(value);
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return list;
    }

    private UnitPermissionLocal createUnitPermission(UnitPermissionValue unitPermit) {
        UnitPermissionLocal permissionLocal = null;
        try {
            permissionLocal = this.unitPermissionLocalHome.create(unitPermit);
        }
        catch (CreateException ex) {
            this.unitPermissionLocalHome.reorganizeSequence();
            try {
                permissionLocal = this.unitPermissionLocalHome.create(unitPermit);
            }
            catch (CreateException e) {
                String msg = "createUnitPermission runs into error";
                logger.error((Object)msg, (Throwable)e);
                throw new ImplicitRollbackException(msg);
            }
        }
        return permissionLocal;
    }

    private Collection synchroniseOldNewUnitPermissions(ArrayList<UnitPermissionValue> collNewUnitPermissions, ArrayList<UnitPermissionValue> collOldUnitPermissions, boolean unitTreeSelected) {
        UnitPermissionLocal permissionLocal;
        ArrayList<UnitPermissionValue> updatePermissions = new ArrayList<UnitPermissionValue>();
        ArrayList<UnitPermissionLocal> collNewPermissionLocal = new ArrayList<UnitPermissionLocal>();
        for (UnitPermissionValue unitPermit : collNewUnitPermissions) {
            permissionLocal = null;
            if (unitPermit.getUnitpermissionid() > 0L) {
                try {
                    permissionLocal = this.unitPermissionLocalHome.findByPrimaryKey(new UnitPermissionPK(unitPermit.getUnitpermissionid()));
                    updatePermissions.add(permissionLocal.getUnitPermissionValue());
                }
                catch (FinderException e) {
                    permissionLocal = this.createUnitPermission(unitPermit);
                }
            } else {
                permissionLocal = this.createUnitPermission(unitPermit);
            }
            collNewPermissionLocal.add(permissionLocal);
        }
        for (UnitPermissionValue unitPermit : collOldUnitPermissions) {
            permissionLocal = null;
            if ((unitPermit.getGroupId() <= 0L || unitTreeSelected) && (unitPermit.getTypeGroupId() <= 0L || !unitTreeSelected)) continue;
            try {
                permissionLocal = this.unitPermissionLocalHome.findByPrimaryKey(new UnitPermissionPK(unitPermit.getUnitpermissionid()));
                updatePermissions.add(permissionLocal.getUnitPermissionValue());
            }
            catch (FinderException e) {
                permissionLocal = this.createUnitPermission(unitPermit);
            }
            collNewPermissionLocal.add(permissionLocal);
        }
        collOldUnitPermissions.removeAll(updatePermissions);
        for (UnitPermissionValue unitPermit : collOldUnitPermissions) {
            this.deleteUnitPermissionById(unitPermit.getUnitpermissionid());
        }
        return collNewPermissionLocal;
    }

    public boolean setUnitPermissionForUseUser(long useUserId, long unitId, boolean setUnitUserRefresh, boolean setUnitUserRefreshTMP) throws UnitNotFoundException {
        if (!this.hasUseUserPermissions(unitId, useUserId)) {
            try {
                UnitPermissionValue unitPermissionValue = new UnitPermissionValue();
                unitPermissionValue.setUnitId(unitId);
                unitPermissionValue.setUseUserId(useUserId);
                this.unitPermissionLocalHome.create(unitPermissionValue);
                if (setUnitUserRefresh || setUnitUserRefreshTMP) {
                    try {
                        UnitModelLocal unitModelLocal = this.unitModelLocalHome.findByPrimaryKey(new UnitModelPK(unitId));
                        if (setUnitUserRefresh) {
                            unitModelLocal.setUnitUserRefresh(true);
                            unitModelLocal.setUnitUserSyncStartTime(0L);
                        }
                        if (setUnitUserRefreshTMP) {
                            unitModelLocal.setUnitUserRefreshTmp(true);
                        }
                    }
                    catch (FinderException e) {
                        logger.error((Object)("runs into" + (Object)((Object)e)));
                        throw new UnitNotFoundException(unitId);
                    }
                }
                return true;
            }
            catch (CreateException e) {
                logger.error((Object)("runs into" + (Object)((Object)e)));
            }
        }
        return false;
    }

    public boolean transferACLFlag() {
        try {
            Collection coll = this.unitModelLocalHome.findyByIsBasicAndUnitUserRefreshTmp();
            for (UnitModelLocal unitModelLocal : coll) {
                unitModelLocal.setUnitUserRefresh(true);
                unitModelLocal.setUnitUserSyncStartTime(0L);
                unitModelLocal.setUnitUserRefreshTmp(false);
            }
        }
        catch (FinderException e) {
            logger.error((Object)("runs into:" + (Object)((Object)e)));
            return false;
        }
        return true;
    }

    public boolean removeUnitPermissionForUseUser(long useUserId, long unitId, boolean setUnitUserRefresh, boolean setUnitUserRefreshTMP) {
        block9: {
            try {
                Collection coll = this.unitPermissionLocalHome.findByUnitORGroupIdAndUserId(unitId, useUserId);
                Iterator it = coll.iterator();
                if (!it.hasNext()) break block9;
                UnitPermissionLocal permissionLocal = (UnitPermissionLocal)it.next();
                permissionLocal.remove();
                if (setUnitUserRefresh || setUnitUserRefreshTMP) {
                    try {
                        UnitModelLocal unitModelLocal = this.unitModelLocalHome.findByPrimaryKey(new UnitModelPK(unitId));
                        if (setUnitUserRefresh) {
                            unitModelLocal.setUnitUserRefresh(true);
                            unitModelLocal.setUnitUserSyncStartTime(0L);
                        }
                        if (setUnitUserRefreshTMP) {
                            unitModelLocal.setUnitUserRefreshTmp(true);
                        }
                    }
                    catch (FinderException e) {
                        logger.warn((Object)("unit " + unitId + " doesn't exist"));
                    }
                }
                return true;
            }
            catch (EJBException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
            catch (FinderException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
            catch (RemoveException e) {
                logger.error((Object)("runs into" + (Object)((Object)e)));
            }
        }
        return false;
    }

    public void setPermissionsByUseUserId(long useUserId, ArrayList<UnitPermissionValue> newUnitPermissions, boolean unitTreeSelected, boolean setUnitUserRefresh, boolean setUnitUserRefreshTMP) {
        ArrayList<UnitPermissionValue> oldUnitPermissions = this.getUnitPermissionsByUseUserId(useUserId);
        try {
            UseUserLocal useUser = this.useUserHome.findByPrimaryKey(new UseUserPK(useUserId));
            Collection collNewPermissionLocal = this.synchroniseOldNewUnitPermissions(newUnitPermissions, oldUnitPermissions, unitTreeSelected);
            useUser.setUnitPermissions(collNewPermissionLocal);
            ArrayList<UnitPermissionValue> set = new ArrayList<UnitPermissionValue>();
            set.addAll(newUnitPermissions);
            set.addAll(oldUnitPermissions);
            if (setUnitUserRefresh) {
                this.updateUnitUserRefresh(set);
            }
            if (setUnitUserRefreshTMP) {
                this.updateUnitUserRefreshTmp(set);
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
    }

    public void setPermissionsByGroupId(long groupId, ArrayList<UnitPermissionValue> newUnitPermissions, boolean unitTreeSelected) {
        ArrayList<UnitPermissionValue> oldUnitPermissions = this.getUnitPermissionsByGroupId(groupId);
        try {
            GroupIdentLocal groupIdent = this.groupIdentHome.findByPrimaryKey(new GroupIdentPK(groupId));
            this.createAuditDataForPermissions(groupIdent, oldUnitPermissions, newUnitPermissions);
            Collection collNewPermissionLocal = this.synchroniseOldNewUnitPermissions(newUnitPermissions, oldUnitPermissions, unitTreeSelected);
            groupIdent.setUnitPermissions(collNewPermissionLocal);
            this.permissionCheckerLocal.updateAllUserPermissions();
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
    }

    public void setUnitPermissions(ArrayList<UnitPermissionValue> collUnitPermissions) throws CreateException {
        try {
            for (UnitPermissionValue permissionValue : collUnitPermissions) {
                this.unitPermissionLocalHome.create(permissionValue);
            }
            this.permissionCheckerLocal.updateAllUserPermissions();
        }
        catch (CreateException e) {
            logger.error((Object)"runs into", (Throwable)e);
            throw new CreateException("No creation for unitpermission possible");
        }
    }

    public void deleteAllUnitPermissions() throws RemoveException {
        assert (false);
        for (UnitPermissionValue permissionValue : this.getUnitPermissions(-1L)) {
            Object unitPermissionLocal = null;
            try {
                unitPermissionLocal.remove();
            }
            catch (EJBException e) {
                logger.error((Object)"runs into", (Throwable)e);
            }
            catch (RemoveException e) {
                logger.error((Object)"runs into", (Throwable)e);
                throw new RemoveException("No creation for unitpermission possible");
            }
        }
    }

    public HashSet<Long> getUnitIdsForPermissionByUsername(String username) {
        ArrayList<UnitPermissionValue> permits = this.getUnitPermissionsByAccount(username);
        HashSet<Long> unitIds = this.getUnitIdsForPermission(permits);
        return unitIds;
    }

    public HashSet<Long> getUnitIdsForPermissionByGroupId(long groupId) {
        ArrayList<UnitPermissionValue> permits = this.getUnitPermissionsByGroupId(groupId);
        HashSet<Long> unitIds = this.getUnitIdsForPermission(permits);
        return unitIds;
    }

    public HashSet<Long> getUnitIdsForPermissionByRoleId(long roleId) {
        ArrayList<UnitPermissionValue> permits = this.getUnitPermissionsByRoleId(roleId);
        HashSet<Long> unitIds = this.getUnitIdsForPermission(permits);
        return unitIds;
    }

    public HashSet<Long> getUnitIdsForPermissionByUseUserId(long useUserId) {
        ArrayList<UnitPermissionValue> permits = this.getUnitPermissionsByUseUserId(useUserId);
        HashSet<Long> unitIds = this.getUnitIdsForPermission(permits);
        return unitIds;
    }

    public HashSet<Long> getUnitIdsForPermissionByUseGroupId(long useGroupId) {
        ArrayList<UnitPermissionValue> permits = this.getUnitPermissionsByUseGroupId(useGroupId);
        HashSet<Long> unitIds = this.getUnitIdsForPermission(permits);
        return unitIds;
    }

    private HashSet<Long> getUnitIdsForPermission(ArrayList<UnitPermissionValue> permits) {
        Object arr;
        HashSet<Long> unitIds = new HashSet<Long>();
        HashSet<Long> unitGroupIds = new HashSet<Long>();
        HashSet<Long> unitTypeGroupIds = new HashSet<Long>();
        for (UnitPermissionValue u : permits) {
            if (u.getGroupId() > 0L) {
                unitGroupIds.add(u.getGroupId());
                continue;
            }
            if (u.getUnitId() > 0L) {
                unitIds.add(u.getUnitId());
                continue;
            }
            unitTypeGroupIds.add(u.getTypeGroupId());
        }
        HashSet<Long> unitGroupIdsSubs = new HashSet<Long>();
        for (Long parentId : unitGroupIds) {
            arr = this.collectFolders(parentId);
            unitGroupIdsSubs.addAll((Collection<Long>)arr);
        }
        unitGroupIds.addAll(unitGroupIdsSubs);
        for (Long parentId : unitGroupIds) {
            arr = this.getChildrenIdsByParentId(parentId, 1);
            for (int i = 0; i < ((Object)arr).length; ++i) {
                unitIds.add((long)arr[i]);
            }
        }
        for (Long parentId : unitTypeGroupIds) {
            ArrayList<UnitModelValue> list = this.getUnitModelValuesByTypeId(parentId);
            for (UnitModelValue value : list) {
                unitIds.add(value.getUnitId());
            }
        }
        return unitIds;
    }

    public ArrayList<Long> collectParentFolders(long childId) {
        long[] parentIds;
        ArrayList<Long> list = new ArrayList<Long>();
        for (long parentId : parentIds = this.getParentIdsByChildId(childId)) {
            list.add(parentId);
            list.addAll(this.collectParentFolders(parentId));
        }
        return list;
    }

    private ArrayList<Long> collectFolders(long parent) {
        ArrayList<Long> list = new ArrayList<Long>();
        long[] childrenIds = this.getChildrenIdsByParentId(parent, 0);
        if (childrenIds != null) {
            for (long childUnitId : childrenIds) {
                list.add(childUnitId);
                list.addAll(this.collectFolders(childUnitId));
            }
        }
        return list;
    }

    private ArrayList<Long> collectAllBasicUnits(long groupId) {
        ArrayList<Long> list = new ArrayList<Long>();
        Collection<UnitModelLocal> childrenIds = this.getChildrenUnitsByParent(groupId);
        for (UnitModelLocal unitModel : childrenIds) {
            if (unitModel.getBasic()) {
                list.add(unitModel.getUnitId());
                continue;
            }
            list.addAll(this.collectAllBasicUnits(unitModel.getUnitId()));
        }
        return list;
    }

    public long[] getChildrenIdsByParentId(long parentId, int typeBasic) {
        UnitModelLocal unitModel = null;
        long[] childrenIds = null;
        try {
            unitModel = this.unitModelLocalHome.findByPrimaryKey(new UnitModelPK(parentId));
            Collection coll = unitModel.getChildUnits();
            ArrayList<UnitModelLocal> requestedColl = new ArrayList<UnitModelLocal>();
            for (UnitModelLocal unitModelCild : coll) {
                if (unitModelCild.getUnitModelValue().getBasic() && typeBasic != 0) {
                    requestedColl.add(unitModelCild);
                }
                if (unitModelCild.getUnitModelValue().getBasic() || typeBasic == 1) continue;
                requestedColl.add(unitModelCild);
            }
            childrenIds = new long[requestedColl.size()];
            int i = 0;
            for (UnitModelLocal unitModelCild : requestedColl) {
                long unitId;
                childrenIds[i] = unitId = unitModelCild.getUnitId();
                ++i;
            }
        }
        catch (FinderException e) {
            this.deletePermissionsForUnit(parentId);
            childrenIds = new long[]{};
            logger.error((Object)"runs into", (Throwable)e);
        }
        return childrenIds;
    }

    public Collection<UnitModelLocal> getChildrenUnitsByParent(long parentId) {
        Collection coll = null;
        try {
            UnitModelLocal unitModel = this.unitModelLocalHome.findByPrimaryKey(new UnitModelPK(parentId));
            coll = unitModel.getChildUnits();
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return coll;
    }

    public long[] getParentIdsByChildId(long childId) {
        long[] parentIds = null;
        try {
            UnitModelLocal unitModel = this.unitModelLocalHome.findByPrimaryKey(new UnitModelPK(childId));
            Collection coll = this.unitModelLocalHome.findyParentsFromChildId(childId);
            parentIds = new long[coll.size()];
            int i = 0;
            for (UnitModelLocal unitModelParent : coll) {
                long unitId;
                parentIds[i] = unitId = unitModelParent.getUnitId();
                ++i;
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        if (parentIds == null) {
            parentIds = new long[]{};
        }
        return parentIds;
    }

    public ArrayList<UnitDTO> getUnitDTOsForPermissionByUsername(String username) {
        HashSet<Long> unitIds = this.getUnitIdsForPermissionByUsername(username);
        ArrayList<UnitDTO> unitDtos = this.getUnitDTOsForUnitIds(unitIds);
        return unitDtos;
    }

    public ArrayList<UnitDTO> getUnitDTOsForPermissionByGroupId(long groupId) {
        HashSet<Long> unitIds = this.getUnitIdsForPermissionByGroupId(groupId);
        ArrayList<UnitDTO> unitDtos = this.getUnitDTOsForUnitIds(unitIds);
        return unitDtos;
    }

    public ArrayList<UnitDTO> getUnitDTOsForPermissionByUseUserId(long useUserId) {
        HashSet<Long> unitIds = this.getUnitIdsForPermissionByUseUserId(useUserId);
        ArrayList<UnitDTO> unitDtos = this.getUnitDTOsForUnitIds(unitIds);
        return unitDtos;
    }

    public ArrayList<UnitDTO> getUnitDTOsForPermissionByRoleId(long roleId) {
        HashSet<Long> unitIds = this.getUnitIdsForPermissionByRoleId(roleId);
        ArrayList<UnitDTO> unitDtos = this.getUnitDTOsForUnitIds(unitIds);
        return unitDtos;
    }

    private ArrayList<UnitDTO> getUnitDTOsForUnitIds(HashSet<Long> unitIds) {
        ArrayList<UnitDTO> unitDtos = new ArrayList<UnitDTO>();
        for (Long unitId : unitIds) {
            UnitDTO unitDto = this.commonData.getUnit(unitId);
            unitDtos.add(unitDto);
        }
        return unitDtos;
    }

    public ArrayList<UnitDTO> getUnitDTOsForPermissionByUsernameInGroup(String username) {
        HashSet<Long> unitIdsSum = new HashSet<Long>();
        List<GroupIdentValue> userGroups = this.adminFacade.getGroupsByUsername(username);
        for (GroupIdentValue group : userGroups) {
            HashSet<Long> unitIds = this.getUnitIdsForPermissionByGroupId(group.getID());
            unitIdsSum.addAll(unitIds);
        }
        ArrayList<UnitDTO> unitDtos = this.getUnitDTOsForUnitIds(unitIdsSum);
        return unitDtos;
    }

    private ArrayList<UnitPermissionDTO> getUnitPermissionDTOsForUnitIds(HashSet<Long> unitIds, boolean user, boolean group, boolean role) {
        ArrayList<UnitPermissionDTO> unitPermissionDTOs = new ArrayList<UnitPermissionDTO>();
        for (Long unitId : unitIds) {
            UnitDTO unitDto = this.commonData.getUnit(unitId);
            UnitPermissionDTO unitPermissionDTO = new UnitPermissionDTO(unitDto.getUnitModelValue(), unitDto.getUnitIdentityValue(), unitDto.getUnitTypeIdentityValue());
            if (user) {
                unitPermissionDTO.setUserPermission(true);
            }
            if (group) {
                unitPermissionDTO.setGroupPermission(true);
            }
            if (role) {
                unitPermissionDTO.setRolePermission(true);
            }
            unitPermissionDTOs.add(unitPermissionDTO);
        }
        return unitPermissionDTOs;
    }

    public ArrayList<UnitPermissionDTO> getUnitPermissionDTOsByUsername(String username) {
        HashSet<Long> unitIds = this.getUnitIdsForPermissionByUsername(username);
        ArrayList<UnitPermissionDTO> unitPermissionDTOs = this.getUnitPermissionDTOsForUnitIds(unitIds, true, false, false);
        return unitPermissionDTOs;
    }

    public ArrayList<UnitPermissionDTO> getUnitPermissionDTOsByGroupId(long groupId) {
        HashSet<Long> unitIds = this.getUnitIdsForPermissionByGroupId(groupId);
        ArrayList<UnitPermissionDTO> unitPermissionDTOs = this.getUnitPermissionDTOsForUnitIds(unitIds, false, true, false);
        return unitPermissionDTOs;
    }

    public ArrayList<UnitPermissionDTO> getUnitPermissionDTOsByUseUserId(long useUserId) {
        HashSet<Long> unitIds = this.getUnitIdsForPermissionByUseUserId(useUserId);
        ArrayList<UnitPermissionDTO> unitPermissionDTOs = this.getUnitPermissionDTOsForUnitIds(unitIds, true, false, false);
        return unitPermissionDTOs;
    }

    public ArrayList<UnitPermissionDTO> getUnitPermissionDTOsByUseGroupId(long useGroupId) {
        HashSet<Long> unitIds = this.getUnitIdsForPermissionByUseGroupId(useGroupId);
        ArrayList<UnitPermissionDTO> unitPermissionDTOs = this.getUnitPermissionDTOsForUnitIds(unitIds, false, true, false);
        return unitPermissionDTOs;
    }

    public ArrayList<UnitPermissionDTO> getUnitPermissionDTOsByRoleId(long roleId) {
        HashSet<Long> unitIds = this.getUnitIdsForPermissionByRoleId(roleId);
        ArrayList<UnitPermissionDTO> unitPermissionDTOs = this.getUnitPermissionDTOsForUnitIds(unitIds, false, false, true);
        return unitPermissionDTOs;
    }

    public ArrayList<UnitPermissionDTO> getUnitPermissionDTOsByUsernameInGroup(String username) {
        HashSet<Long> unitIdsSum = new HashSet<Long>();
        List<GroupIdentValue> userGroups = this.adminFacade.getGroupsByUsername(username);
        for (GroupIdentValue group : userGroups) {
            HashSet<Long> unitIds = this.getUnitIdsForPermissionByGroupId(group.getID());
            unitIdsSum.addAll(unitIds);
        }
        ArrayList<UnitPermissionDTO> unitPermissionDTOs = this.getUnitPermissionDTOsForUnitIds(unitIdsSum, false, true, false);
        return unitPermissionDTOs;
    }

    private HashMap<Long, HashSet<String>> buildPermissionMapWithNames(Object obj, HashSet<Long> unitIds, HashMap<Long, HashSet<String>> unitToPermissionNames) {
        Cloneable value;
        String name = "";
        Iterator<Long> it = unitIds.iterator();
        if (obj instanceof GroupIdentValue) {
            value = (GroupIdentValue)obj;
            name = ((GroupIdentValue)value).getGroupname();
        } else if (obj instanceof RoleValue) {
            value = (RoleValue)obj;
            name = ((RoleValue)value).getRolename();
        }
        while (it.hasNext()) {
            Long unitId = it.next();
            HashSet<String> set = new HashSet<String>();
            if (unitToPermissionNames.containsKey(unitId)) {
                set = unitToPermissionNames.get(unitId);
            }
            set.add(name);
            unitToPermissionNames.put(unitId, set);
        }
        return unitToPermissionNames;
    }

    public UnitPermissionDTOList getAllUnitPermissionDTOsForUsername(String username) {
        List<RoleValue> roles;
        HashSet<Long> unitIds;
        UnitPermissionDTOList unitPermissionDTOs = new UnitPermissionDTOList();
        HashSet unitIdsAll = new HashSet();
        HashSet<RoleValue> allRoles = new HashSet<RoleValue>();
        HashSet<Long> unitIdsGroup = new HashSet<Long>();
        List<GroupIdentValue> userGroups = this.adminFacade.getGroupsByUsername(username);
        HashMap<Long, HashSet<String>> unitToGroupnames = new HashMap<Long, HashSet<String>>();
        GroupIdentValue group = null;
        for (int i = 0; i != userGroups.size(); ++i) {
            group = userGroups.get(i);
            unitIds = this.getUnitIdsForPermissionByGroupId(group.getID());
            unitIdsGroup.addAll(unitIds);
            unitToGroupnames = this.buildPermissionMapWithNames(group, unitIds, unitToGroupnames);
            roles = this.adminFacade.getRolesByGroupId(group.getID());
            allRoles.addAll(roles);
        }
        HashSet<Long> unitIdsUser = this.getUnitIdsForPermissionByUsername(username);
        roles = this.adminFacade.getRolesByUsername(username);
        if (roles != null) {
            allRoles.addAll(roles);
        }
        HashSet<Long> unitIdsRole = new HashSet<Long>();
        HashMap<Long, HashSet<String>> unitToRolenames = new HashMap<Long, HashSet<String>>();
        for (RoleValue role : allRoles) {
            unitIds = this.getUnitIdsForPermissionByRoleId(role.getId());
            unitIdsRole.addAll(unitIds);
            unitToRolenames = this.buildPermissionMapWithNames(role, unitIds, unitToRolenames);
        }
        unitIdsAll.addAll(unitIdsGroup);
        unitIdsAll.addAll(unitIdsRole);
        unitIdsAll.addAll(unitIdsUser);
        Long[] unitIdsArray = unitIdsAll.toArray(new Long[0]);
        for (int i = 0; i != unitIdsArray.length; ++i) {
            HashSet<String> s;
            Long unitId = unitIdsArray[i];
            UnitDTO unitDto = this.commonData.getUnit(unitId);
            UnitPermissionDTO unitPermissionDTO = new UnitPermissionDTO(unitDto);
            if (unitIdsUser.contains(unitId)) {
                unitPermissionDTO.setUserPermission(true);
                unitPermissionDTO.setUserName(username);
            }
            if (unitIdsGroup.contains(unitId)) {
                unitPermissionDTO.setGroupPermission(true);
                s = unitToGroupnames.get(unitId);
                unitPermissionDTO.setGroupNames(s.toString());
            }
            if (unitIdsRole.contains(unitId)) {
                unitPermissionDTO.setRolePermission(true);
                s = unitToRolenames.get(unitId);
                unitPermissionDTO.setRoleNames(s.toString());
            }
            unitPermissionDTOs.add(unitPermissionDTO);
        }
        return unitPermissionDTOs;
    }

    public UnitPermissionDTOList getAllUnitPermissionDTOsForGroupId(long groupId) {
        UnitPermissionDTOList unitPermissionDTOs = new UnitPermissionDTOList();
        HashSet<Long> unitIdsAll = new HashSet<Long>();
        GroupIdentLocal groupIdent = null;
        try {
            groupIdent = this.groupIdentHome.findByPrimaryKey(new GroupIdentPK(groupId));
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        String groupName = "";
        if (groupIdent != null) {
            groupName = groupIdent.getGroupname();
        }
        HashSet<Long> unitIdsGroup = this.getUnitIdsForPermissionByGroupId(groupId);
        List<RoleValue> roles = this.adminFacade.getRolesByGroupId(groupId);
        HashSet<Long> unitIdsRole = new HashSet<Long>();
        HashMap<Long, HashSet<String>> unitToRolenames = new HashMap<Long, HashSet<String>>();
        for (RoleValue role : roles) {
            HashSet<Long> unitIds = this.getUnitIdsForPermissionByRoleId(role.getId());
            unitIdsRole.addAll(unitIds);
            unitToRolenames = this.buildPermissionMapWithNames(role, unitIds, unitToRolenames);
        }
        unitIdsAll.addAll(unitIdsGroup);
        unitIdsAll.addAll(unitIdsRole);
        for (Long unitId : unitIdsAll) {
            UnitDTO unitDto = this.commonData.getUnit(unitId);
            UnitPermissionDTO unitPermissionDTO = new UnitPermissionDTO(unitDto.getUnitModelValue(), unitDto.getUnitIdentityValue(), unitDto.getUnitTypeIdentityValue());
            if (unitIdsGroup.contains(unitId)) {
                unitPermissionDTO.setGroupPermission(true);
                unitPermissionDTO.setGroupNames(groupName);
            }
            if (unitIdsRole.contains(unitId)) {
                unitPermissionDTO.setRolePermission(true);
                HashSet<String> s = unitToRolenames.get(unitId);
                unitPermissionDTO.setRoleNames(s.toString());
            }
            unitPermissionDTOs.add(unitPermissionDTO);
        }
        return unitPermissionDTOs;
    }

    public boolean hasUseUserPermissions(long unitId, long useUserId) {
        Collection coll = null;
        try {
            coll = this.unitPermissionLocalHome.findByUnitORGroupIdAndUserId(unitId, useUserId);
        }
        catch (FinderException e) {
            // empty catch block
        }
        return coll != null && !coll.isEmpty();
    }

    public List<UnitDTO>[] getAccessLists(Long unitId) {
        Principal p = this.sessionContext.getCallerPrincipal();
        String name = p.getName();
        UnitDTOList positiveList = new ArrayList();
        ArrayList<UnitDTO> negativeList = new ArrayList<UnitDTO>();
        if (this.sessionContext.isCallerInRole("superadmin")) {
            positiveList = this.commonData.getUnitsByIsBasic(true, false);
            List[] arr = new List[]{positiveList, negativeList};
            return arr;
        }
        try {
            List<Long> availableUnits;
            if (unitId == null) {
                availableUnits = this.commonData.getUnitIdsByIsBasic(true);
            } else {
                UnitModelLocal unitModel = this.unitModelLocalHome.findByPrimaryKey(new UnitModelPK(unitId));
                if (unitModel.getBasic()) {
                    availableUnits = new ArrayList<Long>();
                    availableUnits.add(unitId);
                } else {
                    availableUnits = this.collectAllBasicUnits(unitId);
                }
            }
            UnitPermissionDTOList permissions = this.getAllUnitPermissionDTOsForUsername(name);
            for (int i = 0; i < availableUnits.size(); ++i) {
                boolean hasPermission = false;
                Long availableUnitId = availableUnits.get(i);
                for (int j = 0; j < permissions.size(); ++j) {
                    if (!availableUnitId.equals(((UnitPermissionDTO)permissions.get(j)).getUnitId())) continue;
                    hasPermission = true;
                }
                if (hasPermission) {
                    positiveList.add(this.commonData.getUnit(availableUnitId));
                    continue;
                }
                negativeList.add(this.commonData.getUnit(availableUnitId));
            }
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        List[] arr = new List[]{positiveList, negativeList};
        return arr;
    }

    public boolean hasAccesRightPermissionForUnit(Long unitId) {
        UnitPermissionDTOList permissions = this.getAllUnitPermissionDTOsForUsername(super.getCallerName());
        if (this.sessionContext.isCallerInRole("superadmin")) {
            return true;
        }
        for (int i = 0; i < permissions.size(); ++i) {
            if (!((UnitPermissionDTO)permissions.get(i)).getUnitId().equals(unitId)) continue;
            return true;
        }
        return false;
    }

    public UnitPermissionDTOList getUnitPermissionDTOsForUseUserValue(UseUserValue value) {
        UnitPermissionDTOList unitPermissionDTOs = new UnitPermissionDTOList();
        HashSet<Long> unitIdsAll = new HashSet<Long>();
        HashSet<Long> unitIdsUseUser = this.getUnitIdsForPermissionByUseUserId(value.getId());
        HashSet<Long> unitIdsUseGroup = this.getUnitIdsForPermissionByUseGroupId(value.getGroupId());
        UseGroupLocal useGroup = null;
        try {
            useGroup = this.useGroupHome.findByPrimaryKey(new UseGroupPK(value.getGroupId()));
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        String groupName = "";
        if (useGroup != null) {
            groupName = useGroup.getUseGroupValue().getName();
        }
        unitIdsAll.addAll(unitIdsUseGroup);
        unitIdsAll.addAll(unitIdsUseUser);
        for (Long unitId : unitIdsAll) {
            UnitDTO unitDto = this.commonData.getUnit(unitId);
            UnitPermissionDTO unitPermissionDTO = new UnitPermissionDTO(unitDto.getUnitModelValue(), unitDto.getUnitIdentityValue(), unitDto.getUnitTypeIdentityValue());
            if (unitIdsUseGroup.contains(unitId)) {
                unitPermissionDTO.setGroupPermission(true);
                unitPermissionDTO.setGroupNames(groupName);
            }
            if (unitIdsUseUser.contains(unitId)) {
                unitPermissionDTO.setUserPermission(true);
                unitPermissionDTO.setUserName(value.getName());
            }
            unitPermissionDTOs.add(unitPermissionDTO);
        }
        return unitPermissionDTOs;
    }

    public Collection<UnitModelLocal> getUnitsWithoutParents(boolean isBasic) {
        ArrayList<UnitModelLocal> coll = new ArrayList<UnitModelLocal>();
        try {
            Collection unitModels = this.unitModelLocalHome.findyByIsBasic(isBasic);
            for (Object obj : unitModels) {
                UnitModelLocal unitModel = (UnitModelLocal)obj;
                if (unitModel == null) continue;
                Collection parents = new ArrayList();
                try {
                    parents = this.unitModelLocalHome.findyParentsFromChildId(unitModel.getUnitId());
                    if (parents.size() != 0) continue;
                    coll.add(unitModel);
                }
                catch (FinderException e) {
                    logger.error((Object)"runs into", (Throwable)e);
                }
            }
        }
        catch (FinderException e) {
            e.printStackTrace();
        }
        return coll;
    }

    private boolean createAuditDataForPermissions(Object forLocalObj, ArrayList<UnitPermissionValue> oldUnitPermissions, ArrayList<UnitPermissionValue> newUnitPermissions) {
        Object local;
        HashSet<Long> setOld = this.getUnitIdsForPermission(oldUnitPermissions);
        HashSet<Long> setNew = this.getUnitIdsForPermission(newUnitPermissions);
        HashSet setOldSave = (HashSet)setOld.clone();
        setOld.removeAll(setNew);
        setNew.removeAll(setOldSave);
        String deleted = "";
        ArrayList<UnitDTO> list = this.getUnitDTOsForUnitIds(setOld);
        for (UnitDTO obj : list) {
            UnitDTO unitDto = obj;
            if (unitDto == null) continue;
            deleted = deleted + unitDto.getUnitName() + " ";
        }
        String inserted = "";
        list = this.getUnitDTOsForUnitIds(setNew);
        for (UnitDTO obj : list) {
            UnitDTO unitDto = obj;
            if (unitDto == null) continue;
            inserted = inserted + unitDto.getUnitName() + " ";
        }
        String pk = "";
        String entity = "";
        if (forLocalObj instanceof AccountLocal) {
            local = (AccountLocal)forLocalObj;
            pk = local.getPrimaryKey().toString() + " " + local.getAccountValue().getUsername();
            entity = "RelationViewRightsToUser";
        } else if (forLocalObj instanceof GroupIdentLocal) {
            local = (GroupIdentLocal)forLocalObj;
            pk = local.getPrimaryKey().toString() + " " + local.getGroupname();
            entity = "RelationViewRightsToUserGroup";
        } else if (forLocalObj instanceof RoleLocal) {
            local = (RoleLocal)forLocalObj;
            pk = local.getPrimaryKey().toString() + " " + local.getRoleValue().getRolename();
            entity = "RelationViewRightsToRole";
        } else if (forLocalObj instanceof UseUserLocal) {
            local = (UseUserLocal)forLocalObj;
            pk = local.getPrimaryKey().toString() + " " + local.getUseUserValue().getName();
            entity = "RelationAssignmentsToUseUser";
        } else if (forLocalObj instanceof UseGroupLocal) {
            local = (UseGroupLocal)forLocalObj;
            pk = local.getPrimaryKey().toString() + " " + local.getUseGroupValue().getName();
            entity = "RelationAssignmentsToUseGroup";
        }
        try {
            if (setNew.size() > 0) {
                this.adminFacade.createAuditData(this.auditAppl, pk, entity, null, inserted);
            }
            if (setOld.size() > 0) {
                this.adminFacade.createAuditData(this.auditAppl, pk, entity, deleted, null);
            }
        }
        catch (CreateException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return true;
    }

    public boolean saveOperativeTimeOffset(long unitId, long runtime) {
        boolean success = false;
        try {
            UnitModelLocal unitModel = this.unitModelLocalHome.findByPrimaryKey(new UnitModelPK(unitId));
            unitModel.setOperativeTimeOffset(runtime);
            success = true;
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return success;
    }

    public boolean moveCacheDataToHistoryForDeletedUnit(UnitModelLocal unitModel) {
        boolean success = true;
        ScanmanMsgFacadeLocal scanmanMsgFacade = null;
        UseFacadeLocal useFacade = null;
        GdataFacadeLocal gdataFacade = null;
        NotifyFacadeLocal notifyFacade = null;
        KeepAliveInFacadeLocal keppAliveFacade = null;
        CurrentStateFacadeLocal currentStateFacade = null;
        try {
            scanmanMsgFacade = ScanmanMsgFacadeUtil.getLocalHome().create();
            useFacade = UseFacadeUtil.getLocalHome().create();
            gdataFacade = GdataFacadeUtil.getLocalHome().create();
            notifyFacade = NotifyFacadeUtil.getLocalHome().create();
            keppAliveFacade = KeepAliveInFacadeUtil.getLocalHome().create();
            currentStateFacade = CurrentStateFacadeUtil.getLocalHome().create();
            if (currentStateFacade != null) {
                success = currentStateFacade.moveCacheDataToHistoryForDeletedUnit(unitModel);
            }
            if (notifyFacade != null) {
                success = notifyFacade.moveCacheDataToHistoryForDeletedUnit(unitModel);
            }
            if (keppAliveFacade != null) {
                success = keppAliveFacade.moveCacheDataToHistoryForDeletedUnit(unitModel);
            }
            if (gdataFacade != null) {
                success = gdataFacade.moveCacheDataToHistoryForDeletedUnit(unitModel);
            }
            if (useFacade != null) {
                success = useFacade.moveCacheDataToHistoryForDeletedUnit(unitModel);
            }
            if (scanmanMsgFacade != null) {
                success = scanmanMsgFacade.moveCacheDataToHistoryForDeletedUnit(unitModel);
            }
        }
        catch (CreateException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        catch (NamingException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return success;
    }

    public void updateUnitUserRefreshForUseGroup(long groupId) {
        if (groupId > 0L) {
            this.updateUnitUserRefresh(this.getUnitPermissionsByUseGroupId(groupId));
        }
    }

    public void updateUnitUserRefreshForUseUser(long userId) {
        this.updateUnitUserRefresh(this.getUnitPermissionsByUseUserId(userId));
    }

    public boolean saveNextMaintenance(long unitId, int nextMaintenance) {
        boolean success = false;
        try {
            UnitModelLocal unitModel = this.unitModelLocalHome.findByPrimaryKey(new UnitModelPK(unitId));
            unitModel.setNextMaintenance(nextMaintenance);
            success = true;
        }
        catch (FinderException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return success;
    }
}

