/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.unit.facade;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.app.unit.exception.UnitNotFoundException;
import de.proveo.wwt.logic.app.unit.exception.admin.UnitCreateException;
import de.proveo.wwt.logic.app.unit.exception.admin.UnitDeleteException;
import de.proveo.wwt.logic.app.unit.exception.admin.UnitUpdateException;
import de.proveo.wwt.logic.ejb.dataIn.geo.cache.CurrentGdataCacheLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.geo.cache.CurrentGdataCacheUtil;
import de.proveo.wwt.logic.ejb.dataIn.geo.history.GdataHistoryLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.geo.history.GdataHistoryUtil;
import de.proveo.wwt.logic.ejb.dataIn.grouphistory.GrouphistoryLocal;
import de.proveo.wwt.logic.ejb.dataIn.grouphistory.GrouphistoryLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.grouphistory.GrouphistoryUtil;
import de.proveo.wwt.logic.ejb.dataIn.grouphistory.GrouphistoryValue;
import de.proveo.wwt.logic.ejb.dataIn.keepalive.cache.KeepAliveCacheLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.keepalive.cache.KeepAliveCacheUtil;
import de.proveo.wwt.logic.ejb.dataIn.keepalive.history.KeepAliveHistoryLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.keepalive.history.KeepAliveHistoryUtil;
import de.proveo.wwt.logic.ejb.dataIn.notify.cache.CurrentNotifyCacheLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.notify.cache.CurrentNotifyCacheUtil;
import de.proveo.wwt.logic.ejb.dataIn.notify.history.NotifyHistoryLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.notify.history.NotifyHistoryUtil;
import de.proveo.wwt.logic.ejb.dataIn.scanmanmsg.ScanmanMsgFacadeUtil;
import de.proveo.wwt.logic.ejb.dataIn.state.init.InitStateModelLocal;
import de.proveo.wwt.logic.ejb.dataIn.state.init.InitStateModelUtil;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.CurrentStateCacheLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.CurrentStateCacheUtil;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.StateHistoryLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.StateHistoryUtil;
import de.proveo.wwt.logic.ejb.dataIn.use.cache.UseCacheLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.use.cache.UseCacheUtil;
import de.proveo.wwt.logic.ejb.dataIn.use.error.UseErrorHistoryLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.use.error.UseErrorHistoryUtil;
import de.proveo.wwt.logic.ejb.dataIn.use.history.UseHistoryLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.use.history.UseHistoryUtil;
import de.proveo.wwt.logic.ejb.general.unit.UnitData;
import de.proveo.wwt.logic.ejb.general.unit.UnitPositionComparator;
import de.proveo.wwt.logic.ejb.general.unit.entity.group.UnitBasicGroupRelLocal;
import de.proveo.wwt.logic.ejb.general.unit.entity.group.UnitBasicGroupRelLocalHome;
import de.proveo.wwt.logic.ejb.general.unit.entity.group.UnitBasicGroupRelPK;
import de.proveo.wwt.logic.ejb.general.unit.entity.group.UnitBasicGroupRelUtil;
import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityLocal;
import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityLocalHome;
import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityPK;
import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityUtil;
import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityValue;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelLocal;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelLocalHome;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelPK;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelUtil;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelValue;
import de.proveo.wwt.logic.ejb.general.unit.entity.state.UnitStateModelLocal;
import de.proveo.wwt.logic.ejb.general.unit.entity.state.UnitStateModelLocalHome;
import de.proveo.wwt.logic.ejb.general.unit.entity.typeidentity.UnitTypeIdentityLocal;
import de.proveo.wwt.logic.ejb.general.unit.entity.typeidentity.UnitTypeIdentityLocalHome;
import de.proveo.wwt.logic.ejb.general.unit.entity.typeidentity.UnitTypeIdentityUtil;
import de.proveo.wwt.logic.ejb.general.unit.entity.typeidentity.UnitTypeIdentityValue;
import de.proveo.wwt.logic.web.admin.AdminFacadeLocal;
import de.proveo.wwt.logic.web.admin.AdminFacadeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.EJBLocalObject;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class UnitFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final Log log = LogFactory.getLog(UnitFacadeBean.class);
    private UnitIdentityLocalHome unitIdentityHome = null;
    private UnitModelLocalHome unitModelHome;
    private UnitBasicGroupRelLocalHome unitBasicGroupRelHome = null;
    private UnitStateModelLocalHome unitStateModel = null;
    private InitStateModelLocal initStateModel = null;
    private GrouphistoryLocalHome grouphistoryHome;
    private AdminFacadeLocal adminFacade;
    private UnitTypeIdentityLocalHome unitTypeIdentityHome;

    public void ejbCreate() throws CreateException {
        try {
            this.unitIdentityHome = UnitIdentityUtil.getLocalHome();
            this.unitModelHome = UnitModelUtil.getLocalHome();
            this.unitBasicGroupRelHome = UnitBasicGroupRelUtil.getLocalHome();
            this.initStateModel = InitStateModelUtil.getLocalHome().create();
            this.grouphistoryHome = GrouphistoryUtil.getLocalHome();
            this.adminFacade = AdminFacadeUtil.getLocalHome().create();
            this.unitTypeIdentityHome = UnitTypeIdentityUtil.getLocalHome();
        }
        catch (NamingException ex) {
            log.error((Object)"runs into", (Throwable)ex);
            throw new EJBException("runs during lookup other ejbs into " + ex.getMessage());
        }
    }

    public long[] getAllUnits() {
        Collection units = new ArrayList();
        try {
            units = this.unitModelHome.findAll();
        }
        catch (FinderException ex) {
            return new long[0];
        }
        ArrayList<Long> unitIdCol = new ArrayList<Long>(units.size());
        for (UnitModelLocal unit : units) {
            try {
                unitIdCol.add(new Long(unit.getUnitId()));
            }
            catch (Exception ex) {
                log.error((Object)"getAllUnits() runs during access a UnitModel RemoteInterface into", (Throwable)ex);
            }
        }
        long[] unitIds = new long[unitIdCol.size()];
        int index = 0;
        Iterator it = unitIdCol.iterator();
        while (it.hasNext()) {
            unitIds[index] = (Long)it.next();
            ++index;
        }
        return unitIds;
    }

    public UnitData[] getRootUnits() {
        return this.getRootUnits(true);
    }

    public UnitData[] getRootUnitGroups() {
        return this.getRootUnits(false);
    }

    protected UnitData[] getRootUnits(boolean includeBasicUnits) {
        ArrayList<UnitData> rootUnitDatas = new ArrayList<UnitData>();
        long[] unitIds = this.getAllUnits();
        for (int unitIndex = 0; unitIndex < unitIds.length; ++unitIndex) {
            try {
                Collection rel = this.unitBasicGroupRelHome.findByBasicId(unitIds[unitIndex]);
                if (!rel.isEmpty()) continue;
                throw new FinderException();
            }
            catch (FinderException ex) {
                try {
                    UnitData data = this.getUnitData(unitIds[unitIndex]);
                    if (!includeBasicUnits && data.getUnitisbasic().booleanValue()) continue;
                    rootUnitDatas.add(data);
                }
                catch (UnitNotFoundException exUnit) {
                    log.error((Object)("getRootUnits(boolean) possible error in unitBasicGroupRel for unitId: " + unitIds[unitIndex]), (Throwable)exUnit);
                }
                continue;
            }
            catch (Exception ex) {
                if (log.isDebugEnabled()) {
                    log.error((Object)("getRootUnits() runs during find parents for unitId: " + unitIds[unitIndex] + " into"), (Throwable)ex);
                    continue;
                }
                log.error((Object)"getRootUnits() runs during find parents into", (Throwable)ex);
            }
        }
        return this.buildArrayFromCollection(rootUnitDatas);
    }

    public void insertUnit(UnitData data) throws UnitCreateException {
        UnitIdentityValue identityData = this.getIdentityData(data);
        UnitModelValue modelData = this.getModelData(data);
        try {
            this.unitIdentityHome.create(identityData);
            this.unitModelHome.create(modelData);
        }
        catch (Exception ex) {
            throw new UnitCreateException((long)data.getUnitid(), ex);
        }
    }

    public void create(UnitIdentityValue unitIdentityValue) {
        try {
            this.unitIdentityHome.create(unitIdentityValue);
        }
        catch (Exception ex) {
            throw new EJBException(ex);
        }
    }

    public void updateUnitTypeIdentity(UnitModelLocal unitModel) throws FinderException, CreateException {
        this.updateUnitTypeIdentity(unitModel, unitModel.getUnitIdentity().getUnitIdentityValue());
    }

    public void updateUnitTypeIdentity(UnitIdentityValue unitIdentityValue) throws FinderException, CreateException {
        UnitModelLocal unitModel = this.unitModelHome.findByPrimaryKey(new UnitModelPK(unitIdentityValue.getUnitId()));
        this.updateUnitTypeIdentity(unitModel, unitIdentityValue);
    }

    public void updateUnitTypeIdentity(UnitModelLocal unitModel, UnitIdentityValue unitIdentityValue) throws FinderException, CreateException {
        if (!unitModel.getBasic()) {
            return;
        }
        UnitTypeIdentityLocal typeIdent = null;
        Iterator it = this.unitTypeIdentityHome.findByUnitKind(unitIdentityValue.getUnitKind()).iterator();
        if (it.hasNext()) {
            typeIdent = (UnitTypeIdentityLocal)it.next();
        }
        if (typeIdent == null) {
            UnitTypeIdentityValue unitTypeIdentity = new UnitTypeIdentityValue();
            unitTypeIdentity.setName(unitIdentityValue.getUnitKind());
            unitTypeIdentity.setImageName(unitIdentityValue.getImageName());
            try {
                typeIdent = this.unitTypeIdentityHome.create(unitTypeIdentity);
            }
            catch (DuplicateKeyException ex) {
                this.unitTypeIdentityHome.reorganizeSequence();
                typeIdent = this.unitTypeIdentityHome.create(unitTypeIdentity);
            }
        }
        ArrayList<UnitModelLocal> coll = new ArrayList<UnitModelLocal>();
        coll.addAll(typeIdent.getUnitModels());
        coll.add(unitModel);
        typeIdent.setUnitModels(coll);
    }

    public void update(UnitIdentityValue unitIdentityValue) {
        try {
            UnitIdentityLocal unitIdentity = this.unitIdentityHome.findByPrimaryKey(new UnitIdentityPK(unitIdentityValue.getUnitId()));
            if (!unitIdentityValue.getUnitKind().equals(unitIdentity.getUnitKind())) {
                this.updateUnitTypeIdentity(unitIdentityValue);
            }
            unitIdentity.setUnitIdentityValue(unitIdentityValue);
        }
        catch (Exception ex) {
            throw new EJBException(ex);
        }
    }

    public void update(UnitModelValue unitModelValue) {
        try {
            UnitModelLocal unitModel = this.unitModelHome.findByPrimaryKey(new UnitModelPK(unitModelValue.getUnitId()));
            unitModel.setUnitModelValue(unitModelValue);
        }
        catch (Exception ex) {
            throw new EJBException(ex);
        }
    }

    public void create(UnitModelValue unitModelValue) {
        try {
            UnitModelLocal unitModel = this.unitModelHome.create(unitModelValue);
            this.updateUnitTypeIdentity(unitModel);
            if (unitModelValue.getBasic()) {
                this.initStateModel.initializeAllStateModels(unitModelValue.getUnitId());
            }
        }
        catch (Exception ex) {
            throw new EJBException(ex);
        }
    }

    public void deleteUnit(long unitId) throws UnitDeleteException {
        try {
            try {
                log.debug((Object)("#########" + unitId + "#######"));
                Collection rels = this.unitBasicGroupRelHome.findByUnitId(unitId);
                log.debug((Object)("---found " + rels.size()));
                for (UnitBasicGroupRelLocal rel : rels) {
                    log.debug((Object)"delete one");
                    rel.remove();
                }
            }
            catch (FinderException ex) {
                log.debug((Object)("deleteUnit(unitId: " + unitId + ") no groups found"), (Throwable)ex);
            }
            try {
                UnitIdentityLocal unitInd = this.unitIdentityHome.findByPrimaryKey(new UnitIdentityPK(unitId));
                unitInd.remove();
            }
            catch (ObjectNotFoundException ex) {
                log.trace((Object)"deleteUnit() unitIdentity already deleted");
            }
            try {
                UnitModelLocal unitMod = this.unitModelHome.findByPrimaryKey(new UnitModelPK(unitId));
                unitMod.remove();
            }
            catch (ObjectNotFoundException ex) {
                log.trace((Object)"deleteUnit() unitIdentity already deleted");
            }
        }
        catch (Exception ex) {
            log.debug((Object)"runs into", (Throwable)ex);
            throw new UnitDeleteException(unitId, ex);
        }
    }

    public void updateUnit(UnitData data) throws UnitUpdateException {
        UnitIdentityValue identityData = this.getIdentityData(data);
        UnitModelValue modelData = this.getModelData(data);
        try {
            UnitModelLocal unitMod = this.unitModelHome.findByPrimaryKey(new UnitModelPK(data.getUnitid()));
            unitMod.setUnitModelValue(modelData);
            UnitIdentityLocal unitInd = this.unitIdentityHome.findByPrimaryKey(new UnitIdentityPK(data.getUnitid()));
            unitInd.setUnitIdentityValue(identityData);
        }
        catch (Exception ex) {
            throw new UnitUpdateException((long)data.getUnitid(), ex);
        }
    }

    public void addUnitToGroup(long unitId, long groupId) throws CreateException {
        try {
            this.unitBasicGroupRelHome.create(groupId, unitId);
            UnitModelLocal unitModel = this.unitModelHome.findByPrimaryKey(new UnitModelPK(unitId));
            UnitModelLocal unitModelGroup = this.unitModelHome.findByPrimaryKey(new UnitModelPK(groupId));
            ArrayList<UnitModelLocal> childs = new ArrayList<UnitModelLocal>(unitModelGroup.getChildUnits());
            if (!childs.contains(unitModel)) {
                childs.add(unitModel);
                unitModelGroup.setChildUnits(childs);
            }
            GrouphistoryValue value = new GrouphistoryValue();
            value.setBeginTime(System.currentTimeMillis());
            value.setBasicUnitId(unitId);
            GrouphistoryLocal history = this.grouphistoryHome.create(value);
            ArrayList<GrouphistoryLocal> histories = new ArrayList<GrouphistoryLocal>(unitModel.getGroupHistories());
            histories.add(history);
            unitModel.setGroupHistories(histories);
        }
        catch (Exception ex) {
            if (log.isDebugEnabled()) {
                log.error((Object)("addUnitToGroup(" + unitId + "," + groupId + ") runs into"), (Throwable)ex);
            }
            log.error((Object)"addUnitToGroup() runs into", (Throwable)ex);
        }
    }

    public void removeUnitFromGroup(long unitId, long groupId) {
        try {
            UnitBasicGroupRelLocal rel = this.unitBasicGroupRelHome.findByPrimaryKey(new UnitBasicGroupRelPK(groupId, unitId));
            rel.remove();
            UnitModelLocal unitModel = this.unitModelHome.findByPrimaryKey(new UnitModelPK(unitId));
            UnitModelLocal unitModelGroup = this.unitModelHome.findByPrimaryKey(new UnitModelPK(groupId));
            ArrayList childs = new ArrayList(unitModelGroup.getChildUnits());
            childs.remove(unitModel);
            unitModelGroup.setChildUnits(childs);
            long time = System.currentTimeMillis();
            GrouphistoryLocal history = this.adminFacade.getGrouphistoryLocalForUnit(unitId, time);
            history.setEndTime(time);
        }
        catch (FinderException ex) {
        }
        catch (Exception ex) {
            if (log.isDebugEnabled()) {
                log.error((Object)("removeUnitFromGroup(" + unitId + "," + groupId + ") runs into"), (Throwable)ex);
            }
            log.error((Object)"removeUnitFromGroup() runs into", (Throwable)ex);
        }
    }

    public UnitData getUnitData(long unitId) throws UnitNotFoundException {
        try {
            UnitModelLocal unitMod = this.unitModelHome.findByPrimaryKey(new UnitModelPK(unitId));
            UnitIdentityLocal unitInd = this.unitIdentityHome.findByPrimaryKey(new UnitIdentityPK(unitId));
            UnitData unitData = this.getUnitData(unitMod.getUnitModelValue(), unitInd.getUnitIdentityValue());
            unitData.setParentUnitId(this.getParentUnitId(unitId));
            return unitData;
        }
        catch (Exception ex) {
            throw new UnitNotFoundException(unitId, ex);
        }
    }

    public Collection getUnitDatas(long[] pks) {
        ArrayList<UnitData> unit_datas = new ArrayList<UnitData>();
        try {
            for (int unitIdIndex = 0; unitIdIndex < pks.length; ++unitIdIndex) {
                unit_datas.add(this.getUnitData(pks[unitIdIndex]));
            }
        }
        catch (UnitNotFoundException ex) {
            log.error((Object)"getUnitDatas() runs into", (Throwable)ex);
        }
        return unit_datas;
    }

    public Collection getUnitDatas(long[] pks, boolean fillPrevNextUnitId) {
        ArrayList<UnitData> unitDatas = new ArrayList<UnitData>();
        try {
            for (int unitIdIndex = 0; unitIdIndex < pks.length; ++unitIdIndex) {
                UnitData unitData = this.getUnitData(pks[unitIdIndex]);
                if (unitIdIndex > 0) {
                    unitData.setPrevUnitId(pks[unitIdIndex - 1]);
                }
                if (unitIdIndex < pks.length - 1) {
                    unitData.setNextUnitId(pks[unitIdIndex + 1]);
                }
                unitDatas.add(unitData);
            }
        }
        catch (UnitNotFoundException ex) {
            log.error((Object)"getUnitDatas(long[], boolean) runs into", (Throwable)ex);
        }
        return unitDatas;
    }

    public UnitData[] getUnderlayingUnits(long unitId) {
        return this.buildArrayFromCollection(this.getUnitDatas(this.getUnderlayingUnitIds(unitId)));
    }

    public Collection getUnderlayingUnitsSorted(long unitId) {
        return this.getUnitDatas(this.getUnderlayingUnitIdsSorted(unitId), true);
    }

    public Collection getBasicUnitsSorted(long unitId) {
        return this.getUnitDatas(this.getBasicUnitIdsSorted(unitId), true);
    }

    public long[] getUnderlayingUnitIds(long unitId) {
        ArrayList<Long> unitIds = new ArrayList<Long>();
        try {
            Collection rels = this.unitBasicGroupRelHome.findByGroupId(unitId);
            for (UnitBasicGroupRelLocal rel : rels) {
                long id = rel.getIdBasic();
                unitIds.add(new Long(id));
            }
        }
        catch (Exception ex) {
            log.error((Object)"getUnderlayingUnitIds() runs into", (Throwable)ex);
        }
        return this.getLongsArrayFromCollection(unitIds);
    }

    protected long[] getLongsArrayFromCollection(Collection col) {
        long[] longs = new long[col.size()];
        Iterator it = col.iterator();
        int index = 0;
        while (it.hasNext()) {
            longs[index] = (Long)it.next();
            ++index;
        }
        return longs;
    }

    protected UnitIdentityValue getIdentityData(UnitData data) {
        return new UnitIdentityValue(data.getUnitid(), data.getUnitname(), data.getUnitkind(), data.getPosition(), data.getImageName());
    }

    protected UnitModelValue getModelData(UnitData data) {
        UnitModelValue value = new UnitModelValue();
        value.setUnitId(data.getUnitid());
        value.setBasic(data.getUnitisbasic());
        value.setIpAddress(data.getIpAddress());
        value.setUnitUserRefresh(data.getUnitUserRefresh());
        value.setNextMaintenance(data.getNextMaintenance());
        value.setOperativeTimeOffset(data.getOperativeTimeOffset());
        value.setAirportMapVisible(data.isAirportMapVisible());
        value.setCallback(data.isCallback());
        return value;
    }

    protected UnitData getUnitData(UnitModelValue model, UnitIdentityValue identity) {
        UnitData unitData = new UnitData(new Long(model.getUnitId()), identity.getName(), model.getCustomerUnitID(), identity.getUnitKind(), new Boolean(model.getBasic()), model.getSendData(), identity.getPosition(), identity.getImageName(), model.getIpAddress(), model.getUnitUserRefresh(), model.getNextMaintenance(), model.getOperativeTimeOffset(), model.getAirportMapVisible(), model.getCallback());
        unitData.setRegistrationNumber(model.getRegistrationNumber());
        unitData.setBodyNumber(model.getBodyNumber());
        return unitData;
    }

    protected UnitData[] buildArrayFromCollection(Collection col) {
        Object[] obArr = col.toArray();
        UnitData[] result = new UnitData[obArr.length];
        for (int i = 0; i < obArr.length; ++i) {
            result[i] = (UnitData)obArr[i];
        }
        return result;
    }

    public boolean isExistence(long unitId) throws UnitNotFoundException {
        UnitModelPK pk = new UnitModelPK(unitId);
        try {
            this.unitModelHome.findByPrimaryKey(pk);
            return true;
        }
        catch (FinderException ex) {
            throw new UnitNotFoundException(unitId, (Exception)((Object)ex));
        }
    }

    public Collection getUnitDatas() {
        ArrayList<UnitData> unit_datas = new ArrayList<UnitData>();
        long[] unitIds = this.getAllUnits();
        try {
            for (int i = 0; i < unitIds.length; ++i) {
                unit_datas.add(this.getUnitData(unitIds[i]));
            }
        }
        catch (Exception ex) {
            log.error((Object)("getUnitDatas() in facade bean runs into" + ex.getMessage()));
        }
        return unit_datas;
    }

    public Collection getUnitDataNames() {
        ArrayList<UnitData> unit_datas = new ArrayList<UnitData>();
        long[] unitIds = this.getAllUnits();
        try {
            for (int i = 0; i < unitIds.length; ++i) {
                unit_datas.add(this.getUnitData(unitIds[i]));
            }
        }
        catch (Exception ex) {
            log.error((Object)("getUnitDatas() in facade bean runs into" + ex.getMessage()));
        }
        return unit_datas;
    }

    public Collection getUnitDatas(Long[] pks) {
        ArrayList<UnitData> unit_datas = new ArrayList<UnitData>();
        try {
            for (int i = 0; i < pks.length; ++i) {
                unit_datas.add(this.getUnitData(pks[i]));
            }
        }
        catch (Exception ex) {
            log.error((Object)("getUnitDatas() in facade bean runs into" + ex.getMessage()));
        }
        return unit_datas;
    }

    public long[] getUnderlayingUnitIdsSorted(long unitId) {
        UnitData[] unitDatas = this.getUnderlayingUnits(unitId);
        ArrayList<UnitData> arryList = new ArrayList<UnitData>(unitDatas.length);
        for (int i = 0; i < unitDatas.length; ++i) {
            arryList.add(unitDatas[i]);
        }
        TreeSet<UnitData> sortedUnitDataSet = new TreeSet<UnitData>(new UnitPositionComparator());
        sortedUnitDataSet.addAll(arryList);
        Object[] arr = sortedUnitDataSet.toArray();
        long[] unitIds = new long[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            unitIds[i] = ((UnitData)arr[i]).getUnitid();
        }
        return unitIds;
    }

    public long[] getBasicUnitIds(long unitId) {
        return this.getBasicUnitIds(unitId, false);
    }

    public long[] getBasicUnitIdsSorted(long unitId) {
        return this.getBasicUnitIds(unitId, true);
    }

    protected long[] getBasicUnitIds(long unitId, boolean sorted) {
        ArrayList<Long> unitIds = new ArrayList<Long>();
        ArrayList<Long> groupUnitIds = new ArrayList<Long>();
        ArrayList<Long> groupUnitIdsHelper = new ArrayList<Long>();
        boolean stillBasicsFlag = true;
        groupUnitIdsHelper.add(new Long(unitId));
        while (stillBasicsFlag) {
            Iterator itHelper = groupUnitIdsHelper.iterator();
            while (itHelper.hasNext()) {
                long con_unitId = (Long)itHelper.next();
                long[] resultUnitIds = null;
                resultUnitIds = sorted ? this.getUnderlayingUnitIdsSorted(con_unitId) : this.getUnderlayingUnitIds(con_unitId);
                int index = 0;
                while (index < resultUnitIds.length) {
                    try {
                        UnitModelLocal unitMod = this.unitModelHome.findByPrimaryKey(new UnitModelPK(resultUnitIds[index++]));
                        UnitModelValue unitModData = unitMod.getUnitModelValue();
                        if (unitModData.getBasic()) {
                            unitIds.add(new Long(unitModData.getUnitId()));
                            continue;
                        }
                        groupUnitIds.add(new Long(unitModData.getUnitId()));
                    }
                    catch (Exception e) {
                        log.error((Object)"getBasicUnitIds() runs into", (Throwable)e);
                    }
                }
            }
            if (groupUnitIds.size() == 0) {
                try {
                    UnitModelLocal unitMod = this.unitModelHome.findByPrimaryKey(new UnitModelPK(unitId));
                    UnitModelValue unitModData = unitMod.getUnitModelValue();
                    if (unitModData.getBasic()) {
                        unitIds.add(new Long(unitModData.getUnitId()));
                    }
                }
                catch (Exception e) {
                    log.error((Object)"getBasicUnitIds() 'check itself' runs into", (Throwable)e);
                }
                stillBasicsFlag = false;
                continue;
            }
            groupUnitIdsHelper.clear();
            groupUnitIdsHelper.addAll(groupUnitIds);
            groupUnitIds.clear();
        }
        long[] basicUnits = new long[unitIds.size()];
        Iterator it = unitIds.iterator();
        int index = 0;
        while (it.hasNext() && index < basicUnits.length) {
            basicUnits[index++] = (Long)it.next();
        }
        return basicUnits;
    }

    public long getParentUnitId(long unitId) {
        try {
            Collection rels = this.unitBasicGroupRelHome.findByBasicId(unitId);
            Iterator it = rels.iterator();
            if (it.hasNext()) {
                return ((UnitBasicGroupRelLocal)it.next()).getIdGroup();
            }
        }
        catch (Exception ex) {
            log.error((Object)"getParentUnitID runs into", (Throwable)ex);
        }
        return 0L;
    }

    public long[] getStateModels(long unitId) throws UnitNotFoundException {
        Collection stateModelStubs = new ArrayList();
        try {
            stateModelStubs = this.unitStateModel.findByUnitId(unitId);
        }
        catch (FinderException ex) {
            log.debug((Object)"getStateModels() (No Problem) runs during find StateModels into", (Throwable)ex);
        }
        ArrayList<Long> stateModels = new ArrayList<Long>(stateModelStubs.size());
        for (UnitStateModelLocal stateModel : stateModelStubs) {
            try {
                stateModels.add(new Long(stateModel.getStateModelId()));
            }
            catch (Exception ex) {
                log.error((Object)"getStateModels() runs during access an Remote Interface into", (Throwable)ex);
            }
        }
        int index = 0;
        long[] stateModelIds = new long[stateModels.size()];
        Iterator it = stateModels.iterator();
        while (it.hasNext()) {
            stateModelIds[index] = (Long)it.next();
            ++index;
        }
        return stateModelIds;
    }

    public Collection getAllUnitgroupSorted() {
        Collection tree = this.getUnitgroupTree();
        ArrayList<UnitData> units = new ArrayList<UnitData>();
        for (UnitData unit : tree) {
            units.add(unit);
            if (!unit.isUnderlayingUnitsValid()) continue;
            units.addAll(unit.getUnderlayingUnits());
        }
        return units;
    }

    public Collection getUnitgroupTree() {
        Collection units = this.getSortedRootUnits(false);
        for (UnitData rootUnit : units) {
            rootUnit.setUnderlayingUnits(this.getUnderlayingUnitsSorted(rootUnit.getUnitid(), false));
        }
        return units;
    }

    protected Collection getSortedRootUnits(boolean includeBasicUnits) {
        UnitData[] rootUnitArr = this.getRootUnits(includeBasicUnits);
        ArrayList<UnitData> rootUnits = new ArrayList<UnitData>(rootUnitArr.length);
        for (int i = 0; i < rootUnitArr.length; ++i) {
            rootUnits.add(rootUnitArr[i]);
        }
        TreeSet<UnitData> sortedUnitDataSet = new TreeSet<UnitData>(new UnitPositionComparator());
        sortedUnitDataSet.addAll(rootUnits);
        return sortedUnitDataSet;
    }

    public Collection getUnderlayingUnitsSorted(long unitId, boolean withBasics) {
        Collection underlayings = this.getUnderlayingUnitsSorted(unitId);
        if (!withBasics) {
            Iterator it = underlayings.iterator();
            while (it.hasNext()) {
                UnitData unit = (UnitData)it.next();
                if (!unit.getUnitisbasic().booleanValue()) continue;
                it.remove();
            }
        }
        return underlayings;
    }

    public void setOperativeTimeOffset(long unitId, long operativeTimeOffset) {
        try {
            UnitModelLocal unitMod = this.unitModelHome.findByPrimaryKey(new UnitModelPK(unitId));
            unitMod.setOperativeTimeOffset(operativeTimeOffset);
        }
        catch (Exception ex) {
            log.error((Object)"setOperativeTimeOffset() runs into", (Throwable)ex);
            throw new EJBException("runs during setOperativeTimeOffset() " + ex.getMessage());
        }
    }

    public void resetUnit(long unitId) {
        try {
            Collection entries = null;
            CurrentStateCacheLocalHome stateCacheHome = CurrentStateCacheUtil.getLocalHome();
            entries = stateCacheHome.findByUnitId(unitId);
            this.deleteAll(entries);
            StateHistoryLocalHome stateHistoryHome = StateHistoryUtil.getLocalHome();
            entries = stateHistoryHome.findByUnitId(unitId);
            this.deleteAll(entries);
            CurrentGdataCacheLocalHome currentGdataCacheHome = CurrentGdataCacheUtil.getLocalHome();
            Collection entriesCurrentGdataCache = currentGdataCacheHome.findByUnitId(unitId);
            this.deleteAll(entriesCurrentGdataCache);
            GdataHistoryLocalHome gdataHistoryHome = GdataHistoryUtil.getLocalHome();
            entries = gdataHistoryHome.findByUnitId(unitId);
            this.deleteAll(entries);
            KeepAliveHistoryLocalHome keepAliveHistoryHome = KeepAliveHistoryUtil.getLocalHome();
            Collection entriesKeepAliveHistory = keepAliveHistoryHome.findByUnitId(unitId);
            this.deleteAll(entriesKeepAliveHistory);
            KeepAliveCacheLocalHome keepAliveCacheHome = KeepAliveCacheUtil.getLocalHome();
            entries = keepAliveCacheHome.findByUnitId(unitId);
            this.deleteAll(entries);
            CurrentNotifyCacheLocalHome currentNotifyCacheHome = CurrentNotifyCacheUtil.getLocalHome();
            entries = currentNotifyCacheHome.findByUnitId(unitId);
            this.deleteAll(entries);
            NotifyHistoryLocalHome notifyHistoryHome = NotifyHistoryUtil.getLocalHome();
            entries = notifyHistoryHome.findByUnitId(unitId);
            this.deleteAll(entries);
            ScanmanMsgFacadeUtil.getLocalHome().create().resetUnit(unitId);
            UseHistoryLocalHome useHistoryHome = UseHistoryUtil.getLocalHome();
            entries = useHistoryHome.findByUnitId(unitId);
            this.deleteAll(entries);
            UseErrorHistoryLocalHome useErrorHistoryHome = UseErrorHistoryUtil.getLocalHome();
            entries = useErrorHistoryHome.findByUnitId(unitId);
            this.deleteAll(entries);
            UseCacheLocalHome useCacheHome = UseCacheUtil.getLocalHome();
            entries = useCacheHome.findByUnitId(unitId);
            this.deleteAll(entries);
            this.initStateModel.initializeAllStateModels(unitId);
        }
        catch (Exception ex) {
            log.error((Object)"resetUnit() runs into", (Throwable)ex);
            throw new EJBException(ex);
        }
    }

    protected void deleteAll(Collection instances) throws RemoveException {
        for (EJBLocalObject localObject : instances) {
            localObject.remove();
        }
    }
}

