/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.status;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationLocal;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationParameterNotFoundException;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationUtil;
import java.util.Date;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class StatusBean
extends BaseSessionBean
implements SessionBean {
    private static final Log log = LogFactory.getLog(StatusBean.class);
    private ConfigurationLocal configuration;
    private static final String TEST_KEY = "status.testkey";
    private static final String TX1_TEST_KEY = "status.testkey.tx1";
    private static final String TX2_TEST_KEY = "status.testkey.tx2";

    public void ejbCreate() throws CreateException {
        try {
            this.configuration = ConfigurationUtil.getLocalHome().create();
        }
        catch (NamingException ex) {
            log.error((Object)"Can not find ConfigurationParameter Entity Bean", (Throwable)ex);
            throw new EJBException("Can not find ConfigurationParameter Entity Bean: " + ex.getMessage());
        }
    }

    public void ping() {
    }

    public void ejbReadTest() {
        try {
            this.configuration.getParameter(TEST_KEY);
        }
        catch (ConfigurationParameterNotFoundException ex) {
            this.configuration.setParameter(TEST_KEY, new Date().toString());
        }
    }

    public void ejbWriteTest() {
        this.configuration.setParameter(TEST_KEY, new Date().toString());
    }

    public void ejbTransactionTest(boolean rollback) {
        String str = new Date().toString();
        if (log.isDebugEnabled()) {
            log.debug((Object)("ejbTransactionTest() " + str));
        }
        this.configuration.setParameter(TX1_TEST_KEY, str);
        this.configuration.setParameter(TX2_TEST_KEY, str);
        if (rollback) {
            throw new EJBException("TestTXrollback");
        }
    }
}

