/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.infoman;

import de.proveo.eventbase.EventPayload;
import de.proveo.util.ByteUtil;
import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.util.properties.PropertiesUtil;
import de.proveo.wwt.logic.ejb.dataIn.scanmanmsg.ScanmanMsgHistoryValue;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationClient;
import de.proveo.wwt.logic.ejb.general.infoman.setup.CurrentInfomanSetupLocal;
import de.proveo.wwt.logic.ejb.general.infoman.setup.CurrentInfomanSetupLocalHome;
import de.proveo.wwt.logic.ejb.general.infoman.setup.CurrentInfomanSetupPK;
import de.proveo.wwt.logic.ejb.general.infoman.setup.CurrentInfomanSetupUtil;
import de.proveo.wwt.logic.ejb.general.infoman.setup.CurrentInfomanSetupValue;
import de.proveo.wwt.logic.ejb.general.infoman.setup.InfomanSetupHistoryLocal;
import de.proveo.wwt.logic.ejb.general.infoman.setup.InfomanSetupHistoryLocalHome;
import de.proveo.wwt.logic.ejb.general.infoman.setup.InfomanSetupHistoryUtil;
import de.proveo.wwt.logic.ejb.general.infoman.setup.InfomanSetupHistoryValue;
import de.proveo.wwt.logic.ejb.general.infoman.setup.update.ScheduledInfomanUpdateLocal;
import de.proveo.wwt.logic.ejb.general.infoman.setup.update.ScheduledInfomanUpdateLocalHome;
import de.proveo.wwt.logic.ejb.general.infoman.setup.update.ScheduledInfomanUpdatePK;
import de.proveo.wwt.logic.ejb.general.infoman.setup.update.ScheduledInfomanUpdateUtil;
import de.proveo.wwt.logic.ejb.general.infoman.software.InfomanSoftwareDescriptionValue;
import de.proveo.wwt.logic.ejb.general.infoman.software.InfomanSoftwareLocal;
import de.proveo.wwt.logic.ejb.general.infoman.software.InfomanSoftwareLocalHome;
import de.proveo.wwt.logic.ejb.general.infoman.software.InfomanSoftwarePK;
import de.proveo.wwt.logic.ejb.general.infoman.software.InfomanSoftwareUtil;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelLocal;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InfomanSetupFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final Log log = LogFactory.getLog(InfomanSetupFacadeBean.class);
    private CurrentInfomanSetupLocalHome currentInfomanSetupHome;
    private InfomanSetupHistoryLocalHome infomanSetupHistoryHome;
    private ScheduledInfomanUpdateLocalHome scheduledInfomanUpdateHome;
    private InfomanSoftwareLocalHome infomanSoftwareHome;
    protected static final String SERIAL_NUMBER_KEY = "sn";
    protected static final String SOFTWARE_VERSION_KEY = "sw";
    protected static final String SOFTWARE_BUILD_DATE_KEY = "swBuild";
    protected static final String SOFTWARE_REVISION_KEY = "svn";
    protected static final String HARDWARE_PLATFORM_KEY = "arch";
    protected static final String CONFIGURATION_HASHCODE_KEY = "config";
    protected static final String KERNEL_KEY = "k";
    protected static final String HARDWARE_SN_KEY = "hwSN";
    protected static final String POWERMANAGEMENT_VERSION_KEY = "pm";
    protected static final String ROOTFS_VERSION_KEY = "rootfs";
    protected static final String JAVA_VERSION_KEY = "java";
    protected static final String CHECKSUM_TYPE_KEY = "checksumType";
    protected static final String CHECKSUM_KEY = "checksum";
    protected static final String CONFIGURATION_KEY = "configurationName";
    protected static final String CONFIGURATION_CONTENT_TYPE = "configurationContentType";
    private static final long DEFAULT_INFOMAN_REQUEST_TIMEOUT = 600000L;
    private long infomanRequestTimeout = 600000L;

    @Override
    public void ejbCreate() throws CreateException {
        try {
            this.currentInfomanSetupHome = CurrentInfomanSetupUtil.getLocalHome();
            this.infomanSetupHistoryHome = InfomanSetupHistoryUtil.getLocalHome();
            this.scheduledInfomanUpdateHome = ScheduledInfomanUpdateUtil.getLocalHome();
            this.infomanSoftwareHome = InfomanSoftwareUtil.getLocalHome();
        }
        catch (NamingException ex) {
            throw new EJBException("runs during lookup other ejbs into", (Exception)ex);
        }
        this.configure();
    }

    protected void configure() {
        try {
            this.infomanRequestTimeout = Long.parseLong(new ConfigurationClient().getParameter("infoman.update.timeout", Long.toString(600000L)));
        }
        catch (Exception ex) {
            log.error((Object)"runs during configure infoman.update.timeout into", (Throwable)ex);
            this.infomanRequestTimeout = 600000L;
        }
    }

    public String getOldStyleBootMessage(String msg) {
        Map<String, String> infos = this.extractInfosFromBootMessage(msg);
        StringBuffer oldMsg = new StringBuffer();
        oldMsg.append(infos.get(SERIAL_NUMBER_KEY));
        oldMsg.append(";");
        oldMsg.append(infos.get(SOFTWARE_VERSION_KEY));
        oldMsg.append(" - ");
        oldMsg.append(infos.get(SOFTWARE_BUILD_DATE_KEY));
        oldMsg.append(" - ");
        oldMsg.append(infos.get(SOFTWARE_REVISION_KEY));
        oldMsg.append(";");
        oldMsg.append(infos.get(HARDWARE_PLATFORM_KEY));
        oldMsg.append(";");
        return oldMsg.toString();
    }

    protected boolean isFieldUpdateNecessary(String field, String infomanField) {
        if (field == null) {
            return infomanField != null;
        }
        return !field.equals(infomanField);
    }

    public boolean updateCache(CurrentInfomanSetupLocal currentInfomanSetup, ScanmanMsgHistoryValue event) {
        currentInfomanSetup.setSyncTime(event.getCreateTime());
        Map<String, String> infos = this.extractInfosFromBootMessage(event.getMsgToString());
        CurrentInfomanSetupValue value = currentInfomanSetup.getCurrentInfomanSetupValue();
        boolean changed = false;
        if (this.isFieldUpdateNecessary(value.getKernelVersion(), infos.get(KERNEL_KEY))) {
            value.setKernelVersion(infos.get(KERNEL_KEY));
            changed = true;
        }
        if (this.isFieldUpdateNecessary(value.getPowerManagementVersion(), infos.get(POWERMANAGEMENT_VERSION_KEY))) {
            value.setPowerManagementVersion(infos.get(POWERMANAGEMENT_VERSION_KEY));
            changed = true;
        }
        if (this.isFieldUpdateNecessary(value.getSoftwareVersion(), infos.get(SOFTWARE_VERSION_KEY))) {
            value.setSoftwareVersion(infos.get(SOFTWARE_VERSION_KEY));
            changed = true;
        }
        if (this.isFieldUpdateNecessary(value.getRootfsVersion(), infos.get(ROOTFS_VERSION_KEY))) {
            value.setRootfsVersion(infos.get(ROOTFS_VERSION_KEY));
            changed = true;
        }
        if (this.isFieldUpdateNecessary(value.getJavaVMVersion(), infos.get(JAVA_VERSION_KEY))) {
            value.setJavaVMVersion(infos.get(JAVA_VERSION_KEY));
            changed = true;
        }
        if (this.isFieldUpdateNecessary(value.getInfomanSN(), infos.get(SERIAL_NUMBER_KEY))) {
            value.setInfomanSN(infos.get(SERIAL_NUMBER_KEY));
            changed = true;
        }
        if (this.isFieldUpdateNecessary(value.getHardware(), infos.get(HARDWARE_PLATFORM_KEY))) {
            value.setHardware(infos.get(HARDWARE_PLATFORM_KEY));
            changed = true;
        }
        if (this.isFieldUpdateNecessary(value.getHardwareSN(), infos.get(HARDWARE_SN_KEY))) {
            value.setHardwareSN(infos.get(HARDWARE_SN_KEY));
            changed = true;
        }
        String oldConfigurationChecksum = currentInfomanSetup.getConfigurationChecksum();
        String newConfigurationChecksum = infos.get(CONFIGURATION_HASHCODE_KEY);
        if (newConfigurationChecksum == null) {
            log.error((Object)"updateCache() missing configuration checksum format");
        } else {
            int index = newConfigurationChecksum.indexOf(":");
            if (index < 0) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("updateCache() wrong checksum format. " + event.toString()));
                }
            } else {
                String newConfigurationChecksumType = newConfigurationChecksum.substring(0, index);
                newConfigurationChecksum = newConfigurationChecksum.substring(index + 1);
                if (value.getConfigurationUpToDate() && (this.isFieldUpdateNecessary(newConfigurationChecksum, oldConfigurationChecksum) || this.isFieldUpdateNecessary(currentInfomanSetup.getConfigurationChecksumType(), newConfigurationChecksumType))) {
                    value.setConfigurationUpToDate(false);
                    changed = true;
                }
            }
        }
        if (changed) {
            currentInfomanSetup.setCurrentInfomanSetupValue(value);
        }
        return changed;
    }

    public void writeHistory(CurrentInfomanSetupLocal currentInfomanSetup) {
        CurrentInfomanSetupValue value = currentInfomanSetup.getCurrentInfomanSetupValue();
        InfomanSetupHistoryValue historyValue = new InfomanSetupHistoryValue();
        historyValue.setUnitId(value.getUnitId());
        historyValue.setCreateTime(value.getSyncTime());
        historyValue.setConfigurationChecksumType(value.getConfigurationChecksumType());
        historyValue.setConfigurationChecksum(value.getConfigurationChecksum());
        historyValue.setConfigurationName(value.getConfigurationName());
        historyValue.setConfiguration(value.getConfiguration());
        historyValue.setConfigurationContentType(value.getConfigurationContentType());
        historyValue.setSoftwareVersion(value.getSoftwareVersion());
        historyValue.setKernelVersion(value.getKernelVersion());
        historyValue.setPowerManagementVersion(value.getPowerManagementVersion());
        historyValue.setRootfsVersion(value.getRootfsVersion());
        historyValue.setJavaVMVersion(value.getJavaVMVersion());
        historyValue.setInfomanSN(value.getInfomanSN());
        historyValue.setHardware(value.getHardware());
        historyValue.setHardwareSN(value.getHardwareSN());
        try {
            InfomanSetupHistoryLocal history;
            try {
                history = this.infomanSetupHistoryHome.create(historyValue);
            }
            catch (DuplicateKeyException ex) {
                this.infomanSetupHistoryHome.reorganizeSequence();
                history = this.infomanSetupHistoryHome.create(historyValue);
            }
            currentInfomanSetup.setHistoryPK(history.getId());
        }
        catch (CreateException ex) {
            throw new EJBException((Exception)((Object)ex));
        }
    }

    public void infomanBoot(ScanmanMsgHistoryValue event) {
        CurrentInfomanSetupLocal currentInfomanSetup;
        if (event.getType() != 25) {
            log.warn((Object)"we extract our information only out of boot events");
            return;
        }
        if (!event.getMsgToString().contains("=")) {
            log.warn((Object)"incompatible infoman boot message");
            return;
        }
        try {
            currentInfomanSetup = this.currentInfomanSetupHome.findByPrimaryKey(new CurrentInfomanSetupPK(event.getUnitId()));
        }
        catch (ObjectNotFoundException ex) {
            try {
                currentInfomanSetup = this.currentInfomanSetupHome.create(event.getUnitId());
            }
            catch (CreateException ex2) {
                throw new EJBException("runs during create current infoman setup into", (Exception)((Object)ex2));
            }
        }
        catch (FinderException ex) {
            throw new EJBException("runs during find current infoman setup into", (Exception)((Object)ex));
        }
        boolean changed = this.updateCache(currentInfomanSetup, event);
        if (changed) {
            this.writeHistory(currentInfomanSetup);
        }
    }

    public void updateConfiguration(ScanmanMsgHistoryValue event) {
        CurrentInfomanSetupLocal infomanSetup;
        if (event.isBinaryPayloadEmpty()) {
            throw new EJBException("binary payload is empty");
        }
        try {
            infomanSetup = this.currentInfomanSetupHome.findByPrimaryKey(new CurrentInfomanSetupPK(event.getUnitId()));
        }
        catch (ObjectNotFoundException ex) {
            try {
                infomanSetup = this.currentInfomanSetupHome.create(event.getUnitId());
            }
            catch (CreateException ex2) {
                throw new EJBException("runs during create current infoman setup into", (Exception)((Object)ex2));
            }
        }
        catch (FinderException ex) {
            throw new EJBException("runs during find current infoman setup into", (Exception)((Object)ex));
        }
        Map<String, String> messagesInfos = this.extractInfosConfigurationMessage(event.getMsgToString());
        try {
            MessageDigest md = MessageDigest.getInstance(messagesInfos.get(CHECKSUM_TYPE_KEY));
            String calculatedChecksum = ByteUtil.toHexString(md.digest(event.getBinaryPayload()));
            if (!calculatedChecksum.equals(messagesInfos.get(CHECKSUM_KEY))) {
                throw new EJBException("checksum of received event is invalid");
            }
        }
        catch (NoSuchAlgorithmException ex) {
            throw new EJBException("unkown checksum algorithm in event", (Exception)ex);
        }
        infomanSetup.setConfigurationChecksumType(messagesInfos.get(CHECKSUM_TYPE_KEY));
        infomanSetup.setConfigurationChecksum(messagesInfos.get(CHECKSUM_KEY));
        infomanSetup.setConfiguration(event.getBinaryPayload());
        infomanSetup.setConfigurationName(messagesInfos.get(CONFIGURATION_KEY));
        infomanSetup.setConfigurationContentType(messagesInfos.get(CONFIGURATION_CONTENT_TYPE));
        infomanSetup.setConfigurationUpToDate(true);
    }

    public Map<String, String> extractInfosConfigurationMessage(String msg) {
        HashMap<String, String> infos = new HashMap<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(msg, ";");
        int index = 0;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (index == 0) {
                int separatorIndex = token.indexOf(":");
                if (separatorIndex > -1) {
                    String type = token.substring(0, separatorIndex);
                    String value = token.substring(separatorIndex + 1);
                    infos.put(CHECKSUM_TYPE_KEY, type);
                    infos.put(CHECKSUM_KEY, value);
                } else if (log.isErrorEnabled()) {
                    log.error((Object)("unexpected configuration message format: " + msg));
                }
            } else if (index == 1) {
                infos.put(CONFIGURATION_KEY, token);
            } else if (index == 2) {
                infos.put(CONFIGURATION_CONTENT_TYPE, token);
            }
            ++index;
        }
        return infos;
    }

    public Map<String, String> extractInfosFromBootMessage(String msg) {
        HashMap<String, String> infos = new HashMap<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(msg, ";");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int index = token.indexOf("=");
            String key = token.substring(0, index);
            String value = token.substring(index + 1);
            infos.put(key, value);
        }
        return infos;
    }

    /*
     * Unable to fully structure code
     */
    public void updateReport(long eventTime, String updateReport) {
        errorMessage = null;
        if (updateReport.startsWith("error")) {
            succesful = false;
            tokenizer = new StringTokenizer(updateReport, ";");
            tokenizer.nextToken();
            try {
                updateId = Long.parseLong(tokenizer.nextToken());
                if (!tokenizer.hasMoreTokens()) ** GOTO lbl23
                errorMessage = tokenizer.nextToken();
            }
            catch (Exception ex) {
                InfomanSetupFacadeBean.log.error((Object)"runs during parse update report into", (Throwable)ex);
                throw new EJBException(ex);
            }
        } else {
            index = updateReport.indexOf(";");
            try {
                updateId = index < 0 ? Long.parseLong(updateReport) : Long.parseLong(updateReport.substring(0, index));
                succesful = true;
            }
            catch (NumberFormatException ex) {
                InfomanSetupFacadeBean.log.error((Object)"runs during parse update report into", (Throwable)ex);
                throw new EJBException((Exception)ex);
            }
        }
lbl23:
        // 3 sources

        try {
            infomanUpdate = this.scheduledInfomanUpdateHome.findByPrimaryKey(new ScheduledInfomanUpdatePK(updateId));
        }
        catch (ObjectNotFoundException ex) {
            InfomanSetupFacadeBean.log.error((Object)("reported update not found. " + updateReport));
            return;
        }
        catch (FinderException ex) {
            InfomanSetupFacadeBean.log.error((Object)"runs find update into", (Throwable)ex);
            throw new EJBException((Exception)ex);
        }
        infomanUpdate.setDone(true);
        infomanUpdate.setSuccessful(succesful);
        if (!succesful) {
            infomanUpdate.setError(errorMessage);
        }
        infomanUpdate.setFinishedTime(eventTime);
    }

    public EventPayload getUpdatePayload(long unitId) {
        Collection updates;
        try {
            updates = this.scheduledInfomanUpdateHome.findActiveUpdates(unitId, System.currentTimeMillis());
        }
        catch (FinderException ex) {
            log.error((Object)"runs during get active scheduled update into", (Throwable)ex);
            throw new EJBException("cannot find planned updates", (Exception)((Object)ex));
        }
        if (updates.size() == 0) {
            return null;
        }
        return this.buildUpdatePayload((ScheduledInfomanUpdateLocal)updates.iterator().next());
    }

    public EventPayload getRequestConfigurationPayload(UnitModelLocal unitModel) {
        if (unitModel != null && unitModel.getCurrentInfomanSetup() != null && !unitModel.getCurrentInfomanSetup().getConfigurationUpToDate()) {
            CurrentInfomanSetupLocal infomanSetup = unitModel.getCurrentInfomanSetup();
            long delta = System.currentTimeMillis() - infomanSetup.getRequestConfigTime();
            if (delta < this.infomanRequestTimeout) {
                log.trace((Object)"getRequestConfigurationPayload() still active request");
                return null;
            }
            EventPayload payload = new EventPayload();
            payload.setName("InfomanSetup");
            Properties properties = new Properties();
            properties.setProperty("action", "send configuration");
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                PropertiesUtil.storeWithoutComments(properties, out);
                payload.setPayload(out.toByteArray());
                infomanSetup.setRequestConfigTime(System.currentTimeMillis());
            }
            catch (IOException ex) {
                log.error((Object)"cannot write infomanSet payload", (Throwable)ex);
                return null;
            }
            return payload;
        }
        if (unitModel != null && unitModel.getCurrentInfomanSetup() == null) {
            log.trace((Object)"getRequestConfigurationPayload() no setup record found");
        } else if (unitModel != null && unitModel.getCurrentInfomanSetup() != null && unitModel.getCurrentInfomanSetup().getConfigurationUpToDate()) {
            log.trace((Object)"getRequestConfigurationPayload() setup is up to date");
        } else {
            log.trace((Object)"getRequestConfigurationPayload() other reason");
        }
        return null;
    }

    public EventPayload buildUpdatePayload(ScheduledInfomanUpdateLocal update) {
        long delta = System.currentTimeMillis() - update.getStartTime();
        if (delta < this.infomanRequestTimeout) {
            return null;
        }
        Properties properties = new Properties();
        properties.setProperty("action", "update");
        properties.setProperty("id", Long.toString(update.getId()));
        if (update.getConfigurationName() != null && !update.getConfigurationName().equals("")) {
            properties.setProperty("configurationChecksumType", update.getConfigurationChecksumType());
            properties.setProperty("configurationChecksum", update.getConfigurationChecksum());
            properties.setProperty(CONFIGURATION_KEY, update.getConfigurationName());
            properties.setProperty(CONFIGURATION_CONTENT_TYPE, update.getConfigurationContentType());
        }
        if (update.getInfomanSoftware() != null) {
            properties.setProperty("softwareChecksumType", update.getInfomanSoftware().getChecksumType());
            properties.setProperty("softwareChecksum", update.getInfomanSoftware().getChecksum());
            properties.setProperty("softwareName", update.getInfomanSoftware().getVersionName());
            properties.setProperty("softwareContentType", update.getInfomanSoftware().getContentType());
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            PropertiesUtil.storeWithoutComments(properties, out);
        }
        catch (IOException ex) {
            log.error((Object)"runs during build update properties into", (Throwable)ex);
            return null;
        }
        EventPayload payload = new EventPayload();
        payload.setName("InfomanSetup");
        payload.setPayload(out.toByteArray());
        update.setStartTime(System.currentTimeMillis());
        return payload;
    }

    public byte[] getUpdateResource(Properties event) {
        ScheduledInfomanUpdateLocal scheduledUpdate;
        try {
            scheduledUpdate = this.scheduledInfomanUpdateHome.findByPrimaryKey(new ScheduledInfomanUpdatePK(Long.parseLong(event.getProperty("id"))));
        }
        catch (ObjectNotFoundException ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)("requested update not found: " + event), (Throwable)ex);
            }
            return null;
        }
        catch (FinderException ex) {
            throw new EJBException("runs during find update into", (Exception)((Object)ex));
        }
        if (scheduledUpdate.getDone()) {
            if (log.isErrorEnabled()) {
                log.error((Object)("requested update is canceled: " + event));
            }
            return null;
        }
        byte[] resource = null;
        String resourceType = event.getProperty("type", "none");
        if (resourceType.equals(CONFIGURATION_HASHCODE_KEY)) {
            resource = scheduledUpdate.getConfiguration();
        } else if (resourceType.equals("software") && scheduledUpdate.getInfomanSoftware() != null) {
            resource = scheduledUpdate.getInfomanSoftware().getSoftware();
        } else if (log.isErrorEnabled()) {
            log.error((Object)("unkown update resource type: " + event));
        }
        return resource;
    }

    public CurrentInfomanSetupValue getCurrentInfomanSetup(long unitId) throws ObjectNotFoundException {
        try {
            CurrentInfomanSetupLocal infomanSetup = this.currentInfomanSetupHome.findByPrimaryKey(new CurrentInfomanSetupPK(unitId));
            return infomanSetup.getCurrentInfomanSetupValue();
        }
        catch (ObjectNotFoundException ex) {
            throw ex;
        }
        catch (FinderException ex) {
            throw new EJBException((Exception)((Object)ex));
        }
    }

    public void resetUpToDateFlag(long id) {
        try {
            CurrentInfomanSetupLocal currentInfomanSetupLocal = this.currentInfomanSetupHome.findByPrimaryKey(new CurrentInfomanSetupPK(id));
            currentInfomanSetupLocal.setConfigurationUpToDate(false);
        }
        catch (FinderException e) {
            log.error((Object)"runs during resetUpToDateFlag() into", (Throwable)e);
        }
    }

    public List<InfomanSoftwareDescriptionValue> getAvailableInfomanSoftware() {
        ArrayList<InfomanSoftwareDescriptionValue> softwareDescriptions = new ArrayList<InfomanSoftwareDescriptionValue>();
        try {
            for (InfomanSoftwareLocal local : this.infomanSoftwareHome.findAll()) {
                softwareDescriptions.add(local.getInfomanSoftwareDescriptionValue());
            }
        }
        catch (FinderException ex) {
            throw new EJBException((Exception)((Object)ex));
        }
        return softwareDescriptions;
    }

    public void deleteInfomanSoftware(long softwareId) throws ObjectNotFoundException, RemoveException {
        try {
            InfomanSoftwareLocal infomanSoftware = this.infomanSoftwareHome.findByPrimaryKey(new InfomanSoftwarePK(softwareId));
            if (!infomanSoftware.getScheduledInfomanUpdates().isEmpty()) {
                throw new RemoveException("still updates there");
            }
            infomanSoftware.remove();
        }
        catch (ObjectNotFoundException ex) {
            throw ex;
        }
        catch (FinderException ex) {
            log.error((Object)"getSoftwareArchive() runs into", (Throwable)ex);
            throw new EJBException((Exception)((Object)ex));
        }
    }

    public List<InfomanSetupHistoryValue> getConfigurationHistory(long unitId, long since, long until) throws FinderException {
        ArrayList<InfomanSetupHistoryValue> versions = new ArrayList<InfomanSetupHistoryValue>();
        for (InfomanSetupHistoryLocal history : this.infomanSetupHistoryHome.findByUnit(unitId, since, until)) {
            versions.add(history.getInfomanSetupHistoryValue());
        }
        return versions;
    }
}

