/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.config;

import de.proveo.wwt.logic.ejb.general.config.Configuration;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationHome;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationParameterNotFoundException;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationUtil;
import java.rmi.RemoteException;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigurationClient {
    private static final Log log = LogFactory.getLog(ConfigurationClient.class);
    private static Configuration configuration;
    private static final Object configSyncLock;

    public String getParameter(String key) throws ConfigurationParameterNotFoundException, RemoteException {
        this.init();
        return configuration.getParameter(key);
    }

    public String getParameter(String key, String defaultValue) throws RemoteException {
        this.init();
        return configuration.getParameter(key, defaultValue);
    }

    public boolean getBoolean(String key) throws ConfigurationParameterNotFoundException, RemoteException {
        this.init();
        return configuration.getBoolean(key);
    }

    public int getInteger(String key) throws ConfigurationParameterNotFoundException, RemoteException {
        this.init();
        return configuration.getInteger(key);
    }

    public long[] getLongArray(String key) throws ConfigurationParameterNotFoundException, RemoteException {
        this.init();
        return configuration.getLongArray(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() throws RemoteException {
        if (configuration == null) {
            Object object = configSyncLock;
            synchronized (object) {
                try {
                    configuration = ConfigurationUtil.getHome().create();
                }
                catch (Exception ex) {
                    log.trace((Object)"no Configuration EJB Refernce found. Use physical lookup");
                }
                if (configuration == null) {
                    try {
                        InitialContext ctx = new InitialContext();
                        Object ref = ctx.lookup("Configuration");
                        ConfigurationHome home = (ConfigurationHome)PortableRemoteObject.narrow((Object)ref, ConfigurationHome.class);
                        configuration = home.create();
                    }
                    catch (Exception ex) {
                        throw new RemoteException(ex.getMessage());
                    }
                }
            }
        }
    }

    public boolean isConfigured(String key) throws RemoteException {
        this.init();
        return configuration.isConfigured(key);
    }

    public String[] getParameterArray(String key) throws ConfigurationParameterNotFoundException, RemoteException {
        this.init();
        return configuration.getParameterArray(key);
    }

    static {
        configSyncLock = new Object();
    }
}

