/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.config;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationParameterNotFoundException;
import de.proveo.wwt.logic.ejb.general.config.persistence.ConfigurationParameterLocal;
import de.proveo.wwt.logic.ejb.general.config.persistence.ConfigurationParameterLocalHome;
import de.proveo.wwt.logic.ejb.general.config.persistence.ConfigurationParameterPK;
import de.proveo.wwt.logic.ejb.general.config.persistence.ConfigurationParameterUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ConfigurationBean
extends BaseSessionBean
implements SessionBean {
    private static final Log log = LogFactory.getLog(ConfigurationBean.class);
    private ConfigurationParameterLocalHome configurationParameterHome;
    protected static final String DEFAULT_PROPERTIES = "/config/default-application.properties";
    private Properties defaultProperties;

    public void ejbCreate() throws CreateException {
        try {
            this.configurationParameterHome = ConfigurationParameterUtil.getLocalHome();
        }
        catch (NamingException ex) {
            log.error((Object)"Can not find ConfigurationParameter Entity Bean", (Throwable)ex);
            throw new EJBException("Can not find ConfigurationParameter Entity Bean: " + ex.getMessage());
        }
        this.defaultProperties = new Properties();
        try {
            InputStream in = this.getClass().getResourceAsStream(DEFAULT_PROPERTIES);
            if (in != null) {
                this.defaultProperties.load(in);
            } else {
                log.warn((Object)"no default properties found");
            }
        }
        catch (IOException ex) {
            throw new EJBException("runs during load default values into", (Exception)ex);
        }
    }

    public String getParameter(String key) throws ConfigurationParameterNotFoundException {
        String value;
        ConfigurationParameterPK pk = new ConfigurationParameterPK(key);
        try {
            ConfigurationParameterLocal configParam = this.configurationParameterHome.findByPrimaryKey(pk);
            value = configParam.getValue();
        }
        catch (FinderException ex) {
            value = this.defaultProperties.getProperty(key);
            if (value != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("getParameter(): key '" + key + "' not found, use default value '" + value + "'."));
                }
            }
            if (log.isErrorEnabled()) {
                log.error((Object)("getParameter(): key '" + key + "' not found and no default value defined!"));
            }
            throw new ConfigurationParameterNotFoundException(key);
        }
        return value;
    }

    public String getParameter(String key, String defaultValue) {
        ConfigurationParameterPK pk = new ConfigurationParameterPK(key);
        try {
            ConfigurationParameterLocal configParam = this.configurationParameterHome.findByPrimaryKey(pk);
            return configParam.getValue();
        }
        catch (FinderException ex) {
            String value = this.defaultProperties.getProperty(key);
            if (value != null && !value.equals(defaultValue) && log.isWarnEnabled()) {
                log.warn((Object)("given parameter overrides default value defined in /config/default-application.properties [" + key + "]"));
            }
            return defaultValue;
        }
    }

    public boolean getBoolean(String key) throws ConfigurationParameterNotFoundException {
        return Boolean.parseBoolean(this.getParameter(key));
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return Boolean.parseBoolean(this.getParameter(key, new Boolean(defaultValue).toString()));
    }

    public int getInteger(String key) throws ConfigurationParameterNotFoundException {
        return Integer.parseInt(this.getParameter(key));
    }

    public long[] getLongArray(String key) throws ConfigurationParameterNotFoundException {
        StringTokenizer tokenizer = new StringTokenizer(this.getParameter(key));
        long[] elementArray = new long[tokenizer.countTokens()];
        for (int index = 0; index < elementArray.length; ++index) {
            elementArray[index] = Long.parseLong(tokenizer.nextToken());
        }
        return elementArray;
    }

    public String[] getParameterArray(String key) throws ConfigurationParameterNotFoundException {
        StringTokenizer tokenizer = new StringTokenizer(this.getParameter(key));
        String[] elementArray = new String[tokenizer.countTokens()];
        for (int index = 0; index < elementArray.length; ++index) {
            elementArray[index] = tokenizer.nextToken();
        }
        return elementArray;
    }

    public boolean isConfigured(String key) {
        try {
            String value = this.getParameter(key);
            return value != null && !value.trim().equals("");
        }
        catch (ConfigurationParameterNotFoundException ex) {
            return false;
        }
    }

    public void setParameter(String key, String value) {
        try {
            ConfigurationParameterLocal parameter = this.configurationParameterHome.findByPrimaryKey(new ConfigurationParameterPK(key));
            parameter.setValue(value);
        }
        catch (ObjectNotFoundException ex) {
            try {
                this.configurationParameterHome.create(key, value);
            }
            catch (CreateException cEx) {
                log.error((Object)"setParameter() runs into", (Throwable)cEx);
                throw new EJBException((Exception)((Object)cEx));
            }
        }
        catch (FinderException ex) {
            log.error((Object)"setParameter() runs into", (Throwable)ex);
            throw new EJBException((Exception)((Object)ex));
        }
    }

    public void removeParameter(String key) {
        try {
            ConfigurationParameterLocal parameter = this.configurationParameterHome.findByPrimaryKey(new ConfigurationParameterPK(key));
            parameter.remove();
        }
        catch (ObjectNotFoundException ex) {
        }
        catch (FinderException ex) {
            log.error((Object)"removeParameter() runs into", (Throwable)ex);
            throw new EJBException((Exception)((Object)ex));
        }
        catch (RemoveException ex) {
            log.error((Object)"removeParameter() runs into", (Throwable)ex);
            throw new EJBException((Exception)((Object)ex));
        }
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultProperties);
        try {
            Object[] configParameters = this.configurationParameterHome.findAll().toArray();
            for (int i = 0; i != configParameters.length; ++i) {
                ConfigurationParameterLocal parameter = (ConfigurationParameterLocal)configParameters[i];
                String key = parameter.getKey();
                String val = parameter.getValue();
                if (key != null && val != null) {
                    properties.put(key, val);
                    continue;
                }
                log.error((Object)("getProperties() found NULL value: key='" + key + "', value='" + val + "'. Check content of table CONFIGURATION_PARAMETER!"));
            }
        }
        catch (FinderException ex) {
            log.error((Object)"getProperties() runs into", (Throwable)ex);
            throw new EJBException((Exception)((Object)ex));
        }
        return properties;
    }
}

