/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.area.adjustment;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.util.geo.GPSPosition;
import de.proveo.wwt.logic.app.geo.GeoStruct;
import de.proveo.wwt.logic.ejb.dataIn.event.EventFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.event.EventFacadeUtil;
import de.proveo.wwt.logic.ejb.dataIn.state.CurrentStateFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.state.CurrentStateFacadeUtil;
import de.proveo.wwt.logic.ejb.dataIn.state.exception.NoStateFoundException;
import de.proveo.wwt.logic.ejb.general.area.adjustment.AdjustmentAreaLocal;
import de.proveo.wwt.logic.ejb.general.area.adjustment.AdjustmentAreaLocalHome;
import de.proveo.wwt.logic.ejb.general.area.adjustment.AdjustmentAreaPK;
import de.proveo.wwt.logic.ejb.general.area.adjustment.AdjustmentAreaUtil;
import de.proveo.wwt.logic.ejb.general.area.adjustment.AdjustmentAreaValue;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationLocal;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationUtil;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelLocal;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelLocalHome;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelPK;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AdjustmentFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final Log log = LogFactory.getLog(AdjustmentFacadeBean.class);
    private static final Random random = new Random(System.currentTimeMillis());
    private AdjustmentAreaLocalHome adjustmentAreaHome;
    private UnitModelLocalHome unitModelHome;
    private CurrentStateFacadeLocal currentStateFacade;
    private EventFacadeLocal eventFacade;
    private ConfigurationLocal configuration;

    protected CurrentStateFacadeLocal getCurrentStateFacade() throws CreateException {
        if (this.currentStateFacade == null) {
            try {
                this.currentStateFacade = CurrentStateFacadeUtil.getLocalHome().create();
            }
            catch (NamingException ex) {
                throw new EJBException("runs during creating currentStateFacadeBean into ", (Exception)ex);
            }
        }
        return this.currentStateFacade;
    }

    protected EventFacadeLocal getEventFacade() throws CreateException {
        if (this.eventFacade == null) {
            try {
                this.eventFacade = EventFacadeUtil.getLocalHome().create();
            }
            catch (NamingException ex) {
                throw new EJBException("runs during creating eventFacadeBean into ", (Exception)ex);
            }
        }
        return this.eventFacade;
    }

    @Override
    public void ejbCreate() throws CreateException {
        try {
            this.adjustmentAreaHome = AdjustmentAreaUtil.getLocalHome();
            this.unitModelHome = UnitModelUtil.getLocalHome();
            this.configuration = ConfigurationUtil.getLocalHome().create();
        }
        catch (NamingException ex) {
            throw new EJBException("runs during lookup other ejbs into", (Exception)ex);
        }
    }

    public void adjust(long unitId, int adjustmentAreaId) throws IllegalStateException, ObjectNotFoundException {
        try {
            UnitModelLocal unitModel = this.unitModelHome.findByPrimaryKey(new UnitModelPK(unitId));
            if (!unitModel.getBasic()) {
                throw new IllegalArgumentException("adjustment is only available for basic units");
            }
        }
        catch (ObjectNotFoundException ex) {
            throw ex;
        }
        catch (FinderException ex) {
            throw new EJBException((Exception)((Object)ex));
        }
        if (this.configuration.getBoolean("adjustment.checkState", false)) {
            try {
                try {
                    this.getCurrentStateFacade();
                }
                catch (CreateException ex) {
                    log.error((Object)"runs into ", (Throwable)ex);
                }
                if (this.currentStateFacade.getCurrentState(unitId, 2050L).getStateId() != 2051L) {
                    throw new IllegalStateException("adjustment is only supprted in state OufOfService");
                }
            }
            catch (NoStateFoundException ex) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("adjust() runs during check current operation state for " + unitId + " into"), (Throwable)ex);
                }
                throw new IllegalStateException("adjustment is only supprted in state OufOfService", ex);
            }
        }
        Position position = this.calculatePosition(this.getAdjustmentArea(adjustmentAreaId));
        long timestamp = System.currentTimeMillis();
        GeoStruct geoEvent = new GeoStruct(unitId, timestamp, timestamp, position.y, position.x, true, "adjust: " + adjustmentAreaId);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("time", Long.toString(timestamp));
        params.put("longitude", Long.toString(position.x));
        params.put("latitude", Long.toString(position.y));
        params.put("quality", "1");
        String record = GPSPosition.createNMEArecord("GGA", params);
        geoEvent.setGgaRec(record);
        params = new HashMap();
        params.put("time", Long.toString(timestamp));
        params.put("status", "A");
        params.put("longitude", Long.toString(position.x));
        params.put("latitude", Long.toString(position.y));
        record = GPSPosition.createNMEArecord("RMC", params);
        geoEvent.setRmcRec(record);
        try {
            this.getEventFacade();
        }
        catch (CreateException ex) {
            log.error((Object)"runs into ", (Throwable)ex);
        }
        this.eventFacade.generateGeoEvent(geoEvent);
    }

    protected Position calculatePosition(AdjustmentAreaValue area) {
        Position position = new Position();
        position.x = this.getRandomBetween(area.getX1(), area.getX2());
        position.y = this.getRandomBetween(area.getY1(), area.getY2());
        return position;
    }

    protected int getRandomBetween(int n1, int n2) {
        int min = Math.min(n1, n2);
        int max = Math.max(n1, n2);
        return min + random.nextInt(max - min);
    }

    public Collection<AdjustmentAreaValue> getAdjustmentAreas() {
        ArrayList<AdjustmentAreaValue> areas = new ArrayList<AdjustmentAreaValue>();
        try {
            Iterator it = this.adjustmentAreaHome.findAll().iterator();
            while (it.hasNext()) {
                areas.add(((AdjustmentAreaLocal)it.next()).getAdjustmentAreaValue());
            }
        }
        catch (FinderException ex) {
            throw new EJBException((Exception)((Object)ex));
        }
        return areas;
    }

    public AdjustmentAreaValue getAdjustmentArea(int adjustmentAreaId) throws ObjectNotFoundException {
        try {
            return this.adjustmentAreaHome.findByPrimaryKey(new AdjustmentAreaPK(adjustmentAreaId)).getAdjustmentAreaValue();
        }
        catch (ObjectNotFoundException ex) {
            throw ex;
        }
        catch (FinderException ex) {
            throw new EJBException((Exception)((Object)ex));
        }
    }

    public AdjustmentAreaValue createAdjustmentArea(AdjustmentAreaValue value) throws CreateException {
        return this.adjustmentAreaHome.create(value).getAdjustmentAreaValue();
    }

    public void deleteAdjustmentArea(int adjustmentAreaId) throws RemoveException, ObjectNotFoundException {
        try {
            this.adjustmentAreaHome.findByPrimaryKey(new AdjustmentAreaPK(adjustmentAreaId)).remove();
        }
        catch (ObjectNotFoundException ex) {
            throw ex;
        }
        catch (FinderException ex) {
            throw new EJBException((Exception)((Object)ex));
        }
    }

    public void updateAdjustmentArea(AdjustmentAreaValue value) throws ObjectNotFoundException {
        try {
            this.adjustmentAreaHome.findByPrimaryKey(new AdjustmentAreaPK(value.getId())).setAdjustmentAreaValue(value);
        }
        catch (ObjectNotFoundException ex) {
            throw ex;
        }
        catch (FinderException ex) {
            throw new EJBException((Exception)((Object)ex));
        }
    }

    protected class Position {
        int x;
        int y;

        protected Position() {
        }
    }
}

