/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.general.area;

import de.proveo.util.ejb.BaseEntityBean;
import de.proveo.wwt.logic.ejb.general.area.AreaData;
import de.proveo.wwt.logic.ejb.general.area.AreaPK;
import de.proveo.wwt.logic.ejb.general.area.AreaPointsLocal;
import de.proveo.wwt.logic.ejb.general.area.AreaPointsLocalHome;
import de.proveo.wwt.logic.ejb.general.area.AreaPointsUtil;
import de.proveo.wwt.logic.ejb.general.area.AreaPointsValue;
import de.proveo.wwt.logic.ejb.general.area.AreaValue;
import java.util.ArrayList;
import java.util.Collection;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AreaBean
extends BaseEntityBean
implements EntityBean {
    private static final Log log = LogFactory.getLog(AreaBean.class);
    private AreaPointsLocalHome areaPointsHome;

    public abstract void setDescription(String var1);

    public ArrayList getPoints() {
        ArrayList<AreaPointsValue> points = new ArrayList<AreaPointsValue>();
        try {
            AreaPointsLocalHome home = this.getAreaPointsHomeInterface();
            for (AreaPointsLocal local : home.findByArea(this.getArea())) {
                points.add(local.getAreaPointsValue());
            }
        }
        catch (FinderException ex) {
            log.error((Object)"runs during find points into", (Throwable)ex);
            throw new EJBException((Exception)((Object)ex));
        }
        return points;
    }

    public abstract AreaValue getAreaValue();

    public abstract void setAreaValue(AreaValue var1);

    public AreaData getAreaData() {
        AreaValue value = this.getAreaValue();
        AreaData data = new AreaData(value);
        data.setAreaPointDatas(this.getPoints());
        return data;
    }

    public AreaPK ejbCreate(AreaValue value) throws CreateException {
        if (value.getArea().length() > 10) {
            log.warn((Object)("database is restricted to a primary column width of 10 characters " + value.getArea()));
            throw new CreateException("database is restricted to a primary column width of 10 characters " + value.getArea());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("ejbCreate('" + value + "')"));
        }
        this.setArea(value.getArea());
        this.setAreaValue(value);
        return null;
    }

    public void ejbPostCreate(AreaValue value) throws CreateException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("ejbPostCreate(pk: '" + this.getArea() + "' " + value + "')"));
        }
    }

    private AreaPointsLocalHome getAreaPointsHomeInterface() {
        try {
            if (this.areaPointsHome == null) {
                this.areaPointsHome = AreaPointsUtil.getLocalHome();
            }
            return this.areaPointsHome;
        }
        catch (NamingException ex) {
            log.error((Object)"getAreaPointsHomeInterface() runs into", (Throwable)ex);
            throw new EJBException("break after previous error.");
        }
    }

    public abstract String getDescription();

    public abstract String getArea();

    public abstract void setArea(String var1);

    public abstract int getPriority();

    public abstract void setPriority(int var1);

    public abstract int getMaxLatMsec();

    public abstract void setMaxLatMsec(int var1);

    public abstract int getMinLatMsec();

    public abstract void setMinLatMsec(int var1);

    public abstract int getMaxLongMsec();

    public abstract void setMaxLongMsec(int var1);

    public abstract int getMinLongMsec();

    public abstract void setMinLongMsec(int var1);

    public abstract Collection getStateHistorys();

    public abstract void setStateHistorys(Collection var1);

    public abstract Collection getCurrentStateCaches();

    public abstract void setCurrentStateCaches(Collection var1);

    public abstract Collection getGdataHistories();

    public abstract void setGdataHistories(Collection var1);

    public abstract Collection getCurrentGdataCaches();

    public abstract void setCurrentGdataCaches(Collection var1);

    public abstract Collection getNotifyHistory();

    public abstract void setNotifyHistory(Collection var1);

    public abstract Collection getCurrentNotifyCaches();

    public abstract void setCurrentNotifyCaches(Collection var1);

    public abstract Collection getUseCaches();

    public abstract void setUseCaches(Collection var1);

    public abstract Collection getUseBeginAreas();

    public abstract void setUseBeginAreas(Collection var1);

    public abstract Collection getUseEndAreas();

    public abstract void setUseEndAreas(Collection var1);
}

