/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataOut.useradministration.facade;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.util.struc.CheckedObject;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.exception.AccessDeniedException;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.group.GroupIdentLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.group.GroupIdentLocalHome;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.group.GroupIdentPK;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.group.GroupIdentUtil;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.group.GroupIdentValue;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.groupanduser.GroupMemberLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.groupanduser.GroupMemberLocalHome;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.groupanduser.GroupMemberUtil;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.groupanduser.GroupMemberValue;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.tracking.LoginLoggerLocalHome;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.tracking.LoginLoggerUtil;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.tracking.LoginLoggerValue;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.user.AccountDataWithPermissions;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.user.AccountLocal;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.user.AccountLocalHome;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.user.AccountUtil;
import de.proveo.wwt.logic.ejb.dataOut.useradministration.user.AccountValue;
import de.proveo.wwt.security.LoginUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class UserAdminFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final transient Log log = LogFactory.getLog(UserAdminFacadeBean.class);
    private AccountLocalHome accountHome;
    private GroupIdentLocalHome groupIdentHome;
    private GroupMemberLocalHome groupMemberHome;
    private LoginLoggerLocalHome loginLoggerHome;

    public AccountDataWithPermissions checkUser(String username, char[] password) throws AccessDeniedException {
        LoginLoggerValue logData = new LoginLoggerValue();
        logData.setUsername(username);
        try {
            AccountLocal account = null;
            Iterator it = this.accountHome.findByUsername(username).iterator();
            if (!it.hasNext()) {
                throw new FinderException();
            }
            account = (AccountLocal)it.next();
            String passwordHash = LoginUtil.createMessageDigest(password);
            if (account.getPassword().equals(passwordHash)) {
                AccountValue value = account.getAccountValue();
                AccountDataWithPermissions data = new AccountDataWithPermissions(value);
                logData.setSuccessful(true);
                this.loginLogger(logData);
                return data;
            }
            logData.setErrorMessage("wrong password");
            logData.setSuccessful(false);
            this.loginLogger(logData);
            throw new AccessDeniedException(username);
        }
        catch (FinderException ex) {
            log.debug((Object)"checkUser(): User not found in DB!");
            logData.setSuccessful(false);
            this.loginLogger(logData, (Exception)((Object)ex));
            throw new AccessDeniedException(username);
        }
    }

    public void deleteGroup(long id) {
        this.deleteGroupGroupMembers(id);
        try {
            GroupIdentLocal group = this.groupIdentHome.findByPrimaryKey(new GroupIdentPK(id));
            group.remove();
        }
        catch (Exception e) {
            log.error((Object)"deleteGroup() runs into", (Throwable)e);
        }
    }

    public void deleteUser(String username) {
        Collection memberships = new ArrayList();
        try {
            memberships = this.groupMemberHome.findByUsername(username);
        }
        catch (FinderException ex) {
            log.debug((Object)("deleteUser() no groupMemberships found for username: " + username));
        }
        for (GroupMemberLocal groupMember : memberships) {
            try {
                groupMember.remove();
            }
            catch (Exception ex) {
                log.error((Object)"deleteUser() runs during delete Memberships into", (Throwable)ex);
            }
        }
        try {
            AccountLocal account = (AccountLocal)this.accountHome.findByUsername(username).iterator().next();
            account.remove();
        }
        catch (FinderException e) {
            log.error((Object)("deleteUser() user not found. username: " + username));
        }
        catch (RemoveException e) {
            log.error((Object)"deleteUser() runs into", (Throwable)e);
        }
    }

    public void ejbCreate() throws CreateException {
        this.lookupOtherBeans();
    }

    public Collection getAccountDatas() {
        ArrayList<AccountValue> user_datas = new ArrayList<AccountValue>();
        try {
            Collection accounts = this.accountHome.findAll();
            for (AccountLocal account : accounts) {
                user_datas.add(account.getAccountValue());
            }
        }
        catch (Exception e) {
            log.error((Object)"getAccountDatas() runs into", (Throwable)e);
        }
        return user_datas;
    }

    public Collection getAccountDatas(String[] usernames) {
        ArrayList<AccountValue> user_datas = new ArrayList<AccountValue>();
        for (int index = 0; index < usernames.length; ++index) {
            try {
                AccountLocal account = (AccountLocal)this.accountHome.findByUsername(usernames[index]).iterator().next();
                user_datas.add(account.getAccountValue());
                continue;
            }
            catch (FinderException e) {
                log.error((Object)("getAccountDatas(primarykeys): Account " + usernames[index] + " not found"), (Throwable)e);
            }
        }
        return user_datas;
    }

    public Collection getCheckedAccountsForGroup(long groupId) {
        Collection accountDatas = this.getAccountDatas();
        Iterator<Object> it = accountDatas.iterator();
        HashMap<String, CheckedObject> checkedAccountsMap = new HashMap<String, CheckedObject>(accountDatas.size());
        while (it.hasNext()) {
            AccountValue data = (AccountValue)it.next();
            CheckedObject checkedObject = new CheckedObject(false, data);
            checkedAccountsMap.put(data.getUsername(), checkedObject);
        }
        ArrayList accountsInThisGroup = new ArrayList();
        try {
            Collection memberRels = this.groupMemberHome.findByGroupId(groupId);
            accountsInThisGroup = new ArrayList(memberRels.size());
            for (GroupMemberLocal groupMember : memberRels) {
                try {
                    String username = groupMember.getUsername();
                    CheckedObject checkedObject = (CheckedObject)checkedAccountsMap.get(username);
                    if (checkedObject == null) continue;
                    checkedObject.setChecked(true);
                }
                catch (Exception ex) {
                    log.error((Object)"getCheckedAccountsForGroup() runs into", (Throwable)ex);
                }
            }
        }
        catch (FinderException ex) {
            log.debug((Object)("getCheckedAccountsForGroup() no accounts for groupId: " + groupId + " found"));
        }
        it = checkedAccountsMap.keySet().iterator();
        ArrayList<CheckedObject> checkedAccounts = new ArrayList<CheckedObject>(accountDatas.size());
        while (it.hasNext()) {
            String username = (String)it.next();
            CheckedObject checkedObject = (CheckedObject)checkedAccountsMap.get(username);
            checkedAccounts.add(checkedObject);
        }
        return checkedAccounts;
    }

    public Collection getCheckedGroupIdentDatas(String username) {
        CheckedObject checked;
        log.debug((Object)"getCheckedGroupIdentDatas() enter");
        ArrayList<CheckedObject> checkedGroups = new ArrayList<CheckedObject>();
        Collection groups = this.getGroupIdentValues();
        HashMap<Long, CheckedObject> groupsMap = new HashMap<Long, CheckedObject>(groups.size());
        for (GroupIdentValue value : groups) {
            groupsMap.put(new Long(value.getID()), new CheckedObject(false, value));
        }
        groups = this.getGroupIdentDatas(username);
        log.debug((Object)("getCheckedGroupIdentDatas() found " + groups.size() + " groups"));
        for (GroupIdentValue data : groups) {
            checked = (CheckedObject)groupsMap.get(new Long(data.getID()));
            checked.setChecked(true);
        }
        for (Long key : groupsMap.keySet()) {
            checked = (CheckedObject)groupsMap.get(key);
            checkedGroups.add(checked);
        }
        return checkedGroups;
    }

    public GroupIdentValue getGroupIdentData(long groupId) {
        log.debug((Object)("getGroupIdentData(" + groupId + ")"));
        GroupIdentValue data = null;
        try {
            GroupIdentLocal groupIdent = this.groupIdentHome.findByPrimaryKey(new GroupIdentPK(groupId));
            data = groupIdent.getGroupIdentValue();
        }
        catch (Exception e) {
            log.error((Object)"getGroupIdentData() runs into", (Throwable)e);
        }
        return data;
    }

    public Collection getGroupIdentDatas(String username) {
        log.debug((Object)("getGroupIdentDatas(" + username + ")"));
        ArrayList<GroupIdentValue> groupIdentDatas = new ArrayList<GroupIdentValue>();
        try {
            Collection groupMembers = this.groupMemberHome.findByUsername(username);
            for (GroupMemberLocal groupMember : groupMembers) {
                try {
                    long groupId = groupMember.getGroupId();
                    GroupIdentLocal groupIdent = this.groupIdentHome.findByPrimaryKey(new GroupIdentPK(groupId));
                    GroupIdentValue value = groupIdent.getGroupIdentValue();
                    groupIdentDatas.add(value);
                }
                catch (Exception ex) {
                    log.error((Object)"getGroupIdentDatasForUser() runs during find GroupIdentDatas", (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            log.error((Object)("getGroupIdentDatasForUser() runs during find groups for username(" + username + ") into"), (Throwable)ex);
        }
        return groupIdentDatas;
    }

    public Collection getGroupIdentDatas(long[] primarykeys) {
        log.debug((Object)"getGroupIdentDatas(long[])");
        ArrayList<GroupIdentValue> groupIdentDatas = new ArrayList<GroupIdentValue>();
        try {
            for (int index = 0; index < primarykeys.length; ++index) {
                GroupIdentLocal groupIdent = null;
                try {
                    groupIdent = this.groupIdentHome.findByPrimaryKey(new GroupIdentPK(primarykeys[index]));
                }
                catch (FinderException e) {
                    log.error((Object)("getGroupIdentDatas(primarykeys): GroupIdent " + primarykeys[index] + " not found"), (Throwable)e);
                }
                if (groupIdent == null) continue;
                groupIdentDatas.add(groupIdent.getGroupIdentValue());
            }
        }
        catch (Exception e) {
            log.error((Object)"getGroupIdentDatas(primarykeys) runs into", (Throwable)e);
        }
        return groupIdentDatas;
    }

    public Collection getGroupIdentValues() {
        log.debug((Object)"getGroupIdentValues() enter");
        ArrayList<GroupIdentValue> groupIdentValues = new ArrayList<GroupIdentValue>();
        try {
            Collection groupIdents = this.groupIdentHome.findAll();
            for (GroupIdentLocal groupIdent : groupIdents) {
                GroupIdentValue data = groupIdent.getGroupIdentValue();
                groupIdentValues.add(data);
            }
        }
        catch (Exception e) {
            log.error((Object)"getGroupIdentValues() runs into", (Throwable)e);
        }
        return groupIdentValues;
    }

    public void insertGroup(GroupIdentValue data) {
        try {
            this.groupIdentHome.create(data);
        }
        catch (Exception e) {
            log.error((Object)"insertGroup() runs into", (Throwable)e);
        }
    }

    public void insertUser(AccountValue value) {
        try {
            this.accountHome.create(value);
        }
        catch (Exception e) {
            log.error((Object)"insertUser() runs into", (Throwable)e);
        }
    }

    public void saveGroupMember(String[] usernames, long groupId) {
        try {
            Collection memberships = this.groupMemberHome.findByGroupId(groupId);
            for (GroupMemberLocal groupMember : memberships) {
                try {
                    groupMember.remove();
                }
                catch (RemoveException ex) {
                    log.error((Object)"saveGroupMember() runs during remove Membership into", (Throwable)ex);
                }
            }
        }
        catch (FinderException ex) {
            log.debug((Object)("saveGroupMember() no memberships found for groupId: " + groupId));
        }
        for (int i = 0; i < usernames.length; ++i) {
            try {
                this.groupMemberHome.create(groupId, usernames[i]);
                continue;
            }
            catch (Exception ex) {
                log.error((Object)("saveGroupMember() runs during create membership username: " + usernames[i] + " groupId: " + groupId + " into"), (Throwable)ex);
            }
        }
    }

    public void saveGroupMember(String username, long[] groupIds) {
        try {
            Collection memberships = this.groupMemberHome.findByUsername(username);
            for (GroupMemberLocal groupMember : memberships) {
                try {
                    groupMember.remove();
                }
                catch (RemoveException ex) {
                    log.error((Object)"saveGroupMember() runs during remove Membership into", (Throwable)ex);
                }
            }
        }
        catch (FinderException ex) {
            log.debug((Object)("saveGroupMember() no memberships found for username: " + username));
        }
        for (int i = 0; i < groupIds.length; ++i) {
            try {
                this.groupMemberHome.create(groupIds[i], username);
                continue;
            }
            catch (Exception ex) {
                log.error((Object)("saveGroupMember() runs during create membership username: " + username + " groupId: " + groupIds[i] + " into"), (Throwable)ex);
            }
        }
    }

    public void updateGroup(GroupIdentValue value) {
        try {
            GroupIdentLocal group = this.groupIdentHome.findByPrimaryKey(new GroupIdentPK(value.getID()));
            group.setGroupIdentValue(value);
        }
        catch (Exception e) {
            log.error((Object)"updateGroup() runs into", (Throwable)e);
        }
    }

    public void updateUser(AccountValue value) {
        try {
            AccountLocal account = (AccountLocal)this.accountHome.findByUsername(value.getUsername()).iterator().next();
            account.setAccountValue(value);
        }
        catch (FinderException e) {
            log.error((Object)("updateUser() user not found. username: " + value.getUsername()));
        }
    }

    protected void deleteGroupGroupMembers(long groupId) {
        Collection accountMembers = new ArrayList();
        try {
            accountMembers = this.groupMemberHome.findByGroupId(groupId);
        }
        catch (FinderException ex) {
            log.debug((Object)"deleteGroup() no Account Memberships found");
        }
        for (GroupMemberLocal groupMember : accountMembers) {
            try {
                groupMember.remove();
            }
            catch (Exception ex) {
                log.error((Object)"deleteGroup() runs during remove Account Membership into", (Throwable)ex);
            }
        }
    }

    protected Collection getGroupsForUser(String username) {
        ArrayList<GroupIdentValue> groups = new ArrayList<GroupIdentValue>();
        try {
            Collection groupMembers = this.groupMemberHome.findByUsername(username);
            for (GroupMemberLocal groupMember : groupMembers) {
                GroupMemberValue groupMemberValue = groupMember.getGroupMemberValue();
                try {
                    GroupIdentLocal groupIdent = this.groupIdentHome.findByPrimaryKey(new GroupIdentPK(groupMemberValue.getGroupId()));
                    groups.add(groupIdent.getGroupIdentValue());
                }
                catch (Exception ex) {
                    log.debug((Object)("getGroupsForUser() username: " + username));
                    log.error((Object)"getGroupsForUser() runs during lookups groups for user into", (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            log.debug((Object)("getGroupsForUser() username: " + username));
            log.error((Object)"getGroupsForUser() runs during lookups groups for user into", (Throwable)ex);
        }
        return groups;
    }

    protected void loginLogger(LoginLoggerValue value) {
        value.setDatetime(System.currentTimeMillis());
        try {
            try {
                this.loginLoggerHome.create(value);
            }
            catch (DuplicateKeyException ex) {
                this.loginLoggerHome.reorganizeSequence();
                this.loginLoggerHome.create(value);
            }
        }
        catch (Exception ex) {
            log.error((Object)"loginLogger() runs into", (Throwable)ex);
        }
    }

    protected void loginLogger(LoginLoggerValue value, Exception e) {
        value.setErrorMessage(e.getMessage());
        this.loginLogger(value);
    }

    protected void lookupOtherBeans() throws CreateException {
        try {
            this.accountHome = AccountUtil.getLocalHome();
            this.groupIdentHome = GroupIdentUtil.getLocalHome();
            this.groupMemberHome = GroupMemberUtil.getLocalHome();
            this.loginLoggerHome = LoginLoggerUtil.getLocalHome();
        }
        catch (NamingException ex) {
            log.error((Object)"lookupOtherBeans() runs into", (Throwable)ex);
            throw new CreateException("lookupOtherBeans() runs into " + ex.getMessage());
        }
    }
}

