/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataOut.replay;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.ejb.dataIn.geo.cache.CurrentGdataCacheLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.geo.cache.CurrentGdataCacheUtil;
import de.proveo.wwt.logic.ejb.dataIn.geo.cache.CurrentGdataCacheValue;
import de.proveo.wwt.logic.ejb.dataIn.geo.history.GdataHistoryLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.geo.history.GdataHistoryUtil;
import de.proveo.wwt.logic.ejb.dataIn.geo.history.GdataHistoryValue;
import de.proveo.wwt.logic.ejb.dataIn.keepalive.cache.KeepAliveCacheLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.keepalive.cache.KeepAliveCacheUtil;
import de.proveo.wwt.logic.ejb.dataIn.keepalive.cache.KeepAliveCacheValue;
import de.proveo.wwt.logic.ejb.dataIn.keepalive.history.KeepAliveHistoryLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.keepalive.history.KeepAliveHistoryUtil;
import de.proveo.wwt.logic.ejb.dataIn.keepalive.history.KeepAliveHistoryValue;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.CurrentStateCacheLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.CurrentStateCacheUtil;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.CurrentStateCacheValue;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.StateHistoryLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.StateHistoryUtil;
import de.proveo.wwt.logic.ejb.dataIn.statepersist.StateHistoryValue;
import de.proveo.wwt.logic.ejb.general.area.AreaLocalHome;
import de.proveo.wwt.logic.ejb.general.area.AreaUtil;
import de.proveo.wwt.logic.ejb.general.area.AreaValue;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationLocal;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationLocalHome;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationUtil;
import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityLocalHome;
import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityUtil;
import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityValue;
import de.proveo.wwt.logic.web.security.PermissionCheckerLocal;
import de.proveo.wwt.logic.web.security.PermissionCheckerLocalHome;
import de.proveo.wwt.logic.web.security.PermissionCheckerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeMap;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.SessionBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReplayDataFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final Log log = LogFactory.getLog(ReplayDataFacadeBean.class);
    private CurrentGdataCacheLocalHome gdataCacheLocalHome;
    private GdataHistoryLocalHome gdataHistoryLocalHome;
    private CurrentStateCacheLocalHome currentStateLocalHome;
    private StateHistoryLocalHome historyStateLocalHome;
    private UnitIdentityLocalHome unitIdentityLocalHome;
    private AreaLocalHome areaLocalHome;
    private PermissionCheckerLocalHome permissionCheckerLocalHome;
    private KeepAliveHistoryLocalHome keepAliveHistoryLocalHome;
    private KeepAliveCacheLocalHome keepAliveCacheLocalHome;
    private ConfigurationLocalHome configurationLocalHome;
    private ConfigurationLocal configurationLocal;

    public void ejbCreate() throws CreateException {
        try {
            this.gdataCacheLocalHome = CurrentGdataCacheUtil.getLocalHome();
            this.gdataHistoryLocalHome = GdataHistoryUtil.getLocalHome();
            this.currentStateLocalHome = CurrentStateCacheUtil.getLocalHome();
            this.historyStateLocalHome = StateHistoryUtil.getLocalHome();
            this.unitIdentityLocalHome = UnitIdentityUtil.getLocalHome();
            this.areaLocalHome = AreaUtil.getLocalHome();
            this.permissionCheckerLocalHome = PermissionCheckerUtil.getLocalHome();
            this.keepAliveHistoryLocalHome = KeepAliveHistoryUtil.getLocalHome();
            this.keepAliveCacheLocalHome = KeepAliveCacheUtil.getLocalHome();
            this.configurationLocalHome = ConfigurationUtil.getLocalHome();
            this.configurationLocal = this.configurationLocalHome.create();
            if (log.isDebugEnabled()) {
                log.debug((Object)"LocalHomes created...");
            }
        }
        catch (Exception ex) {
            log.error((Object)"runs during lookup ejb refs into", (Throwable)ex);
            throw new CreateException("runs during lookup ejb refs into " + ex.getMessage());
        }
    }

    public HashMap getInitialData(long timeStamp) {
        String method = "getInitialData(): ";
        String replayActive = this.configurationLocal.getParameter("airportmap.replay.active", "false");
        if (!replayActive.equals("true")) {
            log.warn((Object)(method + "Replay not available on this server."));
            return null;
        }
        log.debug((Object)(method + "start."));
        HashMap<String, Cloneable> initialCollector = new HashMap<String, Cloneable>();
        try {
            PermissionCheckerLocal permissionCheckerLocal = this.permissionCheckerLocalHome.create();
            HashSet<Long> untiPermissions = permissionCheckerLocal.getUnitPermissions();
            log.debug((Object)(method + "Collection size unitPermissions: " + untiPermissions.size()));
            if (untiPermissions != null & untiPermissions.size() > 0) {
                initialCollector.put("unitPermissions", untiPermissions);
                Collection colGdataCache = this.gdataCacheLocalHome.findInitialByTime(timeStamp);
                log.debug((Object)(method + "Collection size GdataCache: " + colGdataCache.size()));
                Collection colStateCache = this.currentStateLocalHome.findInitialByTime(timeStamp);
                log.debug((Object)(method + "Collection size StateCache: " + colStateCache.size()));
                Collection colGdataHistory = this.gdataHistoryLocalHome.findInitialByTime(timeStamp);
                log.debug((Object)(method + "Collection size GdataHistory: " + colGdataHistory.size()));
                Collection colStateHistory = this.historyStateLocalHome.findInitialByTime(timeStamp);
                log.debug((Object)(method + "Collection size StateHistory: " + colStateHistory.size()));
                Collection colUnitIdentity = this.unitIdentityLocalHome.findAllForAirportmap();
                log.debug((Object)(method + "Collection size UnitIdentity: " + colUnitIdentity.size()));
                Collection colArea = this.areaLocalHome.findAll();
                log.debug((Object)(method + "Collection size Area: " + colArea.size()));
                if (colArea != null & colArea.size() > 0) {
                    HashMap<String, String> areas = new HashMap<String, String>();
                    for (Object local : colArea) {
                        AreaValue value = local.getAreaValue();
                        if (value == null) continue;
                        areas.put(local.getArea(), value.getDescription());
                    }
                    initialCollector.put("areaValues", areas);
                }
                if (colUnitIdentity != null & colUnitIdentity.size() > 0) {
                    HashMap<Long, UnitIdentityValue> unitIdents = new HashMap<Long, UnitIdentityValue>();
                    for (Object local : colUnitIdentity) {
                        unitIdents.put(local.getUnitIdentityValue().getUnitId(), local.getUnitIdentityValue());
                    }
                    initialCollector.put("unitIdentityValues", unitIdents);
                }
                if (colGdataHistory != null & colGdataHistory.size() > 0) {
                    HashMap<Long, GdataHistoryValue> geoStructs = new HashMap<Long, GdataHistoryValue>();
                    for (Object local : colGdataHistory) {
                        geoStructs.put(local.getGdataHistoryValue().getUnitId(), local.getGdataHistoryValue());
                    }
                    initialCollector.put("initGdataHistory", geoStructs);
                }
                if (colStateHistory != null & colStateHistory.size() > 0) {
                    ArrayList<StateHistoryValue> stateHistory = new ArrayList<StateHistoryValue>();
                    for (Object local : colStateHistory) {
                        stateHistory.add(local.getStateHistoryValue());
                    }
                    initialCollector.put("initStateHistory", stateHistory);
                }
                if (colGdataCache != null & colGdataCache.size() > 0) {
                    HashMap<Long, CurrentGdataCacheValue> gDataCache = new HashMap<Long, CurrentGdataCacheValue>();
                    for (Object local : colGdataCache) {
                        gDataCache.put(local.getCurrentGdataCacheValue().getUnitId(), local.getCurrentGdataCacheValue());
                    }
                    initialCollector.put("initGdataCache", gDataCache);
                }
                if (colStateCache != null & colStateCache.size() > 0) {
                    ArrayList<CurrentStateCacheValue> stateCache = new ArrayList<CurrentStateCacheValue>();
                    for (Object local : colStateCache) {
                        stateCache.add(local.getCurrentStateCacheValue());
                    }
                    initialCollector.put("initStateCache", stateCache);
                }
            } else {
                log.debug((Object)(method + "User has no unit permissions"));
            }
            log.debug((Object)(method + "Size of initial context: " + initialCollector.size()));
        }
        catch (FinderException e) {
            log.error((Object)(method + "runs into"), (Throwable)e);
        }
        catch (CreateException e) {
            log.error((Object)(method + "runs into"), (Throwable)e);
        }
        return initialCollector;
    }

    public TreeMap getReplayData(long fromTime, long toTime) {
        String method = "getReplayData(): ";
        String replayActive = this.configurationLocal.getParameter("airportmap.replay.active", "false");
        if (!replayActive.equals("true")) {
            log.warn((Object)(method + "Replay not available on this server."));
            return null;
        }
        log.debug((Object)(method + "start."));
        TreeMap<Long, Cloneable> retValue = new TreeMap<Long, Cloneable>();
        try {
            Cloneable state;
            Cloneable gData;
            Collection colGdataHistory = this.gdataHistoryLocalHome.findByTime(fromTime, toTime);
            log.debug((Object)(method + "*** Collection size GdataHistory: " + colGdataHistory.size()));
            Collection colStateHistory = this.historyStateLocalHome.findByTime(fromTime, toTime);
            log.debug((Object)(method + "Collection size StateHistory: " + colStateHistory.size()));
            Collection colKeepAliveHistory = this.keepAliveHistoryLocalHome.findAllByPeriod(fromTime, toTime);
            log.debug((Object)(method + "Collection size KeepAliveHistory: " + colKeepAliveHistory.size()));
            Collection colGdataCache = this.gdataCacheLocalHome.findByTime(fromTime, toTime);
            log.debug((Object)(method + "Collection size GdataCache: " + colGdataCache.size()));
            Collection colStateCache = this.currentStateLocalHome.findByTime(fromTime, toTime);
            log.debug((Object)(method + "Collection size StateCache: " + colStateCache.size()));
            Collection colKeepAliveCache = this.keepAliveCacheLocalHome.findAllByPeriod(fromTime, toTime);
            log.debug((Object)(method + "Collection size KeepAliveCache: " + colKeepAliveCache.size()));
            if (colGdataHistory != null & colGdataHistory.size() > 0) {
                for (Object local : colGdataHistory) {
                    gData = local.getGdataHistoryValue();
                    while (retValue.containsKey(((GdataHistoryValue)gData).getBeginTime())) {
                        ((GdataHistoryValue)gData).setBeginTime(((GdataHistoryValue)gData).getBeginTime() + 1L);
                    }
                    retValue.put(((GdataHistoryValue)gData).getBeginTime(), gData);
                }
            }
            if (colStateHistory != null & colStateHistory.size() > 0) {
                for (Object local : colStateHistory) {
                    state = local.getStateHistoryValue();
                    while (retValue.containsKey(((StateHistoryValue)state).getBeginTime())) {
                        ((StateHistoryValue)state).setBeginTime(((StateHistoryValue)state).getBeginTime() + 1L);
                    }
                    retValue.put(((StateHistoryValue)state).getBeginTime(), state);
                }
            }
            if (colKeepAliveHistory != null & colKeepAliveHistory.size() > 0) {
                for (Object local : colKeepAliveHistory) {
                    state = local.getKeepAliveHistoryValue();
                    while (retValue.containsKey(((KeepAliveHistoryValue)state).getTimeStamp())) {
                        ((KeepAliveHistoryValue)state).setTimeStamp(((KeepAliveHistoryValue)state).getTimeStamp() + 1L);
                    }
                    retValue.put(((KeepAliveHistoryValue)state).getTimeStamp(), state);
                }
            }
            if (colGdataCache != null & colGdataCache.size() > 0) {
                for (Object local : colGdataCache) {
                    gData = local.getCurrentGdataCacheValue();
                    while (retValue.containsKey(((CurrentGdataCacheValue)gData).getCreateTime())) {
                        ((CurrentGdataCacheValue)gData).setCreateTime(((CurrentGdataCacheValue)gData).getCreateTime() + 1L);
                    }
                    retValue.put(((CurrentGdataCacheValue)gData).getCreateTime(), gData);
                }
            }
            if (colStateCache != null & colStateCache.size() > 0) {
                for (Object local : colStateCache) {
                    state = local.getCurrentStateCacheValue();
                    while (retValue.containsKey(((CurrentStateCacheValue)state).getBeginTime())) {
                        ((CurrentStateCacheValue)state).setBeginTime(((CurrentStateCacheValue)state).getBeginTime() + 1L);
                    }
                    retValue.put(((CurrentStateCacheValue)state).getBeginTime(), state);
                }
            }
            if (colKeepAliveCache != null & colKeepAliveCache.size() > 0) {
                for (Object local : colKeepAliveCache) {
                    state = local.getKeepAliveCacheValue();
                    while (retValue.containsKey(((KeepAliveCacheValue)state).getTimeStamp())) {
                        ((KeepAliveCacheValue)state).setTimeStamp(((KeepAliveCacheValue)state).getTimeStamp() + 1L);
                    }
                    retValue.put(((KeepAliveCacheValue)state).getTimeStamp(), state);
                }
            }
            log.debug((Object)(method + "Size of replay data map: " + retValue.size()));
        }
        catch (FinderException e) {
            log.error((Object)(method + "runs into"), (Throwable)e);
        }
        return retValue;
    }
}

