/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataOut.keepalive;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.ejb.dataIn.keepalive.KeepAliveMessage;
import de.proveo.wwt.logic.ejb.dataIn.keepalive.cache.KeepAliveCacheLocal;
import de.proveo.wwt.logic.ejb.dataIn.keepalive.cache.KeepAliveCacheLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.keepalive.cache.KeepAliveCachePK;
import de.proveo.wwt.logic.ejb.dataIn.keepalive.cache.KeepAliveCacheUtil;
import de.proveo.wwt.logic.ejb.dataIn.keepalive.history.KeepAliveHistoryLocal;
import de.proveo.wwt.logic.ejb.dataIn.keepalive.history.KeepAliveHistoryLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.keepalive.history.KeepAliveHistoryUtil;
import de.proveo.wwt.logic.ejb.dataIn.keepalive.history.KeepAliveHistoryValue;
import de.proveo.wwt.logic.ejb.dataIn.state.CurrentStateFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.state.CurrentStateFacadeStruct;
import de.proveo.wwt.logic.ejb.dataIn.state.CurrentStateFacadeUtil;
import de.proveo.wwt.logic.ejb.dataIn.state.exception.NoStateFoundException;
import de.proveo.wwt.logic.ejb.dataOut.raw.KeepAliveStamp;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationLocal;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationParameterNotFoundException;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationUtil;
import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityLocal;
import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityLocalHome;
import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityPK;
import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityUtil;
import de.proveo.wwt.logic.ejb.general.unit.entity.identity.UnitIdentityValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class KeepAliveOutFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final Log log = LogFactory.getLog(KeepAliveOutFacadeBean.class);
    private static final String CONFIG_PARAM_NAME_TIMEOUT = "infoman.keepalive.timeout";
    private static final long DEFAULT_TIMEOUT = 300L;
    private KeepAliveCacheLocalHome keepAliveCacheHome;
    private KeepAliveHistoryLocalHome keepAliveHistoryHome;
    private UnitIdentityLocalHome unitIdentityHome;
    private ConfigurationLocal configuration;
    private UnitIdentityValue unitIdentityData;
    private long timeout;
    private long currentTime;
    private CurrentStateFacadeLocal currentStateFacade;

    public void ejbCreate() throws CreateException {
        try {
            this.keepAliveCacheHome = KeepAliveCacheUtil.getLocalHome();
            this.keepAliveHistoryHome = KeepAliveHistoryUtil.getLocalHome();
            this.unitIdentityHome = UnitIdentityUtil.getLocalHome();
            this.configuration = ConfigurationUtil.getLocalHome().create();
            this.currentStateFacade = CurrentStateFacadeUtil.getLocalHome().create();
        }
        catch (Exception ex) {
            log.error((Object)"runs during lookup ejb refs into", (Throwable)ex);
            throw new CreateException("runs during lookup ejb refs into " + ex.getMessage());
        }
    }

    public void setSessionContext(SessionContext sessionContext) {
        super.setSessionContext(sessionContext);
        this.unitIdentityData = null;
        this.timeout = 0L;
        this.currentTime = 0L;
    }

    protected UnitIdentityValue getUnitIdentity(long unitId) {
        UnitIdentityPK pk = new UnitIdentityPK(unitId);
        try {
            UnitIdentityLocal unit = this.unitIdentityHome.findByPrimaryKey(pk);
            return unit.getUnitIdentityValue();
        }
        catch (Exception ex) {
            log.error((Object)("getUnitIdentity(): unit for ID '" + unitId + "' not found !"));
            UnitIdentityValue value = new UnitIdentityValue();
            value.setUnitId(unitId);
            value.setName("(n/a)");
            value.setUnitKind("(n/a)");
            return value;
        }
    }

    protected void initKeepAliveTimeOut() {
        try {
            String timeOutStr = this.configuration.getParameter(CONFIG_PARAM_NAME_TIMEOUT);
            this.timeout = Long.parseLong(timeOutStr);
        }
        catch (ConfigurationParameterNotFoundException ex) {
            log.debug((Object)"configuration parameter 'infoman.keepalive.timeout' not found. User default.", (Throwable)ex);
            this.timeout = 300L;
        }
        catch (NumberFormatException ex) {
            log.error((Object)"wrong value for 'infoman.keepalive.timeout'. Runs into", (Throwable)ex);
            this.timeout = 300L;
        }
        this.timeout *= 60000L;
    }

    public Set getKeepAliveMessages(long basicUnitId, long requestedBeginTime, long requestedEndTime) {
        HashSet<KeepAliveStamp> allStamps;
        block7: {
            block6: {
                allStamps = new HashSet<KeepAliveStamp>();
                this.unitIdentityData = this.getUnitIdentity(basicUnitId);
                this.initKeepAliveTimeOut();
                this.currentTime = requestedEndTime;
                try {
                    KeepAliveStamp cache = this.getKeepAliveMessageFromCache();
                    if (cache.getTimeStamp() <= requestedEndTime) {
                        allStamps.add(cache);
                    }
                    if (cache.getTimeStamp() <= requestedBeginTime) {
                        return allStamps;
                    }
                }
                catch (FinderException ex) {
                    if (!log.isDebugEnabled()) break block6;
                    log.debug((Object)("nothing found in cache for unitId: " + basicUnitId + " from: " + new Date(requestedBeginTime).toString() + " (" + requestedBeginTime + ") to: " + new Date(requestedEndTime).toString() + " (" + requestedEndTime + ")"));
                }
            }
            try {
                allStamps.addAll(this.getKeepAliveMessagesFromHistory(requestedBeginTime, requestedEndTime));
            }
            catch (FinderException ex) {
                if (!log.isDebugEnabled()) break block7;
                log.debug((Object)("nothing found in history for unitId: " + basicUnitId + " from: " + new Date(requestedBeginTime).toString() + " (" + requestedBeginTime + ") to: " + new Date(requestedEndTime).toString() + " (" + requestedEndTime + ")"));
            }
        }
        return allStamps;
    }

    protected KeepAliveStamp getKeepAliveMessageFromCache() throws FinderException {
        KeepAliveCachePK pk = new KeepAliveCachePK(this.unitIdentityData.getUnitId());
        KeepAliveCacheLocal cache = this.keepAliveCacheHome.findByPrimaryKey(pk);
        KeepAliveMessage keepAliveMessage = cache.getStruct();
        return this.createStamp(keepAliveMessage);
    }

    protected Collection getKeepAliveMessagesFromHistory(long requestedBeginTime, long requestedEndTime) throws FinderException {
        ArrayList<KeepAliveStamp> stamps = new ArrayList<KeepAliveStamp>();
        Collection historyRecords = this.keepAliveHistoryHome.findByUnitAndPeriod(this.unitIdentityData.getUnitId(), requestedBeginTime, requestedEndTime);
        for (KeepAliveHistoryLocal historyRecord : historyRecords) {
            KeepAliveHistoryValue value = historyRecord.getKeepAliveHistoryValue();
            KeepAliveMessage keepAliveMessage = new KeepAliveMessage(value.getUnitId());
            keepAliveMessage.setTimeStamp(value.getTimeStamp());
            stamps.add(this.createStamp(keepAliveMessage));
        }
        return stamps;
    }

    protected KeepAliveStamp createStamp(KeepAliveMessage keepAliveMessage) {
        long stateId;
        long duration = this.currentTime - keepAliveMessage.getTimeStamp();
        boolean keepAliveValid = duration <= this.timeout;
        try {
            CurrentStateFacadeStruct state = this.currentStateFacade.getCurrentState(this.unitIdentityData.getUnitId(), 2110L);
            stateId = state.getStateId() == 2111L ? state.getStateId() : (keepAliveValid ? 2112L : 2113L);
        }
        catch (NoStateFoundException ex) {
            stateId = keepAliveValid ? 2112L : 2113L;
        }
        return new KeepAliveStamp(keepAliveMessage.getTimeStamp(), duration, stateId, this.unitIdentityData);
    }
}

