/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.stands.parser;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.wwt.logic.ejb.dataIn.fisGse.cache.FisGseCacheValue;
import de.proveo.wwt.logic.ejb.dataIn.fisStaff.cache.FisStaffCacheValue;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.commonData.CommonDataFacadeLocal;
import de.proveo.wwt.logic.web.commonData.CommonDataFacadeUtil;
import de.proveo.wwt.logic.web.currentData.CurrentDataFacadeLocal;
import de.proveo.wwt.logic.web.currentData.CurrentDataFacadeUtil;
import de.proveo.wwt.logic.web.historyData.dto.UseDTO;
import de.proveo.wwt.logic.web.historyData.dto.UseDTOList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GSEAndStaffConverterFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final long serialVersionUID = 830210516697405497L;
    private static final Log log = LogFactory.getLog(GSEAndStaffConverterFacadeBean.class);
    private CommonDataFacadeLocal commonDataFacade;
    private CurrentDataFacadeLocal currentDataFacade;

    public void ejbCreate() throws CreateException {
        try {
            this.commonDataFacade = CommonDataFacadeUtil.getLocalHome().create();
            this.currentDataFacade = CurrentDataFacadeUtil.getLocalHome().create();
        }
        catch (NamingException e) {
            log.error((Object)"naming exception", (Throwable)e);
            throw new EJBException((Exception)e);
        }
    }

    public Map convertFISStaffValueObjectToValueMap(FisStaffCacheValue cacheValue) {
        HashMap<String, String> staffValues = new HashMap<String, String>();
        if (cacheValue.getPersonalNumber() != null) {
            staffValues.put("StaffAllocationPersonalNumber", cacheValue.getPersonalNumber());
        }
        if (cacheValue.getFirstName() != null && !cacheValue.getFirstName().trim().equals("") && cacheValue.getLastName() != null && !cacheValue.getLastName().trim().equals("")) {
            staffValues.put("StaffAllocationName", cacheValue.getFirstName() + " " + cacheValue.getLastName());
        } else if (cacheValue.getShortName() != null) {
            staffValues.put("StaffAllocationName", cacheValue.getShortName());
        }
        if (cacheValue.getTeamId() != null) {
            staffValues.put("StaffAllocationTeamID", cacheValue.getTeamId());
        }
        if (cacheValue.getStaffFunctionCode() != null) {
            staffValues.put("StaffAllocationFuntionCode", cacheValue.getStaffFunctionCode());
        }
        return staffValues;
    }

    public Map convertFISGSEValueObjectToStandsData(FisGseCacheValue cacheValue) {
        HashMap<String, String> gseValues = new HashMap<String, String>();
        String customerGseCode = cacheValue.getCustomerGseCode();
        try {
            UnitDTO unitDTO = this.commonDataFacade.getUnitDTOByName(customerGseCode);
            String registrationNumber = unitDTO.getUnitModelValue().getRegistrationNumber();
            String modelType = unitDTO.getUnitModelValue().getModelType();
            if (unitDTO.getUnitId() != null) {
                String driverName;
                long unitId = unitDTO.getUnitId();
                if (customerGseCode != null) {
                    gseValues.put("GSEAllocationGSEID", customerGseCode);
                }
                if (registrationNumber != null) {
                    gseValues.put("GSEAllocationRegistrationNumber", registrationNumber);
                }
                if ((driverName = this.getCurrentDriverName(unitId)) != null) {
                    gseValues.put("GSEAllocationDriverName", driverName);
                }
                if (modelType != null) {
                    gseValues.put("GSEAllocationGSEType", modelType);
                }
            } else {
                log.error((Object)("Could not find unitId for GSE " + customerGseCode));
            }
        }
        catch (FinderException e) {
            log.error((Object)e.getMessage());
        }
        return gseValues;
    }

    private String getCurrentDriverName(long unitId) {
        UseDTOList useDTOList = this.currentDataFacade.getCurrentUse(unitId, null, false);
        Iterator it = useDTOList.iterator();
        if (it.hasNext()) {
            UseDTO useDTO = (UseDTO)it.next();
            return useDTO.getUseUserName();
        }
        return null;
    }
}

