/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.notify;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.logic.app.notify.event.NotifyEvent;
import de.proveo.wwt.logic.ejb.dataIn.notify.cache.CurrentNotifyCacheLocal;
import de.proveo.wwt.logic.ejb.dataIn.notify.cache.CurrentNotifyCacheLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.notify.cache.CurrentNotifyCachePK;
import de.proveo.wwt.logic.ejb.dataIn.notify.cache.CurrentNotifyCacheUtil;
import de.proveo.wwt.logic.ejb.dataIn.notify.cache.CurrentNotifyCacheValue;
import de.proveo.wwt.logic.ejb.dataIn.notify.exception.NotifyWriteException;
import de.proveo.wwt.logic.ejb.dataIn.notify.history.NotifyHistoryLocal;
import de.proveo.wwt.logic.ejb.dataIn.notify.history.NotifyHistoryLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.notify.history.NotifyHistoryUtil;
import de.proveo.wwt.logic.ejb.dataIn.notify.history.NotifyHistoryValue;
import de.proveo.wwt.logic.ejb.general.area.AreaLocal;
import de.proveo.wwt.logic.ejb.general.area.AreaLocalHome;
import de.proveo.wwt.logic.ejb.general.area.AreaPK;
import de.proveo.wwt.logic.ejb.general.area.AreaUtil;
import de.proveo.wwt.logic.ejb.general.notification.NotificationValue;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelLocal;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserLocal;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserLocalHome;
import de.proveo.wwt.logic.ejb.general.use.user.UseUserUtil;
import de.proveo.wwt.logic.ejb.transaction.ImplicitRollbackException;
import de.proveo.wwt.logic.web.admin.AdminFacadeLocal;
import de.proveo.wwt.logic.web.admin.AdminFacadeUtil;
import java.util.Collection;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class NotifyFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final Log log = LogFactory.getLog(NotifyFacadeBean.class);
    private CurrentNotifyCacheLocalHome cacheHome;
    private NotifyHistoryLocalHome historyHome;
    private AdminFacadeLocal adminFacade;
    private UseUserLocalHome useUserHome;
    private AreaLocalHome areaHome;

    public void ejbCreate() throws CreateException {
        try {
            this.cacheHome = CurrentNotifyCacheUtil.getLocalHome();
            this.historyHome = NotifyHistoryUtil.getLocalHome();
            this.adminFacade = AdminFacadeUtil.getLocalHome().create();
            this.useUserHome = UseUserUtil.getLocalHome();
            this.areaHome = AreaUtil.getLocalHome();
        }
        catch (Exception ex) {
            log.error((Object)"runs during lookup other beans into", (Throwable)ex);
            throw new CreateException("can't find Entity Beans: " + ex.getMessage());
        }
    }

    public SerializableEventWrapper event(Properties event, long unitId, String area) throws ImplicitRollbackException {
        CurrentNotifyCacheValue notifyEvent = new CurrentNotifyCacheValue();
        notifyEvent.setMessageId(Long.parseLong(event.getProperty("nm")));
        notifyEvent.setEntry(Integer.parseInt(event.getProperty("ne")) == 1);
        notifyEvent.setCreateTime(Long.parseLong(event.getProperty("t")));
        notifyEvent.setReceiveTime(System.currentTimeMillis());
        notifyEvent.setUnitId(unitId);
        String userKey = event.getProperty("nuu");
        if (userKey != null) {
            notifyEvent.setRemark(userKey);
        }
        String areaKey = event.getProperty("area", area);
        AreaLocal areaLocal = null;
        if (areaKey != null) {
            try {
                areaLocal = this.areaHome.findByPrimaryKey(new AreaPK(areaKey));
            }
            catch (ObjectNotFoundException ex) {
                notifyEvent.setRemark(areaKey);
            }
            catch (FinderException ex) {
                throw new EJBException((Exception)((Object)ex));
            }
        }
        CurrentNotifyCacheLocal cache = null;
        SerializableEventWrapper wrapper = null;
        try {
            cache = this.writeCache(notifyEvent, userKey);
            if (cache != null) {
                cache.setArea(areaLocal);
                this.writeHistory(notifyEvent, cache);
                long messageId = notifyEvent.getMessageId();
                String message = "";
                NotificationValue value = this.adminFacade.getNotificationById((int)messageId);
                if (value != null) {
                    message = value.getDefaultName();
                }
                NotifyEvent eventWraper = new NotifyEvent(notifyEvent.getUnitId(), notifyEvent.getMessageId(), message, notifyEvent.getEntry(), notifyEvent.getCreateTime(), notifyEvent.getReceiveTime());
                wrapper = new SerializableEventWrapper(eventWraper);
                wrapper.set_typeOfEvent("InfomanNotifyMessages");
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("event() duplicate transmission: " + event));
            }
            return wrapper;
        }
        catch (NotifyWriteException e) {
            throw new ImplicitRollbackException(e.toString());
        }
    }

    public void writeHistory(CurrentNotifyCacheValue event, CurrentNotifyCacheLocal cache) throws NotifyWriteException {
        NotifyHistoryValue struct = new NotifyHistoryValue();
        struct.setUnitId(event.getUnitId());
        struct.setMessageId(event.getMessageId());
        struct.setCreateTime(event.getCreateTime());
        struct.setEntry(event.getEntry());
        struct.setReceiveTime(event.getReceiveTime());
        struct.setRemark(event.getRemark());
        try {
            NotifyHistoryLocal history;
            try {
                history = this.historyHome.create(struct);
            }
            catch (DuplicateKeyException ex) {
                log.debug((Object)"writeHistory() duplicate key");
                this.historyHome.reorganizeSequence();
                history = this.historyHome.create(struct);
                log.debug((Object)"writeHistory() succesful after sequence fixed");
            }
            history.setGroupHistoryId(cache.getGroupHistoryId());
            history.setUseUser(cache.getUseUser());
            history.setArea(cache.getArea());
        }
        catch (Exception ex) {
            String msg = "writeHistory() runs druing create into " + ex.toString();
            log.error((Object)msg);
            throw new NotifyWriteException(msg);
        }
    }

    protected CurrentNotifyCacheLocal writeCache(CurrentNotifyCacheValue event, String userKey) throws NotifyWriteException {
        CurrentNotifyCachePK pk = new CurrentNotifyCachePK(event.getUnitId(), event.getMessageId());
        CurrentNotifyCacheLocal cache = null;
        UseUserLocal useUser = null;
        if (userKey != null) {
            try {
                Collection users = this.useUserHome.findByKey(userKey);
                if (users.size() > 0) {
                    useUser = (UseUserLocal)users.iterator().next();
                } else {
                    event.setRemark(userKey);
                }
            }
            catch (FinderException ex) {
                throw new EJBException((Exception)((Object)ex));
            }
        }
        try {
            cache = this.cacheHome.findByPrimaryKey(pk);
            if (event.getCreateTime() <= cache.getCreateTime()) {
                return null;
            }
            if (cache.change(event)) {
                cache.setGroupHistoryId(this.adminFacade.getGrouphistoryLocalForUnit(event.getUnitId(), event.getCreateTime()));
                cache.setUseUser(useUser);
                return cache;
            }
            return null;
        }
        catch (FinderException findEx) {
            try {
                cache = this.cacheHome.create(event);
                cache.setGroupHistoryId(this.adminFacade.getGrouphistoryLocalForUnit(event.getUnitId(), event.getCreateTime()));
                cache.setUseUser(useUser);
                return cache;
            }
            catch (Exception ex) {
                String msg = "writeCache() runs during create into" + ex.toString();
                log.error((Object)msg, (Throwable)ex);
                throw new NotifyWriteException(msg);
            }
        }
    }

    public Collection getNotifiesFromHistory(long unitId, long startTime, long endTime) {
        try {
            return this.historyHome.findByUnitId(unitId, startTime, endTime);
        }
        catch (Exception ex) {
            log.error((Object)("getNotifiesFromHistory() runs during looking for unitId=" + unitId + ".and startTime=" + startTime + ".and endTime" + endTime + " into"), (Throwable)ex);
            throw new EJBException("getNotifiesFromHistory() runs during looking for unitId=" + unitId + ".and startTime=" + startTime + ".and endTime" + endTime + " into " + ex.getMessage());
        }
    }

    public boolean moveCacheDataToHistoryForDeletedUnit(UnitModelLocal unitModel) {
        Collection currentNotifyCaches = unitModel.getCurrentNotifyCaches();
        CurrentNotifyCacheLocal[] currArr = currentNotifyCaches.toArray(new CurrentNotifyCacheLocal[currentNotifyCaches.size()]);
        for (int k = 0; k != currArr.length; ++k) {
            CurrentNotifyCacheLocal currentNotifyLocal = currArr[k];
            try {
                if (currentNotifyLocal == null) continue;
                currentNotifyLocal.remove();
                continue;
            }
            catch (EJBException e) {
                log.error((Object)"runs into", (Throwable)e);
                continue;
            }
            catch (RemoveException e) {
                log.error((Object)"runs into", (Throwable)e);
            }
        }
        return true;
    }
}

