/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.geo;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.logic.app.geo.GeoStruct;
import de.proveo.wwt.logic.ejb.dataIn.geo.cache.CurrentGdataCacheLocal;
import de.proveo.wwt.logic.ejb.dataIn.geo.cache.CurrentGdataCacheLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.geo.cache.CurrentGdataCachePK;
import de.proveo.wwt.logic.ejb.dataIn.geo.cache.CurrentGdataCacheUtil;
import de.proveo.wwt.logic.ejb.dataIn.geo.history.GdataHistoryLocal;
import de.proveo.wwt.logic.ejb.dataIn.geo.history.GdataHistoryLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.geo.history.GdataHistoryUtil;
import de.proveo.wwt.logic.ejb.general.geo.exception.GeoWriteException;
import de.proveo.wwt.logic.ejb.general.unit.entity.model.UnitModelLocal;
import de.proveo.wwt.logic.ejb.transaction.ImplicitRollbackException;
import de.proveo.wwt.logic.web.admin.AdminFacadeLocal;
import de.proveo.wwt.logic.web.admin.AdminFacadeUtil;
import java.util.Collection;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class GdataFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final Log log = LogFactory.getLog(GdataFacadeBean.class);
    private boolean useBMT = false;
    private CurrentGdataCacheLocalHome currGdataHome;
    private GdataHistoryLocalHome gDataHisHome;
    private AdminFacadeLocal adminFacade;
    private static final int DEFAULT_MAX_REASON_LENGTH = 20;
    private int maxReasonLength = 20;

    public void ejbCreate() throws CreateException {
        this.lookupOtherBeans();
        try {
            InitialContext ctx = new InitialContext();
            this.maxReasonLength = (Integer)ctx.lookup("java:comp/env/maxReasonLength");
        }
        catch (Exception ex) {
            log.warn((Object)"ejbCreate() runs during lookup env entries into", (Throwable)ex);
            this.maxReasonLength = 20;
        }
    }

    public SerializableEventWrapper event(GeoStruct event) throws ImplicitRollbackException {
        if (event.getReason() != null && event.getReason().length() > this.maxReasonLength) {
            String oldReason = event.getReason();
            event.setReason(oldReason.substring(0, this.maxReasonLength));
            if (log.isWarnEnabled()) {
                log.warn((Object)("event() reason exceeded maximumlength of " + this.maxReasonLength + " cutted off. orignal: " + oldReason + " cutted to: " + event.getReason()));
            }
        }
        SerializableEventWrapper wrapper = new SerializableEventWrapper();
        try {
            CurrentGdataCacheLocal gCache = this.currGdataHome.findByPrimaryKey(new CurrentGdataCachePK(event.getUnitId()));
            GeoStruct cacheStruct = gCache.getStruct();
            if (cacheStruct.getBeginTime() >= event.getBeginTime()) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("double transmission: " + event));
                }
                return null;
            }
            GeoStruct histStruct = new GeoStruct(cacheStruct.getUnitId(), cacheStruct.getBeginTime(), cacheStruct.getBeginReceiveTime(), event.getBeginTime(), event.getBeginReceiveTime(), cacheStruct.getPkGdataPrevious(), cacheStruct.getRmcRec(), cacheStruct.getGgaRec(), cacheStruct.getArea(), cacheStruct.getAreaDescription(), cacheStruct.isTrusted(), cacheStruct.getReason(), cacheStruct.getLongMSEC(), cacheStruct.getLatMSEC());
            long pkGdataHistoryPre = 0L;
            try {
                pkGdataHistoryPre = this.writeHistory(histStruct);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("pkGdataHistoryPre after writeHistory : " + pkGdataHistoryPre));
                }
                wrapper.set_historyValue(histStruct);
                cacheStruct.setPkGdataPrevious(pkGdataHistoryPre);
            }
            catch (GeoWriteException gwe) {
                throw new ImplicitRollbackException(gwe.getMessage());
            }
            if (event.getRmcRec().length() == 0 && event.getGgaRec().length() == 0 && !event.isTrusted() && (long)event.getLatMSEC() == 0L && (long)event.getLongMSEC() == 0L) {
                log.debug((Object)"Empty GPS records, not 'trusted' -> update only 'trusted' flag and timestamps");
                GeoStruct special = new GeoStruct(cacheStruct.getUnitId(), event.getBeginTime(), event.getBeginReceiveTime(), 0L, 0L, cacheStruct.getPkGdataPrevious(), cacheStruct.getRmcRec(), cacheStruct.getGgaRec(), cacheStruct.getArea(), cacheStruct.getAreaDescription(), event.isTrusted(), event.getReason());
                gCache.setStruct(special, pkGdataHistoryPre);
                wrapper.set_cacheValue(special);
                wrapper.set_PkGdataHistoryPre(pkGdataHistoryPre);
            } else if (!event.isTrusted()) {
                cacheStruct.setBeginTime(event.getBeginTime());
                cacheStruct.setBeginReceiveTime(event.getBeginReceiveTime());
                cacheStruct.setTrusted(false);
                cacheStruct.setReason(event.getReason());
                gCache.setStruct(cacheStruct, pkGdataHistoryPre);
                wrapper.set_cacheValue(gCache.getStruct());
                wrapper.set_PkGdataHistoryPre(pkGdataHistoryPre);
            } else {
                gCache.setStruct(event, pkGdataHistoryPre);
                gCache.setGroupHistoryId(this.adminFacade.getGrouphistoryLocalForUnit(event.getUnitId(), event.getBeginTime()));
                event.setPkGdataPrevious(pkGdataHistoryPre);
                wrapper.set_cacheValue(gCache.getStruct());
                wrapper.set_PkGdataHistoryPre(pkGdataHistoryPre);
            }
        }
        catch (FinderException fe) {
            try {
                this.writeCache(event);
                return null;
            }
            catch (GeoWriteException gwe) {
                throw new ImplicitRollbackException(gwe.getMessage());
            }
        }
        if (log.isWarnEnabled()) {
            if (wrapper.get_cacheValue() == null) {
                log.warn((Object)"cacheValue of serializable event wrapper is null");
            }
            if (wrapper.get_historyValue() == null) {
                log.warn((Object)"historyValue of serializable event wrapper is null");
            }
        }
        wrapper.set_typeOfEvent("GeoStructHistoryAndCache");
        return wrapper;
    }

    public String getCurrentArea(long unitId) throws FinderException {
        Collection col = this.currGdataHome.findByUnitId(unitId);
        Iterator it = col.iterator();
        if (it.hasNext()) {
            CurrentGdataCacheLocal gdataCache = (CurrentGdataCacheLocal)it.next();
            GeoStruct geoStruct = gdataCache.getStruct();
            return geoStruct.getArea();
        }
        throw new FinderException();
    }

    protected void writeCache(GeoStruct event) throws GeoWriteException {
        try {
            this.currGdataHome.create(event, 0L);
            log.debug((Object)"*new* entry into CurrentGdataCache");
        }
        catch (Exception e) {
            String msg = "writeCache(): runs during CurrentGdataCache.create() into ";
            log.error((Object)msg, (Throwable)e);
            throw new GeoWriteException(msg, e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long writeHistory(GeoStruct event) throws GeoWriteException {
        try {
            GdataHistoryLocal history = this.gDataHisHome.create(event);
            history.setGroupHistoryId(this.adminFacade.getGrouphistoryLocalForUnit(event.getUnitId(), event.getBeginTime()));
            return history.getGDataHistoryId();
        }
        catch (DuplicateKeyException ex) {
            try {
                this.gDataHisHome.reorganizeSequence();
                GdataHistoryLocal history = this.gDataHisHome.create(event);
                history.setGroupHistoryId(this.adminFacade.getGrouphistoryLocalForUnit(event.getUnitId(), event.getBeginTime()));
                return history.getGDataHistoryId();
                catch (Exception ex2) {
                    log.debug((Object)("create history runs into " + ex2.getMessage()));
                    if (this.fixDuplicateHistoryEntry(event)) {
                        log.debug((Object)"try to create history after successful fixDuplicateHistoryEntry");
                        history = this.gDataHisHome.create(event);
                        history.setGroupHistoryId(this.adminFacade.getGrouphistoryLocalForUnit(event.getUnitId(), event.getBeginTime()));
                        return history.getGDataHistoryId();
                    }
                    throw ex2;
                }
            }
            catch (Exception e) {
                String msg = "writeHistory(): runs during GdataHistory.create() into " + e.getMessage();
                log.error((Object)msg, (Throwable)e);
                throw new GeoWriteException(msg, e);
            }
        }
    }

    public void lookupOtherBeans() throws EJBException {
        try {
            this.currGdataHome = CurrentGdataCacheUtil.getLocalHome();
            this.gDataHisHome = GdataHistoryUtil.getLocalHome();
            this.adminFacade = AdminFacadeUtil.getLocalHome().create();
        }
        catch (Exception ex) {
            log.error((Object)"runs during find Entity Bean into", (Throwable)ex);
            throw new EJBException(ex);
        }
    }

    public boolean moveCacheDataToHistoryForDeletedUnit(UnitModelLocal unitModel) {
        long timeNow = System.currentTimeMillis();
        try {
            Collection gCacheCol = this.currGdataHome.findByUnitId(unitModel.getUnitId());
            if (gCacheCol.size() == 0) {
                return true;
            }
            for (Object obj : gCacheCol) {
                CurrentGdataCacheLocal gCache = (CurrentGdataCacheLocal)obj;
                if (gCache == null) continue;
                GeoStruct cacheStruct = gCache.getStruct();
                GeoStruct histStruct = new GeoStruct(cacheStruct.getUnitId(), cacheStruct.getBeginTime(), cacheStruct.getBeginReceiveTime(), timeNow, timeNow, cacheStruct.getPkGdataPrevious(), cacheStruct.getRmcRec(), cacheStruct.getGgaRec(), cacheStruct.getArea(), cacheStruct.getAreaDescription(), cacheStruct.isTrusted(), cacheStruct.getReason(), cacheStruct.getLongMSEC(), cacheStruct.getLatMSEC());
                long pkGdataHistoryPre = 0L;
                try {
                    pkGdataHistoryPre = this.writeHistory(histStruct);
                }
                catch (GeoWriteException e) {
                    log.error((Object)"runs into", (Throwable)e);
                }
                try {
                    if (gCache == null) continue;
                    gCache.remove();
                }
                catch (EJBException e) {
                    log.error((Object)"runs into", (Throwable)e);
                }
                catch (RemoveException e) {
                    log.error((Object)"runs into", (Throwable)e);
                }
            }
        }
        catch (FinderException e1) {
            log.debug((Object)"runs into", (Throwable)e1);
        }
        return true;
    }

    private boolean fixDuplicateHistoryEntry(GeoStruct geoStruct) {
        log.debug((Object)("fixDuplicateHistoryEntry() with " + geoStruct));
        try {
            Collection duplicates = this.gDataHisHome.findByUnitIdBegintime(geoStruct.getUnitId(), geoStruct.getBeginTime());
            if (duplicates != null) {
                for (GdataHistoryLocal gdataHistoryLocal : duplicates) {
                    if (gdataHistoryLocal == null) continue;
                    log.debug((Object)("remove: " + gdataHistoryLocal.getStruct()));
                    gdataHistoryLocal.remove();
                    log.info((Object)"Removed duplicate GdataHistory entry!");
                    return true;
                }
            }
        }
        catch (FinderException e) {
        }
        catch (EJBException e) {
            log.error((Object)"fixDuplicateHistoryEntry runs into", (Throwable)e);
        }
        catch (RemoveException e) {
            log.error((Object)"fixDuplicateHistoryEntry runs into", (Throwable)e);
        }
        log.debug((Object)"fixDuplicateHistoryEntry not successful!");
        return false;
    }
}

