/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.fisStaff;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.logic.ejb.dataIn.fisStaff.cache.FisStaffCacheLocal;
import de.proveo.wwt.logic.ejb.dataIn.fisStaff.cache.FisStaffCacheLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.fisStaff.cache.FisStaffCachePK;
import de.proveo.wwt.logic.ejb.dataIn.fisStaff.cache.FisStaffCacheUtil;
import de.proveo.wwt.logic.ejb.dataIn.fisStaff.cache.FisStaffCacheValue;
import de.proveo.wwt.logic.ejb.dataIn.fisStaff.history.FisStaffHistoryUtil;
import de.proveo.wwt.logic.ejb.dataIn.fisStaff.history.FisStaffHistoryValue;
import de.proveo.wwt.logic.ejb.dataIn.observable.ObservableFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.observable.ObservableFacadeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FisStaffFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final Log log = LogFactory.getLog(FisStaffFacadeBean.class);
    private FisStaffCacheLocalHome fisStaffCacheLocalHome;

    @Override
    public void ejbCreate() throws CreateException {
        try {
            this.fisStaffCacheLocalHome = FisStaffCacheUtil.getLocalHome();
        }
        catch (NamingException ex) {
            throw new EJBException("problem during lookup other EJBs: " + ex.getMessage());
        }
    }

    public void updateStaffAllocation(FisStaffCacheValue fisStaffCacheValue) {
        if (fisStaffCacheValue.getPersonalNumber() == null) {
            log.error((Object)"Can't update staff allocation without personal number");
        } else {
            try {
                FisStaffCacheLocal staffCacheLocal = this.getStaffCacheLocal(fisStaffCacheValue.getPersonalNumber(), fisStaffCacheValue.getUniqueFlightNumber());
                staffCacheLocal.setFisStaffCacheValue(fisStaffCacheValue);
            }
            catch (FinderException e) {
                try {
                    FisStaffCacheLocal gseCacheLocal = this.fisStaffCacheLocalHome.create(fisStaffCacheValue);
                }
                catch (CreateException e1) {
                    log.error((Object)"runs into", (Throwable)e1);
                }
            }
            try {
                log.debug((Object)"send event of type STAFF_ALLOCATION_EVENT_UPDATE to JMS with selector STAFF_ALLOCATION_EVENT");
                SerializableEventWrapper wrapper = new SerializableEventWrapper(fisStaffCacheValue);
                wrapper.set_typeOfEvent("StaffAllocationEventUpdate");
                ObservableFacadeLocal observableFacade = ObservableFacadeUtil.getLocalHome().create();
                observableFacade.notifyClients(wrapper, "StaffAllocationEvent");
            }
            catch (CreateException e) {
                log.error((Object)"runs into", (Throwable)e);
            }
            catch (NamingException e) {
                log.error((Object)"runs into", (Throwable)e);
            }
        }
    }

    public void deleteStaffAllocation(FisStaffCacheValue fisStaffCacheValue) {
        if (fisStaffCacheValue.getPersonalNumber() == null) {
            log.error((Object)"Can't remove staff allocation without personalNumber");
        } else {
            this.moveStaffAssignmentToHistory(fisStaffCacheValue.getPersonalNumber(), fisStaffCacheValue.getUniqueFlightNumber());
            try {
                log.debug((Object)"send event of type STAFF_ALLOCATION_EVENT_DELETE to JMS with selector STAFF_ALLOCATION_EVENT");
                SerializableEventWrapper wrapper = new SerializableEventWrapper(fisStaffCacheValue);
                wrapper.set_typeOfEvent("StaffAllocationEventDelete");
                ObservableFacadeLocal observableFacade = ObservableFacadeUtil.getLocalHome().create();
                observableFacade.notifyClients(wrapper, "StaffAllocationEvent");
            }
            catch (CreateException e) {
                log.error((Object)"runs into", (Throwable)e);
            }
            catch (NamingException e) {
                log.error((Object)"runs into", (Throwable)e);
            }
        }
    }

    public void moveStaffAssignmentToHistory(String personalNumber, String uniqueFlightNumber) {
        try {
            FisStaffCacheLocal staffCache = this.fisStaffCacheLocalHome.findByPrimaryKey(new FisStaffCachePK(personalNumber, uniqueFlightNumber));
            FisStaffCacheValue staffCacheValue = staffCache.getFisStaffCacheValue();
            FisStaffHistoryValue staffHistoryValue = new FisStaffHistoryValue();
            staffHistoryValue.setReceiveTime(staffCacheValue.getReceiveTime());
            staffHistoryValue.setPersonalNumber(staffCacheValue.getPersonalNumber());
            staffHistoryValue.setCustomerCreateTime(staffCacheValue.getCustomerCreateTime());
            staffHistoryValue.setFirstName(staffCacheValue.getFirstName());
            staffHistoryValue.setLastName(staffCacheValue.getLastName());
            staffHistoryValue.setShortName(staffCacheValue.getShortName());
            staffHistoryValue.setUniqueFlightNumber(staffCacheValue.getUniqueFlightNumber());
            staffHistoryValue.setTeamId(staffCacheValue.getTeamId());
            staffHistoryValue.setStaffFunctionCode(staffCacheValue.getStaffFunctionCode());
            FisStaffHistoryUtil.getLocalHome().create(staffHistoryValue);
            staffCache.remove();
        }
        catch (FinderException e) {
            log.debug((Object)("Could not find staff allocation of staff nr. " + personalNumber + " to flight " + uniqueFlightNumber));
        }
        catch (CreateException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        catch (NamingException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        catch (EJBException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        catch (RemoveException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
    }

    private FisStaffCacheLocal getStaffCacheLocal(String personalNumber, String uniqueFlightNumber) throws FinderException {
        Collection col = this.fisStaffCacheLocalHome.findByPersonalNumber(personalNumber);
        if (col.isEmpty() || col.size() == 0) {
            throw new FinderException("Could not find staff allocation for personal number " + personalNumber);
        }
        for (FisStaffCacheLocal staffCache : col) {
            if (!staffCache.getUniqueFlightNumber().equals(uniqueFlightNumber)) continue;
            return staffCache;
        }
        throw new FinderException("Could not find staff allocation for personal number " + personalNumber + " and flight " + uniqueFlightNumber);
    }

    public Collection<FisStaffCacheValue> getAllCacheStaffAssignments() throws FinderException {
        Collection collectionFisStaffCacheLocal = this.fisStaffCacheLocalHome.findAll();
        ArrayList<FisStaffCacheValue> fisStaffValueCollection = new ArrayList<FisStaffCacheValue>();
        for (FisStaffCacheLocal staffCacheLocal : collectionFisStaffCacheLocal) {
            fisStaffValueCollection.add(staffCacheLocal.getFisStaffCacheValue());
        }
        return fisStaffValueCollection;
    }

    public FisStaffCacheValue findByPersonalNumberAndFlightNumber(String personalNumber, String uniqueFlightNumber) {
        FisStaffCacheValue fisStaffCacheValue = null;
        try {
            Collection staffs = this.fisStaffCacheLocalHome.findByPersonalNumberAndFlightNumber(personalNumber, uniqueFlightNumber);
            if (staffs.size() > 0) {
                Iterator i$;
                if (staffs.size() > 1) {
                    log.debug((Object)("could not get unique staff allocation for personal number " + personalNumber + " and flight " + uniqueFlightNumber));
                }
                if ((i$ = staffs.iterator()).hasNext()) {
                    Object staffObject = i$.next();
                    return ((FisStaffCacheLocal)staffObject).getFisStaffCacheValue();
                }
            }
        }
        catch (FinderException e) {
            log.debug((Object)("could not find staff allocation for personal number " + personalNumber + " and flight " + uniqueFlightNumber));
        }
        if (fisStaffCacheValue == null) {
            log.debug((Object)("could not find staff allocation for personal number " + personalNumber + " and flight " + uniqueFlightNumber));
        }
        return fisStaffCacheValue;
    }

    public FisStaffCacheValue createStaffAllocation(String personalNumber, String uniqueFlightNumber) {
        FisStaffCacheValue fisStaffCacheValue = new FisStaffCacheValue();
        try {
            FisStaffCacheLocal fisStaffCacheLocal = this.fisStaffCacheLocalHome.create(personalNumber, uniqueFlightNumber);
            fisStaffCacheValue = fisStaffCacheLocal.getFisStaffCacheValue();
            return fisStaffCacheValue;
        }
        catch (CreateException e) {
            log.error((Object)"runs into", (Throwable)e);
            return fisStaffCacheValue;
        }
    }

    public ArrayList<String> getPersonalNumbersForFlight(String uniqueFlightNumber) {
        ArrayList<String> personalNumbers = new ArrayList<String>();
        try {
            Collection colStaff = this.fisStaffCacheLocalHome.findByUniqueFlightNumber(uniqueFlightNumber);
            for (Object staff : colStaff) {
                personalNumbers.add(((FisStaffCacheLocal)staff).getPersonalNumber());
            }
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return personalNumbers;
    }
}

