/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.fisGse;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.logic.ejb.dataIn.event.EventFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.event.EventFacadeUtil;
import de.proveo.wwt.logic.ejb.dataIn.fisGse.cache.FisGseCacheLocal;
import de.proveo.wwt.logic.ejb.dataIn.fisGse.cache.FisGseCacheLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.fisGse.cache.FisGseCachePK;
import de.proveo.wwt.logic.ejb.dataIn.fisGse.cache.FisGseCacheUtil;
import de.proveo.wwt.logic.ejb.dataIn.fisGse.cache.FisGseCacheValue;
import de.proveo.wwt.logic.ejb.dataIn.fisGse.history.FisGseHistoryUtil;
import de.proveo.wwt.logic.ejb.dataIn.fisGse.history.FisGseHistoryValue;
import de.proveo.wwt.logic.ejb.dataIn.observable.ObservableFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.observable.ObservableFacadeUtil;
import de.proveo.wwt.logic.ejb.dataIn.state.CurrentStateFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.state.CurrentStateFacadeStruct;
import de.proveo.wwt.logic.ejb.dataIn.state.CurrentStateFacadeUtil;
import de.proveo.wwt.logic.ejb.dataIn.state.exception.NoStateFoundException;
import de.proveo.wwt.logic.ejb.dataIn.state.exception.StatesForUnitNotFoundException;
import de.proveo.wwt.logic.ejb.transaction.ImplicitRollbackException;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.commonData.CommonDataFacadeLocal;
import de.proveo.wwt.logic.web.commonData.CommonDataFacadeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FisGSEFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final Log log = LogFactory.getLog(FisGSEFacadeBean.class);
    private FisGseCacheLocalHome fisGseCacheLocalHome;
    private CurrentStateFacadeLocal currentStateFacadeLocal;
    private CommonDataFacadeLocal commonDataFacadeBean;
    private EventFacadeLocal eventFacadeBean;

    @Override
    public void ejbCreate() throws CreateException {
        super.ejbCreate();
        try {
            this.fisGseCacheLocalHome = FisGseCacheUtil.getLocalHome();
            this.currentStateFacadeLocal = CurrentStateFacadeUtil.getLocalHome().create();
            this.commonDataFacadeBean = CommonDataFacadeUtil.getLocalHome().create();
            this.eventFacadeBean = EventFacadeUtil.getLocalHome().create();
        }
        catch (NamingException ex) {
            throw new EJBException("problem during lookup other EJBs: " + ex.getMessage());
        }
    }

    public void updateGSEAllocation(FisGseCacheValue fisGseCacheValue) {
        if (fisGseCacheValue.getCustomerGseCode() == null) {
            log.error((Object)"Can't update GSE allocation without customer unit id");
        } else {
            String gseName = fisGseCacheValue.getCustomerGseCode();
            if (this.gseExists(gseName)) {
                try {
                    FisGseCacheLocal gseCacheLocal = this.getGseCacheLocal(fisGseCacheValue.getCustomerGseCode(), fisGseCacheValue.getUniqueFlightNumber());
                    gseCacheLocal.setFisGseCacheValue(fisGseCacheValue);
                }
                catch (FinderException e) {
                    try {
                        FisGseCacheLocal gseCacheLocal = this.fisGseCacheLocalHome.create(fisGseCacheValue);
                    }
                    catch (CreateException e1) {
                        log.error((Object)"runs into", (Throwable)e1);
                    }
                }
                try {
                    log.debug((Object)"send event of type GSE_ALLOCATION_EVENT_UPDATE to JMS with selector GSE_ALLOATION_EVENT");
                    SerializableEventWrapper wrapper = new SerializableEventWrapper(fisGseCacheValue);
                    wrapper.set_typeOfEvent("GSEAllocationEventUpdate");
                    ObservableFacadeLocal observableFacade = ObservableFacadeUtil.getLocalHome().create();
                    observableFacade.notifyClients(wrapper, "GSEAllocationEvent");
                }
                catch (CreateException e) {
                    log.error((Object)"runs into", (Throwable)e);
                }
                catch (NamingException e) {
                    log.error((Object)"runs into", (Throwable)e);
                }
            } else {
                log.warn((Object)("GSE allocation isn't saved to the DB because GSE with name " + gseName + " doesn't exist."));
            }
        }
    }

    private boolean gseExists(String gseName) {
        try {
            UnitDTO unitDTOByName = this.commonDataFacadeBean.getUnitDTOByName(gseName);
            if (unitDTOByName != null) {
                return true;
            }
        }
        catch (FinderException e) {
            return false;
        }
        return false;
    }

    public void deleteGSEAllocation(FisGseCacheValue fisGseCacheValue) {
        if (fisGseCacheValue.getCustomerGseCode() == null) {
            log.error((Object)"Can't remove GSE allocation without customer unit id");
        } else {
            this.moveGSEAssignmentToHistory(fisGseCacheValue.getCustomerGseCode(), fisGseCacheValue.getUniqueFlightNumber());
            try {
                log.debug((Object)"send event of type GSE_ALLOCATION_EVENT_DELETE to JMS with selector GSE_ALLOATION_EVENT");
                SerializableEventWrapper wrapper = new SerializableEventWrapper(fisGseCacheValue);
                wrapper.set_typeOfEvent("GSEAllocationEventDelete");
                ObservableFacadeLocal observableFacade = ObservableFacadeUtil.getLocalHome().create();
                observableFacade.notifyClients(wrapper, "GSEAllocationEvent");
            }
            catch (CreateException e) {
                log.error((Object)"runs into", (Throwable)e);
            }
            catch (NamingException e) {
                log.error((Object)"runs into", (Throwable)e);
            }
        }
    }

    public void moveGSEAssignmentToHistory(String gseCode, String uniqueFlightNumber) {
        try {
            FisGseCacheLocal gseCache = this.fisGseCacheLocalHome.findByPrimaryKey(new FisGseCachePK(gseCode, uniqueFlightNumber));
            FisGseCacheValue gseCacheValue = gseCache.getFisGseCacheValue();
            FisGseHistoryValue gseHistoryValue = new FisGseHistoryValue();
            gseHistoryValue.setReceiveTime(gseCacheValue.getReceiveTime());
            gseHistoryValue.setCustomerGseCode(gseCacheValue.getCustomerGseCode());
            gseHistoryValue.setCustomerCreateTime(gseCacheValue.getCustomerCreateTime());
            gseHistoryValue.setGseDescription(gseCacheValue.getGseDescription());
            gseHistoryValue.setUniqueFlightNumber(gseCacheValue.getUniqueFlightNumber());
            FisGseHistoryUtil.getLocalHome().create(gseHistoryValue);
            gseCache.remove();
        }
        catch (FinderException e) {
            log.debug((Object)("Could not find GSE allocation of GSE " + gseCode + " to flight " + uniqueFlightNumber));
        }
        catch (CreateException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        catch (NamingException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        catch (EJBException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        catch (RemoveException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
    }

    private FisGseCacheLocal getGseCacheLocal(String customerGSECode, String uniqueFlightNumber) throws FinderException {
        Collection col = this.fisGseCacheLocalHome.findByCustomerGseCode(customerGSECode);
        if (col.isEmpty() || col.size() == 0) {
            throw new FinderException("Could not find GSE allocation for GSE " + customerGSECode);
        }
        for (FisGseCacheLocal gseCache : col) {
            if (!gseCache.getUniqueFlightNumber().equals(uniqueFlightNumber)) continue;
            return gseCache;
        }
        throw new FinderException("Could not find GSE allocation for GSE " + customerGSECode + " and flight " + uniqueFlightNumber);
    }

    public void setGSEAssignmentState(long unitId, long stateId, long beginTime, String rkey) {
        long receiveTime = System.currentTimeMillis();
        boolean update = false;
        try {
            CurrentStateFacadeStruct currentStateStruct = this.currentStateFacadeLocal.getCurrentState(unitId, 2120L);
            long currentStateID = currentStateStruct.getStateId();
            log.debug((Object)("current state of unit " + unitId + " is: " + currentStateID));
            log.debug((Object)("new     state of unit " + unitId + " is: " + stateId));
            if (currentStateID != stateId) {
                update = true;
            }
        }
        catch (NoStateFoundException e1) {
            update = true;
        }
        if (update) {
            long now = System.currentTimeMillis();
            try {
                long previousBeginTime;
                CurrentStateFacadeStruct struct = (CurrentStateFacadeStruct)this.currentStateFacadeLocal.getCurrentState(unitId).get(2120L);
                if (struct != null && beginTime < (previousBeginTime = struct.getEntryTime())) {
                    log.warn((Object)"begin time of new assignment state is older than current gse assignment state. Current time is used instead.");
                    log.debug((Object)("new assignment state begin time: " + beginTime));
                    log.debug((Object)("old assignment state begin time: " + previousBeginTime));
                    beginTime = System.currentTimeMillis();
                }
            }
            catch (StatesForUnitNotFoundException e1) {
                log.debug((Object)("no GSE assignment state found for unit " + unitId));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("changeState(unitId=" + unitId + ",stateModel=" + 2120L + ",stateId=" + stateId + ",beginTime=" + beginTime + ",receiveTime=" + receiveTime + ",remark=" + rkey + ")"));
            }
            Properties event = new Properties();
            event.setProperty("u", Long.toString(unitId));
            event.setProperty("m", Long.toString(2120L));
            event.setProperty("s", Long.toString(stateId));
            event.setProperty("t", Long.toString(beginTime));
            event.setProperty("c", rkey);
            try {
                this.eventFacadeBean.handleEvent(event);
            }
            catch (ImplicitRollbackException e) {
                log.error((Object)"runs into", (Throwable)e);
            }
        }
    }

    public Collection<FisGseCacheValue> getAllCacheGseAssignments() throws FinderException {
        Collection collectionFisGseCacheLocal = this.fisGseCacheLocalHome.findAll();
        ArrayList<FisGseCacheValue> fisGseValueCollection = new ArrayList<FisGseCacheValue>();
        for (FisGseCacheLocal gseCacheLocal : collectionFisGseCacheLocal) {
            fisGseValueCollection.add(gseCacheLocal.getFisGseCacheValue());
        }
        return fisGseValueCollection;
    }

    public FisGseCacheValue createGseAllocation(String gseName, String uniqueFlightNumber) {
        FisGseCacheValue fisGseCacheValue = new FisGseCacheValue();
        try {
            FisGseCacheLocal fisGseCacheLocal = this.fisGseCacheLocalHome.create(gseName, uniqueFlightNumber);
            fisGseCacheValue = fisGseCacheLocal.getFisGseCacheValue();
            return fisGseCacheValue;
        }
        catch (CreateException e) {
            log.error((Object)"runs into", (Throwable)e);
            return fisGseCacheValue;
        }
    }

    public ArrayList<String> getGseNamesForFlight(String uniqueFlightNumber) {
        ArrayList<String> gseNames = new ArrayList<String>();
        try {
            Collection colGse = this.fisGseCacheLocalHome.findByUniqueFlightNumber(uniqueFlightNumber);
            for (Object gse : colGse) {
                gseNames.add(((FisGseCacheLocal)gse).getCustomerGseCode());
            }
        }
        catch (FinderException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        return gseNames;
    }

    public FisGseCacheValue findByGseNameAndFlightNumber(String gseName, String uniqueFlightNumber) {
        FisGseCacheValue fisGseCacheValue = null;
        try {
            Collection gses = this.fisGseCacheLocalHome.findByGseCodeAndFlightNumber(gseName, uniqueFlightNumber);
            if (gses.size() > 0) {
                Iterator i$;
                if (gses.size() > 1) {
                    log.debug((Object)("could not get unique gse allocation for gse name " + gseName + " and flight " + uniqueFlightNumber));
                }
                if ((i$ = gses.iterator()).hasNext()) {
                    Object gseObject = i$.next();
                    return ((FisGseCacheLocal)gseObject).getFisGseCacheValue();
                }
            }
        }
        catch (FinderException e) {
            log.debug((Object)("could not find gse allocation for gse name " + gseName + " and flight " + uniqueFlightNumber));
        }
        if (fisGseCacheValue == null) {
            log.debug((Object)("could not find gse allocation for gse name " + gseName + " and flight " + uniqueFlightNumber));
        }
        return fisGseCacheValue;
    }
}

