/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.dataIn.fisFlight;

import de.proveo.util.ejb.BaseSessionBean;
import de.proveo.util.fis.jaxb.flight.MSG;
import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.logic.ejb.dataIn.fisFlight.FisFlightTransformLocal;
import de.proveo.wwt.logic.ejb.dataIn.fisFlight.FisFlightTransformUtil;
import de.proveo.wwt.logic.ejb.dataIn.fisFlight.cache.FisFlightCacheLocal;
import de.proveo.wwt.logic.ejb.dataIn.fisFlight.cache.FisFlightCacheLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.fisFlight.cache.FisFlightCacheUtil;
import de.proveo.wwt.logic.ejb.dataIn.fisFlight.cache.FisFlightCacheValue;
import de.proveo.wwt.logic.ejb.dataIn.fisFlight.history.FisFlightHistoryLocal;
import de.proveo.wwt.logic.ejb.dataIn.fisFlight.history.FisFlightHistoryLocalHome;
import de.proveo.wwt.logic.ejb.dataIn.fisFlight.history.FisFlightHistoryUtil;
import de.proveo.wwt.logic.ejb.dataIn.fisFlight.history.FisFlightHistoryValue;
import de.proveo.wwt.logic.ejb.dataIn.observable.ObservableFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.observable.ObservableFacadeUtil;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FisFlightFacadeBean
extends BaseSessionBean
implements SessionBean {
    private static final Log log = LogFactory.getLog(FisFlightFacadeBean.class);
    private FisFlightCacheLocalHome fisFlightCacheLocalHome;
    private FisFlightHistoryLocalHome fisFlightHistoryLocalHome;
    private FisFlightTransformLocal fisFlightTransformLocal;

    @Override
    public void ejbCreate() throws CreateException {
        try {
            this.fisFlightCacheLocalHome = FisFlightCacheUtil.getLocalHome();
            this.fisFlightHistoryLocalHome = FisFlightHistoryUtil.getLocalHome();
            this.fisFlightTransformLocal = FisFlightTransformUtil.getLocalHome().create();
        }
        catch (NamingException ex) {
            throw new EJBException("problem during lookup other EJBs: " + ex.getMessage());
        }
    }

    public FisFlightCacheValue getFlightCacheValue(String uniqueFlightNumber) throws FinderException {
        FisFlightCacheLocal fisFlightCacheLocal = this.getFlightCacheLocal(uniqueFlightNumber);
        return fisFlightCacheLocal.getFisFlightCacheValue();
    }

    private FisFlightCacheLocal getFlightCacheLocal(String uniqueFlightNumber) throws FinderException {
        Collection col = this.fisFlightCacheLocalHome.findByUniqueFlightNumber(uniqueFlightNumber);
        if (col.isEmpty() || col.size() == 0) {
            throw new FinderException("Could not find flight with uniqueFlightNumber " + uniqueFlightNumber);
        }
        Iterator it = col.iterator();
        if (it.hasNext()) {
            return (FisFlightCacheLocal)it.next();
        }
        throw new FinderException("Could not find flight with uniqueFlightNumber " + uniqueFlightNumber);
    }

    public FisFlightCacheValue updateFlight(String xmlString) {
        MSG msg = this.fisFlightTransformLocal.getMSGFromXMLString(xmlString);
        String uaft = msg.getMSGSTREAMOUT().getINFOBJGENERICFLIGHT().getUAFT();
        FisFlightCacheValue neuerFis = new FisFlightCacheValue();
        try {
            neuerFis = this.getFlightCacheValue(uaft);
        }
        catch (FinderException e) {
            neuerFis = new FisFlightCacheValue();
        }
        neuerFis = this.fisFlightTransformLocal.updateFlightCacheValueByMSG(neuerFis, msg);
        String actionType = msg.getMSGSTREAMOUT().getINFOBJGENERICFLIGHT().getACTIONTYPE();
        if (actionType.equals("U")) {
            this.updateFlight(neuerFis);
        } else if (actionType.equals("D")) {
            this.deleteFlight(uaft);
        }
        return neuerFis;
    }

    public FisFlightCacheValue createNewFlight(String uniqueFlightNumber) throws CreateException {
        FisFlightCacheLocal fisFlightCacheLocal = this.fisFlightCacheLocalHome.create(uniqueFlightNumber);
        FisFlightCacheValue newFlightCacheValue = fisFlightCacheLocal.getFisFlightCacheValue();
        return newFlightCacheValue;
    }

    public void updateFlight(FisFlightCacheValue fisFlightCacheValue) {
        if (fisFlightCacheValue.getUniqueFlightNumber() == null) {
            log.error((Object)"Can't update flight without unique flight number");
        } else {
            try {
                log.debug((Object)("update flight " + fisFlightCacheValue.getUniqueFlightNumber()));
                FisFlightCacheLocal flightCacheLocal = this.getFlightCacheLocal(fisFlightCacheValue.getUniqueFlightNumber());
                flightCacheLocal.setFisFlightCacheValue(fisFlightCacheValue);
            }
            catch (FinderException e) {
                try {
                    this.fisFlightCacheLocalHome.create(fisFlightCacheValue);
                }
                catch (CreateException e1) {
                    log.error((Object)"runs into", (Throwable)e1);
                }
            }
            try {
                SerializableEventWrapper wrapper = new SerializableEventWrapper(fisFlightCacheValue);
                wrapper.set_typeOfEvent("FlightUpdate");
                ObservableFacadeLocal observableFacade = ObservableFacadeUtil.getLocalHome().create();
                observableFacade.notifyClients(wrapper, "FlightEvent");
            }
            catch (CreateException e) {
                log.error((Object)"runs into", (Throwable)e);
            }
            catch (NamingException e) {
                log.error((Object)"runs into", (Throwable)e);
            }
        }
    }

    public void deleteFlight(String uniqueFlightNumber) {
        try {
            FisFlightCacheLocal flightCacheLocal = this.getFlightCacheLocal(uniqueFlightNumber);
            flightCacheLocal.remove();
        }
        catch (FinderException e) {
            log.debug((Object)("Could not delete flight " + uniqueFlightNumber + " because it doesn't exist."));
        }
        catch (EJBException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        catch (RemoveException e) {
            log.debug((Object)("Could not delete flight " + uniqueFlightNumber));
        }
        try {
            SerializableEventWrapper wrapper = new SerializableEventWrapper((Serializable)((Object)uniqueFlightNumber));
            wrapper.set_typeOfEvent("FlightDelete");
            ObservableFacadeLocal observableFacade = ObservableFacadeUtil.getLocalHome().create();
            observableFacade.notifyClients(wrapper, "FlightEvent");
        }
        catch (CreateException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        catch (NamingException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
    }

    public FisFlightHistoryValue getFlightHistoryValue(String uniqueFlightNumber) throws FinderException {
        Collection col = this.fisFlightHistoryLocalHome.findByUniqueFlightNumber(uniqueFlightNumber);
        if (col.isEmpty() || col.size() == 0) {
            throw new FinderException("Could not find flight with uniqueFlightNumber " + uniqueFlightNumber);
        }
        Iterator it = col.iterator();
        if (it.hasNext()) {
            FisFlightHistoryLocal flightHistory = (FisFlightHistoryLocal)it.next();
            return flightHistory.getFisFlightHistoryValue();
        }
        throw new FinderException("Could not find flight with uniqueFlightNumber " + uniqueFlightNumber);
    }

    public boolean isTurnaroundFlight(String uniqueFlightNumber) throws FinderException {
        try {
            this.getMatchingTurnaroundFlightNumber(uniqueFlightNumber);
            return true;
        }
        catch (FinderException e) {
            return false;
        }
    }

    private boolean isTurnaroundFlight(FisFlightCacheValue flightCacheValue) {
        String uniqueFlightNumber = flightCacheValue.getUniqueFlightNumber();
        try {
            FisFlightCacheValue matchingTurnaroundFlight = this.getMatchingTurnaroundFlight(flightCacheValue);
            return matchingTurnaroundFlight != null;
        }
        catch (FinderException e) {
            return false;
        }
    }

    private boolean isTurnaroundFlight(FisFlightHistoryValue flightHistoryValue) {
        String uniqueFlightNumber = flightHistoryValue.getUniqueFlightNumber();
        try {
            return this.isTurnaroundFlight(uniqueFlightNumber);
        }
        catch (FinderException e) {
            log.error((Object)("flight " + flightHistoryValue + " could not be found"));
            return false;
        }
    }

    public String getMatchingTurnaroundFlightNumber(String uniqueFlightNumber) throws FinderException {
        try {
            FisFlightCacheValue flightCacheValue = this.getFlightCacheValue(uniqueFlightNumber);
            FisFlightCacheValue matchingFlight = this.getMatchingTurnaroundFlight(flightCacheValue);
            return matchingFlight.getUniqueFlightNumber();
        }
        catch (FinderException e) {
            try {
                FisFlightHistoryValue flightHistoryValue = this.getFlightHistoryValue(uniqueFlightNumber);
                FisFlightHistoryValue matchingFlight = this.getMatchingTurnaroundFlight(flightHistoryValue);
                return matchingFlight.getUniqueFlightNumber();
            }
            catch (FinderException e1) {
                throw new FinderException("Could not find matching flight number for flight " + uniqueFlightNumber);
            }
        }
    }

    public FisFlightCacheValue getMatchingTurnaroundFlight(FisFlightCacheValue fisFlightCacheValue) throws FinderException {
        String arrivalDeparture = fisFlightCacheValue.getArrivalDeparture();
        String uniqueFlightNumber = fisFlightCacheValue.getUniqueFlightNumber();
        if ("A".equals(arrivalDeparture)) {
            try {
                Collection departures = this.fisFlightCacheLocalHome.findDepartureFlightForArrival(uniqueFlightNumber);
                if (departures.isEmpty() || departures.size() == 0) {
                    throw new FinderException("Could not find matching flight for " + uniqueFlightNumber);
                }
                Iterator it = departures.iterator();
                if (it.hasNext()) {
                    FisFlightCacheLocal flight = (FisFlightCacheLocal)it.next();
                    return flight.getFisFlightCacheValue();
                }
                throw new FinderException("Could not find matching flight for " + uniqueFlightNumber);
            }
            catch (FinderException e) {
                throw new FinderException("Could not find matching flight for " + uniqueFlightNumber);
            }
        }
        if ("D".equals(arrivalDeparture)) {
            String rkey = fisFlightCacheValue.getRotationKey();
            if (uniqueFlightNumber.equals(rkey)) {
                throw new FinderException("Flight " + uniqueFlightNumber + " is no turnaround flight");
            }
            Collection arrivals = this.fisFlightCacheLocalHome.findByUniqueFlightNumber(rkey);
            if (arrivals.isEmpty() || arrivals.size() == 0) {
                throw new FinderException("Could not find matching flight for " + uniqueFlightNumber);
            }
            Iterator it = arrivals.iterator();
            if (it.hasNext()) {
                FisFlightCacheLocal flight = (FisFlightCacheLocal)it.next();
                return flight.getFisFlightCacheValue();
            }
            throw new FinderException("Could not find matching flight for " + uniqueFlightNumber);
        }
        log.warn((Object)("flight " + uniqueFlightNumber + " is neither arrival nor departure"));
        throw new FinderException("Flight " + uniqueFlightNumber + " is no turnaround flight");
    }

    public FisFlightHistoryValue getMatchingTurnaroundFlight(FisFlightHistoryValue fisFlightHistoryValue) throws FinderException {
        String arrivalDeparture = fisFlightHistoryValue.getArrivalDeparture();
        String uniqueFlightNumber = fisFlightHistoryValue.getUniqueFlightNumber();
        if (arrivalDeparture.equals("A")) {
            try {
                Collection departures = this.fisFlightHistoryLocalHome.findDepartureFlightForArrival(uniqueFlightNumber);
                if (departures.isEmpty() || departures.size() == 0) {
                    throw new FinderException("Could not find matching flight for " + uniqueFlightNumber);
                }
                Iterator it = departures.iterator();
                if (it.hasNext()) {
                    FisFlightHistoryLocal flight = (FisFlightHistoryLocal)it.next();
                    return flight.getFisFlightHistoryValue();
                }
                throw new FinderException("Could not find matching flight for " + uniqueFlightNumber);
            }
            catch (FinderException e) {
                throw new FinderException("Could not find matching flight for " + uniqueFlightNumber);
            }
        }
        if (fisFlightHistoryValue.getArrivalDeparture().equals("D")) {
            String rkey = fisFlightHistoryValue.getRotationKey();
            if (uniqueFlightNumber.equals(rkey)) {
                throw new FinderException("Flight " + uniqueFlightNumber + " is no turnaround flight");
            }
            Collection arrivals = this.fisFlightHistoryLocalHome.findByUniqueFlightNumber(uniqueFlightNumber);
            if (arrivals.isEmpty() || arrivals.size() == 0) {
                throw new FinderException("Could not find matching flight for " + uniqueFlightNumber);
            }
            Iterator it = arrivals.iterator();
            if (it.hasNext()) {
                FisFlightHistoryLocal flight = (FisFlightHistoryLocal)it.next();
                return flight.getFisFlightHistoryValue();
            }
            throw new FinderException("Could not find matching flight for " + uniqueFlightNumber);
        }
        log.warn((Object)("flight " + uniqueFlightNumber + " is neither arrival nor departure"));
        throw new FinderException("Flight " + uniqueFlightNumber + " is no turnaround flight");
    }

    public Collection<FisFlightCacheValue> getAllCacheFlights() throws FinderException {
        Collection collectionFisFlightCacheLocal = this.fisFlightCacheLocalHome.findAll();
        ArrayList<FisFlightCacheValue> fisFlightsValueCollection = new ArrayList<FisFlightCacheValue>();
        for (FisFlightCacheLocal flightCacheLocal : collectionFisFlightCacheLocal) {
            fisFlightsValueCollection.add(flightCacheLocal.getFisFlightCacheValue());
        }
        return fisFlightsValueCollection;
    }

    public Collection<FisFlightCacheValue> getAllStartingFlights() throws FinderException {
        Collection collectionFisFlightCacheLocal = this.fisFlightCacheLocalHome.findAllStartingFlights();
        ArrayList<FisFlightCacheValue> fisFlightsValueCollection = new ArrayList<FisFlightCacheValue>();
        for (FisFlightCacheLocal flightCacheLocal : collectionFisFlightCacheLocal) {
            fisFlightsValueCollection.add(flightCacheLocal.getFisFlightCacheValue());
        }
        return fisFlightsValueCollection;
    }

    public Collection<FisFlightCacheValue> getFlightsByCorrespondentControlNumber(String correspondentControlNumber) throws FinderException {
        Collection collectionFisFlightCacheLocal = this.fisFlightCacheLocalHome.findByCorrespondentControlNumber(correspondentControlNumber);
        ArrayList<FisFlightCacheValue> fisFlightsValueCollection = new ArrayList<FisFlightCacheValue>();
        for (FisFlightCacheLocal flightCacheLocal : collectionFisFlightCacheLocal) {
            fisFlightsValueCollection.add(flightCacheLocal.getFisFlightCacheValue());
        }
        return fisFlightsValueCollection;
    }

    public FisFlightCacheValue getFlightByCorrespondentControlNumberAndUpdateIndex(String correspondentControlNumber, int updateIndex) throws FinderException {
        try {
            Collection collectionFisFlightCacheLocal = this.fisFlightCacheLocalHome.findByCorrespondentControlNumberAndUpdateIndex(correspondentControlNumber, updateIndex);
            if (collectionFisFlightCacheLocal.size() == 1) {
                Iterator it = collectionFisFlightCacheLocal.iterator();
                return ((FisFlightCacheLocal)it.next()).getFisFlightCacheValue();
            }
            if (collectionFisFlightCacheLocal.size() == 0) {
                throw new FinderException("cannot find flight with correspondent control number " + correspondentControlNumber + " and update index " + updateIndex);
            }
            throw new FinderException("flight with correspondent control number " + correspondentControlNumber + " and update index " + updateIndex + " is not unique");
        }
        catch (ObjectNotFoundException e) {
            throw new FinderException("cannot find flight with correspondent control number " + correspondentControlNumber + " and update index " + updateIndex);
        }
    }

    public void moveFlightToHistory(String uniqueFlightNumber) {
        try {
            FisFlightCacheLocal flightCacheLocal = this.getFlightCacheLocal(uniqueFlightNumber);
            FisFlightCacheValue flightCacheValue = flightCacheLocal.getFisFlightCacheValue();
            FisFlightHistoryValue flightHistoryValue = new FisFlightHistoryValue();
            flightHistoryValue.setReceiveTime(flightCacheValue.getReceiveTime());
            flightHistoryValue.setUniqueFlightNumber(flightCacheValue.getUniqueFlightNumber());
            flightHistoryValue.setCustomerCreateTime(flightCacheValue.getCustomerCreateTime());
            flightHistoryValue.setFlightNumberSemantics(flightCacheValue.getFlightNumberSemantics());
            flightHistoryValue.setIataAirlineCode(flightCacheValue.getIataAirlineCode());
            flightHistoryValue.setIcaoAirlineCode(flightCacheValue.getIcaoAirlineCode());
            flightHistoryValue.setFlightNumber(flightCacheValue.getFlightNumber());
            flightHistoryValue.setFlightNumberSuffix(flightCacheValue.getFlightNumberSuffix());
            flightHistoryValue.setScheduledTimeOfArrival(flightCacheValue.getScheduledTimeOfArrival());
            flightHistoryValue.setScheduledTimeOfDeparture(flightCacheValue.getScheduledTimeOfDeparture());
            flightHistoryValue.setArrivalDeparture(flightCacheValue.getArrivalDeparture());
            flightHistoryValue.setMovementType(flightCacheValue.getMovementType());
            flightHistoryValue.setRotationKey(flightCacheValue.getRotationKey());
            flightHistoryValue.setRegistration(flightCacheValue.getRegistration());
            flightHistoryValue.setCallSign(flightCacheValue.getCallSign());
            flightHistoryValue.setEstimatedTimeOfArrival(flightCacheValue.getEstimatedTimeOfArrival());
            flightHistoryValue.setEstimatedTimeOfDeparture(flightCacheValue.getEstimatedTimeOfDeparture());
            flightHistoryValue.setDestination3LetterCode(flightCacheValue.getDestination3LetterCode());
            flightHistoryValue.setOrigin3LetterCode(flightCacheValue.getOrigin3LetterCode());
            flightHistoryValue.setFlightStatus(flightCacheValue.getFlightStatus());
            flightHistoryValue.setFlightNature(flightCacheValue.getFlightNature());
            flightHistoryValue.setAircraftType3LetterCode(flightCacheValue.getAircraftType3LetterCode());
            flightHistoryValue.setAircraftType5LetterCode(flightCacheValue.getAircraftType5LetterCode());
            flightHistoryValue.setLandingTime(flightCacheValue.getLandingTime());
            flightHistoryValue.setOnBlockTime(flightCacheValue.getOnBlockTime());
            flightHistoryValue.setTakeOffTime(flightCacheValue.getTakeOffTime());
            flightHistoryValue.setOffBlockTime(flightCacheValue.getOffBlockTime());
            flightHistoryValue.setVia1AirportCode(flightCacheValue.getVia1AirportCode());
            flightHistoryValue.setVia2AirportCode(flightCacheValue.getVia2AirportCode());
            flightHistoryValue.setVia3AirportCode(flightCacheValue.getVia3AirportCode());
            flightHistoryValue.setVia4AirportCode(flightCacheValue.getVia4AirportCode());
            flightHistoryValue.setVia5AirportCode(flightCacheValue.getVia5AirportCode());
            flightHistoryValue.setVia6AirportCode(flightCacheValue.getVia6AirportCode());
            flightHistoryValue.setVia7AirportCode(flightCacheValue.getVia7AirportCode());
            flightHistoryValue.setVia8AirportCode(flightCacheValue.getVia8AirportCode());
            flightHistoryValue.setParkingStand(flightCacheValue.getParkingStand());
            flightHistoryValue.setFlightUpdateIndex(flightCacheValue.getFlightUpdateIndex());
            flightHistoryValue.setCorrespondentControlNumber(flightCacheValue.getCorrespondentControlNumber());
            flightHistoryValue.setTenMilesOut(flightCacheValue.getTenMilesOut());
            FisFlightHistoryUtil.getHome().create(flightHistoryValue);
            flightCacheLocal.remove();
        }
        catch (FinderException e) {
            log.debug((Object)("cannot find flight with unique flight number " + uniqueFlightNumber));
        }
        catch (RemoteException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        catch (CreateException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        catch (NamingException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        catch (EJBException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
        catch (RemoveException e) {
            log.error((Object)"runs into", (Throwable)e);
        }
    }

    public FisFlightCacheValue getLastFisValue() throws FinderException {
        Iterator valueIterator;
        long maxCustomerCreateTime = this.fisFlightCacheLocalHome.findMaxCustomerCreateTime().getCustomerCreateTime();
        Collection collectionFisFlightCacheLocal = this.fisFlightCacheLocalHome.findByCustomerCreateTime(maxCustomerCreateTime);
        if (collectionFisFlightCacheLocal != null && !collectionFisFlightCacheLocal.isEmpty() && (valueIterator = collectionFisFlightCacheLocal.iterator()).hasNext()) {
            return (FisFlightCacheValue)valueIterator.next();
        }
        return null;
    }
}

