/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.operators;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import javax.swing.SingleSelectionModel;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TabbedPaneUI;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.JemmyInputException;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.drivers.ListDriver;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.Operator;

public class JTabbedPaneOperator
extends JComponentOperator
implements Outputable {
    public static final String SELECTED_PAGE_DPROP = "Selected";
    public static final String PAGE_PREFIX_DPROP = "Page";
    private TestOut output;
    private ListDriver driver = DriverManager.getListDriver(this.getClass());

    public JTabbedPaneOperator(JTabbedPane b) {
        super(b);
    }

    public JTabbedPaneOperator(ContainerOperator cont, ComponentChooser chooser, int index) {
        this((JTabbedPane)cont.waitSubComponent(new JTabbedPaneFinder(chooser), index));
        this.copyEnvironment(cont);
    }

    public JTabbedPaneOperator(ContainerOperator cont, ComponentChooser chooser) {
        this(cont, chooser, 0);
    }

    public JTabbedPaneOperator(ContainerOperator cont, String text, int tabIndex, int index) {
        this((JTabbedPane)JTabbedPaneOperator.waitComponent(cont, (ComponentChooser)new JTabbedPaneByItemFinder(text, tabIndex, cont.getComparator()), index));
        this.copyEnvironment(cont);
    }

    public JTabbedPaneOperator(ContainerOperator cont, String text, int index) {
        this(cont, text, -1, index);
    }

    public JTabbedPaneOperator(ContainerOperator cont, String text) {
        this(cont, text, 0);
    }

    public JTabbedPaneOperator(ContainerOperator cont, int index) {
        this((JTabbedPane)JTabbedPaneOperator.waitComponent(cont, (ComponentChooser)new JTabbedPaneFinder(), index));
        this.copyEnvironment(cont);
    }

    public JTabbedPaneOperator(ContainerOperator cont) {
        this(cont, 0);
    }

    public static JTabbedPane findJTabbedPane(Container cont, ComponentChooser chooser, int index) {
        return (JTabbedPane)JTabbedPaneOperator.findComponent(cont, new JTabbedPaneFinder(chooser), index);
    }

    public static JTabbedPane findJTabbedPane(Container cont, ComponentChooser chooser) {
        return JTabbedPaneOperator.findJTabbedPane(cont, chooser, 0);
    }

    public static JTabbedPane findJTabbedPane(Container cont, String text, boolean ce, boolean ccs, int itemIndex, int index) {
        return JTabbedPaneOperator.findJTabbedPane(cont, new JTabbedPaneByItemFinder(text, itemIndex, new Operator.DefaultStringComparator(ce, ccs)), index);
    }

    public static JTabbedPane findJTabbedPane(Container cont, String text, boolean ce, boolean ccs, int itemIndex) {
        return JTabbedPaneOperator.findJTabbedPane(cont, text, ce, ccs, itemIndex, 0);
    }

    public static JTabbedPane findJTabbedPaneUnder(Component comp, ComponentChooser chooser) {
        return (JTabbedPane)JTabbedPaneOperator.findContainerUnder(comp, new JTabbedPaneFinder(chooser));
    }

    public static JTabbedPane findJTabbedPaneUnder(Component comp) {
        return JTabbedPaneOperator.findJTabbedPaneUnder(comp, new JTabbedPaneFinder());
    }

    public static JTabbedPane waitJTabbedPane(Container cont, ComponentChooser chooser, int index) {
        return (JTabbedPane)JTabbedPaneOperator.waitComponent(cont, (ComponentChooser)new JTabbedPaneFinder(chooser), index);
    }

    public static JTabbedPane waitJTabbedPane(Container cont, ComponentChooser chooser) {
        return JTabbedPaneOperator.waitJTabbedPane(cont, chooser, 0);
    }

    public static JTabbedPane waitJTabbedPane(Container cont, String text, boolean ce, boolean ccs, int itemIndex, int index) {
        return JTabbedPaneOperator.waitJTabbedPane(cont, new JTabbedPaneByItemFinder(text, itemIndex, new Operator.DefaultStringComparator(ce, ccs)), index);
    }

    public static JTabbedPane waitJTabbedPane(Container cont, String text, boolean ce, boolean ccs, int itemIndex) {
        return JTabbedPaneOperator.waitJTabbedPane(cont, text, ce, ccs, itemIndex, 0);
    }

    @Override
    public void setOutput(TestOut output) {
        super.setOutput(output.createErrorOutput());
        this.output = output;
    }

    @Override
    public TestOut getOutput() {
        return this.output;
    }

    @Override
    public void copyEnvironment(Operator anotherOperator) {
        super.copyEnvironment(anotherOperator);
        this.driver = (ListDriver)DriverManager.getDriver("drivers.list", this.getClass(), anotherOperator.getProperties());
    }

    public int findPage(TabPageChooser chooser) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            if (!chooser.checkPage(this, i)) continue;
            return i;
        }
        return -1;
    }

    public int findPage(String title, Operator.StringComparator comparator) {
        return this.findPage(new BySubStringTabPageChooser(title, comparator));
    }

    public int findPage(String title, boolean ce, boolean ccs) {
        return this.findPage(title, new Operator.DefaultStringComparator(ce, ccs));
    }

    public int findPage(String title) {
        return this.findPage(title, this.getComparator());
    }

    public Component selectPage(int index) {
        this.output.printLine("Selecting " + index + "'th page in tabbed pane\n    :" + this.toStringSource());
        this.makeComponentVisible();
        this.driver.selectItem(this, index);
        if (this.getVerification()) {
            this.waitSelected(index);
        }
        return this.getComponentAt(index);
    }

    public Component selectPage(TabPageChooser chooser) {
        this.output.printLine("Selecting \"" + chooser.getDescription() + "\" page in tabbed pane\n    :" + this.toStringSource());
        return this.selectPage(this.waitPage(chooser));
    }

    public Component selectPage(String title, Operator.StringComparator comparator) {
        return this.selectPage(new BySubStringTabPageChooser(title, comparator));
    }

    public Component selectPage(String title, boolean ce, boolean ccs) {
        return this.selectPage(title, new Operator.DefaultStringComparator(ce, ccs));
    }

    public Component selectPage(String title) {
        return this.selectPage(title, this.getComparator());
    }

    public int waitPage(final TabPageChooser chooser) {
        this.waitState(new ComponentChooser(){

            @Override
            public boolean checkComponent(Component comp) {
                return JTabbedPaneOperator.this.findPage(chooser) > -1;
            }

            @Override
            public String getDescription() {
                return "Tabbed with " + chooser.getDescription() + " page.";
            }
        });
        return this.findPage(chooser);
    }

    public int waitPage(String title, Operator.StringComparator comparator) {
        return this.waitPage(new BySubStringTabPageChooser(title, comparator));
    }

    public int waitPage(String title) {
        return this.waitPage(title, this.getComparator());
    }

    public void waitSelected(final int pageIndex) {
        this.getOutput().printLine("Wait " + Integer.toString(pageIndex) + "'th page to be " + " selected in component \n    : " + this.toStringSource());
        this.getOutput().printGolden("Wait " + Integer.toString(pageIndex) + "'th page to be " + " selected");
        this.waitState(new ComponentChooser(){

            @Override
            public boolean checkComponent(Component comp) {
                return JTabbedPaneOperator.this.getSelectedIndex() == pageIndex;
            }

            @Override
            public String getDescription() {
                return Integer.toString(pageIndex) + "'th page has been selected";
            }
        });
    }

    public void waitSelected(String pageTitle) {
        this.waitSelected(this.findPage(pageTitle));
    }

    @Override
    public Hashtable getDump() {
        Hashtable result = super.getDump();
        if (((JTabbedPane)this.getSource()).getSelectedIndex() != -1) {
            result.put(SELECTED_PAGE_DPROP, ((JTabbedPane)this.getSource()).getTitleAt(((JTabbedPane)this.getSource()).getSelectedIndex()));
        }
        Object[] pages = new String[((JTabbedPane)this.getSource()).getTabCount()];
        for (int i = 0; i < ((JTabbedPane)this.getSource()).getTabCount(); ++i) {
            pages[i] = ((JTabbedPane)this.getSource()).getTitleAt(i);
        }
        this.addToDump(result, PAGE_PREFIX_DPROP, pages);
        return result;
    }

    public void addChangeListener(final ChangeListener changeListener) {
        this.runMapping(new Operator.MapVoidAction("addChangeListener"){

            @Override
            public void map() {
                ((JTabbedPane)JTabbedPaneOperator.this.getSource()).addChangeListener(changeListener);
            }
        });
    }

    public void addTab(final String string, final Component component) {
        this.runMapping(new Operator.MapVoidAction("addTab"){

            @Override
            public void map() {
                ((JTabbedPane)JTabbedPaneOperator.this.getSource()).addTab(string, component);
            }
        });
    }

    public void addTab(final String string, final Icon icon, final Component component) {
        this.runMapping(new Operator.MapVoidAction("addTab"){

            @Override
            public void map() {
                ((JTabbedPane)JTabbedPaneOperator.this.getSource()).addTab(string, icon, component);
            }
        });
    }

    public void addTab(final String string, final Icon icon, final Component component, final String string1) {
        this.runMapping(new Operator.MapVoidAction("addTab"){

            @Override
            public void map() {
                ((JTabbedPane)JTabbedPaneOperator.this.getSource()).addTab(string, icon, component, string1);
            }
        });
    }

    public Color getBackgroundAt(final int i) {
        return (Color)this.runMapping(new Operator.MapAction("getBackgroundAt"){

            @Override
            public Object map() {
                return ((JTabbedPane)JTabbedPaneOperator.this.getSource()).getBackgroundAt(i);
            }
        });
    }

    public Rectangle getBoundsAt(final int i) {
        return (Rectangle)this.runMapping(new Operator.MapAction("getBoundsAt"){

            @Override
            public Object map() {
                return ((JTabbedPane)JTabbedPaneOperator.this.getSource()).getBoundsAt(i);
            }
        });
    }

    public Component getComponentAt(final int i) {
        return (Component)this.runMapping(new Operator.MapAction("getComponentAt"){

            @Override
            public Object map() {
                return ((JTabbedPane)JTabbedPaneOperator.this.getSource()).getComponentAt(i);
            }
        });
    }

    public Icon getDisabledIconAt(final int i) {
        return (Icon)this.runMapping(new Operator.MapAction("getDisabledIconAt"){

            @Override
            public Object map() {
                return ((JTabbedPane)JTabbedPaneOperator.this.getSource()).getDisabledIconAt(i);
            }
        });
    }

    public Color getForegroundAt(final int i) {
        return (Color)this.runMapping(new Operator.MapAction("getForegroundAt"){

            @Override
            public Object map() {
                return ((JTabbedPane)JTabbedPaneOperator.this.getSource()).getForegroundAt(i);
            }
        });
    }

    public Icon getIconAt(final int i) {
        return (Icon)this.runMapping(new Operator.MapAction("getIconAt"){

            @Override
            public Object map() {
                return ((JTabbedPane)JTabbedPaneOperator.this.getSource()).getIconAt(i);
            }
        });
    }

    public SingleSelectionModel getModel() {
        return (SingleSelectionModel)this.runMapping(new Operator.MapAction("getModel"){

            @Override
            public Object map() {
                return ((JTabbedPane)JTabbedPaneOperator.this.getSource()).getModel();
            }
        });
    }

    public Component getSelectedComponent() {
        return (Component)this.runMapping(new Operator.MapAction("getSelectedComponent"){

            @Override
            public Object map() {
                return ((JTabbedPane)JTabbedPaneOperator.this.getSource()).getSelectedComponent();
            }
        });
    }

    public int getSelectedIndex() {
        return this.runMapping(new Operator.MapIntegerAction("getSelectedIndex"){

            @Override
            public int map() {
                return ((JTabbedPane)JTabbedPaneOperator.this.getSource()).getSelectedIndex();
            }
        });
    }

    public int getTabCount() {
        return this.runMapping(new Operator.MapIntegerAction("getTabCount"){

            @Override
            public int map() {
                return ((JTabbedPane)JTabbedPaneOperator.this.getSource()).getTabCount();
            }
        });
    }

    public int getTabPlacement() {
        return this.runMapping(new Operator.MapIntegerAction("getTabPlacement"){

            @Override
            public int map() {
                return ((JTabbedPane)JTabbedPaneOperator.this.getSource()).getTabPlacement();
            }
        });
    }

    public int getTabRunCount() {
        return this.runMapping(new Operator.MapIntegerAction("getTabRunCount"){

            @Override
            public int map() {
                return ((JTabbedPane)JTabbedPaneOperator.this.getSource()).getTabRunCount();
            }
        });
    }

    public String getTitleAt(final int i) {
        return (String)this.runMapping(new Operator.MapAction("getTitleAt"){

            @Override
            public Object map() {
                return ((JTabbedPane)JTabbedPaneOperator.this.getSource()).getTitleAt(i);
            }
        });
    }

    public TabbedPaneUI getUI() {
        return (TabbedPaneUI)this.runMapping(new Operator.MapAction("getUI"){

            @Override
            public Object map() {
                return ((JTabbedPane)JTabbedPaneOperator.this.getSource()).getUI();
            }
        });
    }

    public int indexOfComponent(final Component component) {
        return this.runMapping(new Operator.MapIntegerAction("indexOfComponent"){

            @Override
            public int map() {
                return ((JTabbedPane)JTabbedPaneOperator.this.getSource()).indexOfComponent(component);
            }
        });
    }

    public int indexOfTab(final String string) {
        return this.runMapping(new Operator.MapIntegerAction("indexOfTab"){

            @Override
            public int map() {
                return ((JTabbedPane)JTabbedPaneOperator.this.getSource()).indexOfTab(string);
            }
        });
    }

    public int indexOfTab(final Icon icon) {
        return this.runMapping(new Operator.MapIntegerAction("indexOfTab"){

            @Override
            public int map() {
                return ((JTabbedPane)JTabbedPaneOperator.this.getSource()).indexOfTab(icon);
            }
        });
    }

    public void insertTab(final String string, final Icon icon, final Component component, final String string1, final int i) {
        this.runMapping(new Operator.MapVoidAction("insertTab"){

            @Override
            public void map() {
                ((JTabbedPane)JTabbedPaneOperator.this.getSource()).insertTab(string, icon, component, string1, i);
            }
        });
    }

    public boolean isEnabledAt(final int i) {
        return this.runMapping(new Operator.MapBooleanAction("isEnabledAt"){

            @Override
            public boolean map() {
                return ((JTabbedPane)JTabbedPaneOperator.this.getSource()).isEnabledAt(i);
            }
        });
    }

    public void removeChangeListener(final ChangeListener changeListener) {
        this.runMapping(new Operator.MapVoidAction("removeChangeListener"){

            @Override
            public void map() {
                ((JTabbedPane)JTabbedPaneOperator.this.getSource()).removeChangeListener(changeListener);
            }
        });
    }

    public void removeTabAt(final int i) {
        this.runMapping(new Operator.MapVoidAction("removeTabAt"){

            @Override
            public void map() {
                ((JTabbedPane)JTabbedPaneOperator.this.getSource()).removeTabAt(i);
            }
        });
    }

    public void setBackgroundAt(final int i, final Color color) {
        this.runMapping(new Operator.MapVoidAction("setBackgroundAt"){

            @Override
            public void map() {
                ((JTabbedPane)JTabbedPaneOperator.this.getSource()).setBackgroundAt(i, color);
            }
        });
    }

    public void setComponentAt(final int i, final Component component) {
        this.runMapping(new Operator.MapVoidAction("setComponentAt"){

            @Override
            public void map() {
                ((JTabbedPane)JTabbedPaneOperator.this.getSource()).setComponentAt(i, component);
            }
        });
    }

    public void setDisabledIconAt(final int i, final Icon icon) {
        this.runMapping(new Operator.MapVoidAction("setDisabledIconAt"){

            @Override
            public void map() {
                ((JTabbedPane)JTabbedPaneOperator.this.getSource()).setDisabledIconAt(i, icon);
            }
        });
    }

    public void setEnabledAt(final int i, final boolean b) {
        this.runMapping(new Operator.MapVoidAction("setEnabledAt"){

            @Override
            public void map() {
                ((JTabbedPane)JTabbedPaneOperator.this.getSource()).setEnabledAt(i, b);
            }
        });
    }

    public void setForegroundAt(final int i, final Color color) {
        this.runMapping(new Operator.MapVoidAction("setForegroundAt"){

            @Override
            public void map() {
                ((JTabbedPane)JTabbedPaneOperator.this.getSource()).setForegroundAt(i, color);
            }
        });
    }

    public void setIconAt(final int i, final Icon icon) {
        this.runMapping(new Operator.MapVoidAction("setIconAt"){

            @Override
            public void map() {
                ((JTabbedPane)JTabbedPaneOperator.this.getSource()).setIconAt(i, icon);
            }
        });
    }

    public void setModel(final SingleSelectionModel singleSelectionModel) {
        this.runMapping(new Operator.MapVoidAction("setModel"){

            @Override
            public void map() {
                ((JTabbedPane)JTabbedPaneOperator.this.getSource()).setModel(singleSelectionModel);
            }
        });
    }

    public void setSelectedComponent(final Component component) {
        this.runMapping(new Operator.MapVoidAction("setSelectedComponent"){

            @Override
            public void map() {
                ((JTabbedPane)JTabbedPaneOperator.this.getSource()).setSelectedComponent(component);
            }
        });
    }

    public void setSelectedIndex(final int i) {
        this.runMapping(new Operator.MapVoidAction("setSelectedIndex"){

            @Override
            public void map() {
                ((JTabbedPane)JTabbedPaneOperator.this.getSource()).setSelectedIndex(i);
            }
        });
    }

    public void setTabPlacement(final int i) {
        this.runMapping(new Operator.MapVoidAction("setTabPlacement"){

            @Override
            public void map() {
                ((JTabbedPane)JTabbedPaneOperator.this.getSource()).setTabPlacement(i);
            }
        });
    }

    public void setTitleAt(final int i, final String string) {
        this.runMapping(new Operator.MapVoidAction("setTitleAt"){

            @Override
            public void map() {
                ((JTabbedPane)JTabbedPaneOperator.this.getSource()).setTitleAt(i, string);
            }
        });
    }

    public void setUI(final TabbedPaneUI tabbedPaneUI) {
        this.runMapping(new Operator.MapVoidAction("setUI"){

            @Override
            public void map() {
                ((JTabbedPane)JTabbedPaneOperator.this.getSource()).setUI(tabbedPaneUI);
            }
        });
    }

    private static class BySubStringTabPageChooser
    implements TabPageChooser {
        String title;
        Operator.StringComparator comparator;

        public BySubStringTabPageChooser(String title, Operator.StringComparator comparator) {
            this.title = title;
            this.comparator = comparator;
        }

        @Override
        public boolean checkPage(JTabbedPaneOperator oper, int index) {
            return this.comparator.equals(oper.getTitleAt(index), this.title);
        }

        @Override
        public String getDescription() {
            return "Page having \"" + this.title + "\" title.";
        }
    }

    public static class JTabbedPaneByItemFinder
    implements ComponentChooser {
        String title;
        int itemIndex;
        Operator.StringComparator comparator;

        public JTabbedPaneByItemFinder(String lb, int ii, Operator.StringComparator comparator) {
            this.title = lb;
            this.itemIndex = ii;
            this.comparator = comparator;
        }

        public JTabbedPaneByItemFinder(String lb, int ii) {
            this(lb, ii, Operator.getDefaultStringComparator());
        }

        @Override
        public boolean checkComponent(Component comp) {
            if (comp instanceof JTabbedPane) {
                if (this.title == null) {
                    return true;
                }
                JTabbedPaneOperator tpo = new JTabbedPaneOperator((JTabbedPane)comp);
                if (tpo.getTabCount() > this.itemIndex) {
                    int ii = this.itemIndex;
                    if (ii == -1 && (ii = tpo.getSelectedIndex()) == -1) {
                        return false;
                    }
                    return this.comparator.equals(tpo.getTitleAt(ii), this.title);
                }
            }
            return false;
        }

        @Override
        public String getDescription() {
            return "JTabbedPane with text \"" + this.title + "\" in " + new Integer(this.itemIndex).toString() + "'th item";
        }
    }

    public static class JTabbedPaneFinder
    extends Operator.Finder {
        public JTabbedPaneFinder(ComponentChooser sf) {
            super(JTabbedPane.class, sf);
        }

        public JTabbedPaneFinder() {
            super(JTabbedPane.class);
        }
    }

    public class NoSuchPageException
    extends JemmyInputException {
        public NoSuchPageException(String item) {
            super("No such page as \"" + item + "\"", JTabbedPaneOperator.this.getSource());
        }
    }

    public static interface TabPageChooser {
        public boolean checkPage(JTabbedPaneOperator var1, int var2);

        public String getDescription();
    }
}

