/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.operators;

import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.drivers.ListDriver;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.Operator;

public class ChoiceOperator
extends ComponentOperator
implements Outputable {
    public static final String SELECTED_ITEM_DPROP = "Selected item";
    public static final String ITEM_PREFIX_DPROP = "Item";
    private TestOut output;
    private ListDriver driver = DriverManager.getListDriver(this.getClass());

    public ChoiceOperator(Choice b) {
        super(b);
    }

    public ChoiceOperator(ContainerOperator cont, ComponentChooser chooser, int index) {
        this((Choice)cont.waitSubComponent(new ChoiceFinder(chooser), index));
        this.copyEnvironment(cont);
    }

    public ChoiceOperator(ContainerOperator cont, ComponentChooser chooser) {
        this(cont, chooser, 0);
    }

    public ChoiceOperator(ContainerOperator cont, String text, int index) {
        this((Choice)ChoiceOperator.waitComponent(cont, (ComponentChooser)new ChoiceBySelectedItemFinder(text, cont.getComparator()), index));
        this.copyEnvironment(cont);
    }

    public ChoiceOperator(ContainerOperator cont, String text) {
        this(cont, text, 0);
    }

    public ChoiceOperator(ContainerOperator cont, int index) {
        this((Choice)ChoiceOperator.waitComponent(cont, (ComponentChooser)new ChoiceFinder(), index));
        this.copyEnvironment(cont);
    }

    public ChoiceOperator(ContainerOperator cont) {
        this(cont, 0);
    }

    public static Choice findChoice(Container cont, ComponentChooser chooser, int index) {
        return (Choice)ChoiceOperator.findComponent(cont, new ChoiceFinder(chooser), index);
    }

    public static Choice findChoice(Container cont, ComponentChooser chooser) {
        return ChoiceOperator.findChoice(cont, chooser, 0);
    }

    public static Choice findChoice(Container cont, String text, boolean ce, boolean ccs, int index) {
        return ChoiceOperator.findChoice(cont, new ChoiceBySelectedItemFinder(text, new Operator.DefaultStringComparator(ce, ccs)), index);
    }

    public static Choice findChoice(Container cont, String text, boolean ce, boolean ccs) {
        return ChoiceOperator.findChoice(cont, text, ce, ccs, 0);
    }

    public static Choice waitChoice(Container cont, ComponentChooser chooser, int index) {
        return (Choice)ChoiceOperator.waitComponent(cont, (ComponentChooser)new ChoiceFinder(chooser), index);
    }

    public static Choice waitChoice(Container cont, ComponentChooser chooser) {
        return ChoiceOperator.waitChoice(cont, chooser, 0);
    }

    public static Choice waitChoice(Container cont, String text, boolean ce, boolean ccs, int index) {
        return ChoiceOperator.waitChoice(cont, new ChoiceBySelectedItemFinder(text, new Operator.DefaultStringComparator(ce, ccs)), index);
    }

    public static Choice waitChoice(Container cont, String text, boolean ce, boolean ccs) {
        return ChoiceOperator.waitChoice(cont, text, ce, ccs, 0);
    }

    @Override
    public void setOutput(TestOut out) {
        this.output = out;
        super.setOutput(this.output.createErrorOutput());
    }

    @Override
    public TestOut getOutput() {
        return this.output;
    }

    @Override
    public void copyEnvironment(Operator anotherOperator) {
        super.copyEnvironment(anotherOperator);
        this.driver = (ListDriver)DriverManager.getDriver("drivers.list", this.getClass(), anotherOperator.getProperties());
    }

    public int findItemIndex(String item, int index) {
        return this.findItemIndex(item, this.getComparator(), index);
    }

    public int findItemIndex(String item) {
        return this.findItemIndex(item, 0);
    }

    public void selectItem(String item, int index) {
        this.selectItem(item, this.getComparator(), index);
    }

    public void selectItem(String item) {
        this.selectItem(item, 0);
    }

    public void selectItem(int index) {
        this.output.printLine("Select " + Integer.toString(index) + "`th item in combobox\n    : " + this.toStringSource());
        this.output.printGolden("Select " + Integer.toString(index) + "`th item in combobox");
        this.makeComponentVisible();
        try {
            this.waitComponentEnabled();
        }
        catch (InterruptedException e) {
            throw new JemmyException("Interrupted!", e);
        }
        this.driver.selectItem(this, index);
        if (this.getVerification()) {
            this.waitItemSelected(index);
        }
    }

    public void waitItemSelected(final int index) {
        this.getOutput().printLine("Wait " + Integer.toString(index) + "'th item to be selected in component \n    : " + this.toStringSource());
        this.getOutput().printGolden("Wait " + Integer.toString(index) + "'th item to be selected");
        this.waitState(new ComponentChooser(){

            @Override
            public boolean checkComponent(Component comp) {
                return ChoiceOperator.this.getSelectedIndex() == index;
            }

            @Override
            public String getDescription() {
                return "Has " + Integer.toString(index) + "'th item selected";
            }
        });
    }

    @Override
    public Hashtable getDump() {
        Hashtable result = super.getDump();
        if (((Choice)this.getSource()).getSelectedItem() != null) {
            result.put(SELECTED_ITEM_DPROP, ((Choice)this.getSource()).getSelectedItem());
        }
        Object[] items = new String[((Choice)this.getSource()).getItemCount()];
        for (int i = 0; i < ((Choice)this.getSource()).getItemCount(); ++i) {
            items[i] = ((Choice)this.getSource()).getItem(i);
        }
        this.addToDump(result, ITEM_PREFIX_DPROP, items);
        return result;
    }

    public void add(final String item) {
        this.runMapping(new Operator.MapVoidAction("add"){

            @Override
            public void map() {
                ((Choice)ChoiceOperator.this.getSource()).add(item);
            }
        });
    }

    public void addItemListener(final ItemListener itemListener) {
        this.runMapping(new Operator.MapVoidAction("addItemListener"){

            @Override
            public void map() {
                ((Choice)ChoiceOperator.this.getSource()).addItemListener(itemListener);
            }
        });
    }

    @Override
    public void addNotify() {
        this.runMapping(new Operator.MapVoidAction("addNotify"){

            @Override
            public void map() {
                ((Choice)ChoiceOperator.this.getSource()).addNotify();
            }
        });
    }

    public String getItem(final int index) {
        return (String)this.runMapping(new Operator.MapAction("getItem"){

            @Override
            public Object map() {
                return ((Choice)ChoiceOperator.this.getSource()).getItem(index);
            }
        });
    }

    public int getItemCount() {
        return this.runMapping(new Operator.MapIntegerAction("getItemCount"){

            @Override
            public int map() {
                return ((Choice)ChoiceOperator.this.getSource()).getItemCount();
            }
        });
    }

    public int getSelectedIndex() {
        return this.runMapping(new Operator.MapIntegerAction("getSelectedIndex"){

            @Override
            public int map() {
                return ((Choice)ChoiceOperator.this.getSource()).getSelectedIndex();
            }
        });
    }

    public String getSelectedItem() {
        return (String)this.runMapping(new Operator.MapAction("getSelectedItem"){

            @Override
            public Object map() {
                return ((Choice)ChoiceOperator.this.getSource()).getSelectedItem();
            }
        });
    }

    public void insert(final String item, final int index) {
        this.runMapping(new Operator.MapVoidAction("insert"){

            @Override
            public void map() {
                ((Choice)ChoiceOperator.this.getSource()).insert(item, index);
            }
        });
    }

    public void remove(final int position) {
        this.runMapping(new Operator.MapVoidAction("remove"){

            @Override
            public void map() {
                ((Choice)ChoiceOperator.this.getSource()).remove(position);
            }
        });
    }

    public void remove(final String item) {
        this.runMapping(new Operator.MapVoidAction("remove"){

            @Override
            public void map() {
                ((Choice)ChoiceOperator.this.getSource()).remove(item);
            }
        });
    }

    public void removeAll() {
        this.runMapping(new Operator.MapVoidAction("removeAll"){

            @Override
            public void map() {
                ((Choice)ChoiceOperator.this.getSource()).removeAll();
            }
        });
    }

    public void removeItemListener(final ItemListener itemListener) {
        this.runMapping(new Operator.MapVoidAction("removeItemListener"){

            @Override
            public void map() {
                ((Choice)ChoiceOperator.this.getSource()).removeItemListener(itemListener);
            }
        });
    }

    public void select(final int pos) {
        this.runMapping(new Operator.MapVoidAction("select"){

            @Override
            public void map() {
                ((Choice)ChoiceOperator.this.getSource()).select(pos);
            }
        });
    }

    public void setState(final String str) {
        this.runMapping(new Operator.MapVoidAction("select"){

            @Override
            public void map() {
                ((Choice)ChoiceOperator.this.getSource()).select(str);
            }
        });
    }

    private int findItemIndex(String item, Operator.StringComparator comparator, int index) {
        int count = 0;
        for (int i = 0; i < this.getItemCount(); ++i) {
            if (!comparator.equals(this.getItem(i), item)) continue;
            if (count == index) {
                return i;
            }
            ++count;
        }
        return -1;
    }

    private void selectItem(String item, Operator.StringComparator comparator, int index) {
        this.selectItem(this.findItemIndex(item, comparator, index));
    }

    public static class ChoiceBySelectedItemFinder
    implements ComponentChooser {
        String label;
        Operator.StringComparator comparator;

        public ChoiceBySelectedItemFinder(String lb, Operator.StringComparator comparator) {
            this.label = lb;
            this.comparator = comparator;
        }

        public ChoiceBySelectedItemFinder(String lb) {
            this(lb, Operator.getDefaultStringComparator());
        }

        @Override
        public boolean checkComponent(Component comp) {
            if (comp instanceof Choice && ((Choice)comp).getSelectedItem() != null) {
                return this.comparator.equals(((Choice)comp).getSelectedItem(), this.label);
            }
            return false;
        }

        @Override
        public String getDescription() {
            return "Choice with label \"" + this.label + "\"";
        }
    }

    public static class ChoiceFinder
    extends Operator.Finder {
        public ChoiceFinder(ComponentChooser sf) {
            super(Choice.class, sf);
        }

        public ChoiceFinder() {
            super(Choice.class);
        }
    }
}

