/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jcterm;

import com.jcraft.jcterm.Configuration;
import com.jcraft.jcterm.ConfigurationRepositoryFS;
import com.jcraft.jcterm.Connection;
import com.jcraft.jcterm.Frame;
import com.jcraft.jcterm.JCTermSwing;
import com.jcraft.jcterm.JSchSession;
import com.jcraft.jcterm.Sftp;
import com.jcraft.jcterm.Splash;
import com.jcraft.jcterm.Term;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.ProxyHTTP;
import com.jcraft.jsch.ProxySOCKS5;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class JCTermSwingFrame
extends JFrame
implements Frame,
ActionListener,
Runnable {
    static String COPYRIGHT = "JCTerm 0.0.11\nCopyright (C) 2002,2012 ymnk<ymnk@jcraft.com>, JCraft,Inc.\nOfficial Homepage: http://www.jcraft.com/jcterm/\nThis software is licensed under GNU LGPL.";
    private static int counter = 1;
    private int mode = 0;
    private String xhost = "127.0.0.1";
    private int xport = 0;
    private boolean xforwarding = false;
    private String user = "";
    private String host = "127.0.0.1";
    private String proxy_http_host = null;
    private int proxy_http_port = 0;
    private String proxy_socks5_host = null;
    private int proxy_socks5_port = 0;
    private JSchSession jschsession = null;
    private Proxy proxy = null;
    private int compression = 0;
    private Splash splash = null;
    private JCTermSwing term = null;
    private Connection connection = null;
    private Channel channel = null;
    private boolean close_on_exit = true;
    private Frame frame = this;
    private String configName = "default";
    private Thread thread = null;

    static void resetCounter() {
        counter = 1;
    }

    public boolean getCloseOnExit() {
        return this.close_on_exit;
    }

    public void setCloseOnExit(boolean close_on_exit) {
        this.close_on_exit = close_on_exit;
    }

    public JCTermSwingFrame() {
    }

    public JCTermSwingFrame(String name) {
        this(name, "default");
    }

    public JCTermSwingFrame(String name, String configName) {
        super(name);
        this.configName = configName;
        this.setDefaultCloseOperation(2);
        this.enableEvents(8L);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        JMenuBar mb = this.getJMenuBar();
        this.setJMenuBar(mb);
        this.term = new JCTermSwing();
        this.getContentPane().add("Center", this.term);
        this.pack();
        this.term.setVisible(true);
        ComponentAdapter l = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Component c = e.getComponent();
                Container cp = ((JFrame)c).getContentPane();
                int cw = c.getWidth();
                int ch = c.getHeight();
                int cwm = c.getWidth() - cp.getWidth();
                int chm = c.getHeight() - cp.getHeight();
                JCTermSwingFrame.this.term.setSize(cw -= cwm, ch -= chm);
            }
        };
        this.addComponentListener(l);
        this.applyConfig(configName);
        this.openSession();
    }

    public void kick() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    @Override
    public void run() {
        String destination = null;
        while (this.thread != null) {
            try {
                int port = 22;
                try {
                    String _host;
                    String[] destinations = JCTermSwing.getCR().load((String)this.configName).destinations;
                    destination = _host = this.promptDestination(this.term, destinations);
                    if (_host == null) break;
                    String _user = _host.substring(0, _host.indexOf(64));
                    if ((_host = _host.substring(_host.indexOf(64) + 1)) == null || _host.length() == 0) continue;
                    if (_host.indexOf(58) != -1) {
                        try {
                            port = Integer.parseInt(_host.substring(_host.indexOf(58) + 1));
                        }
                        catch (Exception eee) {
                            // empty catch block
                        }
                        _host = _host.substring(0, _host.indexOf(58));
                    }
                    this.user = _user;
                    this.host = _host;
                }
                catch (Exception ee) {
                    continue;
                }
                try {
                    MyUserInfo ui = new MyUserInfo();
                    this.jschsession = JSchSession.getSession(this.user, null, this.host, port, ui, this.proxy);
                    this.setCompression(this.compression);
                    Configuration conf = JCTermSwing.getCR().load(this.configName);
                    conf.addDestination(destination);
                    JCTermSwing.getCR().save(conf);
                }
                catch (Exception e) {
                    break;
                }
                Channel channel = null;
                OutputStream out = null;
                InputStream in = null;
                if (this.mode == 0) {
                    channel = this.jschsession.getSession().openChannel("shell");
                    if (this.xforwarding) {
                        this.jschsession.getSession().setX11Host(this.xhost);
                        this.jschsession.getSession().setX11Port(this.xport + 6000);
                        channel.setXForwarding(true);
                    }
                    out = channel.getOutputStream();
                    in = channel.getInputStream();
                    channel.connect();
                } else if (this.mode == 1) {
                    out = new PipedOutputStream();
                    in = new PipedInputStream();
                    channel = this.jschsession.getSession().openChannel("sftp");
                    channel.connect();
                    new Sftp((ChannelSftp)channel, new PipedInputStream((PipedOutputStream)out), new PipedOutputStream((PipedInputStream)in)).kick();
                }
                final PipedOutputStream fout = out;
                final PipedInputStream fin = in;
                final Channel fchannel = channel;
                this.connection = new Connection(){

                    @Override
                    public InputStream getInputStream() {
                        return fin;
                    }

                    @Override
                    public OutputStream getOutputStream() {
                        return fout;
                    }

                    @Override
                    public void requestResize(Term term) {
                        if (fchannel instanceof ChannelShell) {
                            int c = term.getColumnCount();
                            int r = term.getRowCount();
                            ((ChannelShell)fchannel).setPtySize(c, r, c * term.getCharWidth(), r * term.getCharHeight());
                        }
                    }

                    @Override
                    public void close() {
                        fchannel.disconnect();
                    }
                };
                this.frame.setTitle("[" + counter++ + "] " + this.user + "@" + this.host + (port != 22 ? ":" + new Integer(port).toString() : ""));
                this.term.requestFocus();
                this.term.start(this.connection);
                break;
            }
            catch (Exception exception) {
                // empty catch block
                break;
            }
        }
        this.frame.setTitle("JCTerm");
        this.thread = null;
        this.dispose_connection();
        if (this.getCloseOnExit()) {
            this.frame.setVisible(false);
            this.frame.dispose();
        } else {
            this.term.clear();
            this.term.redraw(0, 0, this.term.getWidth(), this.term.getHeight());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose_connection() {
        JCTermSwingFrame jCTermSwingFrame = this;
        synchronized (jCTermSwingFrame) {
            if (this.channel != null) {
                this.channel.disconnect();
                this.channel = null;
            }
        }
    }

    public void setProxyHttp(String host, int port) {
        this.proxy_http_host = host;
        this.proxy_http_port = port;
        this.proxy = this.proxy_http_host != null && this.proxy_http_port != 0 ? new ProxyHTTP(this.proxy_http_host, this.proxy_http_port) : null;
    }

    public String getProxyHttpHost() {
        return this.proxy_http_host;
    }

    public int getProxyHttpPort() {
        return this.proxy_http_port;
    }

    public void setProxySOCKS5(String host, int port) {
        this.proxy_socks5_host = host;
        this.proxy_socks5_port = port;
        this.proxy = this.proxy_socks5_host != null && this.proxy_socks5_port != 0 ? new ProxySOCKS5(this.proxy_socks5_host, this.proxy_socks5_port) : null;
    }

    public String getProxySOCKS5Host() {
        return this.proxy_socks5_host;
    }

    public int getProxySOCKS5Port() {
        return this.proxy_socks5_port;
    }

    public void setXHost(String xhost) {
        this.xhost = xhost;
    }

    public void setXPort(int xport) {
        this.xport = xport;
    }

    public void setXForwarding(boolean foo) {
        this.xforwarding = foo;
    }

    public void setCompression(int compression) {
        if (compression < 0 || 9 < compression) {
            return;
        }
        this.compression = compression;
        if (this.jschsession != null) {
            if (compression == 0) {
                this.jschsession.getSession().setConfig("compression.s2c", "none");
                this.jschsession.getSession().setConfig("compression.c2s", "none");
                this.jschsession.getSession().setConfig("compression_level", "0");
            } else {
                this.jschsession.getSession().setConfig("compression.s2c", "zlib@openssh.com,zlib,none");
                this.jschsession.getSession().setConfig("compression.c2s", "zlib@openssh.com,zlib,none");
                this.jschsession.getSession().setConfig("compression_level", new Integer(compression).toString());
            }
            try {
                this.jschsession.getSession().rekey();
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
    }

    public void setFontSize(int size) {
        Configuration conf = JCTermSwing.getCR().load(this.configName);
        conf.font_size = size;
        JCTermSwing.getCR().save(conf);
        this._setFontSize(size);
    }

    private void _setFontSize(int size) {
        int mwidth = this.frame.getWidth() - this.term.getTermWidth();
        int mheight = this.frame.getHeight() - this.term.getTermHeight();
        this.term.setFont("Monospaced-" + size);
        this.frame.setSize(mwidth + this.term.getTermWidth(), mheight + this.term.getTermHeight());
        this.term.clear();
        this.term.redraw(0, 0, this.term.getWidth(), this.term.getHeight());
    }

    public int getCompression() {
        return this.compression;
    }

    public void setLineSpace(int foo) {
        this.term.setLineSpace(foo);
    }

    public void setSplash(Splash foo) {
        this.splash = foo;
    }

    public boolean getAntiAliasing() {
        return this.term.getAntiAliasing();
    }

    public void setAntiAliasing(boolean foo) {
        this.term.setAntiAliasing(foo);
    }

    public void setUserHost(String userhost) {
        try {
            String _user = userhost.substring(0, userhost.indexOf(64));
            String _host = userhost.substring(userhost.indexOf(64) + 1);
            this.user = _user;
            this.host = _host;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void openSession() {
        this.kick();
    }

    public void setPortForwardingL(int port1, String host, int port2) {
        if (this.jschsession == null) {
            return;
        }
        try {
            this.jschsession.getSession().setPortForwardingL(port1, host, port2);
        }
        catch (JSchException e) {
            // empty catch block
        }
    }

    public void setPortForwardingR(int port1, String host, int port2) {
        if (this.jschsession == null) {
            return;
        }
        try {
            this.jschsession.getSession().setPortForwardingR(port1, host, port2);
        }
        catch (JSchException e) {
            // empty catch block
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block42: {
            String action = e.getActionCommand();
            int _mode = 0;
            if (action.equals("Open SHELL Session...")) {
                _mode = 0;
            } else if (action.equals("Open SFTP Session...")) {
                _mode = 1;
            }
            if (action.equals("Open SHELL Session...") || action.equals("Open SFTP Session...")) {
                if (this.thread == null) {
                    this.mode = _mode;
                    this.openSession();
                } else {
                    this.frame.openFrame(_mode, this.configName);
                }
            } else if (action.equals("HTTP...")) {
                String foo = this.getProxyHttpHost();
                int bar = this.getProxyHttpPort();
                String proxy = JOptionPane.showInputDialog(this, "HTTP proxy server (hostname:port)", foo != null && bar != 0 ? foo + ":" + bar : "");
                if (proxy == null) {
                    return;
                }
                if (proxy.length() == 0) {
                    this.setProxyHttp(null, 0);
                    return;
                }
                try {
                    foo = proxy.substring(0, proxy.indexOf(58));
                    bar = Integer.parseInt(proxy.substring(proxy.indexOf(58) + 1));
                    if (foo != null) {
                        this.setProxyHttp(foo, bar);
                    }
                }
                catch (Exception ee) {}
            } else if (action.equals("SOCKS5...")) {
                String foo = this.getProxySOCKS5Host();
                int bar = this.getProxySOCKS5Port();
                String proxy = JOptionPane.showInputDialog(this, "SOCKS5 server (hostname:1080)", foo != null && bar != 0 ? foo + ":" + bar : "");
                if (proxy == null) {
                    return;
                }
                if (proxy.length() == 0) {
                    this.setProxySOCKS5(null, 0);
                    return;
                }
                try {
                    foo = proxy.substring(0, proxy.indexOf(58));
                    bar = Integer.parseInt(proxy.substring(proxy.indexOf(58) + 1));
                    if (foo != null) {
                        this.setProxySOCKS5(foo, bar);
                    }
                }
                catch (Exception ee) {}
            } else if (action.equals("X11 Forwarding...")) {
                String display = JOptionPane.showInputDialog(this, "XDisplay name (hostname:0)", this.xhost == null ? "" : this.xhost + ":" + this.xport);
                try {
                    if (display != null) {
                        this.xhost = display.substring(0, display.indexOf(58));
                        this.xport = Integer.parseInt(display.substring(display.indexOf(58) + 1));
                        this.xforwarding = true;
                    }
                }
                catch (Exception ee) {
                    this.xforwarding = false;
                    this.xhost = null;
                }
            } else if (action.equals("AntiAliasing")) {
                this.setAntiAliasing(!this.getAntiAliasing());
            } else if (action.equals("Compression...")) {
                String foo = JOptionPane.showInputDialog(this, "Compression level(0-9)\n0 means no compression.\n1 means fast.\n9 means slow, but best.", new Integer(this.compression).toString());
                try {
                    if (foo != null) {
                        this.compression = Integer.parseInt(foo);
                        this.setCompression(this.compression);
                    }
                }
                catch (Exception ee) {}
            } else {
                if (action.equals("About...")) {
                    JOptionPane.showMessageDialog(this, COPYRIGHT);
                    return;
                }
                if (action.equals("Local Port...") || action.equals("Remote Port...")) {
                    if (this.jschsession == null) {
                        JOptionPane.showMessageDialog(this, "Establish the connection before this setting.");
                        return;
                    }
                    try {
                        String title = "";
                        title = action.equals("Local Port...") ? title + "Local port forwarding" : title + "remote port forwarding";
                        title = title + "(port:host:hostport)";
                        String foo = JOptionPane.showInputDialog(this, title, "");
                        if (foo == null) {
                            return;
                        }
                        int port1 = Integer.parseInt(foo.substring(0, foo.indexOf(58)));
                        foo = foo.substring(foo.indexOf(58) + 1);
                        String host = foo.substring(0, foo.indexOf(58));
                        int port2 = Integer.parseInt(foo.substring(foo.indexOf(58) + 1));
                        if (action.equals("Local Port...")) {
                            this.setPortForwardingL(port1, host, port2);
                            break block42;
                        }
                        this.setPortForwardingR(port1, host, port2);
                    }
                    catch (Exception ee) {}
                } else if (action.equals("Quit")) {
                    this.quit();
                }
            }
        }
    }

    @Override
    public JMenuBar getJMenuBar() {
        JMenuBar mb = new JMenuBar();
        JMenu m = new JMenu("File");
        JMenuItem mi = new JMenuItem("Open SHELL Session...");
        mi.addActionListener(this);
        mi.setActionCommand("Open SHELL Session...");
        m.add(mi);
        mi = new JMenuItem("Open SFTP Session...");
        mi.addActionListener(this);
        mi.setActionCommand("Open SFTP Session...");
        m.add(mi);
        mi = new JMenuItem("Quit");
        mi.addActionListener(this);
        mi.setActionCommand("Quit");
        m.add(mi);
        mb.add(m);
        m = new JMenu("Proxy");
        mi = new JMenuItem("HTTP...");
        mi.addActionListener(this);
        mi.setActionCommand("HTTP...");
        m.add(mi);
        mi = new JMenuItem("SOCKS5...");
        mi.addActionListener(this);
        mi.setActionCommand("SOCKS5...");
        m.add(mi);
        mb.add(m);
        m = new JMenu("PortForwarding");
        mi = new JMenuItem("Local Port...");
        mi.addActionListener(this);
        mi.setActionCommand("Local Port...");
        m.add(mi);
        mi = new JMenuItem("Remote Port...");
        mi.addActionListener(this);
        mi.setActionCommand("Remote Port...");
        m.add(mi);
        mi = new JMenuItem("X11 Forwarding...");
        mi.addActionListener(this);
        mi.setActionCommand("X11 Forwarding...");
        m.add(mi);
        mb.add(m);
        m = new JMenu("Etc");
        mi = new JMenuItem("AntiAliasing");
        mi.addActionListener(this);
        mi.setActionCommand("AntiAliasing");
        m.add(mi);
        mi = new JMenuItem("Compression...");
        mi.addActionListener(this);
        mi.setActionCommand("Compression...");
        m.add(mi);
        JMenu mcolor = new JMenu("Color");
        final ActionListener mcolor_action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCTermSwingFrame.this.setFgBg(e.getActionCommand());
            }
        };
        mcolor.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent me) {
                JMenu jm = (JMenu)me.getSource();
                String[] fg_bg = JCTermSwing.getCR().load((String)((JCTermSwingFrame)JCTermSwingFrame.this).configName).fg_bg;
                for (int i = 0; i < fg_bg.length; ++i) {
                    String[] tmp = fg_bg[i].split(":");
                    JMenuItem mi = new JMenuItem("ABC");
                    mi.setForeground(JCTermSwing.toColor(tmp[0]));
                    mi.setBackground(JCTermSwing.toColor(tmp[1]));
                    mi.setActionCommand(fg_bg[i]);
                    mi.addActionListener(mcolor_action);
                    jm.add(mi);
                }
            }

            @Override
            public void menuDeselected(MenuEvent me) {
                JMenu jm = (JMenu)me.getSource();
                jm.removeAll();
            }

            @Override
            public void menuCanceled(MenuEvent arg) {
            }
        });
        m.add(mcolor);
        JMenu mfsize = new JMenu("Font size");
        final ActionListener mfsize_action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String _font_size = e.getActionCommand();
                try {
                    JCTermSwingFrame.this.setFontSize(Integer.parseInt(_font_size));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        };
        mfsize.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent me) {
                JMenu jm = (JMenu)me.getSource();
                int font_size = JCTermSwing.getCR().load((String)((JCTermSwingFrame)JCTermSwingFrame.this).configName).font_size;
                JMenuItem mi = new JMenuItem("Smaller (" + (font_size - 1) + ")");
                mi.setActionCommand("" + (font_size - 1));
                mi.addActionListener(mfsize_action);
                jm.add(mi);
                mi = new JMenuItem("Larger (" + (font_size + 1) + ")");
                mi.setActionCommand("" + (font_size + 1));
                mi.addActionListener(mfsize_action);
                jm.add(mi);
            }

            @Override
            public void menuDeselected(MenuEvent me) {
                JMenu jm = (JMenu)me.getSource();
                jm.removeAll();
            }

            @Override
            public void menuCanceled(MenuEvent arg) {
            }
        });
        m.add(mfsize);
        mb.add(m);
        m = new JMenu("Help");
        mi = new JMenuItem("About...");
        mi.addActionListener(this);
        mi.setActionCommand("About...");
        m.add(mi);
        mb.add(m);
        return mb;
    }

    public void quit() {
        this.thread = null;
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }

    public void setTerm(JCTermSwing term) {
        this.term = term;
    }

    public Term getTerm() {
        return this.term;
    }

    @Override
    public void openFrame(int _mode, String configName) {
        JCTermSwingFrame c = new JCTermSwingFrame("JCTerm", configName);
        c.mode = _mode;
        c.setXForwarding(true);
        c.setXPort(this.xport);
        c.setXHost(this.xhost);
        c.setLocationRelativeTo(null);
        c.setVisible(true);
        c.setResizable(true);
    }

    void setFgBg(String fg_bg) {
        Configuration conf = JCTermSwing.getCR().load(this.configName);
        conf.addFgBg(fg_bg);
        JCTermSwing.getCR().save(conf);
        this._setFgBg(fg_bg);
    }

    private void _setFgBg(String fg_bg) {
        String[] tmp = fg_bg.split(":");
        Color fg = JCTermSwing.toColor(tmp[0]);
        Color bg = JCTermSwing.toColor(tmp[1]);
        this.term.setForeGround(fg);
        this.term.setDefaultForeGround(fg);
        this.term.setBackGround(bg);
        this.term.setDefaultBackGround(bg);
        this.term.resetCursorGraphics();
        this.term.clear();
        this.term.redraw(0, 0, this.term.getWidth(), this.term.getHeight());
    }

    private String promptDestination(JComponent term, String[] destinations) {
        JComboBox<String> jb = new JComboBox<String>();
        jb.setEditable(true);
        for (int i = 0; i < destinations.length; ++i) {
            jb.addItem(destinations[i]);
        }
        JPanel panel = new JPanel();
        jb.requestFocusInWindow();
        JOptionPane pane = new JOptionPane(jb, 3, 2){

            @Override
            public void selectInitialValue() {
            }
        };
        JDialog dialog = pane.createDialog(this.term, "Enter username@hostname");
        dialog.setDefaultCloseOperation(2);
        dialog.setVisible(true);
        Object o = pane.getValue();
        String d = null;
        if (o != null && (Integer)o == 0) {
            d = (String)jb.getSelectedItem();
        }
        if (d == null || d.length() == 0) {
            return null;
        }
        return d;
    }

    void setFrame(Frame frame) {
        this.frame = frame;
    }

    void applyConfig(String configName) {
        this.configName = configName;
        Configuration conf = JCTermSwing.getCR().load(configName);
        this._setFontSize(conf.font_size);
        this._setFgBg(conf.fg_bg[0]);
    }

    public static void main(String[] arg) {
        JCTermSwing.setCR(new ConfigurationRepositoryFS());
        String s = System.getProperty("jcterm.config.use_ssh_agent");
        if (s != null && s.equals("true")) {
            JSchSession.useSSHAgent(true);
        }
        JCTermSwingFrame frame = new JCTermSwingFrame("JCTerm");
        frame.setCloseOnExit(false);
        frame.setVisible(true);
        frame.setResizable(true);
    }

    public class MyUserInfo
    implements UserInfo,
    UIKeyboardInteractive {
        String passwd = null;
        String passphrase = null;
        JTextField pword = new JPasswordField(20);
        final GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        private Container panel;

        public boolean promptYesNo(String str) {
            Object[] options = new Object[]{"yes", "no"};
            int foo = JOptionPane.showOptionDialog(JCTermSwingFrame.this.term, str, "Warning", -1, 2, null, options, options[0]);
            return foo == 0;
        }

        public String getPassword() {
            return this.passwd;
        }

        public String getPassphrase() {
            return this.passphrase;
        }

        public boolean promptPassword(String message) {
            Object[] ob = new Object[]{this.pword};
            JPanel panel = new JPanel();
            panel.add(this.pword);
            this.pword.requestFocusInWindow();
            JOptionPane pane = new JOptionPane(panel, 3, 2){

                @Override
                public void selectInitialValue() {
                }
            };
            JDialog dialog = pane.createDialog(JCTermSwingFrame.this.term, message);
            dialog.setDefaultCloseOperation(2);
            dialog.setVisible(true);
            Object o = pane.getValue();
            if (o != null && (Integer)o == 0) {
                this.passwd = this.pword.getText();
                return true;
            }
            return false;
        }

        public boolean promptPassphrase(String message) {
            return true;
        }

        public void showMessage(String message) {
            JOptionPane.showMessageDialog(null, message);
        }

        public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
            int i;
            this.panel = new JPanel();
            this.panel.setLayout(new GridBagLayout());
            this.gbc.weightx = 1.0;
            this.gbc.gridwidth = 0;
            this.gbc.gridx = 0;
            this.panel.add((Component)new JLabel(instruction), this.gbc);
            ++this.gbc.gridy;
            this.gbc.gridwidth = -1;
            JTextField[] texts = new JTextField[prompt.length];
            for (i = 0; i < prompt.length; ++i) {
                this.gbc.fill = 0;
                this.gbc.gridx = 0;
                this.gbc.weightx = 1.0;
                this.panel.add((Component)new JLabel(prompt[i]), this.gbc);
                this.gbc.gridx = 1;
                this.gbc.fill = 2;
                this.gbc.weighty = 1.0;
                if (echo[i]) {
                    texts[i] = new JTextField(20);
                } else {
                    texts[i] = new JPasswordField(20);
                    texts[i].requestFocusInWindow();
                }
                this.panel.add((Component)texts[i], this.gbc);
                ++this.gbc.gridy;
            }
            for (i = prompt.length - 1; i > 0; --i) {
                texts[i].requestFocusInWindow();
            }
            JOptionPane pane = new JOptionPane(this.panel, 3, 2){

                @Override
                public void selectInitialValue() {
                }
            };
            JDialog dialog = pane.createDialog(JCTermSwingFrame.this.term, destination + ": " + name);
            dialog.setDefaultCloseOperation(2);
            dialog.setVisible(true);
            Object o = pane.getValue();
            if (o != null && (Integer)o == 0) {
                String[] response = new String[prompt.length];
                for (int i2 = 0; i2 < prompt.length; ++i2) {
                    response[i2] = texts[i2].getText();
                }
                return response;
            }
            return null;
        }
    }
}

