/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.rebase;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.Collection;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.ui.rebase.BasicPanel;
import org.netbeans.modules.mercurial.ui.rebase.Bundle;
import org.netbeans.modules.mercurial.ui.rebase.SelectBasePanel;
import org.netbeans.modules.mercurial.ui.rebase.SelectDestPanel;
import org.netbeans.modules.mercurial.ui.rebase.SelectSourcePanel;
import org.netbeans.modules.mercurial.ui.repository.HeadRevisionPicker;

abstract class RebaseKind {
    private final String id;
    private final PropertyChangeSupport support;
    private boolean valid;

    public RebaseKind(String id) {
        this.id = id;
        this.support = new PropertyChangeSupport(this);
    }

    public abstract String getDisplayName();

    public abstract String getDescription();

    public abstract JPanel getPanel();

    public abstract String getBase();

    public abstract String getSource();

    public abstract String getDest();

    public final String getId() {
        return this.id;
    }

    public final void addPropertyChangeListener(PropertyChangeListener list) {
        this.support.addPropertyChangeListener(list);
    }

    protected final void setValid(boolean valid) {
        boolean oldValid = this.valid;
        this.valid = valid;
        this.support.firePropertyChange("rebase.propValid", oldValid, valid);
    }

    public final boolean isValid() {
        return this.valid;
    }

    protected static void setRevision(JTextField tf, HgLogMessage message, String wcparentCSetId) {
        tf.setText(message.toAnnotatedString(wcparentCSetId));
    }

    public static class BasicKind
    extends RebaseKind {
        private final BasicPanel basicPanel = new BasicPanel();
        private final String wcParentCSet;
        private String dest;

        public BasicKind(Collection<HgLogMessage> branchHeads, HgLogMessage workingCopyParent) {
            super(BasicKind.class.getName());
            this.wcParentCSet = workingCopyParent.getCSetShortID();
            this.initialize(branchHeads, workingCopyParent);
        }

        @Override
        public String getDisplayName() {
            return Bundle.LBL_RebaseKind_basic_displayName();
        }

        @Override
        public String getDescription() {
            return Bundle.LBL_RebaseKind_basic_description();
        }

        @Override
        public JPanel getPanel() {
            return this.basicPanel;
        }

        @Override
        public String getBase() {
            return this.wcParentCSet;
        }

        @Override
        public String getSource() {
            return null;
        }

        @Override
        public String getDest() {
            return this.dest;
        }

        private void initialize(Collection<HgLogMessage> branchHeads, HgLogMessage workingCopyParent) {
            HgLogMessage tipmostHead = branchHeads.iterator().next();
            for (HgLogMessage head : branchHeads) {
                if (head.getRevisionAsLong() <= tipmostHead.getRevisionAsLong()) continue;
                tipmostHead = head;
            }
            this.dest = tipmostHead.getCSetShortID();
            BasicKind.setRevision(this.basicPanel.jTextField1, workingCopyParent, this.wcParentCSet);
            BasicKind.setRevision(this.basicPanel.jTextField2, tipmostHead, this.wcParentCSet);
            this.setValid(workingCopyParent.getRevisionAsLong() != tipmostHead.getRevisionAsLong());
        }
    }

    public static class SelectBaseKind
    extends RebaseKind
    implements ActionListener {
        private final SelectBasePanel panel;
        private HgLogMessage base;
        private HgLogMessage dest;
        private final File repository;
        private final String wcParentCSet;

        public SelectBaseKind(File repository, Collection<HgLogMessage> branchHeads, HgLogMessage workingCopyParent) {
            super(SelectBaseKind.class.getName());
            this.repository = repository;
            this.panel = new SelectBasePanel();
            this.wcParentCSet = workingCopyParent.getCSetShortID();
            this.base = workingCopyParent;
            this.initialize(branchHeads);
            this.attachListeners();
        }

        @Override
        public String getDisplayName() {
            return Bundle.LBL_RebaseKind_base_displayName();
        }

        @Override
        public String getDescription() {
            return Bundle.LBL_RebaseKind_base_description();
        }

        @Override
        public JPanel getPanel() {
            return this.panel;
        }

        @Override
        public String getBase() {
            return this.base.getCSetShortID();
        }

        @Override
        public String getSource() {
            return null;
        }

        @Override
        public String getDest() {
            return this.dest.getCSetShortID();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HeadRevisionPicker picker;
            if (e.getSource() == this.panel.btnBrowseDest) {
                HeadRevisionPicker picker2 = new HeadRevisionPicker(this.repository, null);
                if (picker2.showDialog()) {
                    this.dest = picker2.getSelectionRevision();
                    this.updateLabels();
                }
            } else if (e.getSource() == this.panel.btnBrowseBase && (picker = new HeadRevisionPicker(this.repository, null)).showDialog()) {
                this.base = picker.getSelectionRevision();
                this.updateLabels();
            }
        }

        private void initialize(Collection<HgLogMessage> branchHeads) {
            this.dest = branchHeads.iterator().next();
            for (HgLogMessage head : branchHeads) {
                if (head.getRevisionAsLong() <= this.dest.getRevisionAsLong() && !this.dest.getCSetShortID().equals(this.base.getCSetShortID())) continue;
                this.dest = head;
            }
            this.updateLabels();
        }

        private void updateLabels() {
            SelectBaseKind.setRevision(this.panel.tfBaseRevision, this.base, this.wcParentCSet);
            SelectBaseKind.setRevision(this.panel.tfDestinationRevision, this.dest, this.wcParentCSet);
            this.setValid(!this.base.getCSetShortID().equals(this.dest.getCSetShortID()));
        }

        private void attachListeners() {
            this.panel.btnBrowseBase.addActionListener(this);
            this.panel.btnBrowseDest.addActionListener(this);
        }
    }

    public static class SelectDestinationKind
    extends RebaseKind
    implements ActionListener {
        private final SelectDestPanel panel;
        private final String wcParentCSet;
        private HgLogMessage dest;
        private final File repository;

        public SelectDestinationKind(File repository, Collection<HgLogMessage> branchHeads, HgLogMessage workingCopyParent) {
            super(SelectDestinationKind.class.getName());
            this.repository = repository;
            this.panel = new SelectDestPanel();
            this.wcParentCSet = workingCopyParent.getCSetShortID();
            this.initialize(branchHeads, workingCopyParent);
            this.attachListeners();
        }

        @Override
        public String getDisplayName() {
            return Bundle.LBL_RebaseKind_destination_displayName();
        }

        @Override
        public String getDescription() {
            return Bundle.LBL_RebaseKind_destination_description();
        }

        @Override
        public JPanel getPanel() {
            return this.panel;
        }

        @Override
        public String getBase() {
            return this.wcParentCSet;
        }

        @Override
        public String getSource() {
            return null;
        }

        @Override
        public String getDest() {
            return this.dest.getCSetShortID();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HeadRevisionPicker picker;
            if (e.getSource() == this.panel.btnBrowse && (picker = new HeadRevisionPicker(this.repository, null)).showDialog()) {
                this.dest = picker.getSelectionRevision();
                this.updateLabels();
            }
        }

        private void initialize(Collection<HgLogMessage> branchHeads, HgLogMessage workingCopyParent) {
            this.dest = branchHeads.iterator().next();
            for (HgLogMessage head : branchHeads) {
                if (head.getRevisionAsLong() <= this.dest.getRevisionAsLong() && this.dest.getRevisionAsLong() != workingCopyParent.getRevisionAsLong()) continue;
                this.dest = head;
            }
            SelectDestinationKind.setRevision(this.panel.tfBaseRevision, workingCopyParent, this.wcParentCSet);
            this.updateLabels();
        }

        private void updateLabels() {
            SelectDestinationKind.setRevision(this.panel.tfDestinationRevision, this.dest, this.wcParentCSet);
            this.setValid(!this.wcParentCSet.equals(this.dest.getCSetShortID()));
        }

        private void attachListeners() {
            this.panel.btnBrowse.addActionListener(this);
        }
    }

    public static class SelectSourceKind
    extends RebaseKind
    implements ActionListener {
        private final SelectSourcePanel panel;
        private HgLogMessage source;
        private HgLogMessage dest;
        private final File repository;
        private final String wcParentCSet;

        public SelectSourceKind(File repository, Collection<HgLogMessage> branchHeads, HgLogMessage workingCopyParent) {
            super(SelectSourceKind.class.getName());
            this.repository = repository;
            this.panel = new SelectSourcePanel();
            this.wcParentCSet = workingCopyParent.getCSetShortID();
            this.source = workingCopyParent;
            this.initialize(branchHeads);
            this.attachListeners();
        }

        @Override
        public String getDisplayName() {
            return Bundle.LBL_RebaseKind_source_displayName();
        }

        @Override
        public String getDescription() {
            return Bundle.LBL_RebaseKind_source_description();
        }

        @Override
        public JPanel getPanel() {
            return this.panel;
        }

        @Override
        public String getBase() {
            return null;
        }

        @Override
        public String getSource() {
            return this.source.getCSetShortID();
        }

        @Override
        public String getDest() {
            return this.dest.getCSetShortID();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HeadRevisionPicker picker;
            if (e.getSource() == this.panel.btnBrowseDest) {
                HeadRevisionPicker picker2 = new HeadRevisionPicker(this.repository, null);
                if (picker2.showDialog()) {
                    this.dest = picker2.getSelectionRevision();
                    this.updateLabels();
                }
            } else if (e.getSource() == this.panel.btnBrowseSource && (picker = new HeadRevisionPicker(this.repository, null)).showDialog()) {
                this.source = picker.getSelectionRevision();
                this.updateLabels();
            }
        }

        private void initialize(Collection<HgLogMessage> branchHeads) {
            this.dest = branchHeads.iterator().next();
            for (HgLogMessage head : branchHeads) {
                if (head.getRevisionAsLong() <= this.dest.getRevisionAsLong() && !this.dest.getCSetShortID().equals(this.source.getCSetShortID())) continue;
                this.dest = head;
            }
            this.updateLabels();
        }

        private void updateLabels() {
            SelectSourceKind.setRevision(this.panel.tfSourceRevision, this.source, this.wcParentCSet);
            SelectSourceKind.setRevision(this.panel.tfDestinationRevision, this.dest, this.wcParentCSet);
            this.setValid(!this.source.getCSetShortID().equals(this.dest.getCSetShortID()));
        }

        private void attachListeners() {
            this.panel.btnBrowseSource.addActionListener(this);
            this.panel.btnBrowseDest.addActionListener(this);
        }
    }
}

