/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.diff;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.ui.diff.DiffNode;
import org.netbeans.modules.mercurial.ui.diff.MultiDiffPanel;
import org.netbeans.modules.mercurial.ui.status.OpenInEditorAction;
import org.netbeans.modules.versioning.diff.DiffUtils;
import org.netbeans.modules.versioning.util.CollectionUtils;
import org.netbeans.modules.versioning.util.FilePathCellRenderer;
import org.netbeans.modules.versioning.util.SortedTable;
import org.netbeans.modules.versioning.util.TableSorter;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.common.FileViewComponent;
import org.openide.ErrorManager;
import org.openide.awt.MouseUtils;
import org.openide.cookies.EditorCookie;
import org.openide.explorer.view.NodeTableModel;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

class DiffFileTable
implements FileViewComponent<DiffNode>,
MouseListener,
ListSelectionListener,
AncestorListener {
    private final NodeTableModel tableModel;
    private final JTable table;
    private final JScrollPane component;
    private DiffNode[] nodes = new DiffNode[0];
    private EditorCookie[] editorCookies;
    private String[] tableColumns;
    private final TableSorter sorter;
    private static final Map<String, String[]> columnLabels = new HashMap<String, String[]>(4);
    private static final Comparator NodeComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            Node.Property p1 = (Node.Property)o1;
            Node.Property p2 = (Node.Property)o2;
            String sk1 = (String)p1.getValue("sortkey");
            if (sk1 != null) {
                String sk2 = (String)p2.getValue("sortkey");
                return sk1.compareToIgnoreCase(sk2);
            }
            try {
                String s1 = (String)p1.getValue();
                String s2 = (String)p2.getValue();
                return s1.compareToIgnoreCase(s2);
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify((Throwable)e);
                return 0;
            }
        }
    };
    private final MultiDiffPanel master;
    private PropertyChangeListener changeListener;

    public DiffFileTable(MultiDiffPanel master) {
        ResourceBundle loc = NbBundle.getBundle(DiffFileTable.class);
        columnLabels.put("name", new String[]{loc.getString("CTL_DiffTable_Column_Name_Title"), loc.getString("CTL_DiffTable_Column_Name_Desc")});
        columnLabels.put("status", new String[]{loc.getString("CTL_DiffTable_Column_Status_Title"), loc.getString("CTL_DiffTable_Column_Status_Desc")});
        columnLabels.put("location", new String[]{loc.getString("CTL_DiffTable_Column_Location_Title"), loc.getString("CTL_DiffTable_Column_Location_Desc")});
        this.master = master;
        this.tableModel = new NodeTableModel();
        this.sorter = new TableSorter((TableModel)this.tableModel);
        this.sorter.setColumnComparator(Node.Property.class, NodeComparator);
        this.table = new SortedTable(this.sorter);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.setSelectionMode(2);
        this.table.setRowHeight(this.table.getFontMetrics(this.table.getFont()).getHeight() * 6 / 5);
        this.component = new JScrollPane(this.table, 22, 31);
        this.component.getViewport().setBackground(this.table.getBackground());
        Color borderColor = UIManager.getColor("scrollpane_border");
        if (borderColor == null) {
            borderColor = UIManager.getColor("controlShadow");
        }
        this.component.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, borderColor));
        this.table.addMouseListener(this);
        this.table.setDefaultRenderer(Node.Property.class, new DiffTableCellRenderer());
        this.table.addAncestorListener(this);
        this.table.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DiffFileTable.class, (String)"ACSN_DiffTable"));
        this.table.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DiffFileTable.class, (String)"ACSD_DiffTable"));
        this.setColumns(new String[]{"name", "status", "location"});
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(121, 64), "org.openide.actions.PopupAction");
        this.table.getActionMap().put("org.openide.actions.PopupAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiffFileTable.this.showPopup(Utils.getPositionForPopup((JTable)DiffFileTable.this.table));
            }
        });
    }

    public DiffNode getSelectedNode() {
        DiffNode selected = null;
        if (this.table.getSelectedRowCount() == 1) {
            int modelRow = this.getSelectedModelIndex();
            selected = this.nodes[modelRow];
        }
        return selected;
    }

    public void setSelectedNode(DiffNode toSelect) {
        int index = Arrays.asList(this.nodes).indexOf((Object)toSelect);
        if (index >= 0) {
            index = this.sorter.viewIndex(index);
            this.setSelectedIndex(index);
        }
    }

    public DiffNode getNodeAtPosition(int position) {
        return this.nodes[this.sorter.modelIndex(position)];
    }

    public DiffNode[] getNeighbouringNodes(DiffNode node, int boundary) {
        DiffNode[] nodes;
        int index = Arrays.asList(this.nodes).indexOf((Object)node);
        if (index < 0) {
            nodes = new DiffNode[]{};
        } else {
            index = this.sorter.viewIndex(index);
            int min = Math.max(0, index - 2);
            int max = Math.min(this.table.getRowCount() - 1, index + 2);
            nodes = new DiffNode[max - min + 1];
            int i = index;
            int k = 0;
            for (int j = index + 1; i >= min || j <= max; --i, ++j) {
                if (i >= min) {
                    nodes[k++] = this.getNodeAtPosition(i);
                }
                if (j > max) continue;
                nodes[k++] = this.getNodeAtPosition(j);
            }
        }
        return nodes;
    }

    public DiffNode getNextNode(DiffNode node) {
        int index;
        DiffNode next = null;
        if (node != null && (index = Arrays.asList(this.nodes).indexOf((Object)node)) >= 0) {
            index = this.sorter.viewIndex(index);
            if (++index < this.table.getRowCount()) {
                next = this.nodes[this.getModelIndex(index)];
            }
        }
        return next;
    }

    public DiffNode getPreviousNode(DiffNode node) {
        int index;
        DiffNode prev = null;
        if (node != null && (index = Arrays.asList(this.nodes).indexOf((Object)node)) >= 0) {
            index = this.sorter.viewIndex(index);
            if (--index >= 0) {
                prev = this.nodes[this.getModelIndex(index)];
            }
        }
        return prev;
    }

    public boolean hasNextNode(DiffNode node) {
        return this.getNextNode(node) != null;
    }

    public boolean hasPreviousNode(DiffNode node) {
        return this.getPreviousNode(node) != null;
    }

    void setDefaultColumnSizes() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int width = DiffFileTable.this.table.getWidth();
                if (DiffFileTable.this.tableColumns.length == 3) {
                    for (int i = 0; i < DiffFileTable.this.tableColumns.length; ++i) {
                        if ("location".equals(DiffFileTable.this.tableColumns[i])) {
                            DiffFileTable.this.table.getColumnModel().getColumn(i).setPreferredWidth(width * 60 / 100);
                            continue;
                        }
                        DiffFileTable.this.table.getColumnModel().getColumn(i).setPreferredWidth(width * 20 / 100);
                    }
                }
            }
        });
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        this.setDefaultColumnSizes();
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
    }

    public JComponent getComponent() {
        return this.component;
    }

    final void setColumns(String[] columns) {
        if (Arrays.equals(columns, this.tableColumns)) {
            return;
        }
        this.setModelProperties(columns);
        this.tableColumns = columns;
        for (int i = 0; i < this.tableColumns.length; ++i) {
            this.sorter.setColumnComparator(i, null);
            this.sorter.setSortingStatus(i, 0);
            if (!"status".equals(this.tableColumns[i])) continue;
            this.sorter.setSortingStatus(i, 1);
            break;
        }
        this.setDefaultColumnSizes();
    }

    public int getPreferredHeaderHeight() {
        return this.getTable().getTableHeader().getPreferredSize().height;
    }

    public int getPreferredHeight() {
        return this.getTable().getPreferredSize().height;
    }

    private void setModelProperties(String[] columns) {
        Node.Property[] properties = new Node.Property[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            String column = columns[i];
            String[] labels = columnLabels.get(column);
            properties[i] = new ColumnDescriptor(column, String.class, labels[0], labels[1]);
        }
        this.tableModel.setProperties(properties);
    }

    public Object prepareModel(DiffNode[] nodes) {
        return null;
    }

    public void setModel(DiffNode[] nodes, EditorCookie[] editorCookies, Object modelData) {
        this.editorCookies = editorCookies;
        this.nodes = nodes;
        this.tableModel.setNodes((Node[])nodes);
        this.changeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Object source = e.getSource();
                String propertyName = e.getPropertyName();
                if ("modified".equals(propertyName) && source instanceof EditorCookie.Observable) {
                    DiffFileTable.this.statusModifiedChanged((EditorCookie)((EditorCookie.Observable)source));
                }
            }
        };
        for (EditorCookie editorCookie : this.editorCookies) {
            if (!(editorCookie instanceof EditorCookie.Observable)) continue;
            ((EditorCookie.Observable)editorCookie).addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.changeListener, (Object)editorCookie));
        }
    }

    private void statusModifiedChanged(EditorCookie editorCookie) {
        int index = CollectionUtils.findInArray((Object[])this.editorCookies, (Object)editorCookie);
        if (index == -1) {
            return;
        }
        this.tableModel.fireTableChanged((TableModelEvent)new TableSorter.SortingSafeTableModelEvent((TableModel)this.tableModel, index, 0));
    }

    void focus() {
        this.table.requestFocus();
    }

    private void setSelectedIndex(int currentIndex) {
        if (currentIndex == this.table.getSelectedRow()) {
            return;
        }
        this.table.getSelectionModel().setSelectionInterval(currentIndex, currentIndex);
        this.table.scrollRectToVisible(this.table.getCellRect(currentIndex, 0, true));
    }

    private int getSelectedModelIndex() {
        return this.getModelIndex(this.table.getSelectedRow());
    }

    private int getModelIndex(int viewIndex) {
        return viewIndex != -1 ? this.sorter.modelIndex(viewIndex) : -1;
    }

    private JTable getTable() {
        return this.table;
    }

    private void showPopup(final MouseEvent e) {
        int row = this.table.rowAtPoint(e.getPoint());
        if (row != -1) {
            boolean makeRowSelected = true;
            int[] selectedrows = this.table.getSelectedRows();
            for (int i = 0; i < selectedrows.length; ++i) {
                if (row != selectedrows[i]) continue;
                makeRowSelected = false;
                break;
            }
            if (makeRowSelected) {
                this.table.getSelectionModel().setSelectionInterval(row, row);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JPopupMenu menu = DiffFileTable.this.master.getPopup();
                if (menu != null) {
                    menu.show(DiffFileTable.this.table, e.getX(), e.getY());
                }
            }
        });
    }

    private void showPopup(Point p) {
        JPopupMenu menu = this.master.getPopup();
        if (menu != null) {
            menu.show(this.table, p.x, p.y);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && MouseUtils.isDoubleClick((MouseEvent)e)) {
            int row = this.table.rowAtPoint(e.getPoint());
            if (row == -1) {
                return;
            }
            Action action = this.nodes[row = this.sorter.modelIndex(row)].getPreferredAction();
            if (action == null || !action.isEnabled()) {
                action = new OpenInEditorAction();
            }
            if (action.isEnabled()) {
                action.actionPerformed(new ActionEvent(this, 0, ""));
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        int min = selectionModel.getMinSelectionIndex();
        int max = selectionModel.getMaxSelectionIndex();
        if (min != -1 && min == max) {
            this.master.nodeSelected(this.getSelectedNode());
        } else {
            ArrayList<DiffNode> selectedNodes = new ArrayList<DiffNode>();
            if (min == -1) {
                this.master.nodeSelected(null);
            } else {
                for (int i = min; i <= max; ++i) {
                    if (!selectionModel.isSelectedIndex(i)) continue;
                    int idx = this.sorter.modelIndex(i);
                    selectedNodes.add(this.nodes[idx]);
                }
            }
            TopComponent tc = (TopComponent)this.master.getClientProperty(TopComponent.class);
            if (tc == null) {
                return;
            }
            Node[] nodesToActivate = selectedNodes.toArray(new Node[selectedNodes.size()]);
            tc.setActivatedNodes(nodesToActivate);
        }
    }

    private static class ColumnDescriptor
    extends PropertySupport.ReadOnly {
        public ColumnDescriptor(String name, Class type, String displayName, String shortDescription) {
            super(name, type, displayName, shortDescription);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return null;
        }
    }

    private class DiffTableCellRenderer
    extends DefaultTableCellRenderer {
        private FilePathCellRenderer pathRenderer = new FilePathCellRenderer();

        private DiffTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component renderer;
            int modelColumnIndex = table.convertColumnIndexToModel(column);
            if (modelColumnIndex == 0) {
                int modelRow = DiffFileTable.this.sorter.modelIndex(row);
                String htmlDisplayName = DiffUtils.getHtmlDisplayName((Node)DiffFileTable.this.nodes[modelRow], (boolean)this.isModified(modelRow), (boolean)isSelected);
                if (HgModuleConfig.getDefault().isExcludedFromCommit(DiffFileTable.this.nodes[modelRow].getSetup().getBaseFile().getAbsolutePath())) {
                    htmlDisplayName = "<s>" + (htmlDisplayName == null ? DiffFileTable.this.nodes[modelRow].getName() : htmlDisplayName) + "</s>";
                }
                if (htmlDisplayName != null) {
                    value = "<html>" + htmlDisplayName;
                }
            }
            if ((renderer = modelColumnIndex == 2 ? this.pathRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column) : super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column)) instanceof JComponent) {
                File file = (File)DiffFileTable.this.nodes[DiffFileTable.this.sorter.modelIndex(row)].getLookup().lookup(File.class);
                String path = file != null ? file.getAbsolutePath() : null;
                ((JComponent)renderer).setToolTipText(path);
            }
            return renderer;
        }

        private boolean isModified(int row) {
            EditorCookie editorCookie = DiffFileTable.this.editorCookies[row];
            return editorCookie != null ? editorCookie.isModified() : false;
        }
    }
}

