/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.annotate;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.accessibility.Accessible;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.StatusBar;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.WorkingCopyInfo;
import org.netbeans.modules.mercurial.kenai.HgKenaiAccessor;
import org.netbeans.modules.mercurial.ui.annotate.AnnotateAction;
import org.netbeans.modules.mercurial.ui.annotate.AnnotateLine;
import org.netbeans.modules.mercurial.ui.annotate.AnnotationMark;
import org.netbeans.modules.mercurial.ui.annotate.AnnotationMarkInstaller;
import org.netbeans.modules.mercurial.ui.annotate.AnnotationMarkProvider;
import org.netbeans.modules.mercurial.ui.annotate.Bundle;
import org.netbeans.modules.mercurial.ui.annotate.LinesReader;
import org.netbeans.modules.mercurial.ui.annotate.TooltipWindow;
import org.netbeans.modules.mercurial.ui.diff.DiffAction;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.ui.log.LogAction;
import org.netbeans.modules.mercurial.ui.update.RevertModifications;
import org.netbeans.modules.mercurial.ui.update.RevertModificationsAction;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.VCSKenaiAccessor;
import org.netbeans.spi.diff.DiffProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.xml.XMLUtil;

final class AnnotationBar
extends JComponent
implements Accessible,
PropertyChangeListener,
DocumentListener,
ChangeListener,
ActionListener,
Runnable,
ComponentListener {
    private final JTextComponent textComponent;
    private final EditorUI editorUI;
    private final FoldHierarchy foldHierarchy;
    private final BaseDocument doc;
    private final Caret caret;
    private Timer caretTimer;
    private boolean annotated;
    private Map<Element, AnnotateLine> elementAnnotations = Collections.emptyMap();
    private String elementAnnotationsSubstitute;
    private Color backgroundColor = Color.WHITE;
    private Color foregroundColor = Color.BLACK;
    private Color selectedColor = Color.BLUE;
    private String recentStatusMessage;
    private String recentRevision;
    static RequestProcessor requestProcessor = null;
    private RequestProcessor.Task latestAnnotationTask = null;
    private File repositoryRoot;
    private Map<String, VCSKenaiAccessor.KenaiUser> kenaiUsersMap = null;
    private Map<String, HgLogMessage.HgRevision> previousRevisions;
    private Map<String, File> originalFiles;
    private File referencedFile;
    private FileObject referencedFileObject;
    private String annotatedRevision;
    private WorkingCopyInfo wcInfo;
    private RequestProcessor.Task refreshAnnotationsTask;
    private boolean refreshing;
    private MouseListener mouseListener;

    public AnnotationBar(JTextComponent target) {
        this.textComponent = target;
        this.editorUI = Utilities.getEditorUI((JTextComponent)target);
        this.foldHierarchy = FoldHierarchy.get((JTextComponent)this.editorUI.getComponent());
        this.doc = this.editorUI.getDocument();
        this.caret = this.textComponent.getCaret();
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.elementAnnotationsSubstitute = "";
    }

    public File getRepositoryRoot() {
        return this.repositoryRoot;
    }

    public void annotate() {
        this.annotated = true;
        this.elementAnnotations = Collections.emptyMap();
        this.doc.addDocumentListener((DocumentListener)this);
        this.textComponent.addComponentListener(this);
        this.editorUI.addPropertyChangeListener((PropertyChangeListener)this);
        this.revalidate();
    }

    public void setAnnotationMessage(String message) {
        this.elementAnnotationsSubstitute = message;
        this.revalidate();
    }

    public void annotationLines(File file, List<AnnotateLine> annotateLines) {
        boolean isKenaiRepository;
        this.repositoryRoot = Mercurial.getInstance().getRepositoryRoot(this.getCurrentFile());
        if (this.referencedFile == null) {
            this.wcInfo = WorkingCopyInfo.getInstance(this.repositoryRoot);
            this.wcInfo.removePropertyChangeListener(this);
            this.wcInfo.addPropertyChangeListener(this);
        }
        final LinkedList<AnnotateLine> lines = new LinkedList<AnnotateLine>(annotateLines);
        int lineCount = lines.size();
        final int[] ann2editorPermutation = new int[lineCount];
        for (int i = 0; i < lineCount; ++i) {
            ann2editorPermutation[i] = i + 1;
        }
        DiffProvider diff = (DiffProvider)Lookup.getDefault().lookup(DiffProvider.class);
        if (diff != null) {
            LinesReader r = new LinesReader(lines);
            Reader docReader = Utils.getDocumentReader((Document)this.doc);
            try {
                Difference[] differences;
                for (Difference d : differences = diff.computeDiff((Reader)r, docReader)) {
                    int c;
                    int editorStart;
                    int offset;
                    if (d.getType() == 1) {
                        offset = d.getSecondEnd() - d.getSecondStart() + 1;
                        editorStart = d.getFirstStart();
                    } else if (d.getType() == 0) {
                        offset = d.getFirstEnd() - d.getFirstStart() + 1;
                        editorStart = d.getFirstEnd();
                        for (c = editorStart - offset; c < editorStart; ++c) {
                            ann2editorPermutation[c] = -1;
                        }
                        offset = -offset;
                    } else {
                        int firstLen = d.getFirstEnd() - d.getFirstStart();
                        int secondLen = d.getSecondEnd() - d.getSecondStart();
                        offset = secondLen - firstLen;
                        if (offset == 0) continue;
                        editorStart = d.getFirstEnd();
                        int c2 = d.getFirstStart();
                        while (c2 < editorStart) {
                            int n = c2++;
                            ann2editorPermutation[n] = ann2editorPermutation[n] + -1;
                        }
                    }
                    c = editorStart;
                    while (c < lineCount) {
                        int n = c++;
                        ann2editorPermutation[n] = ann2editorPermutation[n] + offset;
                    }
                }
            }
            catch (IOException e) {
                Mercurial.LOG.log(Level.INFO, "Cannot compute local diff required for annotations, ignoring...");
            }
        }
        this.doc.render(new Runnable(){

            @Override
            public void run() {
                StyledDocument sd = (StyledDocument)AnnotationBar.this.doc;
                Iterator it = lines.iterator();
                AnnotationBar.this.previousRevisions = Collections.synchronizedMap(new HashMap());
                AnnotationBar.this.originalFiles = Collections.synchronizedMap(new HashMap());
                AnnotationBar.this.elementAnnotations = Collections.synchronizedMap(new HashMap(lines.size()));
                while (it.hasNext()) {
                    AnnotateLine line = (AnnotateLine)it.next();
                    int lineNum = ann2editorPermutation[line.getLineNum() - 1];
                    if (lineNum == -1) continue;
                    try {
                        int lineOffset = NbDocument.findLineOffset((StyledDocument)sd, (int)(lineNum - 1));
                        Element element = sd.getParagraphElement(lineOffset);
                        AnnotationBar.this.elementAnnotations.put(element, line);
                    }
                    catch (IndexOutOfBoundsException ex) {
                        Mercurial.LOG.log(Level.INFO, null, ex);
                    }
                }
            }
        });
        String url = HgUtils.getRemoteRepository(this.repositoryRoot);
        boolean bl = isKenaiRepository = url != null && HgKenaiAccessor.getInstance().isKenai(url);
        if (isKenaiRepository) {
            this.kenaiUsersMap = new HashMap<String, VCSKenaiAccessor.KenaiUser>();
            for (AnnotateLine line : lines) {
                VCSKenaiAccessor.KenaiUser ku;
                String author = line.getAuthor();
                if (author == null || author.equals("") || this.kenaiUsersMap.keySet().contains(author) || (ku = HgKenaiAccessor.getInstance().forName(author, url)) == null) continue;
                this.kenaiUsersMap.put(author, ku);
            }
        }
        this.caret.addChangeListener(this);
        this.caretTimer = new Timer(500, this);
        this.caretTimer.setRepeats(false);
        this.elementAnnotationsSubstitute = "";
        this.onCurrentLine();
        this.revalidate();
        this.repaint();
    }

    File getCurrentFile() {
        DataObject dobj;
        File result = this.referencedFile;
        if (result == null && (dobj = (DataObject)this.doc.getProperty((Object)"stream")) != null) {
            FileObject fo = dobj.getPrimaryFile();
            result = FileUtil.toFile((FileObject)fo);
        }
        return result;
    }

    FileObject getCurrentFileObject() {
        FileObject result = this.referencedFileObject;
        if (result == null) {
            Object sdp = this.doc.getProperty((Object)"stream");
            if (sdp instanceof FileObject) {
                result = (FileObject)sdp;
            } else if (sdp instanceof DataObject) {
                result = ((DataObject)sdp).getPrimaryFile();
            }
        }
        return result;
    }

    Document getDocument() {
        return this.doc;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.mouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    e.consume();
                    AnnotationBar.this.createPopup(e).show(e.getComponent(), e.getX(), e.getY());
                } else if (e.getID() == 502 && e.getButton() == 1) {
                    e.consume();
                    AnnotationBar.this.showTooltipWindow(e);
                }
            }
        };
        this.addMouseListener(this.mouseListener);
        this.setToolTipText("");
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.mouseListener != null) {
            this.removeMouseListener(this.mouseListener);
            this.mouseListener = null;
        }
    }

    JTextComponent getTextComponent() {
        return this.textComponent;
    }

    private void showTooltipWindow(MouseEvent event) {
        Point p = new Point(event.getPoint());
        SwingUtilities.convertPointToScreen(p, this);
        Point p2 = new Point(p);
        SwingUtilities.convertPointFromScreen(p2, this.textComponent);
        AnnotateLine al = null;
        if (!this.elementAnnotations.isEmpty()) {
            al = this.getAnnotateLine(this.getLineFromMouseEvent(event));
        }
        if (al != null && al.getCommitMessage() != null) {
            TooltipWindow ttw = new TooltipWindow(this, al);
            ttw.show(new Point(p.x - p2.x, p.y));
        }
    }

    private JPopupMenu createPopup(MouseEvent e) {
        ResourceBundle loc = NbBundle.getBundle(AnnotationBar.class);
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem diffMenu = new JMenuItem(loc.getString("CTL_MenuItem_DiffToRevision"));
        AnnotateLine al = null;
        if (!this.elementAnnotations.isEmpty()) {
            al = this.getAnnotateLine(this.getLineFromMouseEvent(e));
        }
        final String revisionPerLine = al == null ? null : al.getRevision();
        final String changesetIdPerLine = al == null ? null : al.getId();
        final int lineNumber = al == null ? -1 : al.getPreviousLineNumber();
        final File file = this.getCurrentFile();
        final File originalFile = al == null ? null : new File(this.repositoryRoot, al.getFileName());
        boolean revisionCanBeRolledBack = al == null || this.referencedFile != null ? false : al.canBeRolledBack();
        diffMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final PreviousRevisionInvoker pri = new PreviousRevisionInvoker(revisionPerLine, originalFile);
                pri.runWithRevision(new Runnable(){

                    @Override
                    public void run() {
                        DiffAction.diff(pri.getOriginalFile(), pri.getPreviousRevision(), originalFile, new HgLogMessage.HgRevision(changesetIdPerLine, revisionPerLine), lineNumber > 1 ? lineNumber - 1 : lineNumber);
                    }
                }, true);
            }
        });
        popupMenu.add(diffMenu);
        if (changesetIdPerLine != null) {
            JMenuItem showCommitMenu = new JMenuItem(Bundle.CTL_AnnotationBar_action_showCommit(revisionPerLine));
            showCommitMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LogAction.openHistory(AnnotationBar.this.repositoryRoot, new File[]{file}, changesetIdPerLine);
                }
            });
            popupMenu.add(showCommitMenu);
        }
        JMenuItem rollbackMenu = new JMenuItem(loc.getString("CTL_MenuItem_Revert"));
        rollbackMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnnotationBar.this.revert(file, revisionPerLine);
            }
        });
        popupMenu.add(rollbackMenu);
        rollbackMenu.setEnabled(revisionCanBeRolledBack);
        JMenuItem annotationsForSelectedItem = new JMenuItem(NbBundle.getMessage(AnnotationBar.class, (String)"CTL_MenuItem_ShowAnnotationsPrevious", (Object)revisionPerLine));
        annotationsForSelectedItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Mercurial.getInstance().getRequestProcessor().post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            HgUtils.openInRevision(originalFile, lineNumber > 0 ? lineNumber - 1 : -1, new HgLogMessage.HgRevision(changesetIdPerLine, revisionPerLine), true);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                });
            }
        });
        popupMenu.add(annotationsForSelectedItem);
        JMenuItem previousAnnotationsMenu = new JMenuItem();
        previousAnnotationsMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final PreviousRevisionInvoker pri = new PreviousRevisionInvoker(revisionPerLine, originalFile);
                pri.runWithRevision(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (lineNumber > 0 && !"-1".equals(pri.getPreviousRevision().getRevisionNumber())) {
                                HgUtils.openInRevision(originalFile, new HgLogMessage.HgRevision(changesetIdPerLine, revisionPerLine), lineNumber - 1, pri.getOriginalFile(), pri.getPreviousRevision(), true);
                            } else {
                                HgUtils.openInRevision(pri.getOriginalFile(), -1, pri.getPreviousRevision(), !"-1".equals(pri.getPreviousRevision().getRevisionNumber()));
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }, false);
            }
        });
        popupMenu.add(previousAnnotationsMenu);
        if (this.isKenai() && al != null) {
            String author = al.getAuthor();
            final int lineNr = al.getLineNum();
            final VCSKenaiAccessor.KenaiUser ku = this.kenaiUsersMap.get(author);
            if (ku != null) {
                popupMenu.addSeparator();
                JMenuItem chatMenu = new JMenuItem(NbBundle.getMessage(AnnotationBar.class, (String)"CTL_MenuItem_Chat", (Object)author));
                chatMenu.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ku.startChat(VCSKenaiAccessor.KenaiUser.getChatLink((FileObject)AnnotationBar.this.getCurrentFileObject(), (int)lineNr));
                    }
                });
                popupMenu.add(chatMenu);
            }
        }
        JMenuItem menu = new JMenuItem(loc.getString("CTL_MenuItem_CloseAnnotations"));
        menu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnnotationBar.this.hideBar();
            }
        });
        JPopupMenu.Separator separator = new JPopupMenu.Separator();
        popupMenu.add(separator);
        popupMenu.add(menu);
        diffMenu.setVisible(false);
        annotationsForSelectedItem.setVisible(false);
        previousAnnotationsMenu.setVisible(false);
        rollbackMenu.setVisible(false);
        separator.setVisible(false);
        if (revisionPerLine != null) {
            String key = AnnotationBar.getPreviousRevisionKey(originalFile.getAbsolutePath(), revisionPerLine);
            HgLogMessage.HgRevision previousRevision = this.getPreviousRevisions().get(key);
            if (al.canBeRolledBack() && (previousRevision != null || !this.getPreviousRevisions().containsKey(key))) {
                if (!this.getPreviousRevisions().containsKey(key)) {
                    Mercurial.getInstance().getRequestProcessor().post(new Runnable(){

                        @Override
                        public void run() {
                            AnnotationBar.this.getParentRevision(originalFile, revisionPerLine);
                        }
                    });
                }
                String format = loc.getString("CTL_MenuItem_DiffToRevision");
                String previousRevisionNumber = previousRevision == null ? null : previousRevision.getRevisionNumber();
                diffMenu.setText(MessageFormat.format(format, revisionPerLine, previousRevisionNumber == null ? loc.getString("LBL_PreviousRevision") : previousRevisionNumber));
                diffMenu.setVisible(originalFile != null);
                rollbackMenu.setVisible(true);
                separator.setVisible(true);
                format = loc.getString("CTL_MenuItem_ShowAnnotationsPrevious");
                previousAnnotationsMenu.setText(MessageFormat.format(format, previousRevisionNumber == null ? loc.getString("LBL_PreviousRevision") : previousRevisionNumber));
                previousAnnotationsMenu.setVisible(originalFile != null);
                previousAnnotationsMenu.setEnabled(!"-1".equals(previousRevisionNumber));
                annotationsForSelectedItem.setVisible(originalFile != null && revisionPerLine != null && !revisionPerLine.equals(this.annotatedRevision));
            }
        }
        return popupMenu;
    }

    void setAnnotatedRevision(String revision) {
        this.annotatedRevision = revision;
    }

    private RequestProcessor.Task getRefreshAnnotationsTask() {
        assert (EventQueue.isDispatchThread());
        if (this.refreshAnnotationsTask == null) {
            this.refreshAnnotationsTask = AnnotationBar.getRequestProcessor().create(new Runnable(){

                @Override
                public void run() {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (AnnotationBar.this.textComponent instanceof JEditorPane && AnnotationBar.this.refreshing) {
                                AnnotateAction.showAnnotations((JEditorPane)AnnotationBar.this.textComponent, AnnotationBar.this.getCurrentFile(), null, false);
                            }
                        }
                    });
                }
            });
        }
        return this.refreshAnnotationsTask;
    }

    boolean isAnnotated() {
        return this.annotated;
    }

    private void revert(final File file, String revision) {
        final File root = Mercurial.getInstance().getRepositoryRoot(file);
        if (root == null) {
            return;
        }
        File[] files = new File[]{file};
        RevertModifications revertModifications = new RevertModifications(root, files, revision);
        if (!revertModifications.showDialog()) {
            return;
        }
        final String revStr = revertModifications.getSelectionRevision();
        final boolean doBackup = revertModifications.isBackupRequested();
        RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(root);
        HgProgressSupport support = new HgProgressSupport(){

            @Override
            public void perform() {
                RevertModificationsAction.performRevert(root, revStr, file, doBackup, this.getLogger());
            }
        };
        support.start(rp, root, NbBundle.getMessage(AnnotationBar.class, (String)"MSG_Revert_Progress"));
    }

    private HgLogMessage.HgRevision getParentRevision(File file, String revision) {
        String key = AnnotationBar.getPreviousRevisionKey(file.getAbsolutePath(), revision);
        HgLogMessage.HgRevision parent = this.getPreviousRevisions().get(key);
        if (parent == null) {
            File originalFile = this.getOriginalFile(file, revision);
            try {
                parent = HgCommand.getParent(this.repositoryRoot, originalFile, revision);
            }
            catch (HgException ex) {
                Mercurial.LOG.log(Level.INFO, null, ex);
            }
            this.getPreviousRevisions().put(key, parent);
        }
        return parent;
    }

    private File getOriginalFile(File file, String revision) {
        HgLogMessage[] msg;
        String key = AnnotationBar.getPreviousRevisionKey(file.getAbsolutePath(), revision);
        File originalFile = this.getOriginalFiles().get(key);
        if (originalFile == null && (msg = HgCommand.getLogMessages(this.repositoryRoot, Collections.singleton(file), revision, revision, true, true, false, 1, Collections.<String>emptyList(), OutputLogger.getLogger(null), true)).length > 0 && (originalFile = msg[0].getOriginalFile(this.repositoryRoot, file)) != null) {
            this.getOriginalFiles().put(key, originalFile);
        }
        return originalFile == null ? file : originalFile;
    }

    void hideBar() {
        this.annotated = false;
        this.revalidate();
        this.release();
    }

    private static synchronized RequestProcessor getRequestProcessor() {
        if (requestProcessor == null) {
            requestProcessor = new RequestProcessor("AnnotationBarRP", 1, true);
        }
        return requestProcessor;
    }

    private void onCurrentLine() {
        if (this.latestAnnotationTask != null) {
            this.latestAnnotationTask.cancel();
        }
        this.latestAnnotationTask = AnnotationBar.getRequestProcessor().post((Runnable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ResourceBundle loc = NbBundle.getBundle(AnnotationBar.class);
        StatusBar statusBar = this.editorUI.getStatusBar();
        this.recentStatusMessage = loc.getString("CTL_StatusBar_WaitFetchAnnotation");
        statusBar.setText("main", this.recentStatusMessage);
        int line = -1;
        int offset = this.caret.getDot();
        try {
            line = Utilities.getLineOffset((BaseDocument)this.doc, (int)offset);
        }
        catch (BadLocationException ex) {
            Mercurial.LOG.log(Level.SEVERE, "Can not get line for caret at offset ", offset);
            this.clearRecentFeedback();
            return;
        }
        AnnotateLine al = this.getAnnotateLine(line);
        if (al == null) {
            AnnotationMarkProvider amp = AnnotationMarkInstaller.getMarkProvider(this.textComponent);
            if (amp != null) {
                amp.setMarks(Collections.<AnnotationMark>emptyList());
            }
            this.clearRecentFeedback();
            if (this.recentRevision != null) {
                this.recentRevision = null;
                this.repaint();
            }
            return;
        }
        String revision = al.getRevision();
        if (!revision.equals(this.recentRevision)) {
            this.recentRevision = revision;
            this.repositoryRoot = Mercurial.getInstance().getRepositoryRoot(this.getCurrentFile());
            this.repaint();
            AnnotationMarkProvider amp = AnnotationMarkInstaller.getMarkProvider(this.textComponent);
            if (amp != null) {
                Iterator<Map.Entry<Element, AnnotateLine>> it2;
                ArrayList<AnnotationMark> marks = new ArrayList<AnnotationMark>(this.elementAnnotations.size());
                Map<Element, AnnotateLine> map = this.elementAnnotations;
                synchronized (map) {
                    it2 = new HashSet<Map.Entry<Element, AnnotateLine>>(this.elementAnnotations.entrySet()).iterator();
                }
                while (it2.hasNext()) {
                    Map.Entry<Element, AnnotateLine> next = it2.next();
                    AnnotateLine annotateLine = next.getValue();
                    if (revision.equals(annotateLine.getRevision())) {
                        Element element = next.getKey();
                        if (!this.elementAnnotations.containsKey(element)) continue;
                        int elementOffset = element.getStartOffset();
                        int lineNumber = NbDocument.findLineNumber((StyledDocument)((StyledDocument)this.doc), (int)elementOffset);
                        AnnotationMark mark = new AnnotationMark(lineNumber, revision);
                        marks.add(mark);
                    }
                    if (!Thread.interrupted()) continue;
                    this.clearRecentFeedback();
                    return;
                }
                amp.setMarks(marks);
            }
        }
        if (al.getCommitMessage() != null) {
            this.recentStatusMessage = al.getCommitMessage();
            statusBar.setText("main", al.getRevision() + ":" + al.getId() + " - " + al.getAuthor() + ": " + this.recentStatusMessage);
        } else {
            this.clearRecentFeedback();
        }
    }

    private void clearRecentFeedback() {
        StatusBar statusBar = this.editorUI.getStatusBar();
        if (statusBar.getText("main") == this.recentStatusMessage) {
            statusBar.setText("main", "");
        }
    }

    @Override
    public Dimension getPreferredSize() {
        int width;
        Dimension dim = this.textComponent.getSize();
        dim.width = width = this.annotated ? this.getBarWidth() : 0;
        dim.height *= 2;
        return dim;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getBarWidth() {
        String longestString = "";
        if (this.elementAnnotations.isEmpty()) {
            longestString = this.elementAnnotationsSubstitute;
        } else {
            Map<Element, AnnotateLine> map = this.elementAnnotations;
            synchronized (map) {
                for (AnnotateLine line : this.elementAnnotations.values()) {
                    String displayName = this.getDisplayName(line);
                    if (displayName.length() <= longestString.length()) continue;
                    longestString = displayName;
                }
            }
        }
        char[] data = longestString.toCharArray();
        int w = this.getGraphics().getFontMetrics().charsWidth(data, 0, data.length);
        return w + 4 + (this.isKenai() ? 18 : 0);
    }

    private String getDisplayName(AnnotateLine line) {
        return line.getRevision() + "  " + line.getAuthor();
    }

    private void release() {
        AnnotationMarkProvider amp;
        this.refreshing = false;
        if (this.refreshAnnotationsTask != null) {
            this.refreshAnnotationsTask.cancel();
        }
        if (this.wcInfo != null) {
            this.wcInfo.removePropertyChangeListener(this);
        }
        this.editorUI.removePropertyChangeListener((PropertyChangeListener)this);
        this.textComponent.removeComponentListener(this);
        this.doc.removeDocumentListener((DocumentListener)this);
        this.caret.removeChangeListener(this);
        if (this.caretTimer != null) {
            this.caretTimer.removeActionListener(this);
        }
        this.elementAnnotations = Collections.emptyMap();
        this.previousRevisions = null;
        this.originalFiles = null;
        if (this.latestAnnotationTask != null) {
            this.latestAnnotationTask.cancel();
        }
        if ((amp = AnnotationMarkInstaller.getMarkProvider(this.textComponent)) != null) {
            amp.setMarks(Collections.<AnnotationMark>emptyList());
        }
        this.clearRecentFeedback();
    }

    private void paintView(View view, Graphics g, int yBase) {
        JTextComponent component = this.editorUI.getComponent();
        if (component == null) {
            return;
        }
        BaseTextUI textUI = (BaseTextUI)component.getUI();
        Element rootElem = textUI.getRootView(component).getElement();
        int line = rootElem.getElementIndex(view.getStartOffset());
        String annotation = "";
        AnnotateLine al = null;
        if (!this.elementAnnotations.isEmpty()) {
            al = this.getAnnotateLine(line);
            if (al != null) {
                annotation = this.getDisplayName(al);
            }
        } else {
            annotation = this.elementAnnotationsSubstitute;
        }
        if (al != null && al.getRevision().equals(this.recentRevision)) {
            g.setColor(this.selectedColor());
        } else {
            g.setColor(this.foregroundColor());
        }
        int texty = yBase + this.editorUI.getLineAscent();
        int textx = 2;
        g.drawString(annotation, textx, texty);
    }

    boolean isKenai() {
        return this.kenaiUsersMap != null && this.kenaiUsersMap.size() > 0;
    }

    VCSKenaiAccessor.KenaiUser getKenaiUser(String author) {
        if (this.kenaiUsersMap == null) {
            return null;
        }
        return this.kenaiUsersMap.get(author);
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        if (this.editorUI == null) {
            return null;
        }
        int line = this.getLineFromMouseEvent(e);
        StringBuilder annotation = new StringBuilder();
        if (!this.elementAnnotations.isEmpty()) {
            AnnotateLine al = this.getAnnotateLine(line);
            if (al != null) {
                String escapedAuthor = NbBundle.getMessage(AnnotationBar.class, (String)"TT_Annotation");
                try {
                    escapedAuthor = XMLUtil.toElementContent((String)al.getAuthor());
                }
                catch (CharConversionException e1) {
                    Mercurial.LOG.log(Level.INFO, "HG.AB: can not HTML escape: ", al.getAuthor());
                }
                annotation.append("<html><!-- line=").append(line++).append(" -->").append(al.getRevision()).append(":").append(al.getId()).append(" - <b>").append(escapedAuthor).append("</b>");
                if (al.getDate() != null) {
                    annotation.append(" ").append(DateFormat.getDateInstance().format(al.getDate()));
                }
                if (al.getCommitMessage() != null) {
                    String escaped = null;
                    try {
                        escaped = XMLUtil.toElementContent((String)al.getCommitMessage());
                    }
                    catch (CharConversionException e1) {
                        Mercurial.LOG.log(Level.INFO, "HG.AB: can not HTML escape: ", al.getCommitMessage());
                    }
                    if (escaped != null) {
                        String lined = escaped.replace("\r\n", "\n").replace("\r", "\n").replace("\n", "<br>");
                        annotation.append("<p>").append(lined);
                    }
                }
            }
        } else {
            annotation.append(this.elementAnnotationsSubstitute);
        }
        return annotation.toString();
    }

    private AnnotateLine getAnnotateLine(int line) {
        StyledDocument sd = (StyledDocument)this.doc;
        int lineOffset = NbDocument.findLineOffset((StyledDocument)sd, (int)line);
        Element element = sd.getParagraphElement(lineOffset);
        AnnotateLine al = this.elementAnnotations.get(element);
        if (al != null) {
            int startOffset = element.getStartOffset();
            int endOffset = element.getEndOffset();
            try {
                int len = endOffset - startOffset;
                String text = this.doc.getText(startOffset, len - 1);
                String content = al.getContent();
                if (text.equals(content)) {
                    return al;
                }
            }
            catch (BadLocationException e) {
                Mercurial.LOG.log(Level.INFO, "HG.AB: can not locate line annotation.");
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        block13: {
            super.paintComponent(g);
            Rectangle clip = g.getClipBounds();
            JTextComponent component = this.editorUI.getComponent();
            if (component == null) {
                return;
            }
            BaseTextUI textUI = (BaseTextUI)component.getUI();
            View rootView = Utilities.getDocumentView((JTextComponent)component);
            if (rootView == null) {
                return;
            }
            g.setColor(this.backgroundColor());
            g.fillRect(clip.x, clip.y, clip.width, clip.height);
            AbstractDocument doc = (AbstractDocument)component.getDocument();
            doc.readLock();
            try {
                this.foldHierarchy.lock();
                try {
                    int startPos = textUI.getPosFromY(clip.y);
                    int startViewIndex = rootView.getViewIndex(startPos, Position.Bias.Forward);
                    int rootViewCount = rootView.getViewCount();
                    if (startViewIndex < 0 || startViewIndex >= rootViewCount) break block13;
                    int clipEndY = clip.y + clip.height;
                    for (int i = startViewIndex; i < rootViewCount; ++i) {
                        View view = rootView.getView(i);
                        Rectangle rec = component.modelToView(view.getStartOffset());
                        if (rec == null) {
                        } else {
                            int y = rec.y;
                            this.paintView(view, g, y);
                            if (y < clipEndY) continue;
                        }
                        break;
                    }
                }
                finally {
                    this.foldHierarchy.unlock();
                }
            }
            catch (BadLocationException ble) {
                Mercurial.LOG.log(Level.WARNING, null, ble);
            }
            finally {
                doc.readUnlock();
            }
        }
    }

    private Color backgroundColor() {
        if (this.textComponent != null) {
            return this.textComponent.getBackground();
        }
        return this.backgroundColor;
    }

    private Color foregroundColor() {
        if (this.textComponent != null) {
            return this.textComponent.getForeground();
        }
        return this.foregroundColor;
    }

    private Color selectedColor() {
        if (this.backgroundColor.equals(this.backgroundColor())) {
            return this.selectedColor;
        }
        if (this.textComponent != null) {
            return this.textComponent.getCaretColor();
        }
        return this.selectedColor;
    }

    private int getLineFromMouseEvent(MouseEvent e) {
        int line = -1;
        if (this.editorUI != null) {
            try {
                JTextComponent component = this.editorUI.getComponent();
                BaseTextUI textUI = (BaseTextUI)component.getUI();
                int clickOffset = textUI.viewToModel(component, new Point(0, e.getY()));
                line = Utilities.getLineOffset((BaseDocument)this.doc, (int)clickOffset);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return line;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt == null) {
            return;
        }
        String id = evt.getPropertyName();
        if ("component".equals(id)) {
            if (evt.getNewValue() == null) {
                this.release();
            }
        } else if (WorkingCopyInfo.PROPERTY_WORKING_COPY_PARENT.equals(id)) {
            Mutex.EVENT.readAccess(new Runnable(){

                @Override
                public void run() {
                    if (AnnotationBar.this.annotated) {
                        AnnotationBar.this.hideBar();
                        AnnotationBar.this.refreshing = true;
                        AnnotationBar.this.getRefreshAnnotationsTask().schedule(1000);
                    }
                }
            });
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void insertUpdate(DocumentEvent e) {
        if (!this.elementAnnotations.isEmpty()) {
            Element[] elements = e.getDocument().getRootElements();
            Map<Element, AnnotateLine> map = this.elementAnnotations;
            synchronized (map) {
                for (int i = 0; i < elements.length; ++i) {
                    Element key;
                    AnnotateLine recent;
                    Element[] added;
                    Element element = elements[i];
                    DocumentEvent.ElementChange change = e.getChange(element);
                    if (change == null) continue;
                    Element[] removed = change.getChildrenRemoved();
                    if (removed.length == (added = change.getChildrenAdded()).length) {
                        for (int c = 0; c < removed.length; ++c) {
                            recent = this.elementAnnotations.get(removed[c]);
                            if (recent == null) continue;
                            this.elementAnnotations.remove(removed[c]);
                            this.elementAnnotations.put(added[c], recent);
                        }
                        continue;
                    }
                    if (removed.length != 1 || added.length <= 0 || (recent = this.elementAnnotations.get(key = removed[0])) == null) continue;
                    this.elementAnnotations.remove(key);
                    this.elementAnnotations.put(added[0], recent);
                }
            }
        }
        this.repaint();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        final int length = e.getDocument().getLength();
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                if (length == 0) {
                    AnnotationBar.this.hideBar();
                    if (AnnotationBar.this.referencedFile == null) {
                        AnnotationBar.this.refreshing = true;
                        AnnotationBar.this.getRefreshAnnotationsTask().schedule(4000);
                    }
                }
                AnnotationBar.this.repaint();
            }
        });
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        assert (e.getSource() == this.caret);
        this.caretTimer.restart();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        assert (e.getSource() == this.caretTimer);
        this.onCurrentLine();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.revalidate();
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    private static String getPreviousRevisionKey(String filePath, String revision) {
        return filePath + "#" + revision;
    }

    private Map<String, HgLogMessage.HgRevision> getPreviousRevisions() {
        HashMap revisions = this.previousRevisions;
        return revisions == null ? new HashMap(0) : revisions;
    }

    private Map<String, File> getOriginalFiles() {
        HashMap files = this.originalFiles;
        return files == null ? new HashMap(0) : files;
    }

    void setReferencedFile(File file) {
        this.referencedFile = FileUtil.normalizeFile((File)file);
        this.referencedFileObject = FileUtil.toFileObject((File)file);
    }

    private class PreviousRevisionInvoker {
        private final String revisionPerLine;
        private final File file;
        private HgLogMessage.HgRevision previousRevision;
        private File originalFile;

        private PreviousRevisionInvoker(String revisionPerLine, File originalFile) {
            this.revisionPerLine = revisionPerLine;
            this.file = originalFile;
        }

        private void runWithRevision(final Runnable runnable, final boolean inAWT) {
            if (this.revisionPerLine != null) {
                new HgProgressSupport(){

                    @Override
                    protected void perform() {
                        PreviousRevisionInvoker.this.previousRevision = AnnotationBar.this.getParentRevision(PreviousRevisionInvoker.this.file, PreviousRevisionInvoker.this.revisionPerLine);
                        if (!this.isCanceled() && PreviousRevisionInvoker.this.previousRevision != null) {
                            PreviousRevisionInvoker.this.originalFile = AnnotationBar.this.getOriginalFile(PreviousRevisionInvoker.this.file, PreviousRevisionInvoker.this.revisionPerLine);
                            if (!this.isCanceled() && PreviousRevisionInvoker.this.file != null) {
                                if (inAWT) {
                                    EventQueue.invokeLater(runnable);
                                } else {
                                    AnnotationBar.getRequestProcessor().post(runnable);
                                }
                            }
                        }
                    }
                }.start(Mercurial.getInstance().getRequestProcessor(), AnnotationBar.this.repositoryRoot, NbBundle.getMessage(AnnotationBar.class, (String)"MSG_GettingPreviousRevision"));
            }
        }

        private HgLogMessage.HgRevision getPreviousRevision() {
            return this.previousRevision;
        }

        private File getOriginalFile() {
            return this.originalFile;
        }
    }
}

