/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.api;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.HgFileNode;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.clone.CloneAction;
import org.netbeans.modules.mercurial.ui.commit.CommitAction;
import org.netbeans.modules.mercurial.ui.commit.CommitOptions;
import org.netbeans.modules.mercurial.ui.push.PushAction;
import org.netbeans.modules.mercurial.ui.repository.HgURL;
import org.netbeans.modules.mercurial.ui.repository.RepositoryConnection;
import org.netbeans.modules.mercurial.ui.wizards.CloneWizardAction;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.hooks.HgHook;
import org.netbeans.modules.versioning.util.VCSBugtrackingAccessor;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

public class Mercurial {
    private static final String WORKINGDIR_KEY_PREFIX = "working.dir.";

    @Deprecated
    public static void cloneRepository(String repositoryUrl, File targetDir, String cloneName, String defaultPull, String defaultPush) throws MalformedURLException {
        assert (!SwingUtilities.isEventDispatchThread()) : "Accessing remote repository. Do not call in awt!";
        Mercurial.cloneRepository(repositoryUrl, targetDir, cloneName, defaultPull, defaultPush, null, null, true);
    }

    public static void cloneRepository(String repositoryUrl, File targetDir, String cloneName, String defaultPull, String defaultPush, boolean scanForProjects) throws MalformedURLException {
        assert (!SwingUtilities.isEventDispatchThread()) : "Accessing remote repository. Do not call in awt!";
        Mercurial.cloneRepository(repositoryUrl, targetDir, cloneName, defaultPull, defaultPush, null, null, scanForProjects);
    }

    @Deprecated
    public static void cloneRepository(String repositoryUrl, File targetDir, String cloneName, String pullUrl, String pushUrl, String username, String password) throws MalformedURLException {
        Mercurial.cloneRepository(repositoryUrl, targetDir, cloneName, pullUrl, pushUrl, username, password, true);
    }

    public static void cloneRepository(String repositoryUrl, File targetDir, String cloneName, String pullUrl, String pushUrl, String username, String password, boolean scanForProjects) throws MalformedURLException {
        HgURL pushPath;
        HgURL pullPath;
        HgURL hgUrl;
        assert (!SwingUtilities.isEventDispatchThread()) : "Accessing remote repository. Do not call in awt!";
        if (!Mercurial.isClientAvailable(true)) {
            org.netbeans.modules.mercurial.Mercurial.LOG.log(Level.WARNING, "Mercurial client is unavailable");
            return;
        }
        if (repositoryUrl == null) {
            throw new IllegalArgumentException("repository URL is null");
        }
        try {
            hgUrl = new HgURL(repositoryUrl, username, password != null ? password.toCharArray() : null);
        }
        catch (URISyntaxException ex) {
            throw new MalformedURLException(ex.getMessage());
        }
        pullUrl = Mercurial.getNonEmptyString(pullUrl);
        pushUrl = Mercurial.getNonEmptyString(pushUrl);
        try {
            pullPath = pullUrl != null ? new HgURL(pullUrl) : null;
        }
        catch (URISyntaxException ex) {
            throw new MalformedURLException("Invalid pull URL: " + ex.getMessage());
        }
        try {
            pushPath = pushUrl != null ? new HgURL(pushUrl) : null;
        }
        catch (URISyntaxException ex) {
            throw new MalformedURLException("Invalid push URL: " + ex.getMessage());
        }
        File cloneFile = new File(targetDir, cloneName);
        CloneAction.performClone(hgUrl, cloneFile, true, null, pullPath, pushPath, scanForProjects).waitFinished();
        try {
            Mercurial.storeWorkingDir(new URL(repositoryUrl), targetDir.toURI().toURL());
        }
        catch (Exception e) {
            Logger.getLogger(Mercurial.class.getName()).log(Level.FINE, "Cannot store mercurial workdir preferences", e);
        }
        VCSBugtrackingAccessor bugtrackingSupport = (VCSBugtrackingAccessor)Lookup.getDefault().lookup(VCSBugtrackingAccessor.class);
        if (bugtrackingSupport != null) {
            bugtrackingSupport.setFirmAssociations(new File[]{cloneFile}, repositoryUrl);
        }
    }

    public static void commit(File[] roots, final String message) {
        assert (!SwingUtilities.isEventDispatchThread()) : "Accessing remote repository. Do not call in awt!";
        if (!Mercurial.isClientAvailable(true)) {
            org.netbeans.modules.mercurial.Mercurial.LOG.log(Level.WARNING, "Mercurial client is unavailable");
            return;
        }
        Set<File> repositories = HgUtils.getRepositoryRoots(new HashSet<File>(Arrays.asList(roots)));
        org.netbeans.modules.mercurial.Mercurial hg = org.netbeans.modules.mercurial.Mercurial.getInstance();
        if (repositories.size() == 0) {
            hg.versionedFilesChanged();
            repositories = HgUtils.getRepositoryRoots(new HashSet<File>(Arrays.asList(roots)));
        }
        if (repositories.size() != 1) {
            org.netbeans.modules.mercurial.Mercurial.LOG.log(Level.WARNING, "Committing for {0} repositories", repositories.size());
            return;
        }
        final File repository = repositories.iterator().next();
        final HashSet<File> rootFiles = new HashSet<File>(Arrays.asList(roots));
        FileStatusCache cache = hg.getFileStatusCache();
        cache.refreshAllRoots(Collections.singletonMap(repository, rootFiles));
        File[] files = cache.listFiles(roots, 6612);
        if (files.length == 0) {
            return;
        }
        HgFileNode[] nodes = new HgFileNode[files.length];
        for (int i = 0; i < files.length; ++i) {
            nodes[i] = new HgFileNode(files[i]);
        }
        CommitOptions[] commitOptions = HgUtils.createDefaultCommitOptions(nodes, HgModuleConfig.getDefault().getExludeNewFiles());
        final HashMap<HgFileNode, CommitOptions> commitFiles = new HashMap<HgFileNode, CommitOptions>(nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            commitFiles.put(nodes[i], commitOptions[i]);
        }
        RequestProcessor rp = hg.getRequestProcessor(repository);
        HgProgressSupport support = new HgProgressSupport(){

            @Override
            public void perform() {
                OutputLogger logger = this.getLogger();
                CommitAction.performCommit(message, commitFiles, Collections.singletonMap(repository, rootFiles), this, logger, Collections.<HgHook>emptyList());
            }
        };
        support.start(rp, repository, NbBundle.getMessage(CommitAction.class, (String)"LBL_Commit_Progress")).waitFinished();
    }

    public static void pushToDefault(final File repository) {
        assert (!SwingUtilities.isEventDispatchThread()) : "Accessing remote repository. Do not call in awt!";
        if (!Mercurial.isClientAvailable(true)) {
            org.netbeans.modules.mercurial.Mercurial.LOG.log(Level.WARNING, "Mercurial client is unavailable");
            return;
        }
        if (repository == null) {
            throw new IllegalArgumentException("repository is null");
        }
        RequestProcessor rp = org.netbeans.modules.mercurial.Mercurial.getInstance().getRequestProcessor(repository);
        HgProgressSupport support = new HgProgressSupport(){

            @Override
            public void perform() {
                PushAction.getDefaultAndPerformPush(repository, null, null, this.getLogger());
            }
        };
        support.start(rp, repository, NbBundle.getMessage(PushAction.class, (String)"MSG_PUSH_PROGRESS")).waitFinished();
    }

    private static String getNonEmptyString(String s) {
        if (s == null) {
            return null;
        }
        return (s = s.trim()).length() != 0 ? s : null;
    }

    private static void storeWorkingDir(URL remoteUrl, URL localFolder) {
        Preferences prf = NbPreferences.forModule(Mercurial.class);
        prf.put(WORKINGDIR_KEY_PREFIX + remoteUrl, localFolder.toString());
    }

    public static void addRecentUrl(String url) throws MalformedURLException {
        RepositoryConnection rc;
        try {
            rc = new RepositoryConnection(url);
        }
        catch (URISyntaxException ex) {
            org.netbeans.modules.mercurial.Mercurial.LOG.log(Level.INFO, "Could not add URL to the list of recent URLs:", ex);
            return;
        }
        HgModuleConfig.getDefault().insertRecentUrl(rc);
    }

    public static boolean isRepository(String url) {
        if (!Mercurial.isClientAvailable(false)) {
            org.netbeans.modules.mercurial.Mercurial.LOG.log(Level.INFO, "Mercurial client is unavailable");
            return false;
        }
        boolean retval = false;
        HgURL hgUrl = null;
        try {
            hgUrl = new HgURL(url);
        }
        catch (URISyntaxException ex) {
            org.netbeans.modules.mercurial.Mercurial.LOG.log(Level.FINE, "Invalid mercurial url " + url, ex);
        }
        if (hgUrl != null) {
            retval = HgCommand.checkRemoteRepository(hgUrl.toHgCommandUrlString());
        }
        return retval;
    }

    public static void openCloneWizard(String url) throws MalformedURLException {
        Mercurial.openCloneWizard(url, false);
    }

    public static File openCloneWizard(String url, boolean waitFinished) throws MalformedURLException {
        if (!Mercurial.isClientAvailable(true)) {
            org.netbeans.modules.mercurial.Mercurial.LOG.log(Level.WARNING, "Mercurial client is unavailable");
            return null;
        }
        Mercurial.addRecentUrl(url);
        CloneWizardAction wiz = CloneWizardAction.getInstance();
        return wiz.performClone(waitFinished);
    }

    public static boolean isClientAvailable() {
        return Mercurial.isClientAvailable(false);
    }

    public static boolean isClientAvailable(boolean notifyUI) {
        return org.netbeans.modules.mercurial.Mercurial.getInstance().isAvailable(true, notifyUI);
    }
}

