/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.webkit.debugging.api.css;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.netbeans.modules.web.webkit.debugging.api.css.Media;
import org.netbeans.modules.web.webkit.debugging.api.css.RuleId;
import org.netbeans.modules.web.webkit.debugging.api.css.SourceRange;
import org.netbeans.modules.web.webkit.debugging.api.css.Style;
import org.netbeans.modules.web.webkit.debugging.api.css.StyleSheetBody;
import org.netbeans.modules.web.webkit.debugging.api.css.StyleSheetOrigin;

public class Rule {
    private RuleId id;
    private String selector;
    private final String sourceURL;
    private final int sourceLine;
    private final StyleSheetOrigin origin;
    private final Style style;
    private SourceRange selectorRange;
    private final List<Media> media;
    private StyleSheetBody parentStyleSheet;
    private final JSONObject json;

    Rule(JSONObject rule) {
        this.json = rule;
        boolean isRuleMatch = rule.containsKey((Object)"rule");
        if (isRuleMatch) {
            rule = (JSONObject)this.json.get((Object)"rule");
        }
        if (rule.containsKey((Object)"ruleId")) {
            this.id = new RuleId((JSONObject)rule.get((Object)"ruleId"));
        }
        this.sourceURL = (String)rule.get((Object)"sourceURL");
        this.sourceLine = rule.containsKey((Object)"sourceLine") ? ((Number)rule.get((Object)"sourceLine")).intValue() : -1;
        String originCode = (String)rule.get((Object)"origin");
        this.origin = StyleSheetOrigin.forCode(originCode);
        this.style = new Style((JSONObject)rule.get((Object)"style"));
        if (rule.containsKey((Object)"media")) {
            JSONArray array = (JSONArray)rule.get((Object)"media");
            this.media = new ArrayList<Media>(array.size());
            for (Object o : array) {
                this.media.add(new Media((JSONObject)o));
            }
        } else {
            this.media = Collections.EMPTY_LIST;
        }
        if (rule.containsKey((Object)"selectorList")) {
            JSONObject selectorList = (JSONObject)rule.get((Object)"selectorList");
            this.selector = (String)selectorList.get((Object)"text");
            if (selectorList.containsKey((Object)"range")) {
                this.selectorRange = new SourceRange((JSONObject)selectorList.get((Object)"range"));
            }
        } else {
            this.selector = (String)rule.get((Object)"selectorText");
            if (rule.containsKey((Object)"selectorRange")) {
                this.selectorRange = new SourceRange((JSONObject)rule.get((Object)"selectorRange"));
            }
        }
    }

    public RuleId getId() {
        return this.id;
    }

    public String getSelector() {
        return this.selector;
    }

    void setSelector(String selector) {
        this.selector = selector;
    }

    public String getSourceURL() {
        return this.sourceURL;
    }

    public int getSourceLine() {
        int line = this.sourceLine == -1 && this.selectorRange != null ? this.selectorRange.getStartLine() : this.sourceLine;
        return line;
    }

    public StyleSheetOrigin getOrigin() {
        return this.origin;
    }

    public Style getStyle() {
        return this.style;
    }

    public SourceRange getSelectorRange() {
        return this.selectorRange;
    }

    public List<Media> getMedia() {
        return Collections.unmodifiableList(this.media);
    }

    public StyleSheetBody getParentStyleSheet() {
        return this.parentStyleSheet;
    }

    void setParentStyleSheet(StyleSheetBody parentStyleSheet) {
        this.parentStyleSheet = parentStyleSheet;
    }

    public String toString() {
        return this.json.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Rule)) {
            return false;
        }
        RuleId ruleId = this.getId();
        if (ruleId == null) {
            return this == object;
        }
        Rule other = (Rule)object;
        return ruleId.equals(other.getId());
    }

    public int hashCode() {
        RuleId ruleId = this.getId();
        return ruleId == null ? super.hashCode() : ruleId.hashCode();
    }
}

