/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.webkit.debugging.api.css;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.netbeans.modules.web.webkit.debugging.TransportHelper;
import org.netbeans.modules.web.webkit.debugging.api.css.ComputedStyleProperty;
import org.netbeans.modules.web.webkit.debugging.api.css.InheritedStyleEntry;
import org.netbeans.modules.web.webkit.debugging.api.css.InlineStyles;
import org.netbeans.modules.web.webkit.debugging.api.css.MatchedStyles;
import org.netbeans.modules.web.webkit.debugging.api.css.PropertyInfo;
import org.netbeans.modules.web.webkit.debugging.api.css.Rule;
import org.netbeans.modules.web.webkit.debugging.api.css.RuleId;
import org.netbeans.modules.web.webkit.debugging.api.css.Style;
import org.netbeans.modules.web.webkit.debugging.api.css.StyleId;
import org.netbeans.modules.web.webkit.debugging.api.css.StyleSheetBody;
import org.netbeans.modules.web.webkit.debugging.api.css.StyleSheetHeader;
import org.netbeans.modules.web.webkit.debugging.api.css.StyleSheetOrigin;
import org.netbeans.modules.web.webkit.debugging.api.dom.Node;
import org.netbeans.modules.web.webkit.debugging.spi.Command;
import org.netbeans.modules.web.webkit.debugging.spi.Response;
import org.netbeans.modules.web.webkit.debugging.spi.ResponseCallback;

public class CSS {
    private final TransportHelper transport;
    private final ResponseCallback callback;
    private final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();
    private final Map<String, StyleSheetBody> styleSheets = new HashMap<String, StyleSheetBody>();
    private final AtomicBoolean styleSheetChanged = new AtomicBoolean();
    private Map<String, PropertyInfo> supportedProperties;
    private String classForHover;

    public CSS(TransportHelper transport) {
        this.transport = transport;
        this.callback = new Callback();
        this.transport.addListener(this.callback);
    }

    public void enable() {
        this.transport.sendBlockingCommand(new Command("CSS.enable"));
    }

    public void disable() {
        this.transport.sendCommand(new Command("CSS.disable"));
    }

    public List<StyleSheetHeader> getAllStyleSheets() {
        JSONObject result;
        ArrayList<StyleSheetHeader> sheets = new ArrayList<StyleSheetHeader>();
        Response response = this.transport.sendBlockingCommand(new Command("CSS.getAllStyleSheets"));
        if (response != null && (result = response.getResult()) != null) {
            JSONArray headers = (JSONArray)result.get((Object)"headers");
            for (Object o : headers) {
                JSONObject header = (JSONObject)o;
                sheets.add(new StyleSheetHeader(header));
            }
        }
        return sheets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StyleSheetBody getStyleSheet(String styleSheetId) {
        JSONObject result;
        StyleSheetBody body;
        CSS cSS = this;
        synchronized (cSS) {
            body = this.styleSheets.get(styleSheetId);
            if (body != null) {
                return body;
            }
        }
        JSONObject params = new JSONObject();
        params.put((Object)"styleSheetId", (Object)styleSheetId);
        Response response = this.transport.sendBlockingCommand(new Command("CSS.getStyleSheet", params));
        if (response != null && (result = response.getResult()) != null) {
            JSONObject sheetInfo = (JSONObject)result.get((Object)"styleSheet");
            body = new StyleSheetBody(sheetInfo);
            CSS cSS2 = this;
            synchronized (cSS2) {
                this.styleSheets.put(styleSheetId, body);
            }
        }
        return body;
    }

    public String getStyleSheetText(String styleSheetId) {
        JSONObject result;
        String text = null;
        JSONObject params = new JSONObject();
        params.put((Object)"styleSheetId", (Object)styleSheetId);
        Response response = this.transport.sendBlockingCommand(new Command("CSS.getStyleSheetText", params));
        if (response != null && (result = response.getResult()) != null) {
            text = (String)result.get((Object)"text");
        }
        return text;
    }

    public void setStyleSheetText(String styleSheetId, String styleSheetText) {
        styleSheetText = this.replaceHoverInStyleSheetText(styleSheetText);
        JSONObject params = new JSONObject();
        params.put((Object)"styleSheetId", (Object)styleSheetId);
        params.put((Object)"text", (Object)styleSheetText);
        this.transport.sendBlockingCommand(new Command("CSS.setStyleSheetText", params));
        if (!this.styleSheetChanged.getAndSet(false)) {
            this.notifyStyleSheetChanged(styleSheetId);
        }
    }

    public Map<String, PropertyInfo> getSupportedCSSProperties() {
        if (this.supportedProperties == null) {
            JSONObject result;
            HashMap<String, PropertyInfo> map = new HashMap<String, PropertyInfo>();
            Response response = this.transport.sendBlockingCommand(new Command("CSS.getSupportedCSSProperties"));
            if (response != null && (result = response.getResult()) != null) {
                JSONArray properties = (JSONArray)result.get((Object)"cssProperties");
                for (Object o : properties) {
                    PropertyInfo info = o instanceof String ? new PropertyInfo((String)o) : new PropertyInfo((JSONObject)o);
                    map.put(info.getName(), info);
                }
                this.supportedProperties = map;
            }
        }
        return this.supportedProperties;
    }

    public void forcePseudoState(Node node, PseudoClass[] forcedPseudoClasses) {
        JSONObject params = new JSONObject();
        params.put((Object)"nodeId", (Object)node.getNodeId());
        JSONArray pseudoClasses = new JSONArray();
        if (forcedPseudoClasses != null) {
            for (PseudoClass pseudoClass : forcedPseudoClasses) {
                pseudoClasses.add((Object)pseudoClass.getCode());
            }
        }
        params.put((Object)"forcedPseudoClasses", (Object)pseudoClasses);
        this.transport.sendCommand(new Command("CSS.forcePseudoState", params));
    }

    public MatchedStyles getMatchedStyles(Node node, PseudoClass[] forcedPseudoClasses, boolean includePseudo, boolean includeInherited) {
        JSONObject result;
        MatchedStyles matchedStyles = null;
        JSONObject params = new JSONObject();
        params.put((Object)"nodeId", (Object)node.getNodeId());
        if (forcedPseudoClasses != null && forcedPseudoClasses.length != 0) {
            JSONArray pseudoClasses = new JSONArray();
            for (PseudoClass pseudoClass : forcedPseudoClasses) {
                pseudoClasses.add((Object)pseudoClass.getCode());
            }
            params.put((Object)"forcedPseudoClasses", (Object)pseudoClasses);
        }
        params.put((Object)"includePseudo", (Object)includePseudo);
        params.put((Object)"includeInherited", (Object)includeInherited);
        Response response = this.transport.sendBlockingCommand(new Command("CSS.getMatchedStylesForNode", params));
        if (response != null && (result = response.getResult()) != null) {
            matchedStyles = new MatchedStyles(result);
            for (Rule rule : matchedStyles.getMatchedRules()) {
                this.returnHoverToSelector(rule);
                if (rule.getOrigin() == StyleSheetOrigin.USER_AGENT) continue;
                String styleSheetId = rule.getStyle().getId().getStyleSheetId();
                StyleSheetBody body = this.getStyleSheet(styleSheetId);
                rule.setParentStyleSheet(body);
            }
            for (InheritedStyleEntry entry : matchedStyles.getInheritedRules()) {
                for (Rule rule : entry.getMatchedRules()) {
                    this.returnHoverToSelector(rule);
                    if (rule.getOrigin() == StyleSheetOrigin.USER_AGENT) continue;
                    String styleSheetId = rule.getStyle().getId().getStyleSheetId();
                    StyleSheetBody body = this.getStyleSheet(styleSheetId);
                    rule.setParentStyleSheet(body);
                }
            }
        }
        return matchedStyles;
    }

    public InlineStyles getInlineStyles(Node node) {
        JSONObject result;
        InlineStyles inlineStyles = null;
        JSONObject params = new JSONObject();
        params.put((Object)"nodeId", (Object)node.getNodeId());
        Response response = this.transport.sendBlockingCommand(new Command("CSS.getInlineStylesForNode", params));
        if (response != null && (result = response.getResult()) != null) {
            inlineStyles = new InlineStyles(result);
        }
        return inlineStyles;
    }

    public List<ComputedStyleProperty> getComputedStyle(Node node) {
        JSONObject result;
        ArrayList<ComputedStyleProperty> list = Collections.EMPTY_LIST;
        JSONObject params = new JSONObject();
        params.put((Object)"nodeId", (Object)node.getNodeId());
        Response response = this.transport.sendBlockingCommand(new Command("CSS.getComputedStyleForNode", params));
        if (response != null && (result = response.getResult()) != null) {
            JSONArray properties = (JSONArray)result.get((Object)"computedStyle");
            list = new ArrayList<ComputedStyleProperty>(properties.size());
            for (Object o : properties) {
                list.add(new ComputedStyleProperty((JSONObject)o));
            }
        }
        return list;
    }

    public Style setPropertyText(StyleId styleId, int propertyIndex, String propertyText, boolean overwrite) {
        JSONObject result;
        Style resultingStyle = null;
        JSONObject params = new JSONObject();
        params.put((Object)"styleId", (Object)styleId.toJSONObject());
        params.put((Object)"propertyIndex", (Object)propertyIndex);
        params.put((Object)"text", (Object)propertyText);
        params.put((Object)"overwrite", (Object)overwrite);
        Response response = this.transport.sendBlockingCommand(new Command("CSS.setPropertyText", params));
        if (response != null && (result = response.getResult()) != null) {
            JSONObject style = (JSONObject)result.get((Object)"style");
            resultingStyle = new Style(style);
        }
        return resultingStyle;
    }

    public Style toggleProperty(StyleId styleId, int propertyIndex, boolean disable) {
        JSONObject result;
        Style resultingStyle = null;
        JSONObject params = new JSONObject();
        params.put((Object)"styleId", (Object)styleId.toJSONObject());
        params.put((Object)"propertyIndex", (Object)propertyIndex);
        params.put((Object)"disable", (Object)disable);
        Response response = this.transport.sendBlockingCommand(new Command("CSS.toggleProperty", params));
        if (response != null && (result = response.getResult()) != null) {
            JSONObject style = (JSONObject)result.get((Object)"style");
            resultingStyle = new Style(style);
        }
        return resultingStyle;
    }

    public Rule setRuleSelector(RuleId ruleId, String selector) {
        JSONObject result;
        Rule resultingRule = null;
        JSONObject params = new JSONObject();
        params.put((Object)"ruleId", (Object)ruleId.toJSONObject());
        params.put((Object)"selector", (Object)selector);
        Response response = this.transport.sendBlockingCommand(new Command("CSS.setRuleSelector", params));
        if (response != null && (result = response.getResult()) != null) {
            JSONObject rule = (JSONObject)result.get((Object)"rule");
            resultingRule = new Rule(rule);
        }
        return resultingRule;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    private void notifyMediaQuertResultChanged() {
        for (Listener listener : this.listeners) {
            listener.mediaQueryResultChanged();
        }
    }

    private void notifyStyleSheetChanged(String styleSheetId) {
        for (Listener listener : this.listeners) {
            listener.styleSheetChanged(styleSheetId);
        }
    }

    void handleMediaQuertResultChanged(JSONObject params) {
        this.notifyMediaQuertResultChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleStyleSheetChanged(JSONObject params) {
        this.styleSheetChanged.set(true);
        String styleSheetId = (String)params.get((Object)"styleSheetId");
        CSS cSS = this;
        synchronized (cSS) {
            this.styleSheets.remove(styleSheetId);
        }
        this.notifyStyleSheetChanged(styleSheetId);
    }

    public synchronized void reset() {
        this.styleSheets.clear();
        this.classForHover = null;
    }

    public void setClassForHover(String classForHover) {
        this.classForHover = classForHover;
    }

    private String getClassForHover() {
        return this.classForHover;
    }

    private void returnHoverToSelector(Rule rule) {
        String selector = rule.getSelector();
        String clazz = this.getClassForHover();
        if (clazz != null) {
            selector = Pattern.compile(Pattern.quote("." + clazz)).matcher(selector).replaceAll(":hover");
            rule.setSelector(selector);
        }
    }

    private String replaceHoverInStyleSheetText(String styleSheetText) {
        String clazz = this.getClassForHover();
        if (clazz != null) {
            styleSheetText = styleSheetText.replaceAll(":hover", "." + clazz);
        }
        return styleSheetText;
    }

    class Callback
    implements ResponseCallback {
        Callback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleResponse(Response response) {
            String method = response.getMethod();
            JSONObject params = response.getParams();
            if ("CSS.mediaQueryResultChanged".equals(method)) {
                CSS.this.handleMediaQuertResultChanged(params);
            } else if ("CSS.styleSheetChanged".equals(method)) {
                CSS.this.handleStyleSheetChanged(params);
            } else if ("DOM.documentUpdated".equals(method)) {
                Callback callback = this;
                synchronized (callback) {
                    CSS.this.styleSheets.clear();
                }
            }
        }
    }

    public static interface Listener {
        public void mediaQueryResultChanged();

        public void styleSheetChanged(String var1);
    }

    public static enum PseudoClass {
        ACTIVE("active"),
        FOCUS("focus"),
        HOVER("hover"),
        VISITED("visited");

        private final String code;

        private PseudoClass(String code) {
            this.code = code;
        }

        String getCode() {
            return this.code;
        }
    }
}

