/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.webkit.debugging.api.console;

import java.util.EventListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import org.json.simple.JSONObject;
import org.netbeans.modules.web.webkit.debugging.TransportHelper;
import org.netbeans.modules.web.webkit.debugging.api.WebKitDebugging;
import org.netbeans.modules.web.webkit.debugging.api.console.ConsoleMessage;
import org.netbeans.modules.web.webkit.debugging.api.console.RemoteObjectMessage;
import org.netbeans.modules.web.webkit.debugging.api.debugger.CallFrame;
import org.netbeans.modules.web.webkit.debugging.api.debugger.RemoteObject;
import org.netbeans.modules.web.webkit.debugging.spi.Command;
import org.netbeans.modules.web.webkit.debugging.spi.Response;
import org.netbeans.modules.web.webkit.debugging.spi.ResponseCallback;

public final class Console {
    private static final Logger LOGGER = Logger.getLogger(Console.class.getName());
    private final TransportHelper transport;
    private final WebKitDebugging webKit;
    private boolean enabled;
    private final Callback callback;
    private int numberOfClients = 0;
    private final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();
    private final InputCallback input = new InputCallback();

    public Console(TransportHelper transport, WebKitDebugging webKit) {
        this.transport = transport;
        this.webKit = webKit;
        this.callback = new Callback();
        this.transport.addListener(this.callback);
    }

    public void enable() {
        ++this.numberOfClients;
        if (!this.enabled) {
            this.enabled = true;
            this.transport.sendBlockingCommand(new Command("Console.enable"));
        }
    }

    public void disable() {
        assert (this.numberOfClients > 0);
        --this.numberOfClients;
        if (this.numberOfClients == 0) {
            this.transport.sendCommand(new Command("Console.disable"));
            this.enabled = false;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void clearMessages() {
        this.transport.sendCommand(new Command("Console.clearMessages"));
    }

    public void addInspectedHeapObject(int heapObjectId) {
        JSONObject params = new JSONObject();
        params.put((Object)"heapObjectId", (Object)heapObjectId);
        this.transport.sendBlockingCommand(new Command("Console.addInspectedHeapObject", params));
    }

    public void addListener(Listener l) {
        this.listeners.add(l);
    }

    public void removeListener(Listener l) {
        this.listeners.remove(l);
    }

    private void notifyConsoleMessage(ConsoleMessage msg) {
        for (Listener l : this.listeners) {
            l.messageAdded(msg);
        }
    }

    private void notifyConsoleMessagesCleared() {
        for (Listener l : this.listeners) {
            l.messagesCleared();
        }
    }

    private void notifyConsoleMessageRepeatCountUpdated(int count) {
        for (Listener l : this.listeners) {
            l.messageRepeatCountUpdated(count);
        }
    }

    public void reset() {
        this.listeners.clear();
    }

    public InputCallback getInput() {
        return this.input;
    }

    private class Callback
    implements ResponseCallback {
        private Callback() {
        }

        @Override
        public void handleResponse(Response response) {
            String method = response.getMethod();
            if (method == null || !method.startsWith("Console")) {
                return;
            }
            if ("Console.messageAdded".equals(method)) {
                JSONObject msg = (JSONObject)response.getParams().get((Object)"message");
                final ConsoleMessage cm = new ConsoleMessage(msg);
                Console.this.transport.getRequestProcessor().post(new Runnable(){

                    @Override
                    public void run() {
                        Console.this.notifyConsoleMessage(cm);
                    }
                });
            } else if ("Console.messageRepeatCountUpdated".equals(method)) {
                final int count = ((Number)response.getParams().get((Object)"count")).intValue();
                Console.this.transport.getRequestProcessor().post(new Runnable(){

                    @Override
                    public void run() {
                        Console.this.notifyConsoleMessageRepeatCountUpdated(count);
                    }
                });
            } else if ("Console.messagesCleared".equals(method)) {
                Console.this.transport.getRequestProcessor().post(new Runnable(){

                    @Override
                    public void run() {
                        Console.this.notifyConsoleMessagesCleared();
                    }
                });
            } else {
                LOGGER.warning("Unknown console event: method = " + method);
            }
        }
    }

    public final class InputCallback {
        public void line(String line) {
            CallFrame frame = Console.this.webKit.getDebugger().getCurrentCallFrame();
            RemoteObject result = frame != null ? frame.evaluate(line) : Console.this.webKit.getRuntime().evaluate(line);
            if (result != null) {
                RemoteObjectMessage msg = new RemoteObjectMessage(Console.this.webKit, result);
                Console.this.notifyConsoleMessage(msg);
            }
        }
    }

    public static interface Listener
    extends EventListener {
        public void messageAdded(ConsoleMessage var1);

        public void messagesCleared();

        public void messageRepeatCountUpdated(int var1);
    }
}

