/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.knockout.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.javascript2.editor.model.DeclarationScope;
import org.netbeans.modules.javascript2.editor.model.JsFunction;
import org.netbeans.modules.javascript2.editor.model.JsObject;
import org.netbeans.modules.javascript2.editor.model.Occurrence;
import org.netbeans.modules.javascript2.editor.model.TypeUsage;
import org.netbeans.modules.javascript2.editor.spi.model.FunctionArgument;
import org.netbeans.modules.javascript2.editor.spi.model.FunctionInterceptor;
import org.netbeans.modules.javascript2.editor.spi.model.ModelElementFactory;

public class KnockoutExportInterceptor
implements FunctionInterceptor {
    private static final Logger LOGGER = Logger.getLogger(KnockoutExportInterceptor.class.getName());
    private static final String GLOBAL_KO_OBJECT = "ko";
    private static final Pattern NAME_PATTERN = Pattern.compile("ko\\.(exportSymbol|exportProperty)");

    public Pattern getNamePattern() {
        return NAME_PATTERN;
    }

    public void intercept(String functionName, JsObject globalObject, DeclarationScope scope, ModelElementFactory factory, Collection<FunctionArgument> args) {
        if (args.size() == 3) {
            Iterator<FunctionArgument> iterator = args.iterator();
            FunctionArgument objectArgument = iterator.next();
            FunctionArgument nameArgument = iterator.next();
            FunctionArgument valueArgument = iterator.next();
            int offset = nameArgument.getOffset();
            JsObject object = null;
            if (objectArgument.getKind() == FunctionArgument.Kind.REFERENCE) {
                JsObject found;
                List identifiers = (List)objectArgument.getValue();
                JsObject ref = KnockoutExportInterceptor.getReference(scope, identifiers, false);
                if (ref != null && (found = KnockoutExportInterceptor.findJsObjectByAssignment(globalObject, ref, offset)) != null) {
                    ref = found;
                }
                object = ref;
            }
            JsObject value = null;
            if (valueArgument.getKind() == FunctionArgument.Kind.REFERENCE) {
                JsObject found;
                List identifiers = (List)valueArgument.getValue();
                JsObject ref = KnockoutExportInterceptor.getReference(scope, identifiers, true);
                if (ref != null && (found = KnockoutExportInterceptor.findJsObjectByAssignment(globalObject, ref, offset)) != null) {
                    ref = found;
                }
                value = ref;
            }
            String name = (String)nameArgument.getValue();
            OffsetRange offsetRange = new OffsetRange(offset, offset + name.length());
            if (object != null && value != null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Exporting property {0} to {1} as {2}", new Object[]{name, object.getFullyQualifiedName(), value.getFullyQualifiedName()});
                }
                EnumSet modifiers = EnumSet.copyOf(value.getModifiers());
                modifiers.remove(Modifier.STATIC);
                object.addProperty(name, factory.newReference(object, name, offsetRange, value, true, modifiers));
            }
        } else if (args.size() == 2) {
            JsObject ko = globalObject.getProperty(GLOBAL_KO_OBJECT);
            if (ko == null) {
                ko = factory.newObject(globalObject, GLOBAL_KO_OBJECT, OffsetRange.NONE, true);
                globalObject.addProperty(GLOBAL_KO_OBJECT, ko);
            }
            Iterator<FunctionArgument> iterator = args.iterator();
            FunctionArgument nameArgument = iterator.next();
            FunctionArgument valueArgument = iterator.next();
            int offset = nameArgument.getOffset();
            if (nameArgument.getKind() == FunctionArgument.Kind.STRING) {
                List identifiers;
                JsObject value;
                JsObject parent = ko;
                String[] names = ((String)nameArgument.getValue()).split("\\.");
                for (int i = 0; i < names.length - 1; ++i) {
                    String name = names[i];
                    if (i == 0 && GLOBAL_KO_OBJECT.equals(name)) continue;
                    JsObject child = parent.getProperty(name);
                    OffsetRange offsetRange = new OffsetRange(offset, offset + name.length());
                    if (child == null) {
                        child = factory.newObject(parent, name, offsetRange, true);
                        parent.addProperty(name, child);
                    } else if (!child.isDeclared()) {
                        JsObject newJsObject = factory.newObject(parent, name, offsetRange, true);
                        parent.addProperty(name, newJsObject);
                        for (Occurrence occurrence : child.getOccurrences()) {
                            newJsObject.addOccurrence(occurrence.getOffsetRange());
                        }
                        newJsObject.addOccurrence(child.getDeclarationName().getOffsetRange());
                        child = newJsObject;
                    }
                    parent = child;
                }
                String name = names[names.length - 1];
                if (valueArgument.getKind() == FunctionArgument.Kind.REFERENCE && (value = KnockoutExportInterceptor.getReference(scope, identifiers = (List)valueArgument.getValue(), false)) != null) {
                    JsObject found = KnockoutExportInterceptor.findJsObjectByAssignment(globalObject, value, offset);
                    if (found != null && found.isDeclared()) {
                        value = found;
                    } else {
                        int levelUp = identifiers.size() - 1;
                        JsObject foundParent = null;
                        for (JsObject valueParent = value.getParent(); valueParent != null && (foundParent = KnockoutExportInterceptor.findJsObjectByAssignment(globalObject, valueParent, offset)) == null; valueParent = valueParent.getParent()) {
                            --levelUp;
                        }
                        if (foundParent != null) {
                            boolean skip = true;
                            for (int i = levelUp; i < identifiers.size(); ++i) {
                                JsObject property = foundParent.getProperty((String)identifiers.get(i));
                                if (property == null) {
                                    skip = false;
                                    break;
                                }
                                foundParent = property;
                            }
                            if (skip) {
                                return;
                            }
                        }
                    }
                    OffsetRange offsetRange = new OffsetRange(offset, offset + name.length());
                    JsObject property = parent.getProperty(name);
                    if (property != null) {
                        if (property instanceof JsFunction && !(value instanceof JsFunction)) {
                            value = property;
                        } else {
                            HashMap current = new HashMap(property.getProperties());
                            current.keySet().removeAll(value.getProperties().keySet());
                            for (Map.Entry entry : current.entrySet()) {
                                value.addProperty((String)entry.getKey(), (JsObject)entry.getValue());
                            }
                        }
                    }
                    parent.addProperty(name, factory.newReference(parent, name, offsetRange, value, true, null));
                }
            }
        }
    }

    private static JsObject getReference(DeclarationScope scope, List<String> identifier, boolean searchPrototype) {
        if ("this".equals(identifier.get(0))) {
            return (JsObject)scope;
        }
        for (DeclarationScope currentScope = scope; currentScope != null; currentScope = currentScope.getParentScope()) {
            JsObject ret = KnockoutExportInterceptor.getReference((JsObject)currentScope, identifier);
            if (ret == null) continue;
            return ret;
        }
        if (searchPrototype && identifier.size() > 1) {
            ArrayList<String> prototype = new ArrayList<String>(identifier);
            prototype.add(prototype.size() - 1, "prototype");
            return KnockoutExportInterceptor.getReference(scope, prototype, false);
        }
        return null;
    }

    private static JsObject getReference(JsObject object, List<String> identifier) {
        if (object == null) {
            return null;
        }
        if (identifier.isEmpty()) {
            return object;
        }
        return KnockoutExportInterceptor.getReference(object.getProperty(identifier.get(0)), identifier.subList(1, identifier.size()));
    }

    private static JsObject findJsObjectByAssignment(JsObject globalObject, JsObject value, int offset) {
        return KnockoutExportInterceptor.findJsObjectByAssignment(globalObject, value, offset, true);
    }

    private static JsObject findJsObjectByAssignment(JsObject globalObject, JsObject value, int offset, boolean searchPrototype) {
        JsObject obj;
        String fqn;
        int index;
        if (value == null) {
            return null;
        }
        JsObject ret = null;
        Collection assigments = value.getAssignmentForOffset(offset);
        if (assigments.size() == 1) {
            ret = KnockoutExportInterceptor.findJsObjectByName(globalObject, ((TypeUsage)assigments.iterator().next()).getType());
        }
        if (ret == null && searchPrototype && (index = (fqn = value.getFullyQualifiedName()).lastIndexOf(46)) > 0 && (obj = KnockoutExportInterceptor.findJsObjectByName(globalObject, fqn = fqn.substring(0, index) + ".prototype" + fqn.substring(index))) != null) {
            ret = KnockoutExportInterceptor.findJsObjectByAssignment(globalObject, obj, offset, false);
        }
        return ret;
    }

    private static JsObject findJsObjectByName(JsObject global, String fqName) {
        JsObject result;
        JsObject property = result = global;
        StringTokenizer stringTokenizer = new StringTokenizer(fqName, ".");
        while (stringTokenizer.hasMoreTokens() && result != null) {
            String token = stringTokenizer.nextToken();
            property = result.getProperty(token);
            if (property == null) {
                if ((result = result instanceof JsFunction ? ((JsFunction)result).getParameter(token) : null) != null) continue;
                break;
            }
            result = property;
        }
        return result;
    }
}

