/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.knockout.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.javascript2.editor.model.DeclarationScope;
import org.netbeans.modules.javascript2.editor.model.JsFunction;
import org.netbeans.modules.javascript2.editor.model.JsObject;
import org.netbeans.modules.javascript2.editor.model.TypeUsage;
import org.netbeans.modules.javascript2.editor.spi.model.FunctionArgument;
import org.netbeans.modules.javascript2.editor.spi.model.FunctionInterceptor;
import org.netbeans.modules.javascript2.editor.spi.model.ModelElementFactory;

public class KnockoutApplyBindingsInterceptor
implements FunctionInterceptor {
    private static final String GLOBAL_KO_OBJECT = "ko";
    private static final String BINDINGS_OBJECT = "$bindings";
    private static final String GENERATED_FUNCTION_PREFIX = "_L";
    private static final Pattern NAME_PATTERN = Pattern.compile("ko\\.applyBindings");

    public Pattern getNamePattern() {
        return NAME_PATTERN;
    }

    public void intercept(String functionName, JsObject globalObject, DeclarationScope scope, ModelElementFactory factory, Collection<FunctionArgument> args) {
        if (args.size() < 1 || args.size() > 2) {
            return;
        }
        Iterator<FunctionArgument> iterator = args.iterator();
        FunctionArgument modelArgument = iterator.next();
        int offset = modelArgument.getOffset();
        JsObject object = null;
        if (modelArgument.getKind() == FunctionArgument.Kind.REFERENCE) {
            JsObject found;
            List identifiers = (List)modelArgument.getValue();
            JsObject ref = KnockoutApplyBindingsInterceptor.getReference(scope, identifiers, false);
            if (ref != null && (found = KnockoutApplyBindingsInterceptor.findJsObjectByAssignment(globalObject, ref, offset)) != null) {
                ref = found;
            }
            object = ref;
        } else if (modelArgument.getKind() == FunctionArgument.Kind.ANONYMOUS_OBJECT) {
            object = (JsObject)modelArgument.getValue();
        }
        if (object != null) {
            JsObject bindings;
            JsObject ko = globalObject.getProperty(GLOBAL_KO_OBJECT);
            if (ko == null) {
                ko = factory.newObject(globalObject, GLOBAL_KO_OBJECT, OffsetRange.NONE, true);
                globalObject.addProperty(GLOBAL_KO_OBJECT, ko);
            }
            if ((bindings = ko.getProperty(BINDINGS_OBJECT)) == null) {
                bindings = factory.newObject(ko, BINDINGS_OBJECT, OffsetRange.NONE, true);
                ko.addProperty(BINDINGS_OBJECT, bindings);
            }
            for (Map.Entry entry : object.getProperties().entrySet()) {
                if (((String)entry.getKey()).startsWith(GENERATED_FUNCTION_PREFIX) || ((String)entry.getKey()).equals("arguments")) continue;
                bindings.addProperty((String)entry.getKey(), factory.newReference(object, (String)entry.getKey(), OffsetRange.NONE, (JsObject)entry.getValue(), true, null));
            }
        }
    }

    private static JsObject getReference(DeclarationScope scope, List<String> identifier, boolean searchPrototype) {
        if ("this".equals(identifier.get(0))) {
            return (JsObject)scope;
        }
        for (DeclarationScope currentScope = scope; currentScope != null; currentScope = currentScope.getParentScope()) {
            JsObject ret = KnockoutApplyBindingsInterceptor.getReference((JsObject)currentScope, identifier);
            if (ret == null) continue;
            return ret;
        }
        if (searchPrototype && identifier.size() > 1) {
            ArrayList<String> prototype = new ArrayList<String>(identifier);
            prototype.add(prototype.size() - 1, "prototype");
            return KnockoutApplyBindingsInterceptor.getReference(scope, prototype, false);
        }
        return null;
    }

    private static JsObject getReference(JsObject object, List<String> identifier) {
        if (object == null) {
            return null;
        }
        if (identifier.isEmpty()) {
            return object;
        }
        return KnockoutApplyBindingsInterceptor.getReference(object.getProperty(identifier.get(0)), identifier.subList(1, identifier.size()));
    }

    private static JsObject findJsObjectByAssignment(JsObject globalObject, JsObject value, int offset) {
        return KnockoutApplyBindingsInterceptor.findJsObjectByAssignment(globalObject, value, offset, true);
    }

    private static JsObject findJsObjectByAssignment(JsObject globalObject, JsObject value, int offset, boolean searchPrototype) {
        JsObject obj;
        String fqn;
        int index;
        if (value == null) {
            return null;
        }
        JsObject ret = null;
        Collection assigments = value.getAssignmentForOffset(offset);
        if (assigments.size() == 1) {
            ret = KnockoutApplyBindingsInterceptor.findJsObjectByName(globalObject, ((TypeUsage)assigments.iterator().next()).getType());
        }
        if (ret == null && searchPrototype && (index = (fqn = value.getFullyQualifiedName()).lastIndexOf(46)) > 0 && (obj = KnockoutApplyBindingsInterceptor.findJsObjectByName(globalObject, fqn = fqn.substring(0, index) + ".prototype" + fqn.substring(index))) != null) {
            ret = KnockoutApplyBindingsInterceptor.findJsObjectByAssignment(globalObject, obj, offset, false);
        }
        return ret;
    }

    private static JsObject findJsObjectByName(JsObject global, String fqName) {
        JsObject result;
        JsObject property = result = global;
        StringTokenizer stringTokenizer = new StringTokenizer(fqName, ".");
        while (stringTokenizer.hasMoreTokens() && result != null) {
            String token = stringTokenizer.nextToken();
            property = result.getProperty(token);
            if (property == null) {
                if ((result = result instanceof JsFunction ? ((JsFunction)result).getParameter(token) : null) != null) continue;
                break;
            }
            result = property;
        }
        return result;
    }
}

