/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.installations;

import org.netbeans.modules.db.mysql.impl.Installation;
import org.netbeans.modules.db.mysql.util.Utils;
import org.openide.util.Utilities;

public class WindowsStandaloneInstallation
implements Installation {
    static final String DEFAULT_BASE_PATH = "C:/Program Files/MySQL/";
    static final String FOLDER_NAME_PREFIX = "MySQL Server ";
    private final String basePath;

    protected WindowsStandaloneInstallation(String folderName) {
        this.basePath = DEFAULT_BASE_PATH + folderName;
    }

    @Override
    public String[] getStartCommand() {
        return new String[]{this.basePath + "/bin/mysqld.exe", "--console"};
    }

    @Override
    public String[] getStopCommand() {
        return new String[]{this.basePath + "/bin/mysqladmin.exe", "-u root shutdown"};
    }

    @Override
    public boolean isInstalled() {
        return Utilities.isWindows() && Utils.isValidExecutable(this.getStartCommand()[0]);
    }

    @Override
    public boolean isStackInstall() {
        return false;
    }

    @Override
    public String[] getAdminCommand() {
        return new String[]{"", ""};
    }

    @Override
    public String getDefaultPort() {
        return "3306";
    }

    public Installation getInstallation(String command, Installation.Command cmdType) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String toString() {
        return "Windows Installation - " + this.basePath;
    }
}

