/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.impl;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.sql.support.SQLIdentifiers;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.db.mysql.Database;
import org.netbeans.modules.db.mysql.DatabaseServer;
import org.netbeans.modules.db.mysql.DatabaseUser;
import org.netbeans.modules.db.mysql.impl.ConnectManager;
import org.netbeans.modules.db.mysql.impl.ConnectionProcessor;
import org.netbeans.modules.db.mysql.impl.MySQLOptions;
import org.netbeans.modules.db.mysql.impl.StartManager;
import org.netbeans.modules.db.mysql.impl.StopManager;
import org.netbeans.modules.db.mysql.util.DatabaseUtils;
import org.netbeans.modules.db.mysql.util.ExecSupport;
import org.netbeans.modules.db.mysql.util.Utils;
import org.openide.awt.HtmlBrowser;
import org.openide.execution.NbProcessDescriptor;
import org.openide.util.Cancellable;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public final class MySQLDatabaseServer
implements DatabaseServer,
PropertyChangeListener {
    private static final Object lock = new Object();
    private static final Image ICON = ImageUtilities.loadImage((String)"org/netbeans/modules/db/mysql/resources/catalog.gif");
    private static final Image ERROR_BADGE = ImageUtilities.loadImage((String)"org/netbeans/modules/db/mysql/resources/error-badge.gif");
    private static boolean first = true;
    private volatile String displayName;
    private volatile String shortDescription;
    private volatile Image icon;
    private static final Logger LOGGER = Logger.getLogger(DatabaseServer.class.getName());
    private static InputOutput OUTPUT = null;
    private static volatile DatabaseServer DEFAULT;
    private static final MySQLOptions OPTIONS;
    private static final String GET_DATABASES_SQL = "SHOW DATABASES";
    private static final String GET_USERS_SQL = "SELECT DISTINCT user, host FROM mysql.user";
    private static final String CREATE_DATABASE_SQL = "CREATE DATABASE ";
    private static final String DROP_DATABASE_SQL = "DROP DATABASE ";
    private static final String GRANT_ALL_SQL_1 = "GRANT ALL ON ";
    private static final String GRANT_ALL_SQL_2 = ".* TO ?@?";
    final LinkedBlockingQueue<Runnable> commandQueue = new LinkedBlockingQueue();
    final ConnectionProcessor connProcessor = new ConnectionProcessor(this.commandQueue);
    final CopyOnWriteArrayList<ChangeListener> changeListeners = new CopyOnWriteArrayList();
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private volatile String adminPassword;
    private DatabaseServer.ServerState runstate = DatabaseServer.ServerState.DISCONNECTED;
    private volatile String configError = null;
    private volatile HashMap<String, Database> databases = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatabaseServer getDefault() {
        Object object = lock;
        synchronized (object) {
            if (DEFAULT != null) {
                return DEFAULT;
            }
        }
        MySQLDatabaseServer server = new MySQLDatabaseServer();
        Object object2 = lock;
        synchronized (object2) {
            if (DEFAULT == null) {
                DEFAULT = server;
            }
        }
        return DEFAULT;
    }

    private MySQLDatabaseServer() {
        RequestProcessor.getDefault().post((Runnable)this.connProcessor);
        MySQLOptions.getDefault().addPropertyChangeListener(this);
        this.addPropertyChangeListener(ConnectManager.getDefault().getReconnectListener());
        this.addPropertyChangeListener(StartManager.getDefault().getStartListener());
        this.addPropertyChangeListener(StopManager.getDefault().getStopListener());
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                MySQLDatabaseServer.this.checkRunning();
            }
        });
        this.updateDisplayInformation();
    }

    @Override
    public String getHost() {
        return Utils.isEmpty(OPTIONS.getHost()) ? MySQLOptions.getDefaultHost() : OPTIONS.getHost();
    }

    @Override
    public void setHost(String host) {
        OPTIONS.setHost(host);
        this.updateDisplayInformation();
        this.notifyChange();
    }

    @Override
    public String getPort() {
        String port = OPTIONS.getPort();
        if (Utils.isEmpty(port)) {
            return MySQLOptions.getDefaultPort();
        }
        return port;
    }

    @Override
    public void setPort(String port) {
        OPTIONS.setPort(port);
        this.updateDisplayInformation();
        this.notifyChange();
    }

    @Override
    public String getUser() {
        String user = OPTIONS.getAdminUser();
        if (Utils.isEmpty(user)) {
            return MySQLOptions.getDefaultAdminUser();
        }
        return user;
    }

    @Override
    public void setUser(String adminUser) {
        OPTIONS.setAdminUser(adminUser);
        this.updateDisplayInformation();
        this.notifyChange();
    }

    @Override
    public synchronized String getPassword() {
        if (this.adminPassword != null) {
            return this.adminPassword;
        }
        return OPTIONS.getAdminPassword();
    }

    @Override
    public synchronized void setPassword(String adminPassword) {
        String string = this.adminPassword = adminPassword == null ? "" : adminPassword;
        if (this.isSavePassword()) {
            OPTIONS.setAdminPassword(adminPassword);
        }
    }

    @Override
    public boolean isSavePassword() {
        return OPTIONS.isSavePassword();
    }

    @Override
    public void setSavePassword(boolean savePassword) {
        OPTIONS.setSavePassword(savePassword);
        OPTIONS.setAdminPassword(this.getPassword());
    }

    @Override
    public String getAdminPath() {
        return OPTIONS.getAdminPath();
    }

    @Override
    public void setAdminPath(String path) {
        OPTIONS.setAdminPath(path);
    }

    @Override
    public String getStartPath() {
        return OPTIONS.getStartPath();
    }

    @Override
    public void setStartPath(String path) {
        OPTIONS.setStartPath(path);
    }

    @Override
    public String getStopPath() {
        return OPTIONS.getStopPath();
    }

    @Override
    public void setStopPath(String path) {
        OPTIONS.setStopPath(path);
    }

    @Override
    public String getStopArgs() {
        return OPTIONS.getStopArgs();
    }

    @Override
    public void setStopArgs(String args) {
        OPTIONS.setStopArgs(args);
    }

    @Override
    public String getStartArgs() {
        return OPTIONS.getStartArgs();
    }

    @Override
    public void setStartArgs(String args) {
        OPTIONS.setStartArgs(args);
    }

    @Override
    public String getAdminArgs() {
        return OPTIONS.getAdminArgs();
    }

    @Override
    public void setAdminArgs(String args) {
        OPTIONS.setAdminArgs(args);
    }

    @Override
    public synchronized boolean isConnected() {
        return this.runstate == DatabaseServer.ServerState.CONNECTED;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    private void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDisplayInformation() {
        String stateLabel = this.runstate.toString();
        String hostPort = this.getHostPort();
        String user = this.getUser();
        MySQLDatabaseServer mySQLDatabaseServer = this;
        synchronized (mySQLDatabaseServer) {
            this.setDisplayName(Utils.getMessage("LBL_ServerDisplayName", hostPort, user, Utils.getMessage(stateLabel, new Object[0])));
            if (this.runstate != DatabaseServer.ServerState.CONFIGERR) {
                this.icon = ICON;
                this.setShortDescription(Utils.getMessage("LBL_ServerShortDescription", hostPort, user, Utils.getMessage(stateLabel, new Object[0])));
            } else {
                assert (this.configError != null);
                this.icon = ImageUtilities.mergeImages((Image)ICON, (Image)ERROR_BADGE, (int)6, (int)6);
                this.setShortDescription(Utils.getMessage("LBL_ServerShortDescriptionError", this.configError));
            }
        }
        MySQLDatabaseServer.closeOutput();
    }

    @Override
    public String getShortDescription() {
        return this.shortDescription;
    }

    private void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    private String getHostPort() {
        String port = this.getPort();
        port = Utils.isEmpty(port) ? "" : ":" + port;
        return this.getHost() + port;
    }

    @Override
    public String getURL() {
        return DatabaseUtils.getURL(this.getHost(), this.getPort());
    }

    @Override
    public String getURL(String databaseName) {
        return DatabaseUtils.getURL(this.getHost(), this.getPort(), databaseName);
    }

    private void notifyChange() {
        ChangeEvent evt = new ChangeEvent(this);
        for (ChangeListener listener : this.changeListeners) {
            listener.stateChanged(evt);
        }
    }

    private void reportConnectionInvalid(DatabaseException dbe) {
        this.disconnect();
        LOGGER.log(Level.INFO, null, dbe);
        Utils.displayErrorMessage(dbe.getMessage());
    }

    @Override
    public void refreshDatabaseList() {
        if (this.isConnected()) {
            final MySQLDatabaseServer server = this;
            new DatabaseCommand(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void execute() throws Exception {
                    try {
                        HashMap<String, Database> dblist = new HashMap<String, Database>();
                        if (!MySQLDatabaseServer.this.isConnected()) {
                            MySQLDatabaseServer.this.setDatabases(dblist);
                            return;
                        }
                        try {
                            MySQLDatabaseServer.this.connProcessor.validateConnection();
                        }
                        catch (DatabaseException dbe) {
                            MySQLDatabaseServer.this.reportConnectionInvalid(dbe);
                            MySQLDatabaseServer.this.setDatabases(dblist);
                            MySQLDatabaseServer.this.notifyChange();
                            return;
                        }
                        Connection conn = MySQLDatabaseServer.this.connProcessor.getConnection();
                        if (conn == null) {
                            MySQLDatabaseServer.this.setDatabases(dblist);
                            return;
                        }
                        PreparedStatement ps = conn.prepareStatement(MySQLDatabaseServer.GET_DATABASES_SQL);
                        ResultSet rs = ps.executeQuery();
                        while (rs.next()) {
                            String dbname = rs.getString(1);
                            dblist.put(dbname, new Database(server, dbname));
                        }
                        rs.close();
                        ps.close();
                        MySQLDatabaseServer.this.setDatabases(dblist);
                    }
                    finally {
                        MySQLDatabaseServer.this.notifyChange();
                    }
                }
            }.postCommand("refreshDatabaseList");
        } else {
            this.setDatabases(new HashMap<String, Database>());
            this.notifyChange();
        }
    }

    private synchronized void setDatabases(HashMap<String, Database> list) {
        this.databases = list;
    }

    @Override
    public synchronized Collection<Database> getDatabases() throws DatabaseException {
        return this.databases.values();
    }

    private void checkNotOnDispatchThread() {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Can not call this method on the event dispatch thread");
        }
    }

    @Override
    public void disconnectSync() {
        this.disconnect(false);
    }

    @Override
    public void disconnect() {
        this.disconnect(true);
    }

    private void disconnect(boolean async) {
        ArrayBlockingQueue queue = null;
        if (!async) {
            this.checkNotOnDispatchThread();
            queue = new ArrayBlockingQueue(1);
        }
        DatabaseCommand cmd = new DatabaseCommand((BlockingQueue)queue){

            @Override
            public void execute() throws Exception {
                Connection conn = MySQLDatabaseServer.this.connProcessor.getConnection();
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {
                        LOGGER.log(Level.FINE, null, e);
                    }
                }
                MySQLDatabaseServer.this.connProcessor.setConnection(null);
                MySQLDatabaseServer.this.setState(DatabaseServer.ServerState.DISCONNECTED);
                MySQLDatabaseServer.this.updateDisplayInformation();
                MySQLDatabaseServer.this.refreshDatabaseList();
            }
        };
        cmd.postCommand("disconnect");
        if (!async) {
            try {
                cmd.syncUp();
                if (cmd.getException() != null) {
                    Throwable e = cmd.getException();
                    if (e instanceof DatabaseException) {
                        throw new RuntimeException(e);
                    }
                    throw Utils.launderThrowable(e);
                }
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
        }
    }

    @Override
    public void reconnect() throws DatabaseException, TimeoutException {
        this.reconnect(10000L);
    }

    @Override
    public void reconnect(long timeToWait) throws DatabaseException, TimeoutException {
        ArrayBlockingQueue queue = null;
        this.checkNotOnDispatchThread();
        queue = new ArrayBlockingQueue(1);
        DatabaseCommand cmd = new DatabaseCommand((BlockingQueue)queue){

            @Override
            public void execute() throws Exception {
                MySQLDatabaseServer.this.disconnectSync();
                MySQLDatabaseServer.this.checkConfiguration();
                ProgressHandle progress = ProgressHandleFactory.createHandle((String)Utils.getMessage("MSG_ConnectingToServer", new Object[0]));
                try {
                    progress.start();
                    progress.switchToIndeterminate();
                    Connection conn = DatabaseUtils.connect(MySQLDatabaseServer.this.getURL(), MySQLDatabaseServer.this.getUser(), MySQLDatabaseServer.this.getPassword());
                    if (conn == null) {
                        throw new DatabaseException(NbBundle.getMessage(MySQLDatabaseServer.class, (String)"MSG_UnableToConnect", (Object)MySQLDatabaseServer.this.getURL(), (Object)MySQLDatabaseServer.this.getUser()));
                    }
                    MySQLDatabaseServer.this.connProcessor.setConnection(conn);
                    MySQLDatabaseServer.this.setState(DatabaseServer.ServerState.CONNECTED);
                }
                catch (DatabaseException dbe) {
                    MySQLDatabaseServer.this.disconnect();
                    throw dbe;
                }
                catch (TimeoutException te) {
                    MySQLDatabaseServer.this.disconnect();
                    throw te;
                }
                finally {
                    MySQLDatabaseServer.this.refreshDatabaseList();
                    progress.finish();
                }
            }
        };
        cmd.postCommand("reconnect");
        try {
            cmd.syncUp();
            if (cmd.getException() != null) {
                if (cmd.getException() instanceof DatabaseException) {
                    throw new DatabaseException(cmd.getException());
                }
                if (cmd.getException() instanceof TimeoutException) {
                    TimeoutException newte = new TimeoutException(cmd.getException().getMessage());
                    newte.initCause(cmd.getException());
                    throw newte;
                }
                throw Utils.launderThrowable(cmd.getException());
            }
        }
        catch (InterruptedException ie) {
            LOGGER.log(Level.INFO, null, ie);
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkConfiguration() throws DatabaseException {
        try {
            InetAddress.getAllByName(this.getHost());
        }
        catch (UnknownHostException ex) {
            MySQLDatabaseServer mySQLDatabaseServer = this;
            synchronized (mySQLDatabaseServer) {
                this.configError = NbBundle.getMessage(MySQLDatabaseServer.class, (String)"MSG_UnknownHost", (Object)this.getHost());
                this.setState(DatabaseServer.ServerState.CONFIGERR);
            }
            LOGGER.log(Level.INFO, this.configError, ex);
            throw new DatabaseException(this.configError, (Throwable)ex);
        }
        try {
            String port = this.getPort();
            if (port == null) {
                throw new NumberFormatException();
            }
            Integer.valueOf(port);
        }
        catch (NumberFormatException nfe) {
            MySQLDatabaseServer mySQLDatabaseServer = this;
            synchronized (mySQLDatabaseServer) {
                this.configError = NbBundle.getMessage(MySQLDatabaseServer.class, (String)"MSG_InvalidPortNumber", (Object)this.getPort());
                this.setState(DatabaseServer.ServerState.CONFIGERR);
            }
            LOGGER.log(Level.INFO, this.configError, nfe);
            throw new DatabaseException(this.configError, (Throwable)nfe);
        }
    }

    @Override
    public void validateConnection() throws DatabaseException {
        ArrayBlockingQueue queue = new ArrayBlockingQueue(1);
        DatabaseCommand cmd = new DatabaseCommand((BlockingQueue)queue, true){

            @Override
            public void execute() throws Exception {
            }
        };
        cmd.postCommand("validateConnection");
        try {
            cmd.syncUp();
            Throwable e = cmd.getException();
            if (e != null) {
                if (e instanceof DatabaseException) {
                    throw (DatabaseException)e;
                }
                throw Utils.launderThrowable(e);
            }
        }
        catch (InterruptedException e) {
            this.disconnect();
            throw new DatabaseException((Throwable)e);
        }
    }

    @Override
    public boolean databaseExists(String dbname) throws DatabaseException {
        return this.databases.containsKey(dbname);
    }

    @Override
    public void createDatabase(final String dbname) {
        new DatabaseCommand(true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() throws Exception {
                try {
                    Connection conn = MySQLDatabaseServer.this.connProcessor.getConnection();
                    SQLIdentifiers.Quoter quoter = MySQLDatabaseServer.this.connProcessor.getQuoter();
                    String quotedName = quoter.quoteIfNeeded(dbname);
                    PreparedStatement stmt = conn.prepareStatement(MySQLDatabaseServer.CREATE_DATABASE_SQL + quotedName);
                    stmt.executeUpdate();
                    stmt.close();
                }
                finally {
                    MySQLDatabaseServer.this.refreshDatabaseList();
                }
            }
        }.postCommand("createDatabase");
    }

    @Override
    public void dropDatabase(final String dbname, final boolean deleteConnections) {
        new DatabaseCommand(true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() throws Exception {
                try {
                    Connection conn = MySQLDatabaseServer.this.connProcessor.getConnection();
                    SQLIdentifiers.Quoter quoter = MySQLDatabaseServer.this.connProcessor.getQuoter();
                    String quotedName = quoter.quoteIfNeeded(dbname);
                    PreparedStatement stmt = conn.prepareStatement(MySQLDatabaseServer.DROP_DATABASE_SQL + quotedName);
                    stmt.executeUpdate();
                    stmt.close();
                    if (deleteConnections) {
                        DatabaseConnection[] dbconns;
                        String hostname = MySQLDatabaseServer.this.getHost();
                        String ipaddr = Utils.getHostIpAddress(hostname);
                        for (DatabaseConnection dbconn : dbconns = ConnectionManager.getDefault().getConnections()) {
                            if (!dbconn.getDriverClass().equals(MySQLOptions.getDriverClass()) || !dbconn.getDatabaseURL().contains("/" + dbname) || !dbconn.getDatabaseURL().contains(MySQLDatabaseServer.this.getHost()) && !dbconn.getDatabaseURL().contains(ipaddr) || !dbconn.getDatabaseURL().contains(MySQLDatabaseServer.this.getPort())) continue;
                            ConnectionManager.getDefault().removeConnection(dbconn);
                        }
                    }
                }
                finally {
                    MySQLDatabaseServer.this.refreshDatabaseList();
                }
            }
        }.postCommand("dropDatabase");
    }

    @Override
    public void dropDatabase(String dbname) {
        this.dropDatabase(dbname, true);
    }

    @Override
    public List<DatabaseUser> getUsers() throws DatabaseException {
        final ArrayList<DatabaseUser> users = new ArrayList<DatabaseUser>();
        if (!this.isConnected()) {
            return users;
        }
        ArrayBlockingQueue queue = new ArrayBlockingQueue(1);
        DatabaseCommand cmd = new DatabaseCommand(queue, true){

            @Override
            public void execute() throws Exception {
                PreparedStatement stmt = MySQLDatabaseServer.this.connProcessor.getConnection().prepareStatement(MySQLDatabaseServer.GET_USERS_SQL);
                ResultSet rs = stmt.executeQuery();
                while (rs.next()) {
                    String user = rs.getString(1).trim();
                    String host = rs.getString(2).trim();
                    users.add(new DatabaseUser(user, host));
                }
                rs.close();
                stmt.close();
            }
        };
        cmd.postCommand("getUsers");
        try {
            cmd.syncUp();
            if (cmd.getException() != null) {
                Throwable e = cmd.getException();
                if (e instanceof DatabaseException) {
                    throw (DatabaseException)e;
                }
                if (e.getClass().getName().contains("MySQLSyntaxErrorException")) {
                    throw new DatabaseException(e);
                }
                throw Utils.launderThrowable(e);
            }
        }
        catch (InterruptedException e) {
            throw new DatabaseException((Throwable)e);
        }
        return users;
    }

    @Override
    public void grantFullDatabaseRights(final String dbname, final DatabaseUser grantUser) {
        new DatabaseCommand(true){

            @Override
            public void execute() throws Exception {
                String quotedName = MySQLDatabaseServer.this.connProcessor.getQuoter().quoteIfNeeded(dbname);
                PreparedStatement ps = MySQLDatabaseServer.this.connProcessor.getConnection().prepareStatement(MySQLDatabaseServer.GRANT_ALL_SQL_1 + quotedName + MySQLDatabaseServer.GRANT_ALL_SQL_2);
                ps.setString(1, grantUser.getUser());
                ps.setString(2, grantUser.getHost());
                ps.executeUpdate();
                ps.close();
            }
        }.postCommand("grantFullDatabaseRights");
    }

    @Override
    public void start() throws DatabaseException {
        if (!Utils.isValidExecutable(this.getStartPath(), false)) {
            throw new DatabaseException(Utils.getMessage("MSG_InvalidStartCommand", new Object[0]));
        }
        new DatabaseCommand(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() throws Exception {
                DatabaseServer.ServerState state = MySQLDatabaseServer.this.checkRunning(1000L);
                if (state == DatabaseServer.ServerState.CONNECTED) {
                    return;
                }
                try {
                    MySQLDatabaseServer.this.runProcess(MySQLDatabaseServer.this.getStartPath(), MySQLDatabaseServer.this.getStartArgs());
                }
                finally {
                    MySQLDatabaseServer.this.updateDisplayInformation();
                    MySQLDatabaseServer.this.notifyChange();
                }
            }
        }.postCommand("start");
    }

    @Override
    public void stop() throws DatabaseException {
        if (!Utils.isValidExecutable(this.getStopPath(), false)) {
            throw new DatabaseException(Utils.getMessage("MSG_InvalidStopCommand", new Object[0]));
        }
        new StopDatabaseCommand().postCommand("stop");
    }

    @Override
    public void startAdmin() throws DatabaseException {
        String adminCommand = this.getAdminPath();
        if (adminCommand == null || adminCommand.length() == 0) {
            throw new DatabaseException(NbBundle.getMessage(DatabaseServer.class, (String)"MSG_AdminCommandNotSet"));
        }
        if (Utils.isValidURL(adminCommand, false)) {
            this.launchBrowser(adminCommand);
        } else if (Utils.isValidExecutable(adminCommand, false)) {
            this.runProcess(adminCommand, this.getAdminArgs());
            MySQLDatabaseServer.closeOutput();
        } else {
            throw new DatabaseException(NbBundle.getMessage(DatabaseServer.class, (String)"MSG_InvalidAdminCommand", (Object)adminCommand));
        }
    }

    private Process runProcess(String command, String args) throws DatabaseException {
        if (Utilities.isMac() && command.endsWith(".app")) {
            args = "\"" + command + "\" " + args;
            command = "/usr/bin/open";
        }
        try {
            NbProcessDescriptor desc = new NbProcessDescriptor(command, args);
            Process proc = desc.exec();
            new ExecSupport().displayProcessOutputs(proc);
            return proc;
        }
        catch (Exception e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    private void launchBrowser(String adminCommand) throws DatabaseException {
        try {
            HtmlBrowser.URLDisplayer.getDefault().showURL(new URL(adminCommand));
        }
        catch (Exception e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.changeListeners.add(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    @Override
    public synchronized DatabaseServer.ServerState getState() {
        return this.runstate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(DatabaseServer.ServerState runstate) {
        MySQLDatabaseServer mySQLDatabaseServer = this;
        synchronized (mySQLDatabaseServer) {
            this.runstate = runstate;
            if (runstate != DatabaseServer.ServerState.CONFIGERR) {
                this.configError = null;
            }
            this.updateDisplayInformation();
        }
        this.notifyChange();
    }

    public DatabaseServer.ServerState checkRunning() {
        return this.checkRunning(5000L);
    }

    public DatabaseServer.ServerState checkRunning(long timeToWait) {
        try {
            this.reconnect(timeToWait);
        }
        catch (DatabaseException dbe) {
            LOGGER.log(Level.FINE, null, dbe);
        }
        catch (TimeoutException dbe) {
            LOGGER.log(Level.INFO, null, dbe);
        }
        return this.runstate;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.pcs.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
    }

    @Override
    public Image getIcon() {
        return this.icon;
    }

    @Override
    public synchronized boolean hasConfigurationError() {
        return this.runstate == DatabaseServer.ServerState.CONFIGERR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeOutput(String msg) {
        Class<MySQLDatabaseServer> clazz = MySQLDatabaseServer.class;
        synchronized (MySQLDatabaseServer.class) {
            MySQLDatabaseServer.getOutput().getOut().println(msg);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputOutput getOutput() {
        Class<MySQLDatabaseServer> clazz = MySQLDatabaseServer.class;
        synchronized (MySQLDatabaseServer.class) {
            if (OUTPUT == null) {
                OUTPUT = IOProvider.getDefault().getIO(Utils.getMessage("LBL_MySQLOutputTab", new Object[0]), false);
            }
            OUTPUT.select();
            // ** MonitorExit[var0] (shouldn't be in output)
            return OUTPUT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void closeOutput() {
        Class<MySQLDatabaseServer> clazz = MySQLDatabaseServer.class;
        synchronized (MySQLDatabaseServer.class) {
            if (OUTPUT != null) {
                OUTPUT.getOut().close();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    static {
        OPTIONS = MySQLOptions.getDefault();
    }

    private abstract class DatabaseCommand
    implements Runnable {
        private Throwable throwable;
        private final BlockingQueue<Runnable> outqueue;
        private boolean checkConnection = false;
        private String callingMethod = "<unknown>";

        public DatabaseCommand(BlockingQueue<Runnable> outqueue) {
            this(outqueue, false);
        }

        public DatabaseCommand(BlockingQueue<Runnable> outqueue, boolean checkConnection) {
            this.outqueue = outqueue;
            this.checkConnection = checkConnection;
        }

        public DatabaseCommand(boolean checkConnection) {
            this(null, checkConnection);
        }

        public DatabaseCommand() {
            this(null, false);
        }

        public void postCommand(String callingMethod) {
            this.callingMethod = callingMethod;
            if (MySQLDatabaseServer.this.connProcessor.isConnProcessorThread()) {
                this.run();
            } else {
                MySQLDatabaseServer.this.commandQueue.offer(this);
            }
        }

        public void syncUp() throws InterruptedException {
            if (MySQLDatabaseServer.this.connProcessor.isConnProcessorThread()) {
                return;
            }
            assert (this.outqueue != null);
            this.outqueue.take();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (this.checkConnection) {
                    try {
                        MySQLDatabaseServer.this.connProcessor.validateConnection();
                    }
                    catch (DatabaseException dbe) {
                        try {
                            MySQLDatabaseServer.this.reconnect();
                        }
                        catch (DatabaseException dbe2) {
                            LOGGER.log(Level.INFO, null, dbe2);
                            MySQLDatabaseServer.this.disconnect();
                            throw dbe;
                        }
                    }
                }
                this.execute();
            }
            catch (DatabaseException e) {
                if (this.outqueue != null) {
                    this.throwable = e;
                } else {
                    LOGGER.log(Level.INFO, NbBundle.getMessage(MySQLDatabaseServer.class, (String)"MSG_DatabaseCommandFailed", (Object)this.callingMethod), e);
                    Utils.displayErrorMessage(e.getMessage());
                }
            }
            catch (Exception e) {
                if (this.outqueue != null) {
                    this.throwable = e;
                } else {
                    this.throwable = e;
                    Utils.displayErrorMessage(NbBundle.getMessage(MySQLDatabaseServer.class, (String)"MSG_DatabaseCommandFailed", (Object)this.callingMethod, (Object)e.getMessage()));
                }
            }
            finally {
                if (this.outqueue != null) {
                    this.outqueue.offer(this);
                }
            }
        }

        public abstract void execute() throws Exception;

        public Throwable getException() {
            return this.throwable;
        }
    }

    private class StopDatabaseCommand
    extends DatabaseCommand
    implements Cancellable {
        private Process proc = null;

        private StopDatabaseCommand() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() throws Exception {
            ProgressHandle handle = ProgressHandleFactory.createHandle((String)Utils.getMessage("LBL_StoppingMySQLServer", new Object[0]), (Cancellable)this);
            try {
                handle.start();
                handle.switchToIndeterminate();
                this.proc = MySQLDatabaseServer.this.runProcess(MySQLDatabaseServer.this.getStopPath(), MySQLDatabaseServer.this.getStopArgs());
                this.proc.waitFor();
            }
            finally {
                if (this.proc != null) {
                    this.proc.destroy();
                    MySQLDatabaseServer.closeOutput();
                }
                handle.finish();
            }
        }

        public boolean cancel() {
            this.proc.destroy();
            MySQLDatabaseServer.closeOutput();
            return true;
        }
    }
}

