/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.updater;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.zip.CRC32;
import org.netbeans.updater.ModuleUpdater;
import org.netbeans.updater.UpdatingContext;
import org.netbeans.updater.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class UpdateTracking {
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String PATH_SEPARATOR = System.getProperty("path.separator");
    public static final String ELEMENT_MODULES = "installed_modules";
    public static final String ELEMENT_MODULE = "module";
    public static final String ATTR_CODENAMEBASE = "codename";
    public static final String ELEMENT_VERSION = "module_version";
    public static final String ATTR_VERSION = "specification_version";
    public static final String ATTR_LAST = "last";
    public static final String ATTR_INSTALL = "install_time";
    public static final String ELEMENT_FILE = "file";
    public static final String ATTR_FILE_NAME = "name";
    public static final String ATTR_ORIGIN = "origin";
    public static final String UPDATER_ORIGIN = "updater";
    public static final String INSTALLER_ORIGIN = "installer";
    private static final String ATTR_CRC = "crc";
    private static final String NBM_ORIGIN = "nbm";
    public static final String ELEMENT_ADDITIONAL = "module_additional";
    public static final String ELEMENT_ADDITIONAL_MODULE = "module";
    public static final String ATTR_ADDITIONAL_NBM_NAME = "nbm_name";
    public static final String ATTR_ADDITIONAL_SOURCE = "source-display-name";
    public static final String EXTRA_CLUSTER_NAME = "extra";
    private static final String LOCALE_DIR = FILE_SEPARATOR + "locale" + FILE_SEPARATOR;
    public static final String TRACKING_FILE_NAME = "update_tracking";
    public static final String ADDITIONAL_INFO_FILE_NAME = "additional_information.xml";
    private static final String XML_EXT = ".xml";
    private static final String FORBID_AUTOUPDATE = ".noautoupdate";
    private static final Map<File, UpdateTracking> trackings = new HashMap<File, UpdateTracking>();
    private static final Map<File, AdditionalInfo> infos = new HashMap<File, AdditionalInfo>();
    private LinkedHashMap<File, Module> installedModules = new LinkedHashMap();
    private final File directory;
    private final File trackingFile;
    private String origin = "nbm";
    private final UpdatingContext context;
    private static ErrorHandler DUMMY_ERROR_HANDLER = new ErrorHandler(){

        @Override
        public void warning(SAXParseException exception) throws SAXException {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
        }
    };

    private UpdateTracking(File nbPath, UpdatingContext context) {
        assert (nbPath != null) : "Path cannot be null";
        this.trackingFile = new File(nbPath + FILE_SEPARATOR + TRACKING_FILE_NAME);
        this.directory = nbPath;
        this.origin = UPDATER_ORIGIN;
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static UpdateTracking getTracking(File path, boolean createIfDoesNotExists, UpdatingContext context) {
        Map<File, UpdateTracking> map = trackings;
        synchronized (map) {
            UpdateTracking track = trackings.get(path);
            if (track == null) {
                File utFile = new File(path, TRACKING_FILE_NAME);
                if (!createIfDoesNotExists && !utFile.isDirectory()) {
                    return null;
                }
                File noAU = new File(path, FORBID_AUTOUPDATE);
                if (noAU.exists()) {
                    return null;
                }
                track = new UpdateTracking(path, context);
                trackings.put(path, track);
                track.read();
                track.scanDir();
            }
            return track;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static AdditionalInfo getAdditionalInformation(File path, UpdatingContext context) {
        Map<File, AdditionalInfo> map = infos;
        synchronized (map) {
            AdditionalInfo additionalInfo = infos.get(path);
            if (additionalInfo == null) {
                File addInfo;
                UpdateTracking.getTracking(path, false, context);
                File downloadDir = new File(path, ModuleUpdater.DOWNLOAD_DIR);
                if (downloadDir.exists() && downloadDir.isDirectory() && (addInfo = new File(downloadDir, ADDITIONAL_INFO_FILE_NAME)).exists()) {
                    additionalInfo = new AdditionalInfo(addInfo);
                }
            }
            return additionalInfo;
        }
    }

    public static File getPlatformDir() {
        String platform = System.getProperty("netbeans.home");
        return platform == null ? null : new File(platform);
    }

    public static File getUserDir() {
        String user = System.getProperty("netbeans.user");
        File userDir = null;
        if (user != null) {
            userDir = new File(user);
            if (userDir.getPath().startsWith("\\\\")) {
                try {
                    userDir = userDir.getCanonicalFile();
                }
                catch (IOException ex) {
                    userDir = userDir.getAbsoluteFile();
                }
            } else {
                userDir = new File(userDir.toURI().normalize()).getAbsoluteFile();
            }
        }
        return userDir;
    }

    public static List<File> clusters(boolean includeUserDir) {
        File noAU;
        File id;
        String dirs;
        File noAU2;
        File ud;
        ArrayList<File> files = new ArrayList<File>();
        if (includeUserDir && (ud = UpdateTracking.getUserDir()) != null && !(noAU2 = new File(ud, FORBID_AUTOUPDATE)).exists()) {
            files.add(ud);
        }
        if ((dirs = System.getProperty("netbeans.dirs")) != null) {
            StringTokenizer en = new StringTokenizer(dirs, File.pathSeparator);
            while (en.hasMoreElements()) {
                File f = new File((String)en.nextElement());
                File noAU3 = new File(f, FORBID_AUTOUPDATE);
                if (noAU3.exists()) continue;
                files.add(f);
            }
        }
        if ((id = UpdateTracking.getPlatformDir()) != null && !(noAU = new File(id, FORBID_AUTOUPDATE)).exists()) {
            files.add(id);
        }
        return Collections.unmodifiableList(files);
    }

    public boolean isModuleInstalled(String codeBase) {
        for (Module m : this.installedModules.values()) {
            String mm = m.codenamebase;
            int indx = mm.indexOf(47);
            if (indx >= 0) {
                mm = mm.substring(0, indx);
            }
            if (!codeBase.equals(mm)) continue;
            return true;
        }
        return false;
    }

    private void read() {
        Document document;
        int avail = 0;
        try {
            File file = this.trackingFile;
            if (!file.isFile()) {
                return;
            }
            FileInputStream is = new FileInputStream(file);
            avail = ((InputStream)is).available();
            InputSource xmlInputSource = new InputSource(is);
            document = XMLUtil.parse(xmlInputSource, false, false, DUMMY_ERROR_HANDLER, XMLUtil.createAUResolver());
            if (is != null) {
                ((InputStream)is).close();
            }
        }
        catch (SAXException e) {
            XMLUtil.LOG.log(Level.SEVERE, "Bad update_tracking: " + this.trackingFile + ", available bytes: " + avail, e);
            return;
        }
        catch (IOException e) {
            XMLUtil.LOG.log(Level.SEVERE, "Missing update_tracking: " + this.trackingFile + ", available bytes: " + avail, e);
            return;
        }
        Element element = document.getDocumentElement();
        if (element != null && element.getTagName().equals(ELEMENT_MODULES)) {
            this.scanElement_installed_modules(element);
        }
    }

    void scanElement_installed_modules(Element element) {
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element nodeElement;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !(nodeElement = (Element)node).getTagName().equals("module")) continue;
            throw new IllegalStateException("What now!?");
        }
    }

    Module scanElement_module(Element element) {
        Module module = new Module();
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (!attr.getName().startsWith(ATTR_CODENAMEBASE)) continue;
            module.setCodenamebase(attr.getValue());
        }
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element nodeElement;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !(nodeElement = (Element)node).getTagName().equals(ELEMENT_VERSION)) continue;
            this.scanElement_module_version(nodeElement, module);
        }
        return module;
    }

    private void scanElement_module_version(Element element, Module module) {
        Version version = new Version(module);
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getName().equals(ATTR_VERSION)) {
                version.setVersion(attr.getValue());
            }
            if (attr.getName().equals(ATTR_ORIGIN)) {
                version.setOrigin(attr.getValue());
            }
            if (attr.getName().equals(ATTR_LAST)) {
                version.setLast(Boolean.valueOf(attr.getValue()));
            }
            if (!attr.getName().equals(ATTR_INSTALL)) continue;
            long li = 0L;
            try {
                li = Long.parseLong(attr.getValue());
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            version.setInstall_time(li);
        }
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element nodeElement;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !(nodeElement = (Element)node).getTagName().equals(ELEMENT_FILE)) continue;
            this.scanElement_file(nodeElement, version);
        }
        module.addOldVersion(version);
    }

    void scanElement_file(Element element, Version version) {
        ModuleFile file = new ModuleFile();
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getName().equals(ATTR_FILE_NAME)) {
                file.setName(attr.getValue());
            }
            if (attr.getName().equals(ATTR_CRC)) {
                file.setCrc(attr.getValue());
            }
            if (!attr.getName().equals(ATTR_VERSION)) continue;
            file.setLocaleversion(attr.getValue());
        }
        version.addFile(file);
    }

    Module readModuleTracking(String codename, boolean create) {
        new File(this.directory, TRACKING_FILE_NAME).mkdirs();
        File file = new File(new File(this.directory, TRACKING_FILE_NAME), UpdateTracking.getTrackingName(codename) + XML_EXT);
        try {
            if (file.exists() && file.length() == 0L) {
                file.delete();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!file.exists()) {
            if (create) {
                return new Module(codename, file);
            }
            return null;
        }
        return this.readModuleFromFile(file, codename, create);
    }

    Version createVersion(String specversion) {
        Version ver = new Version(null);
        ver.setVersion(specversion);
        return ver;
    }

    private Module readModuleFromFile(File file, String codename, boolean create) {
        Document document;
        try {
            FileInputStream is = new FileInputStream(file);
            InputSource xmlInputSource = new InputSource(is);
            document = XMLUtil.parse(xmlInputSource, false, false, DUMMY_ERROR_HANDLER, XMLUtil.createAUResolver());
            if (is != null) {
                ((InputStream)is).close();
            }
        }
        catch (SAXException e) {
            XMLUtil.LOG.log(Level.SEVERE, "Bad update_tracking", e);
            return null;
        }
        catch (IOException e) {
            if (create) {
                return new Module(codename, file);
            }
            return null;
        }
        Element element = document.getDocumentElement();
        if (element != null && element.getTagName().equals("module")) {
            Module m = this.scanElement_module(element);
            m.setFile(file);
            this.installedModules.put(file, m);
            return m;
        }
        if (create) {
            return new Module(codename, file);
        }
        return null;
    }

    private static String getTrackingName(String codename) {
        String trackingName = codename;
        int pos = trackingName.indexOf(47);
        if (pos > -1) {
            trackingName = trackingName.substring(0, pos);
        }
        return trackingName.replace('.', '-');
    }

    void deleteUnusedFiles() {
        ArrayList<Module> newModules = new ArrayList<Module>(this.installedModules.values());
        for (Module mod : newModules) {
            mod.deleteUnusedFiles();
        }
        this.scanDir();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getFileCRC(File file) throws IOException {
        BufferedInputStream bsrc = null;
        CRC32 crc = new CRC32();
        try {
            int i;
            bsrc = new BufferedInputStream(new FileInputStream(file));
            byte[] bytes = new byte[1024];
            while ((i = bsrc.read(bytes)) != -1) {
                crc.update(bytes, 0, i);
            }
        }
        finally {
            if (bsrc != null) {
                bsrc.close();
            }
        }
        return crc.getValue();
    }

    private void scanDir() {
        File dir = new File(this.directory, TRACKING_FILE_NAME);
        File[] files = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.isDirectory() && file.getName().toUpperCase().endsWith(".XML");
            }
        });
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            if (this.installedModules.containsKey(files[i])) continue;
            this.readModuleFromFile(files[i], null, true);
        }
    }

    public String toString() {
        return "UpdateTracing[" + this.directory + ", origin: " + this.origin + "]";
    }

    public static class AdditionalInfo {
        private Map<String, String> sources;

        private AdditionalInfo(File additionalInfoFile) {
            this.sources = this.readAdditionalInfoFile(additionalInfoFile);
        }

        public String getSource(String nbmFileName) {
            return this.sources != null ? this.sources.get(nbmFileName) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<String, String> readAdditionalInfoFile(File f) {
            Document document;
            if (f == null || !f.exists()) {
                throw new IllegalArgumentException("AdditionalInfo file " + f + " must exists.");
            }
            Map<String, String> res = null;
            FileInputStream is = null;
            try {
                is = new FileInputStream(f);
                document = XMLUtil.parse(new InputSource(is), false, false, null, null);
            }
            catch (SAXException e) {
                XMLUtil.LOG.log(Level.WARNING, "Bad additional_information.xml" + f, e);
                Map<String, String> map = res;
                return map;
            }
            catch (IOException e) {
                XMLUtil.LOG.log(Level.WARNING, "Missing additional_information.xml" + f, e);
                Map<String, String> map = res;
                return map;
            }
            finally {
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException ioe) {
                        XMLUtil.LOG.log(Level.INFO, "Cannot close stream for file " + f, ioe);
                        return res;
                    }
                }
            }
            Element element = document.getDocumentElement();
            if (element != null && element.getTagName().equals(UpdateTracking.ELEMENT_ADDITIONAL)) {
                res = this.scanModuleAdditional(element);
            }
            return res;
        }

        private Map<String, String> scanModuleAdditional(Element element) {
            HashMap<String, String> res = new HashMap<String, String>();
            NodeList nodes = element.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element nodeElement;
                Node node = nodes.item(i);
                if (node.getNodeType() != 1 || !(nodeElement = (Element)node).getTagName().equals("module")) continue;
                String fileSpec = nodeElement.getAttribute(UpdateTracking.ATTR_ADDITIONAL_NBM_NAME);
                String source = nodeElement.getAttribute(UpdateTracking.ATTR_ADDITIONAL_SOURCE);
                res.put(fileSpec, source);
            }
            return res;
        }
    }

    class Module {
        private String codenamebase;
        private List<Version> versions = new ArrayList<Version>();
        private File file = null;
        private Version lastVersion = null;
        private Version newVersion = null;
        private boolean osgi = false;

        public Module() {
        }

        public Module(String codenamebase, File file) {
            this.codenamebase = codenamebase;
            this.file = file;
        }

        String getCodenamebase() {
            return this.codenamebase;
        }

        void setCodenamebase(String codenamebase) {
            this.codenamebase = codenamebase;
        }

        void setOSGi(boolean isOSGi) {
            this.osgi = isOSGi;
        }

        boolean isOSGi() {
            return this.osgi;
        }

        List<Version> getVersions() {
            return this.versions;
        }

        void setVersions(List<Version> versions) {
            this.versions = versions;
        }

        private Version getNewOrLastVersion() {
            if (this.newVersion != null) {
                return this.newVersion;
            }
            return this.lastVersion;
        }

        boolean hasNewVersion() {
            return this.newVersion != null;
        }

        void setFile(File file) {
            this.file = file;
        }

        public Version addNewVersion(String spec_version, String origin) {
            Version version;
            if (this.lastVersion != null) {
                this.lastVersion.setLast(false);
            }
            this.newVersion = version = new Version(this);
            version.setVersion(spec_version);
            version.setOrigin(origin);
            version.setLast(true);
            version.setInstall_time(System.currentTimeMillis());
            this.versions.add(version);
            return version;
        }

        void addOldVersion(Version version) {
            if (version.isLast()) {
                this.lastVersion = version;
            }
            this.versions.add(version);
        }

        void addL10NVersion(Version l_version) {
            if (this.lastVersion != null) {
                this.lastVersion.addL10NFiles(l_version.getFiles());
            } else {
                l_version.setOrigin(UpdateTracking.this.origin);
                l_version.setLast(true);
                l_version.setInstall_time(System.currentTimeMillis());
                this.versions.add(l_version);
            }
        }

        void writeConfigModuleXMLIfMissing() {
            String replaced;
            File configDir = new File(new File(UpdateTracking.this.directory, "config"), "Modules");
            String candidate = null;
            String oldCandidate = null;
            String newCandidate = null;
            String name = this.codenamebase;
            int indx = name.indexOf(47);
            if (indx > 0) {
                name = name.substring(0, indx);
            }
            String searchFor = (replaced = name.replace('.', '-')).indexOf("Modules") > 0 ? replaced + ".jar" : (this.osgi ? replaced + ".jar" : replaced.substring(replaced.lastIndexOf(45) > 0 ? replaced.lastIndexOf(45) + 1 : 0) + ".jar");
            String dash = name.replace('.', '-');
            boolean needInfoInUserDir = false;
            boolean afterNBMsCluster = false;
            for (File c : UpdateTracking.clusters(true)) {
                File customConfigs;
                File hidden = new File(new File(new File(c, "config"), "Modules"), dash + ".xml_hidden");
                if (hidden.exists()) {
                    hidden.delete();
                    XMLUtil.LOG.info("File " + hidden + " deleted.");
                }
                if (UpdateTracking.this.directory.equals(c)) {
                    afterNBMsCluster = true;
                    continue;
                }
                if (afterNBMsCluster || !(customConfigs = new File(new File(new File(c, "config"), "Modules"), dash + UpdateTracking.XML_EXT)).exists()) continue;
                needInfoInUserDir = this.lastVersion == null;
            }
            if (needInfoInUserDir) {
                File userConfig = new File(new File(new File(UpdateTracking.getUserDir(), "config"), "Modules"), dash + UpdateTracking.XML_EXT);
                this.writeModulesConfig(userConfig, searchFor, candidate, newCandidate, oldCandidate, name);
                return;
            }
            File config = new File(configDir, dash + UpdateTracking.XML_EXT);
            if (config.isFile()) {
                return;
            }
            this.writeModulesConfig(config, searchFor, candidate, newCandidate, oldCandidate, name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void write() {
            Document document = XMLUtil.createDocument("module");
            Element e_module = document.getDocumentElement();
            e_module.setAttribute(UpdateTracking.ATTR_CODENAMEBASE, this.getCodenamebase());
            for (Version ver : this.getVersions()) {
                Element e_version = document.createElement(UpdateTracking.ELEMENT_VERSION);
                if (ver.getVersion() != null) {
                    e_version.setAttribute(UpdateTracking.ATTR_VERSION, ver.getVersion());
                }
                e_version.setAttribute(UpdateTracking.ATTR_ORIGIN, ver.getOrigin());
                e_version.setAttribute(UpdateTracking.ATTR_LAST, Boolean.valueOf(ver.isLast()).toString());
                e_version.setAttribute(UpdateTracking.ATTR_INSTALL, Long.toString(ver.getInstall_time()));
                e_module.appendChild(e_version);
                for (ModuleFile moduleFile : ver.getFiles()) {
                    Element e_file = document.createElement(UpdateTracking.ELEMENT_FILE);
                    e_file.setAttribute(UpdateTracking.ATTR_FILE_NAME, moduleFile.getName());
                    e_file.setAttribute(UpdateTracking.ATTR_CRC, moduleFile.getCrc());
                    if (moduleFile.getLocaleversion() != null) {
                        e_file.setAttribute(UpdateTracking.ATTR_VERSION, moduleFile.getLocaleversion());
                    }
                    e_version.appendChild(e_file);
                }
            }
            document.getDocumentElement().normalize();
            OutputStream os = null;
            try {
                os = UpdateTracking.this.context.createOS(this.file);
            }
            catch (Exception e) {
                XMLUtil.LOG.log(Level.WARNING, "Cannot read " + this.file, e);
                if (!this.file.delete()) {
                    XMLUtil.LOG.log(Level.SEVERE, null, new IOException("Corresponding update would not be installed since it is not possible to modify or delete update tracking file " + this.file));
                }
                XMLUtil.LOG.log(Level.SEVERE, null, new IOException("Update tracking file was deleted since permissions does not allow to modify it: " + this.file));
                try {
                    os = UpdateTracking.this.context.createOS(this.file);
                }
                catch (Exception ex) {
                    XMLUtil.LOG.log(Level.WARNING, "Cannot read", ex);
                }
            }
            if (os != null) {
                try {
                    XMLUtil.write(document, os);
                    XMLUtil.LOG.info("File " + this.file + " modified.");
                }
                catch (IOException e) {
                    XMLUtil.LOG.log(Level.WARNING, "Cannot write " + this.file, e);
                }
                finally {
                    try {
                        os.close();
                    }
                    catch (IOException e) {
                        XMLUtil.LOG.log(Level.WARNING, "Cannot close " + this.file, e);
                    }
                }
            }
        }

        void deleteUnusedFiles() {
            if (this.lastVersion == null || this.newVersion == null) {
                return;
            }
            for (ModuleFile modFile : this.lastVersion.getFiles()) {
                if (this.newVersion.containsFile(modFile) || modFile.getName().indexOf(LOCALE_DIR) != -1) continue;
                this.safeDelete(modFile);
            }
        }

        private void safeDelete(ModuleFile modFile) {
            File f = new File(this.file.getParentFile().getParent() + FILE_SEPARATOR + modFile.getName());
            if (f.exists()) {
                try {
                    if (!Long.toString(UpdateTracking.getFileCRC(f)).equals(modFile.getCrc())) {
                        return;
                    }
                }
                catch (IOException ioe) {
                    return;
                }
                UpdateTracking.this.scanDir();
                boolean found = false;
                Iterator it = UpdateTracking.this.installedModules.values().iterator();
                while (!found && it.hasNext()) {
                    Version v;
                    Module mod = (Module)it.next();
                    if (mod.equals(this) || (v = mod.getNewOrLastVersion()) == null || !v.containsFile(modFile)) continue;
                    found = true;
                }
                if (!found) {
                    XMLUtil.LOG.info("Deleting file: " + f);
                    boolean deleted = f.delete();
                    XMLUtil.LOG.info(".... " + f + " was deleted? " + deleted);
                }
            }
        }

        String getL10NSpecificationVersion(String jarpath) {
            Collections.sort(this.versions);
            for (Version ver : this.versions) {
                String localever = ver.getLocaleVersion(jarpath);
                if (localever == null) continue;
                return localever;
            }
            return null;
        }

        private void writeModulesConfig(File config, String searchFor, String candidate, String newCandidate, String oldCandidate, String name) {
            config.getParentFile().mkdirs();
            Boolean isAutoload = null;
            Boolean isEager = null;
            Iterator<ModuleFile> it = this.newVersion.getFiles().iterator();
            boolean needToWrite = false;
            while (it.hasNext()) {
                ModuleFile f = it.next();
                String n = f.getName();
                File p = new File(f.getName()).getParentFile();
                String parentDir = p != null ? p.getName() : "";
                boolean bl = needToWrite = needToWrite || n.indexOf("Modules") >= 0 || this.osgi;
                if (n.endsWith(".jar") && !parentDir.equals("ext")) {
                    candidate = f.getName();
                    if (searchFor.endsWith(candidate) || candidate.endsWith(searchFor)) {
                        newCandidate = candidate;
                        oldCandidate = null;
                        isAutoload = "autoload".equals(parentDir) ? Boolean.TRUE : Boolean.FALSE;
                        isEager = "eager".equals(parentDir) ? Boolean.TRUE : Boolean.FALSE;
                    } else if (newCandidate == null) {
                        oldCandidate = (oldCandidate == null ? "" : oldCandidate + ", ") + candidate;
                    }
                }
                if (isAutoload == null && "autoload".equals(parentDir)) {
                    isAutoload = Boolean.TRUE;
                }
                if (isEager != null || !"eager".equals(parentDir)) continue;
                isEager = Boolean.TRUE;
            }
            if (!needToWrite) {
                XMLUtil.LOG.log(Level.WARNING, "No config file written for module {0}. No jar file present in \"modules\" directory.", this.codenamebase);
                return;
            }
            assert (newCandidate != null || oldCandidate != null) : "No jar file present!";
            if (newCandidate == null) {
                assert (oldCandidate.equals(candidate)) : "More files look as module: " + oldCandidate;
                if (!oldCandidate.equals(candidate)) {
                    XMLUtil.LOG.log(Level.WARNING, "More files look as module: {0}", oldCandidate);
                    oldCandidate = candidate;
                }
            }
            String moduleName = newCandidate == null ? oldCandidate : newCandidate;
            boolean autoload = isAutoload != null && isAutoload != false;
            boolean eager = isEager != null && isEager != false;
            boolean isEnabled = !autoload && !eager;
            String spec = this.newVersion.getVersion();
            try {
                OutputStream os = UpdateTracking.this.context.createOS(config);
                PrintWriter pw = new PrintWriter(new OutputStreamWriter(os, "UTF-8"));
                pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                pw.println("<!DOCTYPE module PUBLIC \"-//NetBeans//DTD Module Status 1.0//EN\"");
                pw.println("                        \"http://www.netbeans.org/dtds/module-status-1_0.dtd\">");
                pw.println("<module name=\"" + name + "\">");
                pw.println("    <param name=\"autoload\">" + autoload + "</param>");
                pw.println("    <param name=\"eager\">" + eager + "</param>");
                if (isEnabled) {
                    pw.println("    <param name=\"enabled\">" + isEnabled + "</param>");
                }
                pw.println("    <param name=\"jar\">" + moduleName + "</param>");
                pw.println("    <param name=\"reloadable\">false</param>");
                pw.println("    <param name=\"specversion\">" + spec + "</param>");
                pw.println("</module>");
                pw.flush();
                pw.close();
                XMLUtil.LOG.info("New config was written in " + config);
            }
            catch (IOException ex) {
                XMLUtil.LOG.log(Level.INFO, null, ex);
            }
        }

        public String toString() {
            return "UpdateTracing.Module[" + this.codenamebase + "(" + this.file + "), OSGI? " + this.osgi + "]";
        }
    }

    class ModuleFile {
        private String name;
        private String crc;
        private String localeversion = null;

        ModuleFile() {
        }

        String getName() {
            return this.name;
        }

        void setName(String name) {
            this.name = name;
        }

        String getCrc() {
            return this.crc;
        }

        void setCrc(String crc) {
            this.crc = crc;
        }

        public String getLocaleversion() {
            return this.localeversion;
        }

        public void setLocaleversion(String localeversion) {
            this.localeversion = localeversion;
        }

        public String toString() {
            return "UpdateTracing.ModuleFile[" + this.name + "(" + this.crc + ")" + "]";
        }
    }

    public class Version
    implements Comparable<Version> {
        private final Module module;
        private String version;
        private String origin;
        private boolean last;
        private long install_time = 0L;
        private List<ModuleFile> files = new ArrayList<ModuleFile>();

        Version(Module m) {
            this.module = m;
        }

        String getVersion() {
            return this.version;
        }

        void setVersion(String version) {
            this.version = version;
        }

        String getOrigin() {
            return this.origin;
        }

        void setOrigin(String origin) {
            this.origin = origin;
        }

        boolean isLast() {
            return this.last;
        }

        void setLast(boolean last) {
            this.last = last;
        }

        long getInstall_time() {
            return this.install_time;
        }

        void setInstall_time(long install_time) {
            this.install_time = install_time;
        }

        List<ModuleFile> getFiles() {
            return this.files;
        }

        void addL10NFiles(List<ModuleFile> l10nfiles) {
            for (ModuleFile lf : l10nfiles) {
                String lname = lf.getName();
                for (int i = this.files.size() - 1; i >= 0; --i) {
                    ModuleFile f = this.files.get(i);
                    if (!f.getName().equals(lname)) continue;
                    this.files.remove(i);
                }
            }
            this.files.addAll(l10nfiles);
        }

        void addFile(ModuleFile file) {
            this.files.add(file);
        }

        public void addFileWithCrc(String filename, String crc) {
            ModuleFile file = new ModuleFile();
            file.setName(filename);
            file.setCrc(crc);
            this.files.add(file);
        }

        public void addL10NFileWithCrc(String filename, String crc, String specver) {
            ModuleFile file = new ModuleFile();
            file.setName(filename);
            file.setCrc(crc);
            file.setLocaleversion(specver);
            this.files.add(file);
        }

        boolean containsFile(ModuleFile file) {
            for (ModuleFile f : this.files) {
                if (!f.getName().equals(file.getName())) continue;
                return true;
            }
            return false;
        }

        ModuleFile findFile(String filename) {
            for (ModuleFile f : this.files) {
                if (!f.getName().equals(filename)) continue;
                return f;
            }
            return null;
        }

        String getLocaleVersion(String filename) {
            String locver = null;
            ModuleFile f = this.findFile(filename);
            if (f != null && (locver = f.getLocaleversion()) == null) {
                locver = this.version;
            }
            return locver;
        }

        @Override
        public int compareTo(Version oth) {
            if (this.install_time < oth.getInstall_time()) {
                return 1;
            }
            if (this.install_time > oth.getInstall_time()) {
                return -1;
            }
            return 0;
        }

        public String toString() {
            return "UpdateTracing.Version[" + this.module + "/" + this.version + ", last? " + this.isLast() + "]";
        }
    }
}

