/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.freemarker;

import freemarker.cache.TemplateLoader;
import freemarker.core.Environment;
import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Bindings;
import javax.script.ScriptContext;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.libs.freemarker.FreemarkerEngine;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

final class RsrcLoader
extends Configuration
implements TemplateLoader,
TemplateExceptionHandler {
    private static final Logger LOG = Logger.getLogger(FreemarkerEngine.class.getName());
    private FileObject fo;
    private ScriptContext map;
    private Bindings engineScope;

    RsrcLoader(FileObject fo, ScriptContext map) {
        this.fo = fo;
        this.map = map;
        this.engineScope = map.getBindings(100);
        this.setTemplateLoader(this);
        this.setTemplateExceptionHandler(this);
        Logger.getLogger("freemarker.runtime").setLevel(Level.OFF);
    }

    @Override
    public void handleTemplateException(TemplateException ex, Environment env, Writer w) throws TemplateException {
        try {
            w.append(ex.getLocalizedMessage());
            LOG.log(Level.INFO, "Failure processing " + this.fo, ex);
            LOG.log(Level.INFO, "Bindings:");
            for (Map.Entry entry : this.engineScope.entrySet()) {
                LOG.log(Level.INFO, "  key: " + (String)entry.getKey() + " value: " + entry.getValue());
            }
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    private FileObject getFile(String name) {
        FileObject tmp;
        FileObject fileObject = tmp = this.getFolder() == null ? null : this.getFolder().getFileObject(name);
        if (tmp == null) {
            try {
                tmp = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)Utilities.toFile((URI)new URI(name))));
            }
            catch (URISyntaxException ex) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return tmp;
    }

    private FileObject getFolder() {
        try {
            return this.fo.getFileSystem().getRoot();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            return FileUtil.getConfigRoot();
        }
    }

    @Override
    public Object findTemplateSource(String string) throws IOException {
        FileObject tmp = this.getFile(string);
        return tmp == null ? null : new Wrap(tmp);
    }

    @Override
    public long getLastModified(Object object) {
        return ((Wrap)object).fo.lastModified().getTime();
    }

    @Override
    public Reader getReader(Object object, String encoding) throws IOException {
        Wrap w = (Wrap)object;
        if (w.reader == null) {
            Charset chset = FileEncodingQuery.getEncoding((FileObject)w.fo);
            w.reader = new InputStreamReader(w.fo.getInputStream(), chset);
        }
        return w.reader;
    }

    @Override
    public void closeTemplateSource(Object object) throws IOException {
        Wrap w = (Wrap)object;
        if (w.reader != null) {
            w.reader.close();
        }
    }

    public Object put(String string, Object object) {
        assert (false);
        return null;
    }

    @Override
    public TemplateModel getSharedVariable(String string) {
        Object value = this.map.getAttribute(string);
        if (value == null) {
            value = this.engineScope.get(string);
        }
        if (value == null && this.fo != null) {
            value = this.fo.getAttribute(string);
        }
        try {
            return this.getObjectWrapper().wrap(value);
        }
        catch (TemplateModelException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    @Override
    public Set getSharedVariableNames() {
        LinkedHashSet<Object> keys = new LinkedHashSet<Object>();
        if (this.map != null) {
            keys.addAll(this.map.getBindings(100).keySet());
        }
        if (this.fo != null) {
            Enumeration en = this.fo.getAttributes();
            while (en.hasMoreElements()) {
                keys.add(en.nextElement());
            }
        }
        return keys;
    }

    private static final class Wrap {
        public FileObject fo;
        public Reader reader;

        public Wrap(FileObject fo) {
            this.fo = fo;
        }
    }
}

