/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.prep.ui.wizard;

import java.awt.Component;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.css.prep.CssPreprocessorType;
import org.netbeans.modules.css.prep.options.CssPrepOptions;
import org.netbeans.modules.css.prep.preferences.CssPreprocessorPreferences;
import org.netbeans.modules.css.prep.ui.customizer.OptionsPanel;
import org.netbeans.modules.css.prep.util.CssPreprocessorUtils;
import org.netbeans.modules.css.prep.util.ValidationResult;
import org.netbeans.modules.web.common.spi.ProjectWebRootQuery;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.Pair;

public class NewFileWizardIterator
implements WizardDescriptor.InstantiatingIterator<WizardDescriptor> {
    private final CssPreprocessorType type;
    WizardDescriptor wizard;
    private WizardDescriptor.Panel<WizardDescriptor> wizardPanel;
    private volatile BottomPanel bottomPanel;

    public NewFileWizardIterator(CssPreprocessorType type) {
        assert (type != null);
        this.type = type;
    }

    public static WizardDescriptor.InstantiatingIterator<WizardDescriptor> createLessWizardIterator() {
        return new NewFileWizardIterator(CssPreprocessorType.LESS);
    }

    public static WizardDescriptor.InstantiatingIterator<WizardDescriptor> createSassWizardIterator() {
        return new NewFileWizardIterator(CssPreprocessorType.SASS);
    }

    public void initialize(WizardDescriptor wizard) {
        this.wizard = wizard;
        this.wizardPanel = this.createWizardPanel();
    }

    public Set<FileObject> instantiate() throws IOException {
        this.getBottomPanel().save();
        FileObject dir = Templates.getTargetFolder((WizardDescriptor)this.wizard);
        FileObject template = Templates.getTemplate((WizardDescriptor)this.wizard);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)dir);
        DataObject dataTemplate = DataObject.find((FileObject)template);
        DataObject createdFile = dataTemplate.createFromTemplate(dataFolder, Templates.getTargetName((WizardDescriptor)this.wizard));
        return Collections.singleton(createdFile.getPrimaryFile());
    }

    public void uninitialize(WizardDescriptor wizard) {
        this.wizard = null;
        this.wizardPanel = null;
        this.bottomPanel = null;
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.wizardPanel;
    }

    public String name() {
        return "";
    }

    public boolean hasNext() {
        return false;
    }

    public boolean hasPrevious() {
        return false;
    }

    public void nextPanel() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void previousPanel() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void addChangeListener(ChangeListener listener) {
        this.getBottomPanel().addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.getBottomPanel().removeChangeListener(listener);
    }

    private WizardDescriptor.Panel<WizardDescriptor> createWizardPanel() {
        Project project = this.getProject();
        assert (project != null);
        this.ensureProperTargetFolder(project);
        return Templates.buildSimpleTargetChooser((Project)project, (SourceGroup[])this.getSourceGroups(project)).bottomPanel((WizardDescriptor.Panel)this.getBottomPanel()).create();
    }

    private Project getProject() {
        return Templates.getProject((WizardDescriptor)this.wizard);
    }

    private void ensureProperTargetFolder(Project project) {
        File inputFolder;
        if (!project.getProjectDirectory().equals(Templates.getTargetFolder((WizardDescriptor)this.wizard))) {
            return;
        }
        FileObject webRoot = this.findWebRoot(project);
        if (webRoot == null) {
            return;
        }
        List<Pair<String, String>> mappings = this.type.getPreferences().getMappings(project);
        if (!mappings.isEmpty() && (inputFolder = CssPreprocessorUtils.resolveInput(webRoot, mappings.get(0))).isDirectory()) {
            FileObject fo = FileUtil.toFileObject((File)inputFolder);
            assert (fo != null) : "FileObject not found for existing directory: " + inputFolder;
            Templates.setTargetFolder((WizardDescriptor)this.wizard, (FileObject)fo);
            return;
        }
        Templates.setTargetFolder((WizardDescriptor)this.wizard, (FileObject)webRoot);
    }

    @CheckForNull
    private FileObject findWebRoot(Project project) {
        Collection webRoots = ProjectWebRootQuery.getWebRoots((Project)project);
        if (webRoots.isEmpty()) {
            return null;
        }
        return (FileObject)webRoots.iterator().next();
    }

    private SourceGroup[] getSourceGroups(Project project) {
        Sources sources = ProjectUtils.getSources((Project)project);
        return sources.getSourceGroups("generic");
    }

    private BottomPanel getBottomPanel() {
        if (this.bottomPanel != null) {
            return this.bottomPanel;
        }
        this.bottomPanel = !this.type.getPreferences().isConfigured(this.getProject()) ? new BottomPanelImpl(this.getProject(), this.type) : BottomPanel.EMPTY;
        return this.bottomPanel;
    }

    private static interface BottomPanel
    extends WizardDescriptor.Panel<WizardDescriptor> {
        public static final BottomPanel EMPTY = new EmptyBottomPanel();

        public void save() throws IOException;
    }

    private static class BottomPanelImpl
    implements BottomPanel,
    PropertyChangeListener {
        private static final String ENABLED = "ENABLED";
        private static final String MAPPINGS = "MAPPINGS";
        private static final String COMPILER_OPTIONS = "COMPILER_OPTIONS";
        private final Project project;
        private final CssPreprocessorType type;
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private volatile OptionsPanel panel;
        private volatile WizardDescriptor settings = null;

        public BottomPanelImpl(Project project, CssPreprocessorType type) {
            assert (project != null);
            assert (type != null);
            this.project = project;
            this.type = type;
        }

        public HelpCtx getHelp() {
            return new HelpCtx("org.netbeans.modules.css.prep.ui.wizard.NewFileWizardIterator." + this.type.name());
        }

        public OptionsPanel getComponent() {
            if (this.panel == null) {
                assert (EventQueue.isDispatchThread());
                CssPreprocessorPreferences preferences = this.type.getPreferences();
                this.panel = new OptionsPanel(this.type, preferences.isEnabled(this.project), preferences.getMappings(this.project), preferences.getCompilerOptions(this.project));
                this.panel.showConfigureExecutableButton();
            }
            return this.panel;
        }

        public void readSettings(WizardDescriptor settings) {
            this.settings = settings;
            settings.putProperty(ENABLED, (Object)this.getComponent().isCompilationEnabled());
            settings.putProperty(MAPPINGS, this.getComponent().getMappings());
            settings.putProperty(COMPILER_OPTIONS, (Object)this.getComponent().getCompilerOptions());
        }

        public void storeSettings(WizardDescriptor settings) {
            settings.putProperty(ENABLED, (Object)this.getComponent().isCompilationEnabled());
            settings.putProperty(MAPPINGS, this.getComponent().getMappings());
            settings.putProperty(COMPILER_OPTIONS, (Object)this.getComponent().getCompilerOptions());
        }

        public boolean isValid() {
            if (this.settings == null) {
                return false;
            }
            ValidationResult result = this.getValidationResult();
            String error = result.getFirstErrorMessage();
            if (error == null) {
                error = result.getFirstWarningMessage();
            }
            if (error != null) {
                this.settings.putProperty("WizardPanel_errorMessage", (Object)error);
                return false;
            }
            this.settings.putProperty("WizardPanel_errorMessage", (Object)" ");
            return true;
        }

        public void addChangeListener(ChangeListener listener) {
            this.getComponent().addChangeListener(listener);
            this.changeSupport.addChangeListener(listener);
            CssPrepOptions.getInstance().addPropertyChangeListener(this);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.getComponent().removeChangeListener(listener);
            this.changeSupport.removeChangeListener(listener);
            CssPrepOptions.getInstance().removePropertyChangeListener(this);
        }

        @Override
        public void save() throws IOException {
            CssPreprocessorPreferences preferences = this.type.getPreferences();
            boolean enabled = (Boolean)this.settings.getProperty(ENABLED);
            if (enabled) {
                preferences.setConfigured(this.project, true);
            }
            preferences.setEnabled(this.project, enabled);
            preferences.setMappings(this.project, (List)this.settings.getProperty(MAPPINGS));
            preferences.setCompilerOptions(this.project, (String)this.settings.getProperty(COMPILER_OPTIONS));
        }

        private ValidationResult getValidationResult() {
            boolean compilationEnabled = this.getComponent().isCompilationEnabled();
            return this.type.getPreferencesValidator().validateMappings(CssPreprocessorUtils.getWebRoot(this.project), compilationEnabled, this.getComponent().getMappings()).validateExecutable(compilationEnabled).getResult();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if ("LESS_PATH_PROPERTY".equals(propertyName) || "SASS_PATH_PROPERTY".equals(propertyName)) {
                this.changeSupport.fireChange();
            }
        }
    }

    private static final class EmptyBottomPanel
    implements BottomPanel {
        private EmptyBottomPanel() {
        }

        public Component getComponent() {
            return new JPanel();
        }

        public HelpCtx getHelp() {
            return null;
        }

        public void readSettings(WizardDescriptor settings) {
        }

        public void storeSettings(WizardDescriptor settings) {
        }

        public boolean isValid() {
            return true;
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }

        @Override
        public void save() throws IOException {
        }
    }
}

