/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.prep.ui.options;

import java.awt.EventQueue;
import java.io.IOException;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.css.prep.CssPreprocessorType;
import org.netbeans.modules.css.prep.options.CssPrepOptions;
import org.netbeans.modules.css.prep.options.CssPrepOptionsValidator;
import org.netbeans.modules.css.prep.sass.SassCssPreprocessor;
import org.netbeans.modules.css.prep.sass.SassExecutable;
import org.netbeans.modules.css.prep.ui.options.Bundle;
import org.netbeans.modules.css.prep.ui.options.SassOptionsPanel;
import org.netbeans.modules.css.prep.util.ValidationResult;
import org.netbeans.modules.css.prep.util.Warnings;
import org.netbeans.modules.web.common.spi.CssPreprocessorImplementation;

public class SassOptions
implements CssPreprocessorImplementation.Options {
    private final SassCssPreprocessor sassCssPreprocessor;
    private SassOptionsPanel panel = null;

    public SassOptions(SassCssPreprocessor sassCssPreprocessor) {
        this.sassCssPreprocessor = sassCssPreprocessor;
    }

    public String getDisplayName() {
        return Bundle.SassOptions_displayName();
    }

    public void addChangeListener(ChangeListener listener) {
        this.getComponent().addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.getComponent().removeChangeListener(listener);
    }

    public SassOptionsPanel getComponent() {
        assert (EventQueue.isDispatchThread());
        if (this.panel == null) {
            this.panel = new SassOptionsPanel();
        }
        return this.panel;
    }

    public void update() {
        this.getComponent().setSassPath(this.getOptions().getSassPath());
        this.getComponent().setSassOutputOnError(this.getOptions().getSassOutputOnError());
        this.getComponent().setSassDebug(this.getOptions().getSassDebug());
    }

    public boolean isValid() {
        return !this.getValidationResult().hasErrors();
    }

    public String getErrorMessage() {
        ValidationResult validationResult = this.getValidationResult();
        if (validationResult.hasErrors()) {
            return validationResult.getErrors().get(0).getMessage();
        }
        return null;
    }

    public String getWarningMessage() {
        ValidationResult validationResult = this.getValidationResult();
        if (validationResult.hasWarnings()) {
            return validationResult.getWarnings().get(0).getMessage();
        }
        return null;
    }

    public boolean changed() {
        String sassPath = this.getOptions().getSassPath();
        return !this.getComponent().getSassPath().equals(sassPath == null ? "" : sassPath) || this.getComponent().getSassOutputOnError() != this.getOptions().getSassOutputOnError() || this.getComponent().getSassDebug() != this.getOptions().getSassDebug();
    }

    public void save() throws IOException {
        Warnings.resetWarning(CssPreprocessorType.SASS);
        SassExecutable.resetVersion();
        boolean fire = false;
        String originalPath = this.getOptions().getSassPath();
        String path = this.getComponent().getSassPath();
        this.getOptions().setSassPath(path);
        if (!path.equals(originalPath)) {
            fire = true;
        }
        this.getOptions().setSassOutpuOnError(this.getComponent().getSassOutputOnError());
        boolean originalDebug = this.getOptions().getSassDebug();
        boolean debug = this.getComponent().getSassDebug();
        this.getOptions().setSassDebug(debug);
        if (debug != originalDebug) {
            fire = true;
        }
        if (fire) {
            this.sassCssPreprocessor.fireOptionsChanged();
        }
    }

    private ValidationResult getValidationResult() {
        return new CssPrepOptionsValidator().validateSassPath(this.getComponent().getSassPath(), true).getResult();
    }

    private CssPrepOptions getOptions() {
        return CssPrepOptions.getInstance();
    }
}

