/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.prep.ui.customizer;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.css.prep.CssPreprocessorType;
import org.netbeans.modules.css.prep.ui.customizer.Bundle;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;
import org.openide.util.Pair;

public class OptionsPanel
extends JPanel {
    private static final long serialVersionUID = 16987546576769L;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final MappingsTableModel mappingsTableModel;
    private final List<Pair<String, String>> mappings = new CopyOnWriteArrayList<Pair<String, String>>();
    volatile boolean configured = false;
    volatile boolean enabled;
    volatile String compilerOptions;
    private JButton addButton;
    private JLabel compilerOptionsInfoLabel;
    private JLabel compilerOptionsLabel;
    private JTextField compilerOptionsTextField;
    private JButton configureExecutablesButton;
    private JCheckBox enabledCheckBox;
    private JLabel mappingsInfoLabel;
    private JScrollPane mappingsScrollPane;
    private JTable mappingsTable;
    private JButton removeButton;
    private JLabel watchLabel;

    public OptionsPanel(CssPreprocessorType type, boolean initialEnabled, List<Pair<String, String>> initialMappings, String initialCompilerOptions) {
        assert (EventQueue.isDispatchThread());
        this.mappingsTableModel = new MappingsTableModel(this.mappings);
        this.enabled = initialEnabled;
        this.compilerOptions = initialCompilerOptions;
        this.initComponents();
        this.init(type, initialEnabled, initialMappings, initialCompilerOptions);
    }

    private void init(CssPreprocessorType type, boolean initialEnabled, List<Pair<String, String>> initialMappings, String initialCompilerOptions) {
        assert (EventQueue.isDispatchThread());
        this.configureExecutablesButton.setVisible(false);
        Mnemonics.setLocalizedText((AbstractButton)this.enabledCheckBox, (String)Bundle.OptionsPanel_compilationEnabled_label(type.getDisplayName()));
        this.mappingsTable.setModel(this.mappingsTableModel);
        this.setCompilationEnabled(initialEnabled);
        this.setMappings(initialMappings);
        this.setCompilerOptions(initialCompilerOptions);
        this.enablePanel(initialEnabled);
        this.enableRemoveButton();
        if ("Mac OS X".equals(UIManager.getLookAndFeel().getName())) {
            this.mappingsTable.setShowGrid(true);
            this.mappingsTable.setGridColor(Color.GRAY);
        }
        this.enabledCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                OptionsPanel.this.enabled = e.getStateChange() == 1;
                OptionsPanel.this.configured = true;
                OptionsPanel.this.enablePanel(OptionsPanel.this.enabled);
                OptionsPanel.this.fireChange();
            }
        });
        this.mappingsTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                OptionsPanel.this.fireChange();
            }
        });
        this.mappingsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                OptionsPanel.this.enableRemoveButton();
            }
        });
        this.compilerOptionsTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.processChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.processChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.processChange();
            }

            private void processChange() {
                OptionsPanel.this.compilerOptions = OptionsPanel.this.compilerOptionsTextField.getText();
                OptionsPanel.this.fireChange();
            }
        });
    }

    public void showConfigureExecutableButton() {
        this.configureExecutablesButton.setVisible(true);
    }

    public boolean isConfigured() {
        return this.configured;
    }

    public boolean isCompilationEnabled() {
        return this.enabled;
    }

    public void setCompilationEnabled(boolean enabled) {
        assert (EventQueue.isDispatchThread());
        this.enabledCheckBox.setSelected(enabled);
    }

    public List<Pair<String, String>> getMappings() {
        return this.mappings;
    }

    public void setMappings(List<Pair<String, String>> mappings) {
        assert (EventQueue.isDispatchThread());
        this.mappings.clear();
        this.mappings.addAll(mappings);
        this.mappingsTableModel.fireMappingsChange();
    }

    public String getCompilerOptions() {
        assert (this.compilerOptions != null);
        return this.compilerOptions;
    }

    public void setCompilerOptions(String compilerOptions) {
        assert (EventQueue.isDispatchThread());
        this.compilerOptionsTextField.setText(compilerOptions);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    void enablePanel(boolean enabled) {
        this.watchLabel.setEnabled(enabled);
        this.mappingsTable.setEnabled(enabled);
        this.mappingsInfoLabel.setEnabled(enabled);
        this.addButton.setEnabled(enabled);
        this.configureExecutablesButton.setEnabled(enabled);
        if (enabled) {
            this.enableRemoveButton();
        } else {
            this.removeButton.setEnabled(false);
        }
        this.compilerOptionsLabel.setEnabled(enabled);
        this.compilerOptionsTextField.setEnabled(enabled);
        this.compilerOptionsInfoLabel.setEnabled(enabled);
    }

    void enableRemoveButton() {
        this.removeButton.setEnabled(this.mappingsTable.getSelectedRowCount() > 0);
    }

    private void initComponents() {
        this.enabledCheckBox = new JCheckBox();
        this.configureExecutablesButton = new JButton();
        this.watchLabel = new JLabel();
        this.mappingsScrollPane = new JScrollPane();
        this.mappingsTable = new JTable();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.mappingsInfoLabel = new JLabel();
        this.compilerOptionsLabel = new JLabel();
        this.compilerOptionsTextField = new JTextField();
        this.compilerOptionsInfoLabel = new JLabel();
        Mnemonics.setLocalizedText((AbstractButton)this.enabledCheckBox, (String)"COMPILATION_ON_SAVE");
        Mnemonics.setLocalizedText((AbstractButton)this.configureExecutablesButton, (String)NbBundle.getMessage(OptionsPanel.class, (String)"OptionsPanel.configureExecutablesButton.text"));
        this.configureExecutablesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsPanel.this.configureExecutablesButtonActionPerformed(evt);
            }
        });
        this.watchLabel.setLabelFor(this.mappingsTable);
        Mnemonics.setLocalizedText((JLabel)this.watchLabel, (String)NbBundle.getMessage(OptionsPanel.class, (String)"OptionsPanel.watchLabel.text"));
        this.mappingsScrollPane.setViewportView(this.mappingsTable);
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(OptionsPanel.class, (String)"OptionsPanel.addButton.text"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsPanel.this.addButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(OptionsPanel.class, (String)"OptionsPanel.removeButton.text"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsPanel.this.removeButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.mappingsInfoLabel, (String)NbBundle.getMessage(OptionsPanel.class, (String)"OptionsPanel.mappingsInfoLabel.text"));
        this.compilerOptionsLabel.setLabelFor(this.compilerOptionsTextField);
        Mnemonics.setLocalizedText((JLabel)this.compilerOptionsLabel, (String)NbBundle.getMessage(OptionsPanel.class, (String)"OptionsPanel.compilerOptionsLabel.text"));
        this.compilerOptionsTextField.setColumns(20);
        Mnemonics.setLocalizedText((JLabel)this.compilerOptionsInfoLabel, (String)NbBundle.getMessage(OptionsPanel.class, (String)"OptionsPanel.compilerOptionsInfoLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.enabledCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.configureExecutablesButton)).addGroup(layout.createSequentialGroup().addComponent(this.mappingsScrollPane, -2, 0, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.addButton).addComponent(this.removeButton))).addGroup(layout.createSequentialGroup().addComponent(this.compilerOptionsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.compilerOptionsInfoLabel).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.compilerOptionsTextField))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.watchLabel).addComponent(this.mappingsInfoLabel)).addGap(0, 0, Short.MAX_VALUE)));
        layout.linkSize(0, this.addButton, this.removeButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.enabledCheckBox).addComponent(this.configureExecutablesButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.watchLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mappingsScrollPane, -1, 87, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mappingsInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.compilerOptionsLabel).addComponent(this.compilerOptionsTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.compilerOptionsInfoLabel)));
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        assert (EventQueue.isDispatchThread());
        this.mappings.add((Pair<String, String>)Pair.of((Object)"", (Object)""));
        this.mappingsTableModel.fireMappingsChange();
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        assert (EventQueue.isDispatchThread());
        int[] selectedRows = this.mappingsTable.getSelectedRows();
        assert (selectedRows.length > 0);
        for (int i = selectedRows.length - 1; i >= 0; --i) {
            this.mappings.remove(selectedRows[i]);
        }
        this.mappingsTableModel.fireMappingsChange();
    }

    private void configureExecutablesButtonActionPerformed(ActionEvent evt) {
        OptionsDisplayer.getDefault().open("Advanced/CssPreprocessors");
    }

    private static final class MappingsTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -65325657686411L;
        private final List<Pair<String, String>> mappings;

        public MappingsTableModel(List<Pair<String, String>> mappings) {
            assert (mappings != null);
            this.mappings = mappings;
        }

        @Override
        public int getRowCount() {
            return this.mappings.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Pair<String, String> pair = this.mappings.get(rowIndex);
            if (columnIndex == 0) {
                return pair.first();
            }
            if (columnIndex == 1) {
                return pair.second();
            }
            throw new IllegalStateException("Unknown column index: " + columnIndex);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            String path = (String)aValue;
            Pair<String, String> pair = this.mappings.get(rowIndex);
            if (columnIndex == 0) {
                this.mappings.set(rowIndex, (Pair<String, String>)Pair.of((Object)path, (Object)pair.second()));
            } else if (columnIndex == 1) {
                this.mappings.set(rowIndex, (Pair<String, String>)Pair.of((Object)pair.first(), (Object)path));
            } else {
                throw new IllegalStateException("Unknown column index: " + columnIndex);
            }
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return Bundle.MappingsTableModel_column_input_title();
            }
            if (columnIndex == 1) {
                return Bundle.MappingsTableModel_column_output_title();
            }
            throw new IllegalStateException("Unknown column index: " + columnIndex);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0 || columnIndex == 1) {
                return String.class;
            }
            throw new IllegalStateException("Unknown column index: " + columnIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (columnIndex == 0 || columnIndex == 1) {
                return true;
            }
            throw new IllegalStateException("Unknown column index: " + columnIndex);
        }

        public void fireMappingsChange() {
            assert (EventQueue.isDispatchThread());
            this.fireTableDataChanged();
        }
    }
}

